"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isStruct = void 0;
const DateTime_1 = require("./DateTime");
function isStruct(o) {
    return (o != null &&
        !Array.isArray(o) &&
        Object.values(o).every((v) => {
            const t = typeof v;
            return t === "string" || t === "number" || (0, DateTime_1.isDateOrTime)(v) || isStruct(v);
        }));
}
exports.isStruct = isStruct;
//# sourceMappingURL=Struct.js.map