export type Maybe<T> = T | undefined;
export type MaybeNull<T> = Maybe<T> | null;
export declare function map<T, U>(maybeT: MaybeNull<T>, f: (t: T) => U): Maybe<U>;
export declare function first<T, U>(iter: Iterable<Maybe<T>>, f: (t: T) => Maybe<U>): Maybe<U>;
export declare function firstDefinedThunk<T>(iter: Iterable<() => Maybe<T>>): Maybe<T>;
/**
 * Convert functions that return `type | null` to `type | undefined`
 */
export declare function denull<T>(t: T | null): Maybe<T>;
