"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultExifToolPath = void 0;
const _fs = __importStar(require("fs"));
const _path = __importStar(require("path"));
const IsWin32_1 = require("./IsWin32");
function findExiftool() {
    const path = require(`exiftool-vendored.${(0, IsWin32_1.isWin32)() ? "exe" : "pl"}`);
    // This s/app.asar/app.asar.unpacked/ path switch adds support for Electron
    // apps that are ASAR-packed.
    // Note that we can't check for electron because child processes that are
    // spawned by the main process will most likely need the ELECTRON_RUN_AS_NODE
    // environment variable set, which will unset the process.versions.electron
    // field.
    const fixedPath = path
        .split(_path.sep)
        .map((ea) => (ea === "app.asar" ? "app.asar.unpacked" : ea))
        .join(_path.sep);
    // Note also, that we must check for the fixedPath first, because Electron's
    // ASAR shenanigans will make existsSync return true even for asar-packed
    // resources.
    if (_fs.existsSync(fixedPath)) {
        return fixedPath;
    }
    if (_fs.existsSync(path)) {
        return path;
    }
    throw new Error(`Vendored ExifTool does not exist at ${path}`);
}
exports.DefaultExifToolPath = findExiftool();
//# sourceMappingURL=FindExiftool.js.map