import { Zone } from "luxon";
import { Maybe } from "./Maybe";
export declare const MaxTzOffsetHours = 14;
/**
 * Zone instances with this offset are a placeholder for being "unset".
 */
export declare const UnsetZoneOffsetMinutes = -1;
/**
 * This is a placeholder for dates where the zone is unknown/unset, because
 * Luxon doesn't officially support "unset" zones.
 */
export declare const UnsetZone: Zone;
/**
 * Zone instances with this name are a placeholder for being "unset".
 */
export declare const UnsetZoneName: string;
/**
 * If `tzSource` matches this value, the tags are from a video, and we had to
 * resort to assuming time fields are in UTC.
 * @see https://github.com/photostructure/exiftool-vendored.js/issues/113
 */
export declare const defaultVideosToUTC = "defaultVideosToUTC";
export declare function normalizeZone(z: Maybe<string | number | Zone>): Maybe<Zone>;
export declare function reasonableTzOffsetMinutes(tzOffsetMinutes: Maybe<number>): boolean;
/**
 * Returns a "zone name" (used by `luxon`) that encodes the given offset.
 */
export declare function offsetMinutesToZoneName(offsetMinutes: Maybe<number>): Maybe<string>;
export interface TzSrc {
    tz: string;
    src: string;
}
/**
 * Parse a timezone offset and return the offset minutes
 */
export declare function extractOffset(tz: Maybe<string>): Maybe<TzSrc>;
export declare function extractTzOffsetFromTags(t: {
    TimeZone?: string;
    OffsetTime?: string;
    /** time zone for DateTimeOriginal, "-08:00" */
    OffsetTimeOriginal?: string;
    /** time zone for CreateDate, "-08:00" */
    OffsetTimeDigitized?: string;
    /**
     * 1 or 2 values: 1. The time zone offset of DateTimeOriginal from GMT in
     * hours, 2. If present, the time zone offset of ModifyDate (which we ignore)
     * @see https://www.exiftool.org/TagNames/EXIF.html
     */
    TimeZoneOffset?: number | number[] | string;
}): Maybe<TzSrc>;
export declare function inferLikelyOffsetMinutes(deltaMinutes: number): number;
export declare function extractTzOffsetFromUTCOffset(t: {
    DateTimeUTC?: string;
    GPSDateTime?: string;
    GPSDateStamp?: string;
    GPSTimeStamp?: string;
    GPSDateTimeStamp?: string;
    SubSecDateTimeOriginal?: string;
    DateTimeOriginal?: string;
    SubSecCreateDate?: string;
    CreateDate?: string;
    SubSecMediaCreateDate?: string;
    MediaCreateDate?: string;
    DateTimeCreated?: string;
}): Maybe<TzSrc>;
