"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseJSON = void 0;
const BinaryField_1 = require("./BinaryField");
const ExifDate_1 = require("./ExifDate");
const ExifDateTime_1 = require("./ExifDateTime");
const ExifTime_1 = require("./ExifTime");
const Revivers = {
    BinaryField: (ea) => BinaryField_1.BinaryField.fromJSON(ea),
    ExifDateTime: (ea) => ExifDateTime_1.ExifDateTime.fromJSON(ea),
    ExifDate: (ea) => ExifDate_1.ExifDate.fromJSON(ea),
    ExifTime: (ea) => ExifTime_1.ExifTime.fromJSON(ea),
};
function parseJSON(s) {
    return JSON.parse(s, (_key, value) => { var _a, _b; return (_b = (_a = Revivers[value === null || value === void 0 ? void 0 : value._ctor]) === null || _a === void 0 ? void 0 : _a.call(Revivers, value)) !== null && _b !== void 0 ? _b : value; });
}
exports.parseJSON = parseJSON;
//# sourceMappingURL=JSON.js.map