"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isFileEmpty = void 0;
const fs_1 = require("fs");
const String_1 = require("./String");
async function isFileEmpty(path) {
    if ((0, String_1.blank)(path)) {
        throw new Error("isFileEmpty(): blank path");
    }
    // TODO: convert this to using fs/promises once node 12 is EOL (2022-04-30)
    try {
        const s = await new Promise((res, rej) => {
            try {
                (0, fs_1.stat)(path, (err, val) => (err == null ? res(val) : rej(err)));
            }
            catch (err) {
                rej(err);
            }
        });
        return s == null || s.size === 0;
    }
    catch (err) {
        if (err.code === "ENOENT")
            return true;
        else
            throw err;
    }
}
exports.isFileEmpty = isFileEmpty;
//# sourceMappingURL=File.js.map