"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinaryField = void 0;
const Number_1 = require("./Number");
// "(Binary data 2506078 bytes, use -b option to extract)"
const BinaryFieldRE = 
// /^\(?Binary data (\d+).*use -b option to extract\)?$/i
/Binary.*? (\d+) bytes/i;
class BinaryField {
    constructor(bytes, rawValue) {
        this.bytes = bytes;
        this.rawValue = rawValue;
    }
    toJSON() {
        return {
            _ctor: "BinaryField",
            bytes: this.bytes,
            rawValue: this.rawValue,
        };
    }
    static fromJSON(json) {
        return new BinaryField(json.bytes, json.rawValue);
    }
    static fromRawValue(rawValue) {
        const m = rawValue.match(BinaryFieldRE);
        if (m != null) {
            const bytes = (0, Number_1.toInt)(m[1]);
            if (bytes != null) {
                return new BinaryField(bytes, rawValue);
            }
        }
        return;
    }
}
exports.BinaryField = BinaryField;
//# sourceMappingURL=BinaryField.js.map