import { DateTime } from "luxon";
import { Maybe } from "./Maybe";
/**
 * Encodes an ExifTime (which may not have a timezone offset)
 */
export declare class ExifTime {
    readonly hour: number;
    readonly minute: number;
    readonly second: number;
    readonly millisecond?: number | undefined;
    readonly rawValue?: string | undefined;
    static fromEXIF(text: string): Maybe<ExifTime>;
    static fromDateTime(dt: DateTime, rawValue?: string): Maybe<ExifTime>;
    constructor(hour: number, minute: number, second: number, millisecond?: number | undefined, rawValue?: string | undefined);
    get millis(): number | undefined;
    private subsec;
    toString(): string;
    toISOString(): string;
    toExifString(): string;
    toJSON(): {
        _ctor: string;
        hour: number;
        minute: number;
        second: number;
        millisecond: number | undefined;
        rawValue: string | undefined;
    };
    static fromJSON(json: ReturnType<ExifTime["toJSON"]>): ExifTime;
}
