"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExifToolTask = void 0;
const bc = __importStar(require("batch-cluster"));
const IgnorableError_1 = require("./IgnorableError");
const String_1 = require("./String");
class ExifToolTask extends bc.Task {
    static renderCommand(args) {
        return [...args, "-ignoreMinorErrors", "-execute", ""].join("\n");
    }
    constructor(args) {
        super(ExifToolTask.renderCommand(args), (stdout, stderr, passed) => {
            let error;
            if ((0, String_1.notBlank)(stderr) || !passed) {
                const errMsg = (stderr !== null && stderr !== void 0 ? stderr : stdout).trim().replace(/error(:\s*|\b)/i, "");
                if (!this.isIgnorableError(errMsg)) {
                    this.errors.push(errMsg);
                    error = new Error(errMsg);
                }
            }
            return this.parse(stdout, error);
        });
        this.args = args;
        this.isIgnorableError = IgnorableError_1.isIgnorableWarning;
        this.errors = [];
    }
    addError(err) {
        this.errors.push(err);
    }
}
exports.ExifToolTask = ExifToolTask;
//# sourceMappingURL=ExifToolTask.js.map