"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BinaryExtractionTask = void 0;
const path_1 = __importDefault(require("path"));
const ExifToolTask_1 = require("./ExifToolTask");
const FilenameCharsetArgs_1 = require("./FilenameCharsetArgs");
const String_1 = require("./String");
const StdoutRe = /\b(\d+) output files? created/i;
/**
 * Task that returns an error string (to prevent retries), or undefined if
 * everything seems to have worked.
 */
class BinaryExtractionTask extends ExifToolTask_1.ExifToolTask {
    constructor(args) {
        super(args);
    }
    static for(tagname, imgSrc, imgDest) {
        const args = [
            ...FilenameCharsetArgs_1.Utf8FilenameCharsetArgs,
            "-b",
            "-" + tagname,
            "-w",
            // The %0f prevents shell escaping. See
            // https://exiftool.org/exiftool_pod.html#w-EXT-or-FMT--textOut
            "%0f" + path_1.default.resolve(imgDest),
            path_1.default.resolve(imgSrc),
        ];
        return new BinaryExtractionTask(args);
    }
    parse(stdout, err) {
        const s = (0, String_1.toS)(stdout).trim();
        const m = StdoutRe.exec(s);
        if (err != null) {
            throw err;
        }
        else if (m == null) {
            throw new Error("Missing expected status message (got " + stdout + ")");
        }
        else if (m[1] === "1") {
            return;
        }
        else {
            // Don't retry: the binary payload is missing, and retrying won't fix that.
            return s;
        }
    }
}
exports.BinaryExtractionTask = BinaryExtractionTask;
//# sourceMappingURL=BinaryExtractionTask.js.map