"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.thenOrTimeout = exports.Timeout = void 0;
const timers_1 = __importDefault(require("timers"));
exports.Timeout = Symbol("timeout");
async function thenOrTimeout(p, timeoutMs) {
    return new Promise(async (resolve, reject) => {
        let pending = true;
        try {
            const t = timers_1.default.setTimeout(() => {
                if (pending) {
                    pending = false;
                    resolve(exports.Timeout);
                }
            }, timeoutMs);
            const result = await p;
            if (pending) {
                pending = false;
                clearTimeout(t);
                resolve(result);
            }
        }
        catch (err) {
            if (pending) {
                pending = false;
                reject(err);
            }
        }
    });
}
exports.thenOrTimeout = thenOrTimeout;
//# sourceMappingURL=Timeout.js.map