/// <reference types="node" />
import { InternalBatchProcessOptions } from "./InternalBatchProcessOptions";
import { Parser } from "./Parser";
type TaskOptions = Pick<InternalBatchProcessOptions, "streamFlushMillis" | "observer" | "passRE" | "failRE" | "logger">;
/**
 * Tasks embody individual jobs given to the underlying child processes. Each
 * instance has a promise that will be resolved or rejected based on the
 * result of the task.
 */
export declare class Task<T = any> {
    #private;
    readonly command: string;
    readonly parser: Parser<T>;
    readonly taskId: number;
    /**
     * @param {string} command is the value written to stdin to perform the given
     * task.
     * @param {Parser<T>} parser is used to parse resulting data from the
     * underlying process to a typed object.
     */
    constructor(command: string, parser: Parser<T>);
    /**
     * @return the resolution or rejection of this task.
     */
    get promise(): Promise<T>;
    get pending(): boolean;
    get state(): string;
    onStart(opts: TaskOptions): void;
    get runtimeMs(): number | undefined;
    toString(): string;
    onStdout(buf: string | Buffer): void;
    onStderr(buf: string | Buffer): void;
    /**
     * @return true if the wrapped promise was rejected
     */
    reject(error: Error): boolean;
}
export {};
