type LogFunc = (message: string, ...optionalParams: any[]) => void;
/**
 * Simple interface for logging.
 */
export interface Logger {
    trace: LogFunc;
    debug: LogFunc;
    info: LogFunc;
    warn: LogFunc;
    error: LogFunc;
}
export declare const LogLevels: (keyof Logger)[];
/**
 * Default `Logger` implementation.
 *
 * - `debug` and `info` go to {@link util.debuglog}("batch-cluster")`.
 *
 * - `warn` and `error` go to `console.warn` and `console.error`.
 *
 * @see https://nodejs.org/api/util.html#util_util_debuglog_section
 * @see https://nodejs.org/api/console.html
 */
export declare const ConsoleLogger: Logger;
/**
 * `Logger` that disables all logging.
 */
export declare const NoLogger: Logger;
export declare function setLogger(l: Logger): void;
export declare function logger(): Logger;
export declare const Log: {
    withLevels: (delegate: Logger) => Logger;
    withTimestamps: (delegate: Logger) => any;
    filterLevels: (l: Logger, minLogLevel: keyof Logger) => any;
};
export {};
