"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.retryOnReject = void 0;
function retryOnReject(f, maxRetries) {
    let retries = 0;
    const g = async () => {
        try {
            return await f();
        }
        catch (err) {
            // console.log("retryOnReject caught error", { err, retries, maxRetries })
            if (retries < maxRetries) {
                retries++;
                return g();
            }
            else {
                throw err;
            }
        }
    };
    return g();
}
exports.retryOnReject = retryOnReject;
//# sourceMappingURL=AsyncRetry.js.map