"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mean = void 0;
class Mean {
    constructor(n = 0, sum = 0) {
        this.sum = sum;
        this._min = undefined;
        this._max = undefined;
        this._n = n;
    }
    push(x) {
        this._n++;
        this.sum += x;
        this._min = this._min == null || this._min > x ? x : this._min;
        this._max = this._max == null || this._max < x ? x : this._max;
    }
    get n() {
        return this._n;
    }
    get min() {
        return this._min;
    }
    get max() {
        return this._max;
    }
    get mean() {
        return this.sum / this.n;
    }
    clone() {
        return new Mean(this.n, this.sum);
    }
}
exports.Mean = Mean;
//# sourceMappingURL=Mean.js.map