"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripSuffix = exports.stripPrefix = exports.pad3 = exports.pad2 = exports.leftPad = exports.toS = exports.notBlank = exports.blank = exports.isString = void 0;
const Array_1 = require("./Array");
function isString(o) {
    return typeof o === "string";
}
exports.isString = isString;
const spaces = (0, Array_1.times)(10, (i) => (0, Array_1.times)(i, () => " ").join(""));
const zeroes = (0, Array_1.times)(10, (i) => (0, Array_1.times)(i, () => "0").join(""));
function blank(s) {
    return s == null || String(s).trim().length === 0;
}
exports.blank = blank;
function notBlank(s) {
    return !blank(s);
}
exports.notBlank = notBlank;
function padding(padChar, count) {
    if (count <= 0)
        return "";
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    return (padChar === "0" ? zeroes : spaces)[Math.floor(count)];
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function toS(s) {
    return s == null ? "" : String(s);
}
exports.toS = toS;
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function leftPad(i, minLen, padChar) {
    if (i == null || isNaN(i))
        i = 0;
    if (i < 0) {
        return "-" + leftPad(-i, minLen - 1, padChar);
    }
    else {
        const s = String(i);
        return padding(padChar, minLen - s.length) + s;
    }
}
exports.leftPad = leftPad;
function pad2(...numbers) {
    return numbers.map((i) => leftPad(i, 2, "0"));
}
exports.pad2 = pad2;
function pad3(...numbers) {
    return numbers.map((i) => leftPad(i, 3, "0"));
}
exports.pad3 = pad3;
/**
 * NOT FOR GENERAL USE, as this is latin-case-insensitive
 */
function stripPrefix(s, prefix) {
    return toS(s).toLowerCase().startsWith(prefix.toLowerCase())
        ? s.slice(prefix.length)
        : s;
}
exports.stripPrefix = stripPrefix;
function stripSuffix(s, suffix) {
    const str = toS(s);
    return str.endsWith(suffix) ? str.slice(0, -suffix.length) : str;
}
exports.stripSuffix = stripSuffix;
//# sourceMappingURL=String.js.map