"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toInt = exports.toFloat = exports.isNumber = void 0;
function isNumber(n) {
    return typeof n === "number" && isFinite(n);
}
exports.isNumber = isNumber;
function toFloat(n) {
    if (n == null)
        return;
    if (isNumber(n))
        return n;
    try {
        return parseFloat(String(n).trim());
    }
    catch {
        return undefined;
    }
}
exports.toFloat = toFloat;
function toInt(n) {
    if (n == null)
        return;
    if (isNumber(n)) {
        // we don't round here, because parsing floats also doesn't round.
        return Math.floor(n);
    }
    try {
        return parseInt(String(n).trim());
    }
    catch {
        return undefined;
    }
}
exports.toInt = toInt;
//# sourceMappingURL=Number.js.map