import { DateTime } from "luxon";
import { ExifDate } from "./ExifDate";
import { ExifDateTime } from "./ExifDateTime";
import { ExifTime } from "./ExifTime";
import { Maybe } from "./Maybe";
export declare function validDateTime(dt: DateTime): boolean;
export declare const MinuteMs: number;
export declare const HourMs: number;
export declare const DayMs: number;
export type DateOrTime = ExifDateTime | ExifDate | ExifTime | DateTime;
export declare function isDateOrTime(o: any): o is DateOrTime;
export declare function dateTimeToExif(d: DateTime, opts?: {
    includeOffset?: boolean;
    includeMilliseconds?: boolean;
}): string;
export declare function toExifString(d: DateOrTime): Maybe<string>;
