"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadRawTask = void 0;
const batch_cluster_1 = require("batch-cluster");
const _path = __importStar(require("path"));
const ExifToolTask_1 = require("./ExifToolTask");
const FilenameCharsetArgs_1 = require("./FilenameCharsetArgs");
class ReadRawTask extends ExifToolTask_1.ExifToolTask {
    static for(filename, exiftoolArgs = []) {
        const args = [...FilenameCharsetArgs_1.Utf8FilenameCharsetArgs, ...exiftoolArgs];
        if (!args.includes("-json"))
            args.push("-json");
        const sourceFile = _path.resolve(filename);
        args.push(sourceFile);
        return new ReadRawTask(sourceFile, args);
    }
    constructor(sourceFile, args) {
        super(args);
        this.sourceFile = sourceFile;
        this.args = args;
    }
    toString() {
        return "ReadRawTask" + this.sourceFile + ")";
    }
    parse(data, err) {
        try {
            return JSON.parse(data)[0];
        }
        catch (jsonError) {
            (0, batch_cluster_1.logger)().error("ExifTool.ReadRawTask(): Invalid JSON", { data });
            throw err !== null && err !== void 0 ? err : jsonError;
        }
    }
}
exports.ReadRawTask = ReadRawTask;
//# sourceMappingURL=ReadRawTask.js.map