"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shallowArrayEql = exports.uniq = exports.filterInPlace = exports.times = exports.compact = void 0;
function compact(array) {
    return array.filter((elem) => elem != null);
}
exports.compact = compact;
function times(n, f) {
    return Array(n)
        .fill(undefined)
        .map((_, i) => f(i));
}
exports.times = times;
/**
 * Remove all elements from the given array that return false from the given
 * predicate `filter`.
 */
function filterInPlace(arr, filter) {
    let j = 0;
    arr.forEach((ea, i) => {
        if (filter(ea)) {
            if (i !== j)
                arr[j] = ea;
            j++;
        }
    });
    arr.length = j;
    return arr;
}
exports.filterInPlace = filterInPlace;
function uniq(arr) {
    return arr.reduce((acc, ea) => {
        if (acc.indexOf(ea) === -1)
            acc.push(ea);
        return acc;
    }, []);
}
exports.uniq = uniq;
// terrible implementation only for internal use
function shallowArrayEql(a, b) {
    return (a != null &&
        b != null &&
        a.length === b.length &&
        a.every((ea, idx) => ea === b[idx]));
}
exports.shallowArrayEql = shallowArrayEql;
//# sourceMappingURL=Array.js.map