"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultExifToolOptions = void 0;
const bc = __importStar(require("batch-cluster"));
const DefaultExiftoolArgs_1 = require("./DefaultExiftoolArgs");
const DefaultMaxProcs_1 = require("./DefaultMaxProcs");
const FindExiftool_1 = require("./FindExiftool");
const GeoTz_1 = require("./GeoTz");
const IgnorableError_1 = require("./IgnorableError");
const VersionTask_1 = require("./VersionTask");
/**
 * Default values for `ExifToolOptions`, except for `processFactory` (which is
 * created by the ExifTool constructor)
 */
exports.DefaultExifToolOptions = Object.freeze({
    ...new bc.BatchClusterOptions(),
    maxProcs: DefaultMaxProcs_1.DefaultMaxProcs,
    maxTasksPerProcess: 500,
    spawnTimeoutMillis: 30000,
    // see https://github.com/photostructure/exiftool-vendored.js/issues/34 :
    taskTimeoutMillis: 20000,
    onIdleIntervalMillis: 2000,
    taskRetries: 1,
    exiftoolPath: FindExiftool_1.DefaultExifToolPath,
    exiftoolArgs: DefaultExiftoolArgs_1.DefaultExiftoolArgs,
    exiftoolEnv: {},
    pass: "{ready}",
    fail: "{ready}",
    exitCommand: "-stay_open\nFalse\n",
    versionCommand: new VersionTask_1.VersionTask().command,
    healthCheckIntervalMillis: 30000,
    healthCheckCommand: "-ver\n-execute\n",
    useMWG: false,
    numericTags: [
        "*Duration*",
        "GPSAltitude",
        "GPSLatitude",
        "GPSLongitude",
        "GPSPosition",
        "Orientation",
    ],
    includeImageDataMD5: false,
    defaultVideosToUTC: true,
    geoTz: GeoTz_1.geoTz,
    isIgnorableError: IgnorableError_1.isIgnorableWarning,
});
//# sourceMappingURL=DefaultExifToolOptions.js.map