import { ExifToolTask } from "./ExifToolTask";
import { Tags } from "./Tags";
export declare function nullish(s: string | undefined): s is undefined;
export declare const DefaultReadTaskOptions: {
    readonly defaultVideosToUTC: boolean;
    readonly useMWG: boolean;
    readonly numericTags: string[];
    readonly includeImageDataMD5: boolean;
    readonly geoTz: typeof import("./GeoTz").geoTz;
    readonly optionalArgs: string[];
};
export type ReadTaskOptions = typeof DefaultReadTaskOptions;
export declare class ReadTask extends ExifToolTask<Tags> {
    #private;
    readonly sourceFile: string;
    readonly args: string[];
    readonly options: ReadTaskOptions;
    private readonly degroup;
    /** May have keys that are group-prefixed */
    private _raw;
    /** Always has non-group-prefixed keys */
    private _tags;
    private readonly tags;
    private lat;
    private lon;
    private invalidLatLon;
    private tz;
    private tzSource?;
    private constructor();
    static for(filename: string, options: Partial<ReadTaskOptions>): ReadTask;
    toString(): string;
    parse(data: string, err?: Error): Tags;
}
