"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toS = exports.ensureSuffix = exports.notBlank = exports.blank = void 0;
const Object_1 = require("./Object");
function blank(s) {
    return s == null || String(s).trim().length === 0;
}
exports.blank = blank;
function notBlank(s) {
    return !blank(s);
}
exports.notBlank = notBlank;
function ensureSuffix(s, suffix) {
    return s.endsWith(suffix) ? s : s + suffix;
}
exports.ensureSuffix = ensureSuffix;
function toS(s) {
    return s == null ? "" : (0, Object_1.isFunction)(s.toString) ? s.toString() : String(s);
}
exports.toS = toS;
//# sourceMappingURL=String.js.map