export declare function delay(millis: number, unref?: boolean): Promise<void>;
/**
 * Run the given thunk until the promise is resolved to true, or the timeout
 * passes.
 */
export declare function until(f: (count: number) => boolean | Promise<boolean>, timeoutMs: number, delayMs?: number): Promise<boolean>;
/**
 * @return a thunk that will call the underlying thunk at most every `minDelayMs`
 * milliseconds. The thunk will accept a boolean, that, when set, will force the
 * underlying thunk to be called (mostly useful for tests)
 */
export declare function ratelimit<T>(f: () => T, minDelayMs: number): () => T | undefined;
