'use strict'

const createError = require('http-errors')

/**
 * Create a HttpError object from simple arguments.
 *
 * @param {number} status
 * @param {Error|object} err
 * @private
 */

function createHttpError (status, err) {
  if (!err) {
    return createError(status)
  }

  return err instanceof Error
    ? createError(status, err, { expose: false })
    : createError(status, err)
}

module.exports.createHttpError = createHttpError
