"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.denull = exports.firstDefinedThunk = exports.first = exports.map = void 0;
function map(maybeT, f) {
    return maybeT == null ? undefined : f(maybeT);
}
exports.map = map;
function first(iter, f) {
    for (const t of iter) {
        if (t != null) {
            const v = f(t);
            if (v != null)
                return v;
        }
    }
    return;
}
exports.first = first;
function firstDefinedThunk(iter) {
    for (const f of iter) {
        const result = f();
        if (result != null)
            return result;
    }
    return;
}
exports.firstDefinedThunk = firstDefinedThunk;
/**
 * Convert functions that return `type | null` to `type | undefined`
 */
function denull(t) {
    return t == null ? undefined : t;
}
exports.denull = denull;
//# sourceMappingURL=Maybe.js.map