"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isIgnorableWarning = void 0;
const String_1 = require("./String");
// Warning: Duplicate MakerNoteUnknown tag in ExifIFD
// Warning: ICC_Profile deleted. Image colors may be affected
const WarningRE = /^Warning: (?:Duplicate|ICC_Profile deleted)/i;
/**
 * This is the default implementation of IgnorableError, and ignores null,
 * undefined, errors without a message, warnings about duplicate tags, and
 * ICC_Profile deletions.
 */
function isIgnorableWarning(err) {
    const msg = (err instanceof Error ? err.message : (0, String_1.toS)(err)).trim();
    return (0, String_1.blank)(msg) || null != WarningRE.exec(msg);
}
exports.isIgnorableWarning = isIgnorableWarning;
//# sourceMappingURL=IgnorableError.js.map