"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toExifString = exports.dateTimeToExif = exports.isDateOrTime = exports.DayMs = exports.HourMs = exports.MinuteMs = exports.validDateTime = void 0;
const luxon_1 = require("luxon");
const ExifDate_1 = require("./ExifDate");
const ExifDateTime_1 = require("./ExifDateTime");
const ExifTime_1 = require("./ExifTime");
function validDateTime(dt) {
    return dt != null && dt.isValid;
}
exports.validDateTime = validDateTime;
exports.MinuteMs = 60 * 1000;
exports.HourMs = 60 * exports.MinuteMs;
exports.DayMs = 24 * exports.HourMs;
function isDateOrTime(o) {
    return (o instanceof ExifDateTime_1.ExifDateTime ||
        o instanceof ExifDate_1.ExifDate ||
        o instanceof ExifTime_1.ExifTime ||
        luxon_1.DateTime.isDateTime(o));
}
exports.isDateOrTime = isDateOrTime;
function dateTimeToExif(d, opts) {
    return d.toFormat("y:MM:dd HH:mm:ss" +
        ((opts === null || opts === void 0 ? void 0 : opts.includeMilliseconds) === true ? ".u" : "") +
        ((opts === null || opts === void 0 ? void 0 : opts.includeOffset) === false ? "" : "ZZ"));
}
exports.dateTimeToExif = dateTimeToExif;
function toExifString(d) {
    var _a;
    if (luxon_1.DateTime.isDateTime(d)) {
        return dateTimeToExif(d);
    }
    else {
        return (_a = d === null || d === void 0 ? void 0 : d.toExifString) === null || _a === void 0 ? void 0 : _a.call(d);
    }
}
exports.toExifString = toExifString;
//# sourceMappingURL=DateTime.js.map