import MediaInfo, { DEFAULT_OPTIONS } from "./MediaInfo.js";
import mediaInfoModuleFactory from "./MediaInfoModule.js";
const noopPrint = () => {
  // No-op
};

/**
 * Factory function for {@link MediaInfo}.
 *
 * @param options User options
 * @returns MediaInfo object
 */

/**
 * Factory function for {@link MediaInfoFactory}.
 *
 * @param options User options
 * @param callback Function that is called once the module is created
 */

/**
 * Factory function for {@link MediaInfoFactory}.
 *
 * @param options User options
 * @param callback Function that is called once the module is created
 * @param callback Error callback
 */

// TODO pass through all emscripten module options
function MediaInfoFactory(options = {}, callback, errCallback) {
  if (callback === undefined) {
    return new Promise((resolve, reject) => MediaInfoFactory(options, resolve, reject));
  }
  const {
    locateFile,
    ...mergedOptions
  } = {
    ...DEFAULT_OPTIONS,
    ...options,
    format: options.format ?? DEFAULT_OPTIONS.format
  };
  const mediaInfoModuleFactoryOpts = {
    // Silence all print in module
    print: noopPrint,
    printErr: noopPrint,
    locateFile: locateFile ? locateFile : (path, prefix) => `${prefix}../${path}`,
    onAbort: err => {
      if (errCallback) {
        errCallback(err);
      }
    }
  };

  // Fetch and load WASM module
  mediaInfoModuleFactory(mediaInfoModuleFactoryOpts).then(wasmModule => callback(new MediaInfo(wasmModule, mergedOptions))).catch(err => {
    if (errCallback) errCallback(err);
  });
}
export default MediaInfoFactory;
//# sourceMappingURL=MediaInfoFactory.cjs.map
