"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.omit = exports.fromEntries = exports.isFunction = exports.keys = void 0;
// eslint-disable-next-line @typescript-eslint/ban-types
function keys(o) {
    return o == null
        ? []
        : Object.keys(o).filter((ea) => ({}.propertyIsEnumerable.call(o, ea)));
}
exports.keys = keys;
function isFunction(obj) {
    return typeof obj === "function";
}
exports.isFunction = isFunction;
function fromEntries(arr, obj) {
    if (arr == null || arr.length === 0)
        return obj;
    // don't use Object.create(null), json stringify will break!
    for (const ea of arr.filter((ea) => ea != null)) {
        if (ea != null && Array.isArray(ea)) {
            const [k, v] = ea;
            // allow NULL fields:
            if (k != null && v !== undefined) {
                if (typeof obj !== "object")
                    obj = {};
                obj[k] = v;
            }
        }
    }
    return obj;
}
exports.fromEntries = fromEntries;
function omit(t, ...keysToOmit) {
    if (t == null)
        return {};
    const result = { ...t };
    for (const ea of keysToOmit) {
        delete result[ea];
    }
    return result;
}
exports.omit = omit;
//# sourceMappingURL=Object.js.map