<?php
/**
 * WooCommerce
 *
 * @package Zeen
 * @since 1.0.0
 */

/**
 * WooCommerce
 *
 * @since 1.0.0
 */
function zeen_woo_active() {
	if ( class_exists( 'woocommerce' ) ) {
		return true;
	} else {
		return false;
	}
}

function zeen_is_woocommerce() {
	if ( zeen_woo_active() && ( is_woocommerce() || is_cart() || is_checkout() ) ) {
		return true;
	} else {
		return false;
	}
}

function zeen_is_shop() {
	if ( zeen_woo_active() && is_shop() ) {
		return true;
	} else {
		return false;
	}
}

if ( ! function_exists( 'zeen_woo_breadcrumbs' ) ) :
	/**
	 * Remove breadcrumbs
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_breadcrumbs() {
		remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
		add_action( 'woocommerce_before_main_content', 'zeen_breadcrumbs', 20, 0 );
	}
endif;
add_action( 'init', 'zeen_woo_breadcrumbs' );

if ( ! function_exists( 'zeen_woo_add_contents' ) ) :
	/**
	 * Add To cart
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_add_contents( $fragments ) {
		ob_start();
		zeen_woo_contents();
		$fragments['.tipi-basket-wrap'] = ob_get_clean();

		return $fragments;

	}
endif;
add_filter( 'woocommerce_add_to_cart_fragments', 'zeen_woo_add_contents' );

if ( ! function_exists( 'zeen_woo_update_count' ) ) :
	/**
	 * Add To cart
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_update_count( $fragments ) {
		ob_start();
		echo '<span class="tipi-cart-count">' . (int) ( WC()->cart->get_cart_contents_count() ) . '</span>';
		$fragments['.tipi-cart-count'] = ob_get_clean();

		return $fragments;

	}
endif;
add_filter( 'woocommerce_add_to_cart_fragments', 'zeen_woo_update_count' );

if ( ! function_exists( 'zeen_woo_empty' ) ) :
	/**
	 * Contents
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_empty() {
		if ( isset( $_GET['empty'] ) ) {
			global $woocommerce;
			$woocommerce->cart->empty_cart();
		}
	}
endif;
add_action( 'init', 'zeen_woo_empty' );

if ( ! function_exists( 'zeen_woo_extra_1' ) ) :
	/**
	 * Extras 1
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_extra_1() {

		global $product;
		$attachment_ids = $product->get_gallery_image_ids();
		woocommerce_template_loop_product_link_open();
		add_filter( 'woocommerce_product_get_image', 'zeen_lazy_load_on_off' );
		woocommerce_template_loop_product_thumbnail();
		remove_filter( 'woocommerce_product_get_image', 'zeen_lazy_load_on_off' );
		if ( ! empty( $attachment_ids[0] ) ) {
			$img_0 = wp_get_attachment_image_src( $attachment_ids[0], 'shop_catalog' );

			$featured_img = wp_get_attachment_image_src( $attachment_ids[0], 'shop_catalog' );
			$srcset = wp_get_attachment_image_srcset( $attachment_ids[0], 'shop_catalog' );
			echo '<img src="' . esc_url( $featured_img[0] ) . '"  class="sec-img" srcset="' . esc_attr( $srcset ) . '">';
		}
		woocommerce_template_loop_product_link_close();
		echo '</div>';
		woocommerce_template_loop_product_link_open();
	}
endif;
add_action( 'woocommerce_before_shop_loop_item_title', 'zeen_woo_extra_1' );

if ( ! function_exists( 'zeen_woo_extra_2' ) ) :
	/**
	 * Extras 1
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_extra_2() {

		woocommerce_template_loop_product_link_close();
	}
endif;
add_action( 'woocommerce_after_shop_loop_item_title', 'zeen_woo_extra_2' );

if ( ! function_exists( 'zeen_woo_before_shop_loop_item' ) ) :
	/**
	 * Extras 1
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_before_shop_loop_item( $args = '' ) {
		global $post;
		$qv = get_theme_mod( 'woo_qv', 1 );
		$add = get_theme_mod( 'woo_add_to_cart', 1 );
		if ( empty( $qv ) && empty( $add ) ) {
			return;
		}
		if ( empty( $args['wrap_off'] ) ) {
			echo '<div class="woo-img-wrap mask">';
		}
		echo '<div class="extras">';
		if ( ! empty( $qv ) ) {
		?>
			<div class="woo-extra-button tipi-tip" data-title="<?php esc_attr_e( 'Quick View', 'zeen' ); ?>"><a href="<?php echo esc_url( get_the_permalink( $post->ID ) ); ?>" class="tipi-i-qv modal-tr" data-pid="<?php echo (int) $post->ID; ?>" data-type="qv"></a></div>
		<?php } ?>
		<?php if ( function_exists( 'woocommerce_template_loop_add_to_cart' ) && ! empty( $add ) ) { ?>
			<div class="woo-extra-button tipi-tip" data-title="<?php esc_attr_e( 'Add To Cart', 'zeen' ); ?>"><?php woocommerce_template_loop_add_to_cart(); ?></div>
		<?php } ?>
		<?php
		echo '</div>';
	}
endif;
add_action( 'woocommerce_before_shop_loop_item', 'zeen_woo_before_shop_loop_item' );



if ( ! function_exists( 'zeen_woo_cart' ) ) :
	function zeen_woo_cart( $button_text, $product, $args ) {

		if ( empty( $product ) ) {
			global $product;
		}
		$cart_icon = get_theme_mod( 'woo_cart', 1 ) == 1 ? 'tipi-i-cart-1-plus' : 'tipi-i-cart-2-plus';
		return sprintf( '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
			esc_url( $product->add_to_cart_url() ),
			esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
			esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
			isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
			'<i class="' . zeen_sanitizer_options( $cart_icon, array( 'tipi-i-cart-1-plus', 'tipi-i-cart-2-plus' ) ) . ' tipi-i-1"></i><i class="tipi-i-check tipi-i-2"></i>'
		);
	}
endif;
add_filter( 'woocommerce_loop_add_to_cart_link', 'zeen_woo_cart', 10, 3 );

if ( ! function_exists( 'zeen_woo_before_main_content' ) ) :
	/**
	 * Before main content
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_before_main_content() {
		$preview = 61;
			$class = '';
		$layout = get_theme_mod( 'woo_product_layout', 2 );
		if ( is_product() ) {
			if ( 1 == $layout ) {
				$preview = 1;
			}
		} else {
			// 3 4 12 13
			if ( get_theme_mod( 'woo_layout', 3 ) > 10 ) {
				$preview = 22;
			}
		}
		$tid = zeen_get_term_id();
		$builder = empty( $tid ) ? '' : zeen_get_term_meta( 'tipi_builder_active', $tid );
		echo '<div id="primary" class="content-area">';
		echo '<div id="contents-wrap"';
		zeen_get_archive_layout_class( array( 'archive' => $preview, 'builder' => $builder ) );
		echo '>';

		echo '<div class="tipi-row content-bg clearfix"><div class="tipi-cols clearfix">';
		$ppl = 3;
		if ( 4 == $layout ) {
			$ppl = 4;
		} elseif ( 12 == $layout ) {
			$ppl = 2;
		}
		echo '<main id="main" class="main entry-content-wrap product-layout-' . (int) $layout . ' ' . esc_attr( zeen_classes( array( 'preview' => $preview, 'echo' => '', 'complete' => 'off' ) ) ) . '" data-ppl="' . (int) $ppl . '">';
	}
endif;
add_action( 'woocommerce_before_main_content', 'zeen_woo_before_main_content', 5 );

if ( ! function_exists( 'zeen_woo_after_main_content' ) ) :
	/**
	 * After main contenter
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_after_main_content() {
		echo '</main>';
		if ( zeen_sidebar_checker( array( 'archive' => 'woo' ) ) ) {
			get_sidebar();
		}
		echo '</div></div>';
		echo '</div></div>';
	}
	endif;
add_action( 'woocommerce_after_main_content', 'zeen_woo_after_main_content', 50 );

if ( ! function_exists( 'zeen_woo_archive_rows' ) ) :
	/**
	 * Rows
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_archive_rows() {
		$layout = get_theme_mod( 'woo_layout', 3 );
		if ( $layout < 10 ) {
			return $layout;
		}

		if ( 12 == $layout ) {
			return 2;
		} elseif ( 13 == $layout ) {
			return 3;
		}
	}
endif;
add_filter( 'loop_shop_columns', 'zeen_woo_archive_rows' );

if ( ! function_exists( 'zeen_woo_pagination' ) ) :
	/**
	 * Rows
	 *
	 * @since 1.0.0
	 */
	function zeen_woo_pagination() {
		$total   = wc_get_loop_prop( 'total_pages' );
		$current = wc_get_loop_prop( 'current_page' );
		$base    = esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
		$format  = '';

		return array( // WPCS: XSS ok.
			'base'         => $base,
			'format'       => $format,
			'add_args'     => false,
			'current'      => max( 1, $current ),
			'total'        => $total,
			'prev_text'         => '<i class="tipi-i-chevron-left"></i>',
			'next_text'         => '<i class="tipi-i-chevron-right"></i>',
		);
	}
endif;
add_filter( 'woocommerce_pagination_args', 'zeen_woo_pagination' );

if ( ! function_exists( 'zeen_woo_per_line' ) ) :
	function zeen_woo_per_line() {
		return get_theme_mod( 'woo_ppp', 9 );
	}
endif;
add_filter( 'loop_shop_per_page', 'zeen_woo_per_line', 20 );


if ( ! function_exists( 'zeen_woo_product_rating' ) ) :
	function zeen_woo_product_rating( $html, $rating, $count ) {
		$width = 100 - ( floatval( $rating ) * 20 );
		// NOTE: Inline style property is necessary here
		$output = '<span class="woo-product-rating">' . str_repeat( '<i class="tipi-i-star2"></i>', 5 ) . '<span style="width:' . (int) $width . '%;" class=""></span></span>';
		return $output;
	}
endif;
add_filter( 'woocommerce_get_star_rating_html', 'zeen_woo_product_rating', 10, 3 );

function zeen_woo_archive_rating() {
	if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' || get_theme_mod( 'woo_archive_stars', 1 ) != 1 || ! function_exists( 'get_rating_count' ) ) {
		return;
	}
	global $product;
	$rating_count = $product->get_rating_count();
	if ( 0 == $rating_count ) {
		return;
	}
	echo wc_get_rating_html( $product->get_average_rating(), $rating_count );
}
add_action( 'woocommerce_after_shop_loop_item', 'zeen_woo_archive_rating' );

if ( ! function_exists( 'zeen_woo_related_args' ) ) :
	function zeen_woo_related_args( $args ) {

		$layout = get_theme_mod( 'woo_layout', 3 );

		if ( 3 == $layout || 13 == $layout ) {
			$ppr = 3;
			$cols = 1;
		} elseif ( 4 == $layout ) {
			$ppr = 4;
			$cols = 1;
		} else {
			$ppr = 4;
			$cols = 2;
		}

		$args['posts_per_page'] = $ppr;
		$args['columns'] = $cols;
		return $args;
	}
endif;
add_filter( 'woocommerce_output_related_products_args', 'zeen_woo_related_args' );
if ( get_theme_mod( 'woo_related_products', 1 ) != 1 ) {
	remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
}

if ( ! function_exists( 'zeen_woo_cart_class' ) ) :
	function zeen_woo_cart_class() {
		return 'mini_cart_item clearfix';
	}
endif;
add_filter( 'woocommerce_mini_cart_item_class', 'zeen_woo_cart_class' );

if ( ! function_exists( 'zeen_woo_summary_bot' ) ) :
	function zeen_woo_summary_bot() {
		global $product;
		echo '<div class="product_meta">';
		do_action( 'woocommerce_product_meta_start' );
		if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) {
			$sku = $product->get_sku();
			echo '<span class="sku_wrapper">';
			esc_html_e( 'SKU:', 'zeen' );
			echo '<span class="sku">';
			if ( empty( $sku ) ) {
				esc_html__( 'N/A', 'zeen' );
			} else {
				echo esc_attr( $sku );
			}
			echo '</span></span>';
		}

		echo wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'zeen' ) . ' ', '</span>' );// WPCS: XSS ok

		do_action( 'woocommerce_product_meta_end' );

		echo '</div>';
	}
endif;

if ( ! function_exists( 'zeen_woo_empty_cart' ) ) :
	function zeen_woo_empty_cart() {
		$options = array(
			'qry'        => array(
				'post_type'      => 'product',
				'posts_per_page' => 3,
			),
			'preview'    => 61,
			'specific' => 'related',
			'img_shape' => 2,
			'excerpt_off' => true,
			'contained' => true,
			'meta_key' => 'total_sales',
			'orderby' => 'meta_value_num',
			'title' => esc_html__( 'Best Sellers', 'zeen' ),
		);

		echo '<div class="shop-empty-cart clearfix">';
		$block = zeen_block_pick( $options );
		$block->output();
		echo '</div>';
	}
endif;

if ( ! function_exists( 'zeen_woo_summary_top' ) ) :
	function zeen_woo_summary_top() {
		global $product;
		echo '<span class="woo-cats">' . wc_get_product_category_list( $product->get_id(), ', ' ) . '</span>'; // WPCS: XSS ok
	}
endif;
add_action( 'woocommerce_single_product_summary', 'zeen_woo_summary_top', 4 );
add_action( 'woocommerce_single_product_summary', 'zeen_woo_summary_bot', 40 );

if ( ! function_exists( 'zeen_woo_review_before' ) ) :
	function zeen_woo_review_before() {
		echo '<span class="review-meta-wrap">';
	}
endif;
add_action( 'woocommerce_review_before_comment_meta', 'zeen_woo_review_before', 9 );

if ( ! function_exists( 'zeen_woo_review_after' ) ) :
	function zeen_woo_review_after() {
		echo '</span>';
	}
endif;
add_action( 'woocommerce_review_meta', 'zeen_woo_review_after', 12 );

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_review_before', 'woocommerce_review_display_gravatar', 10 );
add_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_gravatar', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 11 );
remove_action( 'woocommerce_review_comment_text', 'woocommerce_review_display_comment_text', 10 );
add_action( 'woocommerce_review_comment_text', 'woocommerce_review_display_comment_text', 15 );
remove_action( 'woocommerce_review_before_comment_meta', 'woocommerce_review_display_rating', 10 );
add_action( 'woocommerce_review_meta', 'woocommerce_review_display_rating', 11 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
add_action( 'woocommerce_cart_is_empty', 'zeen_woo_empty_cart' );

// disable stylesheet
add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );
