<?php
/**
 * Let's Review
 *
 * @package Zeen
 * @since 1.0.0
 */

/**
 * Icon 1
 *
 * @since 1.0.0
*/
function zeen_lr_icon_1() {
	return 'tipi-i-cart-1 ';
}

/**
 * Icon 2
 *
 * @since 1.0.0
*/
function zeen_lr_icon_2() {
	return 'tipi-i-long-arrow-right ';
}

/**
 * Term Check
 *
 * @since 1.0.0
*/
function zeen_lr_cat_check() {
	$cats = get_categories();
	if ( ! empty( $cats ) ) {
		foreach ( $cats as $cat ) {
			if ( class_exists( 'Lets_Review_API' ) ) {
				$args = array(
					'posts_per_page' => -1,
					'meta_key' => '_lets_review_onoff',
					'meta_value' => 1,
					'cat' => $cat->term_id,
				);
				$qry = new WP_Query( $args );
				if ( $qry->have_posts() ) {
					update_term_meta( $cat->term_id, '_lets_review_active', true );
				} else {
					update_term_meta( $cat->term_id, '_lets_review_active', '' );
				}
			} else {
				update_term_meta( $cat->term_id, '_lets_review_active', '' );
			}
		}
	}
}
