<?php
/**
 * Zeen control radio image class
 *
 * @package    Zeen
 * @copyright  Copyright Codetipi
 * @since      1.0.0
 */
class Zeen_Control_Slider extends WP_Customize_Control {

	/**
	 * Control type
	 *
	 * @since  1.0.0
	 */
	public $type = 'zeen-slider';

	/**
	 * Enqueue control related scripts
	 *
	 * @since 1.0.0
	 */
	public function enqueue() {
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script( 'zeen-control-slider', get_parent_theme_file_uri( 'assets/admin/js/zeen-control-slider.js' ), array( 'jquery', 'jquery-ui-core', 'jquery-ui-slider' ), false, true );
	}

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @since 1.0.0
	 */
	public function to_json() {

		parent::to_json();

		$this->json['choices'] = $this->choices;
		$this->json['value']   = $this->value();
		$this->json['id']      = $this->id;
		$this->json['detection'] = empty( $this->choices['detection'] ) ? 'change' : $this->choices['detection'];

	}

	/**
	 * Render a JS template for the content of the control
	 *
	 * @since 1.0.0
	 */
	public function content_template() {
		?>
		<span class="zeen-control control-vertical-c zeen-slider-wrap zeen-cf">
			<# if ( data.label ) { #>
				<span class="customize-control-title">{{ data.label }} <# if ( data.description ) { #>
				<span class="tipi-tip description customize-control-description dashicons dashicons-editor-help" data-title="{{{ data.description }}}"></span>
			<# } #></span>
			<# } #>
			<div class="slider-control-wrap">
				<div class="zeen-slider" data-detection=" {{ data.detection }}" data-min="{{ data.choices['min'] }}" data-max="{{ data.choices['max'] }}" data-step="{{ data.choices['step'] }}" data-default="{{ data.choices['default'] }}"></div>
				
				<span class="zeen-tip"><span class="zeen-val-show">{{ data.value }}</span><span class="slider-type"><# if ( data.choices['type'] ) { #>{{ data.choices['type'] }}<# } #></span></span>

				<span class="zeen-data"><span class="dashicons dashicons-image-rotate zeen-reset" title="<?php esc_attr_e( 'Reset to default', 'zeen' ); ?>"></span><span class="zeen-val"><input name="_customize-zeen-slider-{{ data.id }}" class="zeen-val-input" value="{{ data.value }}" min="{{ data.choices['min'] }}" max="{{ data.choices['max'] }}" type="number"></span></span>
			</div>

		</span>

	<?php
	}
}
