<?php
/**
 * Zeen block social icons
 *
 * @since 1.0.0
 */

class ZeenBlockSocialIcons extends ZeenBlocks {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	*/
	public function __construct( $args ) {
		$this->type = 'social';
		parent::__construct( $args );
	}

	/**
	 * Block output
	 *
	 * @since 1.0.0
	 *
	*/
	public function output( $echo = true ) {

		if ( $this->enabled() != true ) {
			return;
		}

		if ( empty( $echo ) ) {
			ob_start();
		}
		$fs = $this->args['fs'];
		if ( empty( $this->args['only_inner'] ) ) {
			$this->opening_wrap();
			$this->block_title();
		}
		$icons = array();
		$use_to = empty( $this->args['use_to'] ) ? 'on' : $this->args['use_to'];
		$social_networks = array(
			array(
				'title' => 'Facebook',
				'network' => 'facebook',
				'icon' => 'facebook',
			),
			array(
				'title' => 'Twitter',
				'network' => 'twitter',
				'icon' => 'twitter',
			),
			array(
				'title' => 'Instagram',
				'network' => 'instagram',
				'icon' => 'instagram',
			),
			array(
				'title' => 'Pinterest',
				'network' => 'pinterest',
				'icon' => 'pinterest',
			),
			array(
				'title' => 'Youtube',
				'network' => 'youtube',
				'icon' => 'youtube-play',
			),
			array(
				'title' => 'Twitch',
				'network' => 'twitch',
				'icon' => 'twitch',
			),
			array(
				'title' => 'Spotify',
				'network' => 'spotify',
				'icon' => 'spotify',
			),
			array(
				'title' => 'Medium',
				'network' => 'medium',
				'icon' => 'medium',
			),
			array(
				'title' => 'Apple Music',
				'network' => 'apple_music',
				'icon' => 'apple_music',
			),
			array(
				'title' => 'Patreon',
				'network' => 'patreon',
				'icon' => 'patreon',
			),
			array(
				'title' => 'Tumblr',
				'network' => 'tumblr',
				'icon' => 'tumblr',
			),
			array(
				'title' => 'Vimeo',
				'network' => 'vimeo',
				'icon' => 'vimeo',
			),
			array(
				'title' => 'Soundcloud',
				'network' => 'soundcloud',
				'icon' => 'soundcloud',
			),
			array(
				'title' => 'VK',
				'network' => 'vk',
				'icon' => 'vk',
			),
			array(
				'title' => 'Linkedin',
				'network' => 'linkedin',
				'icon' => 'linkedin',
			),
		);
		foreach ( $social_networks as $key => $value ) {
			$social_networks[ $key ]['url'] = 'on' == $use_to || empty( $this->args[ $value['network'] . '_url'] ) ? get_theme_mod( 'icons_' . $value['network'] ) : $this->args[ $value['network'] . '_url' ];
		}
		$classes = 'on' == $this->args['centered'] ? ' centered' : '';
		$i = 1;
		?>
		<span class="social-icons clearfix<?php echo esc_attr( $classes ); ?>">
			<ul class="horizontal-menu menu-icons--wrap">
				<?php foreach ( $social_networks as $key ) { ?>
					<?php $url = $key['url']; ?>
					<li class="menu-icon menu-icon-<?php echo esc_attr( $key['icon'] ); ?><?php $this->animation_class(); ?>" style="--animation-order: <?php echo (int) $i; ?>">
						<a href="<?php echo esc_url( $url ); ?>" data-title="<?php echo esc_attr( $key['title'] ); ?>" class="tipi-i-<?php echo esc_attr( $key['icon'] ); ?> tipi-tip tipi-tip-move" rel="noopener" target="_blank"></a>
					</li>
					<?php $i++; ?>
				<?php } ?>
			</ul>
		</span>
		<?php

		if ( empty( $this->args['only_inner'] ) ) {
			$this->closing_wrap();
		}
		if ( empty( $echo ) ) {
			return ob_get_clean();
		}

	}
}
