<?php
/**
 * Theme functions
 *
 * @package Zeen
 * @since 1.0.0
 */

/**
 *  Version constant
 */
define( 'ZEEN_VERSION', '3.2.0' );
define( 'ZEEN_DEBUG', ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) );

/**
 * Theme engine
 */
require get_parent_theme_file_path( 'inc/core/engine.php' );

/**
 * Backend Scripts
 */
function zeen_enqueue_scripts_admin( $pagenow = '' ) {

	if ( is_customize_preview() ) {
		wp_deregister_style( 'wsl-admin' );
		return;
	}

	if ( 'post.php' == $pagenow || 'post-new.php' == $pagenow || 'widgets.php' == $pagenow || 'term.php' == $pagenow || 'edit-tags.php' == $pagenow || 'nav-menus.php' == $pagenow ) {
		$ext = is_rtl() ? 'style-rtl.min.css' : 'style.min.css';
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'zeen-control-color-a', get_parent_theme_file_uri( '/assets/admin/js/zeen-control-color-a.js' ), array( 'jquery', 'wp-color-picker' ), false, true );
		wp_enqueue_style( 'zeen-admin', get_parent_theme_file_uri( 'assets/admin/css/' . $ext ), array(), ZEEN_VERSION );
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script( 'suggest' );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_media();
		wp_enqueue_script( 'alpha-color-picker', get_parent_theme_file_uri( 'assets/admin/js/alpha-color-picker.js' ), array( 'jquery' ), ZEEN_VERSION, true );
		wp_enqueue_script( 'searchable-option-list', get_parent_theme_file_uri( 'assets/admin/js/searchable-option-list.js' ), array( 'jquery' ), ZEEN_VERSION, true );
		wp_enqueue_script( 'zeen-admin-js', get_parent_theme_file_uri( 'assets/admin/js/zeen-admin.js' ), array( 'jquery', 'jquery-ui-core', 'jquery-ui-slider', 'wp-color-picker', 'alpha-color-picker', 'searchable-option-list', 'jquery-ui-datepicker', 'suggest' ), ZEEN_VERSION, true );
		$tipi_builder_active = '';
		if ( 'post.php' == $pagenow || 'post-new.php' == $pagenow ) {
			global $post;
			$tipi_builder_active = get_post_meta( $post->ID, 'tipi_builder_active', true ) == true ? true : false;
		}

		wp_localize_script( 'zeen-admin-js', 'zeenJS',
			array(
				'i18n'                => Zeen\ZeenI18n::zeen_admin_i18n(),
				'slug'                => esc_url( basename( get_parent_theme_file_path() ) ),
				'tipiBuilderActive'   => $tipi_builder_active,
				'slug'                => esc_url( basename( get_parent_theme_file_path() ) ),
				'args'                => Zeen\ZeenHelpers::zeen_admin_args(),
				'adminNonce'          => wp_create_nonce( 'zeen_nonce' ),
				'ajaxURL'             => admin_url( 'admin-ajax.php' ),
			)
		);
	}
}
add_action( 'admin_enqueue_scripts', 'zeen_enqueue_scripts_admin' );

function zeen_enqueue_block_editor_assets() {
	wp_enqueue_style( 'zeen-block-editor', get_parent_theme_file_uri( 'assets/admin/css/editor.css' ), array(), ZEEN_VERSION );
	wp_add_inline_style( 'zeen-block-editor', zeen_get_extra_style_admin() );
	zeen_font_loader();
}
add_action( 'enqueue_block_editor_assets', 'zeen_enqueue_block_editor_assets' );

/**
 * Frontend scripts
 *
 * @since    1.0.0
 */
function zeen_enqueue_scripts() {

	global $wp_query;
	$css_suffix = 1 == get_theme_mod( 'minify_css', 1 ) ? '.min' : '';
	$css_suffix = ZEEN_DEBUG ? '' : $css_suffix;
	$css_suffix = is_rtl() ? '-rtl' . $css_suffix : $css_suffix;
	$style_uri = get_theme_mod( 'mobile_site' ) == 1 && zeen_is_mobile_site() == 'isMob' ? 'style-mobile' . $css_suffix . '.css' : 'style' . $css_suffix . '.css';
	$style_uri = 1 == get_theme_mod( 'responsive', 1 ) ? $style_uri : 'style-unresponsive' . $css_suffix . '.css';
	$js_suffix = 1 == get_theme_mod( 'minify_js', 1 ) ? '.min' : '';
	$js_suffix = ZEEN_DEBUG ? '' : $js_suffix;

	// Theme stylesheet.
	wp_enqueue_style( 'zeen-style', get_parent_theme_file_uri( 'assets/css/' . $style_uri ), array(), ZEEN_VERSION );
	wp_add_inline_style( 'zeen-style', zeen_get_extra_style() );
	if ( zeen_bbp_active() || zeen_bp_active() ) {
		$bbp_style = ZEEN_DEBUG ? 'bbp-buddypress.css' : 'bbp-buddypress.min.css';
		wp_enqueue_style( 'zeen-bbp-buddypress-style', get_parent_theme_file_uri( 'assets/css/' . $bbp_style ), array(), ZEEN_VERSION );
	}
	if ( zeen_woo_active() ) {
		$woo_style = ZEEN_DEBUG ? 'woocommerce.css' : 'woocommerce.min.css';
		wp_enqueue_style( 'zeen-woocommerce-style', get_parent_theme_file_uri( 'assets/css/' . $woo_style ), array(), ZEEN_VERSION );
	}
	zeen_font_loader();

	// Load html5 shiv
	wp_enqueue_script( 'zeen-ie9', get_parent_theme_file_uri( 'assets/js/ie9.js' ), array(), ZEEN_VERSION );
	wp_script_add_data( 'zeen-ie9', 'conditional', 'IE' );
	global $is_IE;
	global $is_edge;
	if ( $is_IE || $is_edge ) {
		// wp_script_add_data only works for IE9 and below.
		wp_enqueue_script( 'zeen-ie', get_parent_theme_file_uri( 'assets/js/ie.js' ), array( 'jquery' ), ZEEN_VERSION, true );
	}
	wp_enqueue_script( 'tween-lite', get_parent_theme_file_uri( 'assets/js/gsap/TweenLite.min.js' ), array(), '1.20.5', true );
	wp_enqueue_script( 'css-plugin', get_parent_theme_file_uri( 'assets/js/gsap/CSSPlugin.min.js' ), array( 'tween-lite' ), '1.20.5', true );
	wp_enqueue_script( 'cookie', get_parent_theme_file_uri( 'assets/js/cookie.min.js' ), array(), '2.1.3', true );
	wp_enqueue_script( 'flickity', get_parent_theme_file_uri( 'assets/js/flickity.pkgd.min.js' ), array(), '2.1.2', true );
	wp_enqueue_script( 'flickity-full-screen', get_parent_theme_file_uri( 'assets/js/flickity-full-screen.min.js' ), array( 'flickity' ), '1.1.0', true );
	wp_enqueue_script( 'flickity-fade', get_parent_theme_file_uri( 'assets/js/flickity-fade.min.js' ), array( 'flickity' ), '1.0.0', true );
	wp_enqueue_script( 'hover-intent', get_parent_theme_file_uri( 'assets/js/hoverIntent.min.js' ), array(), '1.9.0', true );
	wp_enqueue_script( 'menu-aim', get_parent_theme_file_uri( 'assets/js/menu-aim.min.js' ), array(), '1.9.0', true );
	wp_enqueue_script( 'obs', get_parent_theme_file_uri( 'assets/js/obs.min.js' ), array(), '1.0.0', true );
	wp_enqueue_script( 'scroll-magic', get_parent_theme_file_uri( 'assets/js/scrollmagic.min.js' ), array(), '2.0.5', true );
	wp_enqueue_script( 'sticky-kit', get_parent_theme_file_uri( 'assets/js/sticky-kit.min.js' ), array(), '2.2.3', true );
	$dep = array( 'jquery', 'tween-lite', 'cookie', 'flickity', 'flickity-fade', 'flickity-full-screen', 'hover-intent', 'obs', 'sticky-kit', 'scroll-magic', 'menu-aim' );
	if ( get_theme_mod( 'lightbox', 1 ) == 1 ) {
		wp_enqueue_script( 'swipebox', get_parent_theme_file_uri( 'assets/js/swipebox.min.js' ), array(), '1.4.4', true );
		$dep[] = 'swipebox';
	}
	wp_enqueue_script( 'zeen-functions', get_parent_theme_file_uri( 'assets/js/functions' . $js_suffix . '.js' ), $dep, ZEEN_VERSION, true );
	wp_localize_script( 'zeen-functions', 'zeenJS',
		array(
			'root'          => esc_url_raw( rest_url() ) . 'codetipi-zeen/v1/',
			'nonce'         => wp_create_nonce( 'wp_rest' ),
			'qry'           => zeen_get_qry(),
			'args'          => Zeen\ZeenHelpers::zeen_args(),
			'i18n'          => Zeen\ZeenI18n::zeen_i18n(),
		)
	);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	$analytics = get_theme_mod( 'google_analytics' );
	if ( ! empty( $analytics ) ) {
		wp_enqueue_script( 'google-analytics', 'https://www.google-analytics.com/analytics.js', array(), '', true );
	}

	// Theme controls these plugin's styling
	wp_dequeue_style( 'login-with-ajax' );
	wp_dequeue_style( 'wsl-widget' );
	wp_deregister_style( 'bbp-default' );
}
add_action( 'wp_enqueue_scripts', 'zeen_enqueue_scripts' );
