<?php
/**
 * @package Zeen
 * @since 1.0.0
 */

get_header();

$preview = zeen_preview_check();
$fw = zeen_fw_checker( $preview );
$design = get_theme_mod( 'author_page_style', 1 );
?>
<div id="primary" class="content-area">
	<div id="contents-wrap" <?php zeen_get_archive_layout_class( array( 'archive' => $preview ) ); ?>>
		<?php
		if ( empty( $fw ) ) {
			echo '<div class="tipi-row content-bg clearfix">';
		}

		if ( 1 == $design ) {
			zeen_author_page_block( array(
				'aid' => $author,
				'design' => 1,
				'action_type' => 'archive',
			) );
		}
		zeen_ad( 'archive' );

		if ( empty( $fw ) ) {
			echo '<div class="tipi-cols clearfix">';
		}
		if ( 2 == $design ) {
			zeen_get_sidebar( array( 'archive' => $preview, 'author_design' => $design, 'aid' => $author ) );
		}
		?>
		<main id="main" <?php zeen_classes( array( 'preview' => $preview ) ); ?>>
			<?php if ( have_posts() ) : ?>
				<?php zeen_main_layout( array( 'preview' => $preview ) ); ?>
			<?php else : ?>
				<?php zeen_main_layout_none(); ?>
			<?php endif; ?>
		</main><!-- .site-main -->
		<?php
		if ( 1 == $design ) {
			zeen_get_sidebar( array( 'archive' => $preview ) );
		}
		?>
		<?php if ( empty( $fw ) ) { ?>
			</div>
		</div>
		<?php } ?>
	</div>
</div><!-- .content-area -->

<?php
get_footer();
