/*!
 * ScrollMagic v2.0.5 (2015-04-29)
 * The javascript library for magical scroll interactions.
 * (c) 2015 Jan Paepke (@janpaepke)
 * Project Website: http://scrollmagic.io
 * 
 * @version 2.0.5
 * @license Dual licensed under MIT license and GPL.
 * @author Jan Paepke - e-mail@janpaepke.de
 *
 * @file ScrollMagic main library.
 */
!function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.ScrollMagic=t()}(this,function(){"use strict";var z=function(){j.log(2,"(COMPATIBILITY NOTICE) -> As of ScrollMagic 2.0.0 you need to use 'new ScrollMagic.Controller()' to create a new controller instance. Use 'new ScrollMagic.Scene()' to instance a scene.")},I="data-scrollmagic-pin-spacer",t=!(z.version="2.0.5");try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",e,e),window.removeEventListener("test",e,e)}catch(e){t=!1}var k=!!t&&{passive:!0};window.addEventListener("mousewheel",function(){},k),z.Controller=function(e){var n,o,r="ScrollMagic.Controller",i="REVERSE",t="PAUSED",l=O.defaults,a=this,s=j.extend({},l,e),c=[],u=!1,d=0,f=t,g=!0,p=0,h=!0,v=function(){0<s.refreshInterval&&(o=window.setTimeout(R,s.refreshInterval))},m=function(){return s.vertical?j.get.scrollTop(s.container):j.get.scrollLeft(s.container)},w=function(){return s.vertical?s.container===window?document.documentElement.clientHeight:j.get.height(s.container):j.get.width(s.container)},y=this._setScrollPos=function(e){s.vertical?g?window.scrollTo(j.get.scrollLeft(),e):s.container.scrollTop=e:g?window.scrollTo(e,j.get.scrollTop()):s.container.scrollLeft=e},S=function(){if(h&&u){var n=j.type.Array(u)?u:c.slice(0);u=!1;var e=d,t=(d=a.scrollPos())-e;0!==t&&(f=0<t?"FORWARD":i),f===i&&n.reverse(),n.forEach(function(e,t){T(3,"updating Scene "+(t+1)+"/"+n.length+" ("+c.length+" total)"),e.update(!0)}),0===n.length&&3<=s.loglevel&&T(3,"updating 0 Scenes (nothing added to controller)")}},b=function(){n=j.rAF(S)},E=function(e){T(3,"event fired causing an update:",e.type),"resize"==e.type&&(p=w(),f=t),!0!==u&&(u=!0,b())},R=function(){if(!g&&p!=w()){var t;try{t=new Event("resize",{bubbles:!1,cancelable:!1})}catch(e){(t=document.createEvent("Event")).initEvent("resize",!1,!1)}s.container.dispatchEvent(t)}c.forEach(function(e,t){e.refresh()}),v()},T=this._log=function(e,t){s.loglevel>=e&&(Array.prototype.splice.call(arguments,1,0,"("+r+") ->"),j.log.apply(window,arguments))};this._options=s;var C=function(e){if(e.length<=1)return e;var t=e.slice(0);return t.sort(function(e,t){return e.scrollOffset()>t.scrollOffset()?1:-1}),t};return this.addScene=function(e){if(j.type.Array(e))e.forEach(function(e,t){a.addScene(e)});else if(e instanceof z.Scene){if(e.controller()!==a)e.addTo(a);else if(c.indexOf(e)<0){for(var t in c.push(e),c=C(c),e.on("shift.controller_sort",function(){c=C(c)}),s.globalSceneOptions)e[t]&&e[t].call(e,s.globalSceneOptions[t]);T(3,"adding Scene (now "+c.length+" total)")}}else T(1,"ERROR: invalid argument supplied for '.addScene()'");return a},this.removeScene=function(e){if(j.type.Array(e))e.forEach(function(e,t){a.removeScene(e)});else{var t=c.indexOf(e);-1<t&&(e.off("shift.controller_sort"),c.splice(t,1),T(3,"removing Scene (now "+c.length+" left)"),e.remove())}return a},this.updateScene=function(e,n){return j.type.Array(e)?e.forEach(function(e,t){a.updateScene(e,n)}):n?e.update(!0):!0!==u&&e instanceof z.Scene&&(-1==(u=u||[]).indexOf(e)&&u.push(e),u=C(u),b()),a},this.update=function(e){return E({type:"resize"}),e&&S(),a},this.scrollTo=function(e,t){if(j.type.Number(e))y.call(s.container,e,t);else if(e instanceof z.Scene)e.controller()===a?a.scrollTo(e.scrollOffset(),t):T(2,"scrollTo(): The supplied scene does not belong to this controller. Scroll cancelled.",e);else if(j.type.Function(e))y=e;else{var n=j.get.elements(e)[0];if(n){for(;n.parentNode.hasAttribute(I);)n=n.parentNode;var o=s.vertical?"top":"left",r=j.get.offset(s.container),i=j.get.offset(n);g||(r[o]-=a.scrollPos()),a.scrollTo(i[o]-r[o],t)}else T(2,"scrollTo(): The supplied argument is invalid. Scroll cancelled.",e)}return a},this.scrollPos=function(e){return arguments.length?(j.type.Function(e)?m=e:T(2,"Provided value for method 'scrollPos' is not a function. To change the current scroll position use 'scrollTo()'."),a):m.call(a)},this.info=function(e){var t={size:p,vertical:s.vertical,scrollPos:d,scrollDirection:f,container:s.container,isDocument:g};return arguments.length?void 0!==t[e]?t[e]:void T(1,'ERROR: option "'+e+'" is not available'):t},this.loglevel=function(e){return arguments.length?(s.loglevel!=e&&(s.loglevel=e),a):s.loglevel},this.enabled=function(e){return arguments.length?(h!=e&&(h=!!e,a.updateScene(c,!0)),a):h},this.destroy=function(e){window.clearTimeout(o);for(var t=c.length;t--;)c[t].destroy(e);return s.container.removeEventListener("resize",E,k),s.container.removeEventListener("scroll",E,k),j.cAF(n),T(3,"destroyed "+r+" (reset: "+(e?"true":"false")+")"),null},function(){for(var e in s)l.hasOwnProperty(e)||(T(2,'WARNING: Unknown option "'+e+'"'),delete s[e]);if(s.container=j.get.elements(s.container)[0],!s.container)throw T(1,"ERROR creating object "+r+": No valid scroll container supplied"),r+" init failed.";(g=s.container===window||s.container===document.body||!document.body.contains(s.container))&&(s.container=window),p=w(),s.container.addEventListener("resize",E,k),s.container.addEventListener("scroll",E,k);var t=parseInt(s.refreshInterval,10);s.refreshInterval=j.type.Number(t)?t:l.refreshInterval,v(),T(3,"added new "+r+" controller (v"+z.version+")")}(),a};var O={defaults:{container:window,vertical:!0,globalSceneOptions:{},loglevel:2,refreshInterval:100}};z.Controller.addOption=function(e,t){O.defaults[e]=t},z.Controller.extend=function(e){var t=this;z.Controller=function(){return t.apply(this,arguments),this.$super=j.extend({},this),e.apply(this,arguments)||this},j.extend(z.Controller,t),z.Controller.prototype=t.prototype,z.Controller.prototype.constructor=z.Controller},z.Scene=function(e){var n,s,o="ScrollMagic.Scene",c="BEFORE",u="DURING",d="AFTER",r=_.defaults,f=this,g=j.extend({},r,e),p=c,h=0,a={start:0,end:0},v=0,i=!0,l={};this.on=function(e,r){return j.type.Function(r)?(e=e.trim().split(" ")).forEach(function(e){var t=e.split("."),n=t[0],o=t[1];"*"!=n&&(l[n]||(l[n]=[]),l[n].push({namespace:o||"",callback:r}))}):m(1,"ERROR when calling '.on()': Supplied callback for '"+e+"' is not a valid function!"),f},this.off=function(e,i){return e?(e=e.trim().split(" ")).forEach(function(e,t){var n=e.split("."),o=n[0],r=n[1]||"";("*"===o?Object.keys(l):[o]).forEach(function(e){for(var t=l[e]||[],n=t.length;n--;){var o=t[n];!o||r!==o.namespace&&"*"!==r||i&&i!=o.callback||t.splice(n,1)}t.length||delete l[e]})}):m(1,"ERROR: Invalid event name supplied."),f},this.trigger=function(e,n){if(e){var t=e.trim().split("."),o=t[0],r=t[1],i=l[o];m(3,"event fired:",o,n?"->":"",n||""),i&&i.forEach(function(e,t){r&&r!==e.namespace||e.callback.call(f,new z.Event(o,e.namespace,f,n))})}else m(1,"ERROR: Invalid event name supplied.");return f},f.on("change.internal",function(e){"loglevel"!==e.what&&"tweenChanges"!==e.what&&("triggerElement"===e.what?b():"reverse"===e.what&&f.update())}).on("shift.internal",function(e){t(),f.update()});var m=this._log=function(e,t){g.loglevel>=e&&(Array.prototype.splice.call(arguments,1,0,"("+o+") ->"),j.log.apply(window,arguments))};this.addTo=function(e){return e instanceof z.Controller?s!=e&&(s&&s.removeScene(f),s=e,T(),S(!0),b(!0),t(),s.info("container").addEventListener("resize",E),e.addScene(f),f.trigger("add",{controller:s}),m(3,"added "+o+" to controller"),f.update()):m(1,"ERROR: supplied argument of 'addTo()' is not a valid ScrollMagic Controller"),f},this.enabled=function(e){return arguments.length?(i!=e&&(i=!!e,f.update(!0)),f):i},this.remove=function(){if(s){s.info("container").removeEventListener("resize",E);var e=s;s=void 0,e.removeScene(f),f.trigger("remove"),m(3,"removed "+o+" from controller")}return f},this.destroy=function(e){return f.trigger("destroy",{reset:e}),f.remove(),f.triggerElement(null),f.off("*.*"),m(3,"destroyed "+o+" (reset: "+(e?"true":"false")+")"),null},this.update=function(e){if(s)if(e)if(s.enabled()&&i){var t,n=s.info("scrollPos");t=0<g.duration?(n-a.start)/(a.end-a.start):n>=a.start?1:0,f.trigger("update",{startPos:a.start,endPos:a.end,scrollPos:n}),f.progress(t)}else w&&p===u&&x(!0);else s.updateScene(f,!1);return f},this.refresh=function(){return S(),b(),f},this.progress=function(e){if(arguments.length){var t=!1,n=p,o=s?s.info("scrollDirection"):"PAUSED",r=g.reverse||h<=e;if(0===g.duration?(t=h!=e,p=0===(h=e<1&&r?0:1)?c:u):e<0&&p!==c&&r?(p=c,t=!(h=0)):0<=e&&e<1&&r?(h=e,p=u,t=!0):1<=e&&p!==d?(h=1,p=d,t=!0):p!==u||r||x(),t){var i={progress:h,state:p,scrollDirection:o},l=p!=n,a=function(e){f.trigger(e,i)};l&&n!==u&&(a("enter"),a(n===c?"start":"end")),a("progress"),l&&p!==u&&(a(p===c?"start":"end"),a("leave"))}return f}return h};var w,y,t=function(){a={start:v+g.offset},s&&g.triggerElement&&(a.start-=s.info("size")*g.triggerHook),a.end=a.start+g.duration},S=function(e){if(n){var t="duration";C(t,n.call(f))&&!e&&(f.trigger("change",{what:t,newval:g[t]}),f.trigger("shift",{reason:t}))}},b=function(e){var t=0,n=g.triggerElement;if(s&&(n||0<v)){if(n)if(n.parentNode){for(var o=s.info(),r=j.get.offset(o.container),i=o.vertical?"top":"left";n.parentNode.hasAttribute(I);)n=n.parentNode;var l=j.get.offset(n);o.isDocument||(r[i]-=s.scrollPos()),t=l[i]-r[i]}else m(2,"WARNING: triggerElement was removed from DOM and will be reset to",void 0),f.triggerElement(void 0);var a=t!=v;v=t,a&&!e&&f.trigger("shift",{reason:"triggerElementPosition"})}},E=function(e){0<g.triggerHook&&f.trigger("shift",{reason:"containerResize"})},R=j.extend(_.validate,{duration:function(t){if(j.type.String(t)&&t.match(/^(\.|\d)*\d+%$/)){var e=parseFloat(t)/100;t=function(){return s?s.info("size")*e:0}}if(j.type.Function(t)){n=t;try{t=parseFloat(n())}catch(e){t=-1}}if(t=parseFloat(t),!j.type.Number(t)||t<0)throw n?(n=void 0,['Invalid return value of supplied function for option "duration":',t]):['Invalid value for option "duration":',t];return t}}),T=function(e){(e=arguments.length?[e]:Object.keys(R)).forEach(function(t,e){var n;if(R[t])try{n=R[t](g[t])}catch(e){n=r[t];var o=j.type.String(e)?[e]:e;j.type.Array(o)?(o[0]="ERROR: "+o[0],o.unshift(1),m.apply(this,o)):m(1,"ERROR: Problem executing validation callback for option '"+t+"':",e.message)}finally{g[t]=n}})},C=function(e,t){var n=!1,o=g[e];return g[e]!=t&&(g[e]=t,T(e),n=o!=g[e]),n},O=function(t){f[t]||(f[t]=function(e){return arguments.length?("duration"===t&&(n=void 0),C(t,e)&&(f.trigger("change",{what:t,newval:g[t]}),-1<_.shifts.indexOf(t)&&f.trigger("shift",{reason:t})),f):g[t]})};this.controller=function(){return s},this.state=function(){return p},this.scrollOffset=function(){return a.start},this.triggerPosition=function(){var e=g.offset;return s&&(g.triggerElement?e+=v:e+=s.info("size")*f.triggerHook()),e},f.on("shift.internal",function(e){var t="duration"===e.reason;(p===d&&t||p===u&&0===g.duration)&&x(),t&&M()}).on("progress.internal",function(e){x()}).on("add.internal",function(e){M()}).on("destroy.internal",function(e){f.removePin(e.reset)});var x=function(e){if(w&&s){var t=s.info(),n=y.spacer.firstChild;if(e||p!==u){var o={position:y.inFlow?"relative":"absolute",top:0,left:0},r=j.css(n,"position")!=o.position;y.pushFollowers?0<g.duration&&(p===d&&0===parseFloat(j.css(y.spacer,"padding-top"))?r=!0:p===c&&0===parseFloat(j.css(y.spacer,"padding-bottom"))&&(r=!0)):o[t.vertical?"top":"left"]=g.duration*h,j.css(n,o),r&&M()}else{"fixed"!=j.css(n,"position")&&(j.css(n,{position:"fixed"}),M());var i=j.get.offset(y.spacer,!0),l=g.reverse||0===g.duration?t.scrollPos-a.start:Math.round(h*g.duration*10)/10;i[t.vertical?"top":"left"]+=l,j.css(y.spacer.firstChild,{top:i.top,left:i.left})}}},M=function(){if(w&&s&&y.inFlow){var e=p===u,t=s.info("vertical"),n=y.spacer.firstChild,o=j.isMarginCollapseType(j.css(y.spacer,"display")),r={};y.relSize.width||y.relSize.autoFullWidth?e?j.css(w,{width:j.get.width(y.spacer)}):j.css(w,{width:"100%"}):(r["min-width"]=j.get.width(t?w:n,!0,!0),r.width=e?r["min-width"]:"auto"),y.relSize.height?e?j.css(w,{height:j.get.height(y.spacer)-(y.pushFollowers?g.duration:0)}):j.css(w,{height:"100%"}):(r["min-height"]=j.get.height(t?n:w,!0,!o),r.height=e?r["min-height"]:"auto"),y.pushFollowers&&(r["padding"+(t?"Top":"Left")]=g.duration*h,r["padding"+(t?"Bottom":"Right")]=g.duration*(1-h)),j.css(y.spacer,r)}},N=function(){s&&w&&p===u&&!s.info("isDocument")&&x()},P=function(){s&&w&&p===u&&((y.relSize.width||y.relSize.autoFullWidth)&&j.get.width(window)!=j.get.width(y.spacer.parentNode)||y.relSize.height&&j.get.height(window)!=j.get.height(y.spacer.parentNode))&&M()},F=function(e){s&&w&&p===u&&!s.info("isDocument")&&(console.log("onMousewheelOverPin => "),e.preventDefault(),s._setScrollPos(s.info("scrollPos")-((e.wheelDelta||e[s.info("vertical")?"wheelDeltaY":"wheelDeltaX"])/3||30*-e.detail)))};this.setPin=function(e,t){if(t=j.extend({},{pushFollowers:!0,spacerClass:"scrollmagic-pin-spacer"},t),!(e=j.get.elements(e)[0]))return m(1,"ERROR calling method 'setPin()': Invalid pin element supplied."),f;if("fixed"===j.css(e,"position"))return m(1,"ERROR calling method 'setPin()': Pin does not work with elements that are positioned 'fixed'."),f;if(w){if(w===e)return f;f.removePin()}var n=(w=e).parentNode.style.display,o=["top","left","bottom","right","margin","marginLeft","marginRight","marginTop","marginBottom"];w.parentNode.style.display="none";var r="absolute"!=j.css(w,"position"),i=j.css(w,o.concat(["display"])),l=j.css(w,["width","height"]);w.parentNode.style.display=n,!r&&t.pushFollowers&&(m(2,"WARNING: If the pinned element is positioned absolutely pushFollowers will be disabled."),t.pushFollowers=!1),window.setTimeout(function(){w&&0===g.duration&&t.pushFollowers&&m(2,"WARNING: pushFollowers =",!0,"has no effect, when scene duration is 0.")},0);var a=w.parentNode.insertBefore(document.createElement("div"),w),s=j.extend(i,{position:r?"relative":"absolute",boxSizing:"content-box",mozBoxSizing:"content-box",webkitBoxSizing:"content-box"});if(r||j.extend(s,j.css(w,["width","height"])),j.css(a,s),a.setAttribute(I,""),j.addClass(a,t.spacerClass),y={spacer:a,relSize:{width:"%"===l.width.slice(-1),height:"%"===l.height.slice(-1),autoFullWidth:"auto"===l.width&&r&&j.isMarginCollapseType(i.display)},pushFollowers:t.pushFollowers,inFlow:r},!w.___origStyle){w.___origStyle={};var c=w.style;o.concat(["width","height","position","boxSizing","mozBoxSizing","webkitBoxSizing"]).forEach(function(e){w.___origStyle[e]=c[e]||""})}return y.relSize.width&&j.css(a,{width:l.width}),y.relSize.height&&j.css(a,{height:l.height}),a.appendChild(w),j.css(w,{position:r?"relative":"absolute",margin:"auto",top:"auto",left:"auto",bottom:"auto",right:"auto"}),(y.relSize.width||y.relSize.autoFullWidth)&&j.css(w,{boxSizing:"border-box",mozBoxSizing:"border-box",webkitBoxSizing:"border-box"}),window.addEventListener("scroll",N,k),window.addEventListener("resize",N,k),window.addEventListener("resize",P,k),w.addEventListener("mousewheel",F,k),w.addEventListener("DOMMouseScroll",F,k),m(3,"added pin"),x(),f},this.removePin=function(e){if(w){if(p===u&&x(!0),e||!s){var t=y.spacer.firstChild;if(t.hasAttribute(I)){var n=y.spacer.style;margins={},["margin","marginLeft","marginRight","marginTop","marginBottom"].forEach(function(e){margins[e]=n[e]||""}),j.css(t,margins)}y.spacer.parentNode.insertBefore(t,y.spacer),y.spacer.parentNode.removeChild(y.spacer),w.parentNode.hasAttribute(I)||(j.css(w,w.___origStyle),delete w.___origStyle)}window.removeEventListener("scroll",N,k),window.removeEventListener("resize",N,k),window.removeEventListener("resize",P,k),w.removeEventListener("mousewheel",F,k),w.removeEventListener("DOMMouseScroll",F,k),w=void 0,y.spacer=null,m(3,"removed pin (reset: "+(e?"true":"false")+")")}return f};var A,L=[];return f.on("destroy.internal",function(e){f.removeClassToggle(e.reset)}),this.setClassToggle=function(e,t){var n=j.get.elements(e);return 0!==n.length&&j.type.String(t)?(0<L.length&&f.removeClassToggle(),A=t,L=n,f.on("enter.internal_class leave.internal_class",function(e){var n="enter"===e.type?j.addClass:j.removeClass;L.forEach(function(e,t){n(e,A)})})):m(1,"ERROR calling method 'setClassToggle()': Invalid "+(0===n.length?"element":"classes")+" supplied."),f},this.removeClassToggle=function(e){return e&&L.forEach(function(e,t){j.removeClass(e,A)}),f.off("start.internal_class end.internal_class"),A=void 0,L=[],f},function(){for(var e in g)r.hasOwnProperty(e)||(m(2,'WARNING: Unknown option "'+e+'"'),delete g[e]);for(var t in r)O(t);T()}(),f};var _={defaults:{duration:0,offset:0,triggerElement:void 0,triggerHook:.5,reverse:!0,loglevel:2},validate:{offset:function(e){if(e=parseFloat(e),!j.type.Number(e))throw['Invalid value for option "offset":',e];return e},triggerElement:function(e){if(e=e||void 0){var t=j.get.elements(e)[0];if(!t||!t.parentNode)throw['Element defined in option "triggerElement" was not found:',e];e=t}return e},triggerHook:function(e){var t={onCenter:.5,onEnter:1,onLeave:0};if(j.type.Number(e))e=Math.max(0,Math.min(parseFloat(e),1));else{if(!(e in t))throw['Invalid value for option "triggerHook": ',e];e=t[e]}return e},reverse:function(e){return!!e},loglevel:function(e){if(e=parseInt(e),!j.type.Number(e)||e<0||3<e)throw['Invalid value for option "loglevel":',e];return e}},shifts:["duration","offset","triggerHook"]};z.Scene.addOption=function(e,t,n,o){e in _.defaults?z._util.log(1,"[static] ScrollMagic.Scene -> Cannot add Scene option '"+e+"', because it already exists."):(_.defaults[e]=t,_.validate[e]=n,o&&_.shifts.push(e))},z.Scene.extend=function(e){var t=this;z.Scene=function(){return t.apply(this,arguments),this.$super=j.extend({},this),e.apply(this,arguments)||this},j.extend(z.Scene,t),z.Scene.prototype=t.prototype,z.Scene.prototype.constructor=z.Scene},z.Event=function(e,t,n,o){for(var r in o=o||{})this[r]=o[r];return this.type=e,this.target=this.currentTarget=n,this.namespace=t||"",this.timeStamp=this.timestamp=Date.now(),this};var j=z._util=function(l){var n,e={},a=function(e){return parseFloat(e)||0},s=function(e){return e.currentStyle?e.currentStyle:l.getComputedStyle(e)},o=function(e,t,n,o){if((t=t===document?l:t)===l)o=!1;else if(!p.DomElement(t))return 0;e=e.charAt(0).toUpperCase()+e.substr(1).toLowerCase();var r=(n?t["offset"+e]||t["outer"+e]:t["client"+e]||t["inner"+e])||0;if(n&&o){var i=s(t);r+="Height"===e?a(i.marginTop)+a(i.marginBottom):a(i.marginLeft)+a(i.marginRight)}return r},c=function(e){return e.replace(/^[^a-z]+([a-z])/g,"$1").replace(/-([a-z])/g,function(e){return e[1].toUpperCase()})};e.extend=function(e){for(e=e||{},n=1;n<arguments.length;n++)if(arguments[n])for(var t in arguments[n])arguments[n].hasOwnProperty(t)&&(e[t]=arguments[n][t]);return e},e.isMarginCollapseType=function(e){return-1<["block","flex","list-item","table","-webkit-box"].indexOf(e)};var r=0,t=["ms","moz","webkit","o"],i=l.requestAnimationFrame,u=l.cancelAnimationFrame;for(n=0;!i&&n<t.length;++n)i=l[t[n]+"RequestAnimationFrame"],u=l[t[n]+"CancelAnimationFrame"]||l[t[n]+"CancelRequestAnimationFrame"];i||(i=function(e){var t=(new Date).getTime(),n=Math.max(0,16-(t-r)),o=l.setTimeout(function(){e(t+n)},n);return r=t+n,o}),u||(u=function(e){l.clearTimeout(e)}),e.rAF=i.bind(l),e.cAF=u.bind(l);var d=["error","warn","log"],f=l.console||{};for(f.log=f.log||function(){},n=0;n<d.length;n++){var g=d[n];f[g]||(f[g]=f.log)}e.log=function(e){(d.length<e||e<=0)&&(e=d.length);var t=new Date,n=("0"+t.getHours()).slice(-2)+":"+("0"+t.getMinutes()).slice(-2)+":"+("0"+t.getSeconds()).slice(-2)+":"+("00"+t.getMilliseconds()).slice(-3),o=d[e-1],r=Array.prototype.splice.call(arguments,1),i=Function.prototype.bind.call(f[o],f);r.unshift(n),i.apply(f,r)};var p=e.type=function(e){return Object.prototype.toString.call(e).replace(/^\[object (.+)\]$/,"$1").toLowerCase()};p.String=function(e){return"string"===p(e)},p.Function=function(e){return"function"===p(e)},p.Array=function(e){return Array.isArray(e)},p.Number=function(e){return!p.Array(e)&&0<=e-parseFloat(e)+1},p.DomElement=function(e){return"object"==typeof HTMLElement?e instanceof HTMLElement:e&&"object"==typeof e&&null!==e&&1===e.nodeType&&"string"==typeof e.nodeName};var h=e.get={};return h.elements=function(e){var t=[];if(p.String(e))try{e=document.querySelectorAll(e)}catch(e){return t}if("nodelist"===p(e)||p.Array(e)||e instanceof NodeList)for(var n=0,o=t.length=e.length;n<o;n++){var r=e[n];t[n]=p.DomElement(r)?r:h.elements(r)}else(p.DomElement(e)||e===document||e===l)&&(t=[e]);return t},h.scrollTop=function(e){return e&&"number"==typeof e.scrollTop?e.scrollTop:l.pageYOffset||0},h.scrollLeft=function(e){return e&&"number"==typeof e.scrollLeft?e.scrollLeft:l.pageXOffset||0},h.width=function(e,t,n){return o("width",e,t,n)},h.height=function(e,t,n){return o("height",e,t,n)},h.offset=function(e,t){var n={top:0,left:0};if(e&&e.getBoundingClientRect){var o=e.getBoundingClientRect();n.top=o.top,n.left=o.left,t||(n.top+=h.scrollTop(),n.left+=h.scrollLeft())}return n},e.addClass=function(e,t){t&&(e.classList?e.classList.add(t):e.className+=" "+t)},e.removeClass=function(e,t){t&&(e.classList?e.classList.remove(t):e.className=e.className.replace(new RegExp("(^|\\b)"+t.split(" ").join("|")+"(\\b|$)","gi")," "))},e.css=function(e,t){if(p.String(t))return s(e)[c(t)];if(p.Array(t)){var n={},o=s(e);return t.forEach(function(e,t){n[e]=o[c(e)]}),n}for(var r in t){var i=t[r];i==parseFloat(i)&&(i+="px"),e.style[c(r)]=i}},e}(window||{});return z.Scene.prototype.addIndicators=function(){return z._util.log(1,"(ScrollMagic.Scene) -> ERROR calling addIndicators() due to missing Plugin 'debug.addIndicators'. Please make sure to include plugins/debug.addIndicators.js"),this},z.Scene.prototype.removeIndicators=function(){return z._util.log(1,"(ScrollMagic.Scene) -> ERROR calling removeIndicators() due to missing Plugin 'debug.addIndicators'. Please make sure to include plugins/debug.addIndicators.js"),this},z.Scene.prototype.setTween=function(){return z._util.log(1,"(ScrollMagic.Scene) -> ERROR calling setTween() due to missing Plugin 'animation.gsap'. Please make sure to include plugins/animation.gsap.js"),this},z.Scene.prototype.removeTween=function(){return z._util.log(1,"(ScrollMagic.Scene) -> ERROR calling removeTween() due to missing Plugin 'animation.gsap'. Please make sure to include plugins/animation.gsap.js"),this},z.Scene.prototype.setVelocity=function(){return z._util.log(1,"(ScrollMagic.Scene) -> ERROR calling setVelocity() due to missing Plugin 'animation.velocity'. Please make sure to include plugins/animation.velocity.js"),this},z.Scene.prototype.removeVelocity=function(){return z._util.log(1,"(ScrollMagic.Scene) -> ERROR calling removeVelocity() due to missing Plugin 'animation.velocity'. Please make sure to include plugins/animation.velocity.js"),this},z}),
/*!
 * ScrollMagic v2.0.5 (2015-04-29)
 * The javascript library for magical scroll interactions.
 * (c) 2015 Jan Paepke (@janpaepke)
 * Project Website: http://scrollmagic.io
 * 
 * @version 2.0.5
 * @license Dual licensed under MIT license and GPL.
 * @author Jan Paepke - e-mail@janpaepke.de
 *
 * @file ScrollMagic jQuery plugin.
 *
 * requires: jQuery ~1.11 or ~2.1
 */
function(e,t){"function"==typeof define&&define.amd?define(["ScrollMagic","jquery"],t):"object"==typeof exports?t(require("scrollmagic"),require("jquery")):t(e.ScrollMagic,e.jQuery)}(this,function(e,n){"use strict";var t="jquery.ScrollMagic",o=window.console||{},r=Function.prototype.bind.call(o.error||o.log||function(){},o);e||r("("+t+") -> ERROR: The ScrollMagic main module could not be found. Please make sure it's loaded before this plugin or use an asynchronous loader like requirejs."),n||r("("+t+") -> ERROR: jQuery could not be found. Please make sure it's loaded before ScrollMagic or use an asynchronous loader like requirejs."),e._util.get.elements=function(e){return n(e).toArray()},e._util.addClass=function(e,t){n(e).addClass(t)},e._util.removeClass=function(e,t){n(e).removeClass(t)},n.ScrollMagic=e}),
/*!
 * @file ScrollMagic GSAP Animation Plugin.
 *
 * requires: GSAP ~1.14
 * Powered by the Greensock Animation Platform (GSAP): http://www.greensock.com/js
 * Greensock License info at http://www.greensock.com/licensing/
 */
function(e,t){"function"==typeof define&&define.amd?define(["ScrollMagic","TweenMax","TimelineMax"],t):"object"==typeof exports?(require("gsap"),t(require("scrollmagic"),TweenMax,TimelineMax)):t(e.ScrollMagic||e.jQuery&&e.jQuery.ScrollMagic,e.TweenMax||e.TweenLite,e.TimelineMax||e.TimelineLite)}(this,function(e,h,v){var t="animation.gsap",n=window.console||{},o=Function.prototype.bind.call(n.error||n.log||function(){},n);e||o("("+t+") -> ERROR: The ScrollMagic main module could not be found. Please make sure it's loaded before this plugin or use an asynchronous loader like requirejs."),h||o("("+t+") -> ERROR: TweenLite or TweenMax could not be found. Please make sure GSAP is loaded before ScrollMagic or use an asynchronous loader like requirejs."),e.Scene.addOption("tweenChanges",!1,function(e){return!!e}),e.Scene.extend(function(){var d,f=this,g=function(){f._log&&(Array.prototype.splice.call(arguments,1,0,"("+t+")","->"),f._log.apply(this,arguments))};f.on("progress.plugin_gsap",function(){p()}),f.on("destroy.plugin_gsap",function(e){f.removeTween(e.reset)});var p=function(){if(d){var e=f.progress(),t=f.state();d.repeat&&-1===d.repeat()?"DURING"===t&&d.paused()?d.play():"DURING"===t||d.paused()||d.pause():e!=d.progress()&&(0===f.duration()?0<e?d.play():d.reverse():f.tweenChanges()&&d.tweenTo?d.tweenTo(e*d.duration()):d.progress(e).pause())}};f.setTween=function(e,t,n){var o;1<arguments.length&&(arguments.length<3&&(n=t,t=1),e=h.to(e,t,n));try{(o=v?new v({smoothChildTiming:!0}).add(e):e).pause()}catch(e){return g(1,"ERROR calling method 'setTween()': Supplied argument is not a valid TweenObject"),f}if(d&&f.removeTween(),d=o,e.repeat&&-1===e.repeat()&&(d.repeat(-1),d.yoyo(e.yoyo())),f.tweenChanges()&&!d.tweenTo&&g(2,"WARNING: tweenChanges will only work if the TimelineMax object is available for ScrollMagic."),d&&f.controller()&&f.triggerElement()&&2<=f.loglevel()){var r=h.getTweensOf(f.triggerElement()),i=f.controller().info("vertical");r.forEach(function(e,t){var n=e.vars.css||e.vars;if(i?void 0!==n.top||void 0!==n.bottom:void 0!==n.left||void 0!==n.right)return g(2,"WARNING: Tweening the position of the trigger element affects the scene timing and should be avoided!"),!1})}if(1.14<=parseFloat(TweenLite.version))for(var l,a,s=d.getChildren?d.getChildren(!0,!0,!1):[d],c=function(){g(2,"WARNING: tween was overwritten by another. To learn how to avoid this issue see here: https://github.com/janpaepke/ScrollMagic/wiki/WARNING:-tween-was-overwritten-by-another")},u=0;u<s.length;u++)l=s[u],a!==c&&(a=l.vars.onOverwrite,l.vars.onOverwrite=function(){a&&a.apply(this,arguments),c.apply(this,arguments)});return g(3,"added tween"),p(),f},f.removeTween=function(e){return d&&(e&&d.progress(0).pause(),d.kill(),d=void 0,g(3,"removed tween (reset: "+(e?"true":"false")+")")),f}})});