<?php
/**
 * Theme support
 *
 * @package Zeen
 * @since 1.0.0
 */

function zeen_theme_support() {

	// Title Tag
	add_theme_support( 'title-tag' );

	// Wp thumbnails
	add_theme_support( 'post-thumbnails' );

	// Default thumb size
	set_post_thumbnail_size( 100, 100, true );

	// RSS
	add_theme_support( 'automatic-feed-links' );

	// WooCommerce
	add_theme_support( 'woocommerce', array(
		'thumbnail_image_width' => 500,
		'single_image_width' => 500,
		'gallery_thumbnail_image_width' => 200,
	) );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

	// Sensei
	add_theme_support( 'sensei' );

	// Adding post format support
	add_theme_support( 'post-formats',
		array(
			'video',
			'audio',
			'gallery',
		)
	);

	// registering menus
	register_nav_menus(
		array(
			'main' => esc_html__( 'Main Navigation Menu', 'zeen' ),
			'secondary' => esc_html__( 'Secondary Navigation Menu', 'zeen' ),
			'footer' => esc_html__( 'Footer Navigation Menu', 'zeen' ),
			'mobile' => esc_html__( 'Mobile Menu', 'zeen' ),
		)
	);

	// Output HTML5
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Selective widget refresh
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Extra alignments
	add_theme_support( 'align-wide' );

	// Textdomain
	load_theme_textdomain( 'zeen', get_parent_theme_file_path( 'languages' ) );

}
add_action( 'after_setup_theme', 'zeen_theme_support' );
