<?php
/**
 * Template tags
 *
 * @package Zeen
 * @since 1.0.0
 */

/**
 * Adds custom body classes
 *
 * @since 1.0.0
 */
function zeen_body_classes( $classes ) {

	$classes[] = 'headings-f' . (int) get_theme_mod( 'typo_headings', 1 );
	$classes[] = 'body-f' . (int) get_theme_mod( 'typo_body', 2 );
	$classes[] = 'sub-f' . (int) get_theme_mod( 'typo_subtitles', 1 );
	$classes[] = 'quotes-f' . (int) get_theme_mod( 'typo_blockquotes', 1 );
	$classes[] = 'by-f' . (int) get_theme_mod( 'typo_byline', 3 );
	$classes[] = 'wh-f' . (int) get_theme_mod( 'typo_widget_headers', 2 );
	if ( get_theme_mod( 'sidebar_widgets_title_centered' ) == 1 ) {
		$classes[] = 'widget-title-c';
	}
	if ( get_theme_mod( 'to_top_fixed' ) == 1 ) {
		$classes[] = 'to-top__fixed';
	}

	if ( get_theme_mod( 'secondary_menu_font_size', '11' ) < 13 ) {
		$classes[] = 'sm-u13';
	}
	if ( get_theme_mod( 'font_size_block_main_title', 40 ) > 30 ) {
		$classes[] = 'block-titles-big';
	}
	if ( get_theme_mod( 'ipl_separation' ) == 1 ) {
		$classes[] = 'ipl-separated';
	}
	if ( get_theme_mod( 'classic_title_line_onoff', 1 ) == 1 ) {
		$classes[] = 'block-titles-mid-1';
	}

	if ( get_theme_mod( 'mobile_limit_height' ) == 1 && is_single() ) {
		$classes[] = 'body--mobile--limit';
	}
	if ( get_theme_mod( 'mobile_header_on_tablet' ) == 1 ) {
		$classes[] = 'mob-menu-on-tab';
	}
	if ( get_theme_mod( 'masonry_design', 1 ) == 2 ) {
		$classes[] = 'masonry-has-bg';
	}
	if ( get_theme_mod( 'megamenu_color_usage_onoff', 1 ) == 1 ) {
		$classes[] = 'menu-no-color-hover';
	}
	if ( get_theme_mod( 'grid_spacing_tiles', 0 ) == 0 ) {
		$classes[] = 'grids-spacing-0';
	}
	if ( zeen_is_mobile_site() == 'isMob' ) {
		$classes[] = 'is-mobile';
	}

	if ( get_theme_mod( 'mobile_fi_full_screen', 1 ) == 1 ) {
		$classes[] = 'mob-fi-tall';
	}

	if ( get_theme_mod( 'modal_skin', 1 ) == 2 ) {
		$classes[] = 'modal-skin-2';
	}

	if ( get_theme_mod( 'mobile_customization_excerpts', 1 ) == 1 ) {
		$classes[] = 'excerpt-mob-off';
	}
	if ( get_theme_mod( 'mobile_customization_avatars' ) == 1 ) {
		$classes[] = 'avatar-mob-off';
	}

	if ( get_theme_mod( 'classis_split_img_width', 50 ) < 41 ) {
		$classes[] = 'classic-lt-41';
	}
	if ( get_theme_mod( 'classis_split_img_width', 50 ) < 33 ) {
		$classes[] = 'classic-lt-33';
	}
	$classes[] = zeen_is_light( get_theme_mod( 'skin', '#ffffff' ) ) == true ? 'skin-light' : 'skin-dark';

	if ( get_theme_mod( 'sticky_sidebar', 1 ) != 1 ) {
		$classes[] = 'zeen-sb-sticky-off';
	}

	if ( get_theme_mod( 'color_excerpt', '#444' ) == get_theme_mod( 'color_body', '#444' ) ) {
		$classes[] = 'read-more-fade';
	}

	if ( get_theme_mod( 'sticky_menu_post_name' ) == 1 ) {
		$classes[] = 'single-sticky-spin';
	}

	if ( get_theme_mod( 'megamenu_animation' ) == 3 ) {
		$classes[] = 'mm-ani-3';
	}
	$widget_color = get_theme_mod( 'footer_widgets_color', '#fff' );
	if ( get_theme_mod( 'footer_widgets_skin', 3 ) == 3 && ( '#fff' == $widget_color || '#ffffff' == $widget_color ) ) {
		$classes[] = 'footer-widgets-text-white';
	}

	$classes[] = 'site-mob-menu-a-' . (int) get_theme_mod( 'mobile_menu_animation_style', 4 );
	$classes[] = 'site-mob-menu-' . (int) get_theme_mod( 'mobile_menu_style', 1 );
	$classes[] = 'mm-submenu-' . (int) get_theme_mod( 'megamenu_submenu_color', 1 );
	$classes[] = 'main-menu-logo-' . (int) get_theme_mod( 'logo_main_menu_position', 1 );
	$header = zeen_get_style();
	if ( 58 == $header ) {
		$header = get_theme_mod( 'header_style', 1 );
	}
	$classes[] = 'body-header-style-' . (int) $header;

	if ( $header > 80 ) {
		$classes[] = 'body-with-v';
	} elseif ( $header < 60 && $header > 50 ) {
		$classes[] = 'body-header-style-50s';
	} elseif ( $header > 70 && $header < 80 ) {
		$classes[] = 'body-header-style-70s';
		if ( get_theme_mod( 'secondary_menu_side_enable', 1 ) == 1 ) {
			$classes[] = 'body-header-style-70s-w-sb';
		}
	}
	$dropcap = get_theme_mod( 'dropcap' );
	$sticky4_on = true;
	if ( is_singular() ) {
		global $post;

		$dropcap_single = get_post_meta( $post->ID, 'zeen_dropcap', true );
		if ( 1 == $dropcap_single ) {
			$dropcap = 1;
		} elseif ( 2 == $dropcap_single ) {
			$dropcap = '';
		}

		$hero = zeen_get_hero_design( $post->ID );
		$classes[] = 'body-' . esc_attr( $hero['size'] );
		if ( has_post_thumbnail( $post->ID ) && 'hero-l' == $hero['size'] ) {
			$sticky4_on = '';
		}
		if ( is_page() ) {
			if ( get_post_meta( $post->ID, 'tipi_builder_active', true ) == true ) {
				$classes[] = 'tipi-builder-page';
				$classes[] = 'tipi-builder-on';
				$builder_data = get_post_meta( $post->ID, 'tipi_builder_data', true );
				$first = TipiBuilder\ZeenHelpers::zeen_get_first_block( $builder_data );
				if ( ! isset( $first['fs'] ) ) {
					$first['fs'] = 'off';
				}
				if ( ! empty( $first['preview'] ) && ( ( ( $first['preview'] > 50 && $first['preview'] < 60 ) || $first['preview'] > 81 || 49 == $first['preview'] || 35 == $first['preview'] || 46 == $first['preview'] ) && 'on' == $first['fs'] ) || ( ! empty( $first['preview'] ) && 39 == $first['preview'] ) ) {
					$sticky4_on = '';
				} else {
					$sticky4_on = true;
				}
			}
		}
		if ( 31 == $hero['hero_design'] ) {
			$classes[] = 'has-bg';
		}
	} elseif ( is_category() || is_tag() || is_tax() ) {
		$term_id = zeen_get_term_id();
		if ( get_term_meta( $term_id, 'tipi_builder_active', true ) == true ) {
			$classes[] = 'tipi-builder-tax';
			$classes[] = 'tipi-builder-on';
			$builder_data = zeen_get_term_meta( 'tipi_builder_data', $term_id );
			$first = TipiBuilder\ZeenHelpers::zeen_get_first_block( $builder_data );
			if ( ! isset( $first['fs'] ) ) {
				$first['fs'] = 'off';
			}
			if ( ! empty( $first['preview'] ) && ( ( ( $first['preview'] > 50 && $first['preview'] < 60 ) || $first['preview'] > 81 || 49 == $first['preview'] || 35 == $first['preview'] || 46 == $first['preview'] ) && 'on' == $first['fs'] ) || ( ! empty( $first['preview'] ) && 39 == $first['preview'] ) ) {
				$sticky4_on = '';
			}
		}
	}
	if ( ! empty( $sticky4_on ) ) {
		$classes[] = 'sticky-4-unfixed';
	}
	if ( ! empty( $dropcap ) ) {
		$classes[] = 'dropcap--on';
	}

	if ( zeen_woo_active() ) {
		$classes[] = 'woo-layout-' . get_theme_mod( 'woo_layout', 3 );
	}

	if ( zeen_is_bp() ) {
		$classes[] = 'bp-avatar-shape-' . get_theme_mod( 'buddypress_avatar', 1 );
		$classes[] = 'bp-layout-' . get_theme_mod( 'buddypress_layout', 1 );
	}

	$bg_repeat = zeen_get_bg_repeat();
	$background = zeen_get_bg();

	if ( ! empty( $bg_repeat ) ) {
		$classes[] = 'bg-img-' . $bg_repeat;
	}
	if ( ! empty( $bg_repeat ) || ! empty( $background['image'] ) || ( '#fff' != substr( $background['color'], 0, 4 ) && 'rgb(255, 255, 255)' != $background['color'] ) ) {
		if ( empty( $background['image'] ) && get_theme_mod( 'skin', '#ffffff' ) === $background['color'] ) {
			$classes[] = 'same-bg';
		} else {
			$classes[] = 'has-bg';
		}
	}
	$bg_ad = zeen_get_bg_ad();
	if ( ! empty( $bg_ad['image'] ) ) {
		$classes[] = 'has-bg';
		$classes[] = 'has-bg-da';
		if ( get_theme_mod( 'bg_ad_img_stretch', 1 ) == 1 ) {
			$classes[] = 'has-bg-stretch';
		}
	}

	$classes[] = 'byline-font-' . (int) get_theme_mod( 'typo_byline', 2 );

	if ( get_theme_mod( 'classic_title_top_border_onoff' ) == 1 ) {
		$classes[] = 'block-title-bt';
	}

	if ( get_theme_mod( 'classic_title_bottom_border_onoff' ) == 1 ) {
		$classes[] = 'block-title-bb';
	}

	return $classes;
}
add_filter( 'body_class', 'zeen_body_classes' );

/**
 * Fix tag cloud's size
 *
 * @since 1.0.0
 */
function zeen_tag_cloud_args( $args ) {
	$args['largest'] = 1;
	$args['smallest'] = 1;
	$args['unit'] = 'em';
	return $args;
}
add_filter( 'widget_tag_cloud_args', 'zeen_tag_cloud_args' );

/**
 * Duration
 *
 * @since 1.0.0
 */
function zeen_media_duration( $pid = '', $only_value = '' ) {

	$duration = get_post_meta( $pid, 'zeen_duration', true );
	if ( ! empty( $duration ) ) {
		if ( empty( $only_value ) ) {
			echo '<span class="duration font-3">' . esc_attr( $duration ) . '</span>';
		} else {
			echo esc_attr( $duration );
		}
	}

}

/**
 * Adds Background Ad
 *
 * @since 1.0.0
 */
function zeen_bg_ad() {
	$bg_ad = get_theme_mod( 'bg_ad' );
	if ( ! empty( $bg_ad ) ) {
		$bg_ad = get_theme_mod( 'bg_ad_url' );
		if ( ! empty( $bg_ad ) ) {
			echo '<a href=" ' . esc_url( $bg_ad ) . '" id="tipi-bg-da" class="tipi-bg-da" rel="nofollow" target="_blank"></a>';
		}
	}
}

/**
 * Excerpt
 *
 * @since 1.0.0
 */
function zeen_excerpt( $post = '', $limit = 50, $read_more = true ) {
	if ( zeen_is_mobile_site() == 'isMob' && get_theme_mod( 'mobile_customization_excerpts', 1 ) == 1 ) {
		return;
	}
	add_filter( 'lets_review_append', '__return_false' );
	if ( ! empty( $post->post_excerpt ) ) {
		echo '<div class="excerpt body-color">' . $post->post_excerpt;
		if ( get_theme_mod( 'classic_read_more', 1 ) == 1 ) {
			echo zeen_get_read_more( $post->ID );
		}
		echo '</div>';
	} else {
		if ( empty( $post ) ) {
			global $post;
			$post = get_post( $post->ID );
			setup_postdata( $post );
			$excerpt = get_the_excerpt( $post->ID );
			wp_reset_postdata( $post );
		} else {
			$excerpt = get_the_excerpt( $post->ID );
		}

		echo '<div class="excerpt body-color">' . wp_trim_words( $excerpt, $limit, '' );

		if ( ! empty( $excerpt ) ) {
			echo '...';
		}
		if ( get_theme_mod( 'classic_read_more', 1 ) == 1 && ! empty( $excerpt ) && ! empty( $read_more ) ) {
			echo zeen_get_read_more( $post->ID );
		}
		echo '</div>';
	}
}

/**
 * Excerpt Length
 *
 * @since 1.0.0
 */
function zeen_excerpt_length( $length ) {
	return 80;
}
add_filter( 'excerpt_length', 'zeen_excerpt_length' );

/**
 * Read more getter
 *
 * @since 1.0.0
 */
function zeen_get_read_more( $pid = '' ) {
	return ' <span class="read-more-wrap font-3"><a class="read-more" href="' . esc_url( get_permalink( $pid ) ) . '">' . esc_attr( get_theme_mod( 'classic_read_more_text', esc_html__( 'Read More', 'zeen' ) ) ) . '</a></span>';

}

/**
 * By line author
 *
 * @since 1.0.0
 */
function zeen_byline_author( $pid = '', $args = array() ) {

	$args['source'] = empty( $args['source'] ) ? '' : $args['source'];
	$author = '' == $pid ? get_the_author() : get_post_field( 'post_author', $pid );
	if ( empty( $author ) || ( get_theme_mod( $args['source'] . '_byline_author', 1 ) != 1 && get_theme_mod( $args['source'] . '_byline_author_avatar', 1 ) != 1 ) ) {
		return;
	}
	$post_type = get_post_type();
	$args['author_avatar'] = empty( $args['author_avatar'] ) ? '' : $args['author_avatar'];
	$args['author'] = empty( $args['author'] ) ? '' : $args['author'];
	$args['icon'] = empty( $args['icon'] ) ? '' : $args['icon'];
	$avatar_size = empty( $args['avatar_size'] ) ? 50 : $args['avatar_size'];

	$author_url = get_author_posts_url( $author );

	if ( ! empty( $args['author_avatar'] ) ) {
		echo '<span class="byline-part author-avatar flipboard-author';
		if ( ! empty( $args['author'] ) ) {
			echo ' with-name';
		} else {
			echo ' no-name';
		}
		echo '">';
		zeen_get_byline_author_avatar( $author, $avatar_size, $author_url );
		echo '</span>';
	}
	if ( ! empty( $args['author'] ) ) {
		echo '<span class="byline-part author">';
		if ( function_exists( 'coauthors_posts_links' ) ) {
			coauthors_posts_links( null, null, '', null, true );
		} else {
			echo '<a class="url fn n" href="' . esc_url( $author_url ) . '">';
			if ( ! empty( $args['icon'] ) ) {
				echo '<i class="tipi-i-user" aria-hidden="true"></i> ';
			}
			if ( ! empty( $args['sentence'] ) ) {
				echo '<span class="byline-by byline-detail">' . esc_html__( 'By', 'zeen' ) . ' </span>';
			}
			the_author_meta( 'display_name', $author );
			echo '</a>';
		}
		echo '</span>';
	}
}

/**
 * By line author avatar getter
 *
 * @since 1.0.0
 */
function zeen_get_byline_author_avatar( $author_id = '', $author_avatar_size = 50, $author_url = '' ) {
	echo '<a href="' . esc_url( $author_url ) . '" class="author-avatar">' . get_avatar( $author_id, $author_avatar_size, '', '' ) . '</a>';
}

/**
 * Get Categories
 *
 * @since 1.0.0
 */
function zeen_get_cats( $pid = '', $args = array() ) {
	$list = get_the_category( $pid );
	if ( empty( $list ) ) {
		return;
	}
	$args['primary'] = empty( $args['primary'] ) ? '' : $args['primary'];
	$global = get_theme_mod( 'use_primary_cat' );

	if ( ( 1 == $global && 'all' != $args['primary'] ) || ! empty( $args['try_primary'] ) ) {
		if ( class_exists( 'WPSEO_Primary_Term' ) ) {
			$cat_primary = new WPSEO_Primary_Term( 'category', $pid );
			$cat_primary = $cat_primary->get_primary_term();
			$cat_primary = get_term( $cat_primary );
			$list = is_wp_error( $cat_primary ) ? $list : array( $cat_primary );
		} elseif ( isset( $list[0] ) ) {
			$list = array( $list[0] );
		}
	}

	return $list;
}
/**
 * By line category
 *
 * @since 1.0.0
 */
function zeen_byline_category( $pid = '', $args = array() ) {
	$primary = empty( $args['show_primary'] ) ? '' : $args['show_primary'];
	$categories_list = zeen_get_cats( $pid, array( 'primary' => $primary ) );
	$custom_cats = apply_filters( 'zeen_get_cats', array(), $pid, $categories_list );
	if ( ! empty( $custom_cats ) ) {
		$categories_list = $custom_cats;
	}
	if ( empty( $categories_list ) ) {
		$taxes = zeen_get_taxonomies();
		foreach ( $taxes as $key ) {
			$categories_list = get_the_terms( $pid, $key );
			if ( ! empty( $categories_list ) ) {
				if ( 1 == get_theme_mod( 'use_primary_cat' ) ) {
					$categories_list = array( $categories_list[0] );
				}
				break;
			}
		}
		if ( empty( $categories_list ) ) {
			return;
		}
	}
	$cat_design = empty( $args['cat_design'] ) ? 1 : $args['cat_design'];
	$class = '';
	echo '<div class="byline-part cats">';
	if ( ! empty( $args['sentence'] ) ) {
		echo '<span class="byline-in byline-blog-detail">' . esc_html__( 'In', 'zeen' ) . ' </span>';
	}
	if ( ! empty( $args['icon'] ) && 1 == $cat_design ) {
		echo '<i class="tipi-i-folder" aria-hidden="true"></i> ';
	}
	$i = 1;
	foreach ( $categories_list as $cat ) {
		echo '<a href="' . esc_url( get_category_link( $cat ) ) . '"';
		if ( 2 == $cat_design ) {
			$category_color = zeen_term_color( $cat->term_id );
			echo ' style="background-color:' . esc_attr( $category_color ) . '"';
			$class = ' cat-with-bg';
		} elseif ( 3 == $cat_design ) {
			$category_color = zeen_term_color( $cat->term_id );
			$class = ' cat-with-line';
			echo ' style="border-bottom-color:' . esc_attr( $category_color ) . '"';
		} elseif ( 4 == $cat_design ) {
			$category_color = zeen_term_color( $cat->term_id );
			echo ' style="color:' . esc_attr( $category_color ) . '"';
		} elseif ( 5 == $cat_design ) {
			$class = ' cat-with-bg cat-with-bg-dark';
		}

		echo ' class="cat' . esc_attr( $class ) . '">' . esc_attr( $cat->name ) . '</a>';
		if ( 1 == $i && ! empty( $primary_global ) && 'all' != $primary ) {
			break;
		}
		$i++;
	}
	echo '</div>';
}

/**
 * Post Date
 *
 * @since 1.0.0
 */
function zeen_date( $pid = '', $args = array() ) {

	$format = get_theme_mod( 'date_format', 1 );
	$time_mod = '';
	$mod_date = get_the_modified_time( 'U', $pid );
	$time = get_the_time( 'U', $pid );

	$updated = empty( $args['updated'] ) ? '' : $args['updated'];

	if ( $time != $mod_date && 'on' == $updated ) {
		$time_mod = true;
	}
	if ( empty( $args['publish_off'] ) ) {
		echo '<span class="byline-part date">';

		if ( ! empty( $args['icon'] ) ) {
			echo '<i class="tipi-i-calendar" aria-hidden="true"></i> ';
		}

		if ( ! empty( $args['sentence'] ) && 2 != $format ) {
			echo '<span class="byline-on byline-blog-detail">' . esc_html__( 'on', 'zeen' ) . ' </span>';
		}

		echo '<time class="entry-date published dateCreated flipboard-date" datetime="' . esc_attr( get_the_date( 'c', $pid ) ) . '">';
		switch ( $format ) {
			case 2:
				echo sprintf( esc_html__( '%1$s ago', 'zeen' ),
					human_time_diff( $time, current_time( 'timestamp' ) )
				);
				break;

			default:
				echo get_the_date( '', $pid );
				break;
		}
		echo '</time>';
		echo '</span>';
	}
	if ( ! empty( $time_mod ) ) {
		$date = get_the_date( '', $pid );
		$mod = get_the_modified_date( '', $pid );
		$modified = get_the_modified_date( 'c' );
		if ( $date != $mod && strtotime( $modified ) > strtotime( '-3 months' ) ) {
			echo '<div class="last__updated">';
			echo '<span class="last__updated__title">';
			esc_html_e( 'Last updated', 'zeen' );
			echo apply_filters( 'zeen_last_updated_separator', ':' );
			echo '</span>';
			echo '<time class="updated" datetime="' . esc_attr( $modified ) . '">';
			switch ( $format ) {
				case 2:
					echo sprintf( '%1$s %2$s',
						human_time_diff( $mod_date, current_time( 'timestamp' ) ),
						esc_html__( 'ago', 'zeen' )
					);
					break;
				default:
					echo get_the_modified_date( '', $pid );
					break;
			}
			echo '</div></time>';
		}
	}
}

/**
 * Updated
 *
 * @since 1.0.0
 */
function zeen_date_updated( $pid = '' ) {

	$last_updated_single = get_post_meta( $pid, 'zeen_last_updated', true );
	if ( empty( $last_updated_single ) || 99 == $last_updated_single ) {
		$last_updated = get_theme_mod( 'posts_last_updated' );
	} elseif ( 1 == $last_updated_single ) {
		$last_updated = 1;
	} elseif ( 2 == $last_updated_single ) {
		$last_updated = '';
	}

	if ( 1 != $last_updated || is_page() ) {
		return;
	}

	if ( ( is_single() && in_the_loop() && is_main_query() ) || ! empty( $pid ) ) {
		if ( empty( $pid ) ) {
			global $post;
			$pid = $post->ID;
		}

		$list = get_post_meta( $pid, 'zeen_list', true );
		if ( 'on' != $list ) {
			ob_start();
			zeen_date( $pid, array(
				'updated' => true,
				'publish_off' => true,
			) );
			return ob_get_clean();
		}
	}
}

/**
 * Reading Time
 *
 * @since 1.0.0
 */
function zeen_read_time( $pid = '', $args = array() ) {
	$content = get_post_field( 'post_content', $pid );
	if ( empty( $content ) ) {
		return;
	}
	$count = explode( ' ', $content );
	$count = floor( count( $count ) / 220 );
	$count = 0 == $count ? 1 : $count;
	echo '<span class="byline-part read-time">';
	if ( ! empty( $args['icon'] ) ) {
		echo '<i class="tipi-i-clock" aria-hidden="true"></i> ';
	}
	// translators: Number of minutes it takes to read article
	echo esc_attr( sprintf( _n( '%d min read', '%d min read', $count, 'zeen' ), $count ) );
	echo '</span>';
}

/**
 * View Count
 *
 * @since 1.0.0
 */
function zeen_view_count( $pid = '', $args = '' ) {
	$use_jetpack = apply_filters( 'zeen_view_count_use_jetpack_stats', true );
	if ( ! function_exists( 'stats_get_from_restapi' ) && true === $use_jetpack ) {
		return;
	}
	if ( empty( $args['params'] ) ) {
		$args['params'] = 'post/' . $pid;
	}

	$stats = 'zeen-pv-' . $pid;
	if ( true === $use_jetpack ) {
		$views = get_transient( $stats );
		if ( false === $views ) {
			$views = stats_get_from_restapi( array( 'fields' => 'views' ), $args['params'] );
			set_transient( $stats, $views, 180 );
		}
		$views_count = empty( $views->views ) ? '' : $views->views;
	} else {
		$views_count = apply_filters( 'zeen_view_count_custom', '', $pid );
	}

	if ( ! empty( $views_count ) ) {
		if ( ! empty( $args['separator'] ) ) {
			zeen_byline_sep( $args['sep'], $args['sep_output'] );
		}
		if ( ! empty( $args['only_value'] ) ) {
			echo (int) $views_count;
			return;
		}
		echo '<span class="byline-part view-count">';
		if ( ! empty( $args['icon'] ) ) {
			echo '<i class="tipi-i-eye" aria-hidden="true"></i> ';
		}
		$word = empty( $args['icon'] ) ? ' ' . sprintf( _n( 'view', 'views', $views_count, 'zeen' ), $views_count ) : '';
		echo (int) $views_count . esc_attr( $word );
		echo '</span>';
	}

}

/**
 * By line comment count
 *
 * @since 1.0.0
 */
function zeen_byline_comment_count( $pid = '', $args = array() ) {
	$comment_count = isset( $args['comment_count'] ) ? $args['comment_count'] : get_comments_number( $pid );
	if ( empty( $comment_count ) && get_theme_mod( 'show_0_comments' ) != 1 ) {
		return;
	}
	echo '<span class="byline-part comments"><a href="' . esc_url( get_comments_link( $pid ) ) . '">';
	if ( ! empty( $args['icon'] ) ) {
		echo '<i class="tipi-i-message-square" aria-hidden="true"></i> ';
	}
	if ( ! empty( $args['sentence'] ) ) {
		comments_number(
			esc_attr__( '0 Comments', 'zeen' ),
			esc_attr__( '1 Comment', 'zeen' ),
			esc_attr( _n( '% Comment', '% Comments', $comment_count, 'zeen' ) )
		);
	} else {
		echo (int) $comment_count;
	}
	echo '</a></span>';
}

/**
 * By line likes count
 *
 * @since 1.0.0
 */
function zeen_byline_likes_count( $pid = '', $args = array() ) {
	$like_count = get_post_meta( $pid, 'zeen_like_count', true );
	$class = '';
	if ( isset( $_COOKIE['wp_liked_articles'] ) ) {
		$cook = stripslashes( html_entity_decode( $_COOKIE['wp_liked_articles'] ) );
		if ( in_array( $pid , json_decode( $cook, true ) ) ) {
			$class = ' liked';
		}
	}
	$like_count = empty( $like_count ) ? 0 : $like_count;
	echo '<span class="byline-part likes-count"><a href="#" class="tipi-like-count ' . esc_attr( $class ) .'" data-pid="' . (int) ( $pid ) . '">';
	echo '<span class="likes-heart"><i class="tipi-i-heart-o" aria-hidden="true"></i><i class="tipi-i-heart" aria-hidden="true"></i></span>';
	echo '<span class="tipi-value">' . (int) ( $like_count ) . '</span>';
	echo '</a></span>';
}

/**
 * Byline separator
 *
 * @since 1.0.0
 */
function zeen_byline_sep( $output = '', $first = '' ) {

	if ( empty( $output ) || empty( $first ) ) {
		return;
	}

	echo '<span class="byline-part separator">' . esc_attr( apply_filters( 'zeen_byline_separator', '&middot;' ) ) . '</span>';
}

/**
 * Byline
 *
 * @since 1.0.0
 */
function zeen_byline( $pid = '', $args = array() ) {

	$type = empty( $args['type'] ) ? '' : $args['type'];

	if ( ! empty( $type ) && get_theme_mod( $type . '_byline', 1 ) != 1 ) {
		return;
	}

	$location = empty( $args['location'] ) ? '' : $args['location'];
	$elements_location = empty( $args['elements_location'] ) ? 1 : $args['elements_location'];
	$elements_design = empty( $args['elements_design'] ) ? 1 : $args['elements_design'];
	$base_design = empty( $args['base_design'] ) ? 1 : $args['base_design'];
	$cat_design = empty( $args['cat_design'] ) ? '' : $args['cat_design'];
	$icon = '';
	$sentence = '';
	$sep_output = '';
	$sep = '';
	$a = array();

	$a['extras'] = apply_filters( 'zeen_byline_extras_onoff', '' ) == true ? true : '';

	if ( 1 == $location && 2 == $base_design ) {
		$a['cats'] = true;
		$a['comments'] = true;
	}

	if ( 1 == $elements_location ) {
		// ABOVE TITLE
		if ( 2 == $location ) {
			// ONLY SHOW CATS AND DATE IF NOT THE POLY ONE
			if ( 2 != $base_design ) {
				$a['cats'] = true;
				$a['comments'] = true;
			}
			$a['date'] = true;
			$a['author'] = true;
			$a['author_avatar'] = true;
			$a['read_time'] = true;
			$a['like_count'] = true;
			$a['view_count'] = true;
		}
	}

	if ( 2 == $elements_location ) {
		// BELOW TITLE
		if ( 3 == $location ) {
			// ONLY SHOW CATS AND DATE IF NOT THE POLY ONE
			if ( 2 != $base_design ) {
				$a['cats'] = true;
				$a['comments'] = true;
			}
			$a['date'] = true;
			$a['author'] = true;
			$a['author_avatar'] = true;
			$a['read_time'] = true;
			$a['like_count'] = true;
			$a['view_count'] = true;
		}
	}

	if ( 3 == $elements_location ) {
		// SOME ABOVE TITLE SOME BELOW TITLE
		if ( 2 == $location ) {
			// ONLY SHOW CATS AND DATE IF NOT THE POLY ONE
			if ( 2 != $base_design ) {
				$a['cats'] = true;
				$a['comments'] = true;
			}
			$a['read_time'] = true;
		}

		if ( 3 == $location ) {
			$a['author'] = true;
			$a['author_avatar'] = true;
			$a['date'] = true;
			$a['like_count'] = true;
			$a['view_count'] = true;
		}
	}

	if ( 4 == $elements_location ) {
		// ALL BELOW EXCERPT
		if ( 4 == $location ) {
			// ONLY SHOW CATS AND DATE IF NOT THE POLY ONE
			if ( 2 != $base_design ) {
				$a['cats'] = true;
				$a['comments'] = true;
			}
			$a['date'] = true;
			$a['author'] = true;
			$a['author_avatar'] = true;
			$a['read_time'] = true;
			$a['like_count'] = true;
			$a['view_count'] = true;
		}
	}

	if ( 5 == $elements_location ) {
		// SOME BELOW EXCERPT AND SOME BELOW TITLE
		if ( 3 == $location ) {
			// ONLY SHOW CATS AND DATE IF NOT THE POLY ONE
			$a['author'] = true;
			$a['author_avatar'] = true;
			$a['date'] = true;
		}

		if ( 4 == $location ) {
			if ( 2 != $base_design ) {
				$a['cats'] = true;
				$a['comments'] = true;
			}
			$a['like_count'] = true;
			$a['view_count'] = true;
			$a['read_time'] = true;
		}
	}

	if ( 2 == $elements_design ) {
		$sentence = true;
	} elseif ( 3 == $elements_design ) {
		$icon = true;
		$a['author_avatar'] = '';
	} elseif ( 1 != $location ) {
		$sep = true;
	}
	$keys = array( 'cats', 'comments', 'author_avatar', 'author', 'date', 'read_time', 'view_count', 'like_count' );
	foreach ( $keys as $key ) {
		if ( ! empty( $args[ $key ] ) && 'off' == $args[ $key ] ) {
			$a[ $key ] = '';
		}
	}

	if ( zeen_is_mobile_site() == 'isMob' && 1 == get_theme_mod( 'mobile_customization_avatars' ) ) {
		$a['author_avatar'] = '';
	}
	$a = array_filter( $a );
	if ( empty( $a ) ) {
		return;
	}

	echo '<div class="byline byline-' . (int) $location;
	if ( ! empty( $a['cats'] ) ) {
		echo ' byline-cats-design-' . (int) $cat_design;
	}
	echo '">';

	if ( ! empty( $a['author'] ) || ! empty( $a['author_avatar'] ) ) {
		$author_avatar = empty( $a['author_avatar'] ) ? '' : $a['author_avatar'];
		$author = empty( $a['author'] ) ? '' : $a['author'];
		$avatar_size = 'classic' == $type ? 30 : '';
		zeen_byline_author( $pid, array(
			'author_avatar' => $author_avatar,
			'avatar_size' => $avatar_size,
			'author' => $author,
			'icon' => $icon,
			'sentence' => $sentence,
		) );
		if ( ! empty( $a['author'] ) ) {
			$sep_output = true;
		}
	}

	if ( ! empty( $a['cats'] ) ) {
		zeen_byline_sep( $sep, $sep_output );
		$sep_output = true;
		$cats_sentence = '';

		if ( ! empty( $sentence ) && 2 != $base_design ) {
			$cats_sentence = true;
		}
		zeen_byline_category( $pid, array(
			'cat_design' => $cat_design,
			'icon' => $icon,
			'sentence' => $cats_sentence,
		) );
	}
	if ( ! empty( $a['date'] ) ) {
		zeen_byline_sep( $sep, $sep_output );
		$sep_output = true;
		zeen_date( $pid, array(
			'icon' => $icon,
			'sentence' => $sentence,
		) );
	}

	if ( ! empty( $a['comments'] ) ) {
		$comment_count = get_comments_number( $pid );
		if ( ! ( empty( $comment_count ) && get_theme_mod( 'show_0_comments' ) != 1 ) ) {
			zeen_byline_sep( $sep, $sep_output );
			$sep_output = true;
			$comments_sentence = '';
			if ( 3 != $elements_design ) {
				$comments_sentence = true;
			}
			zeen_byline_comment_count( $pid, array(
				'icon' => $icon,
				'sentence' => $comments_sentence,
				'comment_count' => $comment_count,
			) );
		}
	}

	if ( ! empty( $a['read_time'] ) ) {
		$live_blog = get_post_meta( $pid, 'lets_live_blog_enabled', true );
		if ( ( ! empty( $live_blog ) && 'on' != $live_blog ) || empty( $live_blog ) ) {
			zeen_byline_sep( $sep, $sep_output );
			$sep_output = true;
			zeen_read_time( $pid, array(
				'icon' => $icon,
				'sentence' => $sentence,
			) );
		}
	}

	if ( ! empty( $a['like_count'] ) ) {
		zeen_byline_sep( $sep, $sep_output );
		$sep_output = true;
		zeen_byline_likes_count( $pid, array(
			'icon' => $icon,
			'sentence' => $sentence,
		) );
	}
	$use_jetpack = apply_filters( 'zeen_view_count_use_jetpack_stats', true );
	if ( ! empty( $a['view_count'] ) && ( function_exists( 'stats_get_from_restapi' ) || false === $use_jetpack ) ) {
		zeen_view_count( $pid, array(
			'icon' => $icon,
			'sentence' => $sentence,
			'separator' => true,
			'sep' => $sep,
			'sep_output' => $sep_output,
		) );
		$sep_output = true;
	}

	if ( ! empty( $a['extras'] ) ) {
		apply_filters( 'zeen_byline_extras', $pid, $location );
	}

	echo '</div>';

}

/**
 * Tags
 *
 * @since 1.0.0
 */
function zeen_tags() {
	if ( get_theme_mod( 'single_tags', 1 ) == 1 && has_tag() ) {
		echo '<div class="post-tags clearfix">';
		the_tags( '', '', '' );
		echo '</div>';
	}
}


/**
 * Background Element
 *
 * @since 1.0.0
 */
function zeen_elem_bg_area( $location = '' ) {
	if ( 'header' == $location ) {
		$skin = zeen_skin_style( 'header' );
		if ( 5 == $skin ) {
			$self = get_theme_mod( 'header_video_self' );
		} elseif ( 6 == $skin ) {
			$url = get_theme_mod( 'header_video_url' );
		}
		$fb = get_theme_mod( 'header_video_fb' );
	}
	if ( 'footer' == $location ) {
		$skin = zeen_skin_style( 'footer' );
		if ( 5 == $skin ) {
			$self = get_theme_mod( 'footer_video_self' );
		} elseif ( 6 == $skin ) {
			$url = get_theme_mod( 'footer_video_url' );
		}
		$fb = get_theme_mod( 'header_video_fb' );
	}
	echo '<div class="background">';
	if ( ! empty( $self ) ) {
		$src = wp_get_attachment_url( $self );
		$format = substr( $src, -3 );
		echo '<video autoplay muted loop class="media-bg"><source data-src="' . esc_url( $src ) . '" type="video/' . esc_attr( $format ) . '"></video>';
	}
	if ( ! empty( $url ) ) {

		if ( strpos( $url, 'yout' ) !== false ) {
			$type = 'yt';
		} else {

			if ( substr( $url, 0, 2 ) == '<i' ) {
				preg_match( '/src="([^"]+)"/', $url, $matches );
				if ( ! empty( $matches[1] ) ) {
					return $matches[1];
				} else {
					return '';
				}
			} elseif ( substr( $url, 0, 1 ) == '[' ) {
				$url = do_shortcode( $url );
			}

			if ( strpos( $url, 'vim' ) !== false ) {
				$type = 'vim';
			} elseif ( strpos( $url, 'soundc' ) !== false ) {
				$type = 'sc';
			} else {
				$type = '';
			}
		}
		if ( 'vim' == $type ) {
			$url = substr( wp_parse_url( $url, PHP_URL_PATH ), 1 );
			$vid_url = add_query_arg(
				array(
					'autoplay' => 1,
					'muted' => 1,
					'loop' => 1,
					'portrait' => 0,
					'dnt' => 0,
					'byline' => 0,
					'background' => 1,
					'title' => 0,
				),
				'https://player.vimeo.com/video/' . $url
			);
		} elseif ( 'yt' == $type ) {
			preg_match( '([-\w]{11})', $url, $matches );
			if ( ! empty( $matches ) ) {
				$vid_url = add_query_arg( array(
					'autoplay' => 1,
					'mute' => 1,
					'rel' => 0,
					'controls' => 0,
					'loop' => 1,
					'showinfo' => 0,
					'playlist' => $matches[0],
					'modestbranding' => 1,
				), 'https://www.youtube-nocookie.com/embed/' . $matches[0] );
			}
		} else {
			$vid_url = $url;
		}
		echo '<iframe class="media-bg skip-video" data-src="' . esc_url( $vid_url ) . '" frameborder="0" seamless="seamless" allowfullscreen></iframe>';
	}
	if ( ( ! empty( $self ) || ! empty( $url ) ) && ! empty( $fb ) ) {
		echo wp_get_attachment_image( $fb, 'full' );
	}
	echo '</div>';
}

/**
 * Output extra styles
 *
 * @since 1.0.0
 */
function zeen_get_extra_style_admin() {
	$output = '';
	$typo_buttons = get_theme_mod( 'typo_buttons', 2 );
	$headings = get_theme_mod( 'typo_headings', 1 );
	$body = get_theme_mod( 'typo_body', 2 );
	$font = array(
		1 => zeen_get_font( 1 ),
		2 => zeen_get_font( 2 ),
	);
	$font[3] = get_theme_mod( 'font_3_onoff', 1 ) == 1 ? zeen_get_font( 3 ) : $font[2];
	$output .= ".fontfam-1 { font-family: '" . esc_attr( $font[ $headings ]['font-family'] ) . "'" . esc_attr( $font[ $headings ]['category'] ) . "!important;
		letter-spacing: " . floatval( get_theme_mod( 'font_1_letter_spacing' ) ) . "em;	}";

	$output .= '.editor-post-title__block .editor-post-title__input, .wp-block-heading h1, .wp-block-heading h2, .wp-block-heading h3, .wp-block-heading h4, .wp-block-heading h5 {';
	$output .= zeen_font_css_props( $font[ $headings ], true );
	$output .= '}';

	$output .= '.editor-styles-wrapper, .editor-styles-wrapper p { ' . zeen_font_css_props( $font[ $body ], true ) . ';}';
	$output .= '.editor-styles-wrapper .wp-block[data-type="core/paragraph"] { font-size: ' . (int) get_theme_mod( 'desktop_font_size', 15 ) . 'px; }';

	return $output;
}

function zeen_font_css_props( $font, $important = '' ) {
	$output = '';
	$output .= "font-family: '" . esc_attr( $font['font-family'] ) . "'" . esc_attr( $font['category'] , $font['font-fallback'] );
	if ( ! empty( $important ) ) {
		$output .= '!important';
	}
	$output .= ';';
	$output .= 'letter-spacing: ' . floatval( get_theme_mod( 'font_2_letter_spacing' ) ) . 'em;';
	if ( ! empty( $font['font-weight'][0] ) ) {
		$output .= 'font-weight: ' . (int) $font['font-weight'][0] . ';';
	}
	if ( 'italic' == $font['font-style'] ) {
		$output .= 'font-style: italic;';
	}
	return $output;
}

/**
 * Output extra styles
 *
 * @since 1.0.0
 */
function zeen_get_extra_style() {

	$image_sizes = zeen_get_image_sizes();
	$font_1 = zeen_get_font( 1 );
	$font_2 = zeen_get_font( 2 );
	$font_3 = get_theme_mod( 'font_3_onoff', 1 ) == 1 ? zeen_get_font( 3 ) : $font_2;
	$output = '';
	$header_style = zeen_get_style();
	$skins = array(
		array( 'customizer' => 'footer', 'selector' => '.site-footer', 'bg-area' => '.site-footer .bg-area-inner' ),
		array( 'customizer' => 'footer_widgets', 'selector' => '.footer-widget-bg-area', 'bg-area' => '.site-footer .footer-widget-bg-area' ),
		array( 'customizer' => 'lwa', 'selector' => '.content-lwa' ),
		array( 'customizer' => 'header', 'selector' => '.site-header' ),
		array( 'customizer' => 'sidebar', 'selector' => '.sidebar-wrap' ),
		array( 'customizer' => 'subscribe', 'selector' => '.content-subscribe' ),
		array( 'customizer' => 'slide', 'selector' => '.slide-in-menu' ),
		array( 'customizer' => 'mobile_header', 'selector' => '.site-mob-header' ),
		array( 'customizer' => 'mobile_menu', 'selector' => '.mob-menu-wrap' ),
		array( 'customizer' => 'single_subscribe_end', 'selector' => '.content-subscribe-block' ),
	);
	$skin_base = get_theme_mod( 'skin', '#ffffff' );
	$output .= '.content-bg, .article-layout-skin-1.title-cut-bl .hero-wrap .meta:before, .article-layout-skin-1.title-cut-bc .hero-wrap .meta:before, .article-layout-skin-1.title-cut-bl .hero-wrap .share-it:before, .article-layout-skin-1.title-cut-bc .hero-wrap .share-it:before, .standard-archive .page-header, .skin-dark .flickity-viewport { background: ' . sanitize_hex_color( $skin_base ) . ';}';

	if ( '#fff' != $skin_base && '#ffffff' != $skin_base ) {
		$rgba_1 = zeen_hex_rgba( $skin_base );
		$rgba_2 = zeen_hex_rgba( $skin_base, 0 );
		$output .= '.article-layout-skin-1 .splitter--fade:before { background: linear-gradient(0, ' . esc_attr( $rgba_1 ) . ' 0%, ' . esc_attr( $rgba_2 ) . ' 100%); }';
		$output .= '.block-wrap-native .splitter--fade:before, .block-wrap-native .splitter--fade:after { background: linear-gradient(0, ' . esc_attr( $rgba_1 ) . ' 0%, rgba(0,0,0,0) 80%); }';
		$output .= '.splitter .shape--fill { fill: ' . sanitize_hex_color( $skin_base ) . ' }';
		if ( zeen_is_light( $skin_base ) == true ) {
			$skin_17 = zeen_color_manipulation( $skin_base, -17 );
			$output .= '.wpcf7-form-control.wpcf7-text, .wpcf7-form-control.wpcf7-text[type="text"], .wpcf7-form-control.wpcf7-text[type="email"], .wpcf7-form-control.wpcf7-textarea, .hero, .mask, .preview-grid .mask, .preview-slider .mask, .user-page-box { background: ' . sanitize_hex_color( $skin_17 ) . '; }';
		}
	}

	if ( is_singular() ) {
		global $post;
		$builder = get_post_meta( $post->ID, 'tipi_builder_active', true );
		$builder_data = get_post_meta( $post->ID, 'tipi_builder_data', true );
	} elseif ( is_category() || is_tag() || is_tax() ) {
		$term_id = zeen_get_term_id();
		$builder = zeen_get_term_meta( 'tipi_builder_active', $term_id );
		$builder_data = zeen_get_term_meta( 'tipi_builder_data', $term_id );
		$color = zeen_term_color( $term_id );
		switch ( get_theme_mod( 'class_block_title_cat_color', 1 ) ) {
			case 2:
				$title_color = $color;
				break;
			case 3:
				$mid_line = $color;
				break;
			case 4:
				$bt = $color;
				break;
			case 5:
				$bb = $color;
				break;
			case 11:
				$title_color = $color;
				$mid_line = $color;
				$bt = $color;
				$bb = $color;
				break;
			default:
				break;
		}

		$output .= '#block-wrap-' . (int) $term_id . ' .tipi-row-inner-style{ ;';
		if ( ! empty( $bb ) || ! empty( $bt ) ) {
			if ( ! empty( $bb ) ) {
				$output .= 'border-bottom-color:' . esc_attr( $bb ) . ';';
			}
			if ( ! empty( $bt ) ) {
				$output .= 'border-top-color:' . esc_attr( $bt ). ';';
			}
		}
		$output .= '}';

		if ( ! empty( $title_color ) ) {
			$output .= '#block-wrap-' . (int) $term_id . ' .block-title-area{ color: ' . esc_attr( $title_color ) . '}';
		}

		if ( ! empty( $mid_line ) ) {
			$output .= '#block-wrap-' . (int) $term_id . ' .block-title:after{ border-bottom-color: ' . esc_attr( $mid_line ) . '}';
		}
	}

	$background = zeen_get_bg();
	$bg_el = 'site-inner';
	if ( 2 == get_theme_mod( 'header_block_width', 1 ) ) {
		$bg_el = 'site';
	}

	if ( ! empty( $background['color'] ) ) {
		$output .= '.' . esc_attr( $bg_el ) . ' { background-color: ' . esc_attr( $background['color'] ) . '; }';
		$output .= '.splitter svg g { fill: ' . esc_attr( $background['color'] ) . '; }';
	}
	if ( ! empty( $background['image'] ) ) {
		$output .= '.' . esc_attr( $bg_el ) . ' { background-image: url( ' . esc_url( $background['image'] ) . ' ); }';
	}

	$block_main_title = get_theme_mod( 'font_size_block_main_title', 40 );
	if ( $block_main_title < 24 ) {
		$output .= '.block-title, .page-title { font-size:' . (int) $block_main_title . 'px;}';
	}

	if ( $block_main_title < 30 ) {
		$output .= '.block-subtitle { font-size: 15px;}';
	}
	$output .= '.inline-post .block article .title { font-size: ' . get_theme_mod( 'font_size_inline_post', 20 ) . 'px;}';

	$output .= '.widget-title { font-size:' . (int) get_theme_mod( 'font_size_widget_title', 12 ) . 'px;}';

	$typo_buttons = get_theme_mod( 'typo_buttons', 2 );

	// FONT 1
	$output .= '.fontfam-1 {
		font-family: ' . zeen_sanitize_titles( zeen_font_family_output( $font_1 ) ) . '!important;
		letter-spacing:' . floatval( get_theme_mod( 'font_1_letter_spacing' ) ) . 'em;}';
	if ( 1 == $typo_buttons ) {
		$output .= 'input[type=submit], button, .tipi-button,.button,';
	}

	$output .= '.body-f1, .quotes-f1 blockquote, .quotes-f1 q, .by-f1 .byline, .sub-f1 .subtitle, .wh-f1 .widget-title, .headings-f1 h1, .headings-f1 .price, .headings-f1 h2, .headings-f1 h3, .headings-f1 h4, .headings-f1 h5, .headings-f1 h6, .font-1, div.jvectormap-tip {';
	$output .= 'font-family:' . zeen_sanitize_titles( zeen_font_family_output( $font_1 ) ) . ';';
	$output .= 'letter-spacing: ' . floatval( get_theme_mod( 'font_1_letter_spacing' ) ) . 'em;';
	if ( ! empty( $font_1['font-weight'][0] ) ) {
		$output .= 'font-weight: ' . (int) $font_1['font-weight'][0] . ';';
	}
	if ( 'italic' == $font_1['font-style'] ) {
		$output .= 'font-style: italic;';
	}
	$output .= '}';

	// FONT 2
	$output .= '.fontfam-2 { font-family:' . zeen_sanitize_titles( zeen_font_family_output( $font_2 ) ) . '!important;
		letter-spacing:' . floatval( get_theme_mod( 'font_2_letter_spacing' ) ) . 'em;}';

	if ( 2 == $typo_buttons ) {
		$output .= 'input[type=submit], button, .tipi-button,.button,';
	}
	$output .= '.body-f2, .quotes-f2 blockquote, .quotes-f2 q, .by-f2 .byline, .sub-f2 .subtitle, .wh-f2 .widget-title, .headings-f2 h1, .headings-f2 h2, .headings-f2 h3, .headings-f2 h4, .headings-f2 h5, .headings-f2 h6, .font-2 {';
	$output .= 'font-family:' . zeen_sanitize_titles( zeen_font_family_output( $font_2 ) ) . ';';
	$output .= 'letter-spacing: ' . floatval( get_theme_mod( 'font_2_letter_spacing' ) ) . 'em;';
	if ( ! empty( $font_2['font-weight'][0] ) ) {
		$output .= 'font-weight: ' . (int) $font_2['font-weight'][0] . ';';
	}
	if ( 'italic' == $font_2['font-style'] ) {
		$output .= 'font-style: italic;';
	}
	$output .= '}';

	// FONT 3
	$output .= '.fontfam-3 { font-family:' . zeen_sanitize_titles( zeen_font_family_output( $font_3 ) ) . '!important;
		letter-spacing:' . floatval( get_theme_mod( 'font_3_letter_spacing' ) ) . 'em;}';
	if ( 3 == $typo_buttons ) {
		$output .= 'input[type=submit], button, .tipi-button,.button,';
	}
	$output .= '.body-f3, .quotes-f3 blockquote, .quotes-f3 q, .by-f3 .byline, .sub-f3 .subtitle, .wh-f3 .widget-title, .headings-f3 h1, .headings-f3 h2, .headings-f3 h3, .headings-f3 h4, .headings-f3 h5, .headings-f3 h6, .font-3 {';
	$output .= 'font-family:' . zeen_sanitize_titles( zeen_font_family_output( $font_3 ) ) . ';';
	$output .= 'letter-spacing: ' . floatval( get_theme_mod( 'font_3_letter_spacing' ) ) . 'em;';
	if ( 'italic' == $font_3['font-style'] ) {
		$output .= 'font-style: italic;';
	}

	if ( ! empty( $font_3['font-weight'][0] ) ) {
		$output .= 'font-weight: ' . (int) $font_3['font-weight'][0] . ';';
	}
	$output .= '}';
	$site_width = get_theme_mod( 'site_width', 1230 );
	$site_width_posts = get_theme_mod( 'site_width_posts', 1230 );
	$output .= '.tipi-row, .tipi-builder-on .contents-wrap > p { max-width: ' . (int) $site_width . 'px ; }';
	$output .= '.single .site-content .tipi-row { max-width: ' . (int) $site_width_posts . 'px ; }';
	$output .= '.current-date { color: ' . sanitize_hex_color( get_theme_mod( 'current_date_color', '#f8d92f' ) ) . ' }';

	$output .= '.global-accent-border { border-color: ' . sanitize_hex_color( get_theme_mod( 'global_color', '#f7d40e' ) ) . '; }';
	$output .= '.trending-accent-border { border-color: ' . sanitize_hex_color( get_theme_mod( 'trending_color', '#f7d40e' ) ) . '; }';
	$output .= '.trending-accent-bg { border-color: ' . sanitize_hex_color( get_theme_mod( 'trending_color', '#f7d40e' ) ) . '; }';
	if ( get_theme_mod( 'load_more_fill', 1 ) == 2 ) {
		$output .= '.load-more__fill-2.tipi-button.block-loader { border-color: ' . sanitize_hex_color( get_theme_mod( 'load_more_bg', '#18181e' ) ) . '; color: ' . sanitize_hex_color( get_theme_mod( 'load_more_bg', '#18181e' ) ) . '; }';
		$output .= '.load-more__fill-2.tipi-button.block-loader:hover { border-color: ' . sanitize_hex_color( get_theme_mod( 'load_more_color_hover', '#111' ) ) . '; }';
	} else {
		$output .= '.tipi-button.block-loader { background: ' . sanitize_hex_color( get_theme_mod( 'load_more_bg', '#18181e' ) ) . '; }';
		$output .= '.tipi-button.block-loader:hover { background: ' . sanitize_hex_color( get_theme_mod( 'load_more_color_hover', '#111' ) ) . '; }';
	}
	$output .= '.tipi-button.block-loader { color: ' . sanitize_hex_color( get_theme_mod( 'load_more_color_text', '#fff' ) ) . '!important; }';
	$output .= '.wpcf7-submit { background: ' . sanitize_hex_color( get_theme_mod( 'contact_button_color', '#18181e' ) ) . '; }';
	$output .= '.wpcf7-submit:hover { background: ' . sanitize_hex_color( get_theme_mod( 'contact_button_color_hover', '#111' ) ) . '; }';
	$output .= '.global-accent-bg, .icon-base-2:hover .icon-bg, #progress { background-color: ' . sanitize_hex_color( get_theme_mod( 'global_color', '#f7d40e' ) ) . '; }';
	$output .= '.global-accent-text, .mm-submenu-2 .mm-51 .menu-wrap > .sub-menu > li > a { color: ' . sanitize_hex_color( get_theme_mod( 'global_color', '#f7d40e' ) ) . '; }';
	$output .= 'body { color:' . sanitize_hex_color( get_theme_mod( 'color_body', '#444' ) ) . ';}';
	$output .= '.excerpt { color:' . sanitize_hex_color( get_theme_mod( 'color_excerpt', '#444' ) ) . ';}';
	$output .= '.read-more-wrap { color:' . sanitize_hex_color( get_theme_mod( 'color_read_more', '#767676' ) ) . ';}';

	$output .= 'blockquote:not(.comment-excerpt) { color:' . sanitize_hex_color( get_theme_mod( 'color_blockquote', '#111' ) ) . ';}';

	$output .= '.byline, .byline a { color:' . sanitize_hex_color( get_theme_mod( 'color_byline', '#888' ) ) . ';}';
	$output .= '.preview-classic .meta .title, .preview-thumbnail .meta .title { color:' . sanitize_hex_color( get_theme_mod( 'color_block_post_title', '#111' ) ) . ';}';
	$output .= 'h1, h2, h3, h4, h5, h6, .block-title { color:' . sanitize_hex_color( get_theme_mod( 'color_heading', '#111' ) ) . ';}';
	$output .= '.sidebar-widget  .widget-title { color:' . sanitize_hex_color( get_theme_mod( 'color_widget_title', '#111' ) ) . '!important;}';
	$output .= '.link-color-wrap a { color: ' . sanitize_hex_color( get_theme_mod( 'color_link', '#333' ) ) . '; }';
	$output .= '.copyright { color: ' . sanitize_hex_color( get_theme_mod( 'color_copyright', '#555' ) ) . '; }';
	$output .= '.link-color-wrap a:hover { color: ' . sanitize_hex_color( get_theme_mod( 'color_link_hover', '#000' ) ) . '; }';
	$line_height = get_theme_mod( 'font_line_height', 1.666666666666667 );
	$line_height = substr( $line_height, -2 ) == 66 ? 1.666666666666667 : $line_height;
	$output .= 'body {font-size: ' . (int) get_theme_mod( 'mobile_font_size', 15 ) . 'px;line-height:' . floatval( $line_height ) . '; }';
	if ( get_theme_mod( 'italic_subtitle' ) == 1 ) {
		$output .= '.subtitle {font-style:italic;}';
	}
	if ( get_theme_mod( 'italic_blockquotes' ) == 1 ) {
		$output .= 'blockquote {font-style:italic;}';
	}
	if ( get_theme_mod( 'bold_main_menu', 1 ) == 1 ) {
		$output .= '.main-navigation .horizontal-menu, .main-navigation .menu-item, .main-navigation .tipi-i-search span { font-weight: 700;}';
	}
	if ( get_theme_mod( 'bold_secondary_menu', 1 ) == 1 ) {
		$output .= '.secondary-wrap .horizontal-menu, .secondary-wrap .menu-item {font-weight: 700;}';
	}
	if ( get_theme_mod( 'bold_footer_menu', 1 ) == 1 ) {
		$output .= '.footer-lower-area, .footer-lower-area .menu-item {font-weight: 700;}';
	}
	if ( get_theme_mod( 'bold_widget_title', 1 ) == 1 ) {
		$output .= '.widget-title {font-weight: 700!important;}';
	}
	if ( get_theme_mod( 'bold_xs_typo' ) == 1 ) {
		$output .= '.tipi-xs-typo .title {font-weight: 700;}';
	}
	if ( get_theme_mod( 'grid_font_size_override' ) == 1 ) {
		$grid_fs_xl = get_theme_mod( 'font_size_grid_xl_title', 45 );
		$grid_fs_l = get_theme_mod( 'font_size_grid_l_title', 36 );
		$grid_fs_m = get_theme_mod( 'font_size_grid_m_title', 24 );
		$grid_fs_s = get_theme_mod( 'font_size_grid_s_title', 18 );
		$grid_letter_spacing = get_theme_mod( 'letter_spacing_grid', 0 );
		$output .= '.block-wrap-grid .title { letter-spacing: ' . floatval( $grid_letter_spacing ) . 'em; }';
		$output .= '.block-wrap-grid .tipi-s-typo .title-wrap .title, .block-92 .block-piece-2 article .title-wrap .title, .block-94 .block-piece-2 .tipi-xs-6 .title-wrap .title { font-size: ' . (int) $grid_fs_s . 'px';
		if ( $grid_fs_s < 16 ) {
			$output .= '!important';
		}
		$output .= '; }';
		$output .= '.block-wrap-grid .tipi-m-typo .title-wrap .title, .block-wrap-grid .tipi-l-typo .title-wrap .title, .block-wrap-grid .tipi-xl-typo .title-wrap .title, .block-94 .block-piece-2 .tipi-xs-12 .title-wrap .title, .zeen-col--wide .block-wrap-grid:not(.block-wrap-81):not(.block-wrap-82) .tipi-m-typo .title-wrap .title { font-size: ' . (int) $grid_fs_m . 'px; }';
		if ( $grid_fs_m < 20 ) {
			$grid_fs_m_sub = $grid_fs_m > 14 ? $grid_fs_m * 0.9 : $grid_fs_m;
			$output .= '.block-wrap-grid .tipi-m-typo .subtitle, .block-wrap-grid .tipi-l-typo .subtitle, .block-wrap-grid .tipi-xl-typo .subtitle, .block-94 .block-piece-2 .tipi-xs-12 .subtitle, .block-92 .block-piece-2 article .subtitle, .block-94 .block-piece-2 .tipi-xs-6 .subtitle { font-size: ' . (int) $grid_fs_m_sub . 'px; }';
			$output .= '.zeen-col--wide .block-wrap-grid .tipi-l-typo .subtitle, .zeen-col--wide .block-wrap-grid .tipi-xl-typo .subtitle { font-size: ' . (int) $grid_fs_m_sub . 'px !important; }';
		}
		$output .= '.zeen-col--wide .block-wrap-grid .tipi-l-typo .title, .zeen-col--wide .block-wrap-grid .tipi-xl-typo .title { font-size: ' . (int) $grid_fs_m . 'px !important; }';
	}

	$tt = array(
		array( 'entry' => 'tt_inner_post_title', 'class' => '.entry-title', 'default' => '' ),
		array( 'entry' => 'tt_slider_post_title', 'class' => '.block-wrap-slider .title-wrap .title', 'default' => '' ),
		array( 'entry' => 'tt_grid_post_title', 'class' => '.block-wrap-grid .title-wrap .title, .tile-design-4 .meta .title-wrap .title', 'default' => '' ),
		array( 'entry' => 'tt_classic_post_title', 'class' => '.block-wrap-classic .title-wrap .title', 'default' => '' ),
		array( 'entry' => 'tt_block_main_title', 'class' => '.block-title', 'default' => '' ),
		array( 'entry' => 'tt_read_more', 'class' => '.meta .excerpt .read-more', 'default' => 1 ),
		array( 'entry' => 'tt_block_main_subtitle', 'class' => '.block-subtitle', 'default' => '' ),
		array( 'entry' => 'tt_byline', 'class' => '.byline', 'default' => '' ),
		array( 'entry' => 'tt_widget_title', 'class' => '.widget-title', 'default' => '' ),
		array( 'entry' => 'tt_main_menu', 'class' => '.main-navigation', 'default' => 1 ),
		array( 'entry' => 'tt_secondary_menu', 'class' => '.secondary-wrap', 'default' => 1 ),
		array( 'entry' => 'tt_footer_menu', 'class' => '.footer-lower-area .menu-item', 'default' => 1 ),
		array( 'entry' => 'tt_heading', 'class' => '.single-content .entry-content h1, .single-content .entry-content h2, .single-content .entry-content h3, .single-content .entry-content h4, .single-content .entry-content h5, .single-content .entry-content h6, .bbp__thread__title', 'default' => '' ),
	);

	foreach ( $tt as $key ) {
		if ( get_theme_mod( $key['entry'], $key['default'] ) == 1 ) {
			$output .= esc_attr( $key['class'] ) . '{ text-transform: uppercase; }';
		} else {
			$output .= esc_attr( $key['class'] ) . '{ text-transform: none; }';
		}
	}

	$output .= '.mm-submenu-2 .mm-11 .menu-wrap > *, .mm-submenu-2 .mm-31 .menu-wrap > *, .mm-submenu-2 .mm-21 .menu-wrap > *, .mm-submenu-2 .mm-51 .menu-wrap > *  { border-top: ' . (int) ( get_theme_mod( 'dropdown_top_bar_height', 3 ) ) . 'px solid transparent; }';

	$breathing_bottom = get_theme_mod( 'classic_breathing_bot', 30 );
	$output .= '.separation-border { margin-bottom: ' . (int) $breathing_bottom . 'px; }';
	$output .= '.block-wrap-classic .inf-spacer + .block:not(.block-62) { margin-top: ' . (int) $breathing_bottom . 'px; }';
	if ( get_theme_mod( 'masonry_design', 1 ) == 2 ) {
		$masonry_bg = get_theme_mod( 'masonry_background_color', '#eee' );
		$masonry_17 = zeen_color_manipulation( $masonry_bg, -17 );
		$output .= '.block-masonry-style article .preview-mini-wrap .meta { background: ' . sanitize_hex_color( $masonry_bg ) . ';}';
		$output .= '.block-masonry-style article .preview-mini-wrap .mask { background: ' . sanitize_hex_color( $masonry_17 ) . ';}';

		$output .= '.block-masonry-style article .meta { padding: ' . (int) get_theme_mod( 'masonry_whitespace', 15 ) . 'px;padding-top:0;}';
		$output .= '.block-masonry-style article .meta, .block-masonry-style article .meta a, .block-masonry-style article .meta .excerpt { color: ' . get_theme_mod( 'masonry_text_color', '#222' ) . ';}';
	}
	$classic_bottom_border_onoff = get_theme_mod( 'classic_bottom_border_onoff' );
	if ( ! empty( $classic_bottom_border_onoff ) ) {
		$output .= '.separation-border-style { border-bottom: ' . (int) get_theme_mod( 'classic_bottom_border_width' ) . 'px ' . sanitize_hex_color( get_theme_mod( 'classic_bottom_border_color' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'classic_bottom_border_style', 'solid' ) ) . ';padding-bottom:' . (int) ( get_theme_mod( 'classic_bottom_border_padding', 30 ) ) . 'px;}';
	}

	$footer_top_border_onoff = get_theme_mod( 'footer_top_border_onoff' );
	if ( ! empty( $footer_top_border_onoff ) ) {
		$output .= '#colophon .bg-area-inner { border-top: ' . (int) get_theme_mod( 'footer_top_border_width', 1 ) . 'px ' . sanitize_hex_color( get_theme_mod( 'footer_top_border_color' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'footer_top_border_style', 'solid' ) ) . ';}';
	}

	$classic_title_bottom_border_onoff = get_theme_mod( 'classic_title_bottom_border_onoff' );
	if ( ! empty( $classic_title_bottom_border_onoff ) ) {
		$output .= '.block-title-wrap-style .block-title-area { border-bottom: ' . (int) get_theme_mod( 'classic_title_bottom_border_width' ) . 'px ' . sanitize_hex_color( get_theme_mod( 'classic_title_bottom_border_color', '#eee' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'classic_title_bottom_border_style', 'solid' ) ) . ';}';
	}

	$classic_title_top_border_onoff = get_theme_mod( 'classic_title_top_border_onoff' );
	if ( ! empty( $classic_title_top_border_onoff ) ) {
		$output .= '.block-title-wrap-style .block-title-area { border-top: ' . (int) get_theme_mod( 'classic_title_top_border_width' ) . 'px ' . sanitize_hex_color( get_theme_mod( 'classic_title_top_border_color', '#eee' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'classic_title_top_border_style', 'solid' ) ) . ';}';
	}

	$classic_title_line_onoff = get_theme_mod( 'classic_title_line_onoff', 1 );
	if ( ! empty( $classic_title_line_onoff ) ) {
		$line_height = get_theme_mod( 'classic_title_line_width', 1 );
		$output .= '.block-title-wrap-style .block-title:after, .block-title-wrap-style .block-title:before { border-top: ' . (int) $line_height . 'px ' . get_theme_mod( 'classic_title_line_color', '#eee' ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'classic_title_line_style', 'solid' ) ) . ';}';
		if ( $line_height > 1 ) {
			$block_title_mt = $line_height / 2;
			$output .= '.block-title-wrap-style .block-title:after, .block-title-wrap-style .block-title:before { margin-top: -' . (int) ( $block_title_mt + 1 ) . 'px;}';
		}
	}

	$masonry_border = get_theme_mod( 'masonry_borders', 1 );
	if ( 1 == $masonry_border ) {
		$masonry_border_color = get_theme_mod( 'masonry_border_color', '#eee' );
		$output .= '.separation-border-v { background: ' . sanitize_hex_color( $masonry_border_color ) . ';}';
		$output .= '.separation-border-v { height: calc( 100% -  ' . (int) $breathing_bottom . 'px - 1px); }';
	}

	$output .= '@media only screen and (max-width: 480px) {';
	if ( ! empty( $classic_bottom_border_onoff ) ) {
		$output .= '.separation-border-style { padding-bottom: 15px; }.separation-border { margin-bottom: 15px;}';
	} else {
		$output .= '.separation-border { margin-bottom: 30px;}';
	}
	$output .= '}';

	$grid_spacing_tiles = get_theme_mod( 'grid_spacing_tiles', 0 );
	if ( $grid_spacing_tiles > 0 ) {
		$output .= '.grid-spacing { border-top-width: ' . (int) $grid_spacing_tiles . 'px; }';
	}

	$output .= '.sidebar-wrap .sidebar { padding-right: ' . (int) get_theme_mod( 'sidebar_padding_right', 30 ) . 'px; padding-left: ' . (int) get_theme_mod( 'sidebar_padding_left', 30 ) . 'px; padding-top:' . (int) get_theme_mod( 'sidebar_padding_top', 0 ) . 'px; padding-bottom:' . (int) get_theme_mod( 'sidebar_padding_bottom', 0 ) . 'px; }';

	$output .= '.sidebar-left .sidebar-wrap .sidebar { padding-right: ' . (int) get_theme_mod( 'sidebar_padding_left', 30 ) . 'px; padding-left: ' . (int) get_theme_mod( 'sidebar_padding_right', 30 ) . 'px; }';

	// 481 START
	$output .= '@media only screen and (min-width: 481px) {';
	if ( $grid_spacing_tiles > 0 ) {
		$output .= '.block-wrap-grid .block-title-area { margin-bottom: -' . (int) ( $grid_spacing_tiles ) . 'px; }';
		$output .= '.block-wrap-92 .tipi-row-inner-box { margin-top: -' . (int) $grid_spacing_tiles . 'px; }';
	}
	$split_img = get_theme_mod( 'classis_split_img_width', 50 );
	$output .= '.split-1:not(.preview-thumbnail) .mask {
		-webkit-flex: 0 0 calc( ' . (int) $split_img . '% - 15px);
		-ms-flex: 0 0 calc( ' . (int) $split_img . '% - 15px);
		flex: 0 0 calc( ' . (int) $split_img . '% - 15px);
		width: calc( ' . (int) $split_img . '% - 15px);
	}';
	$output .= '.split-1.preview-1:not(.article-window):not(.preview-thumbnail) .mask { padding-bottom:' . (int) ( 32 - ( ( 50 - $split_img ) * 0.66666 ) ) . '%; }';
	if ( $grid_spacing_tiles > 0 ) {
		$border_rtl = is_rtl() ? 'left' : 'right';
		$output .= '.grid-spacing { border-' . $border_rtl . '-width: ' . (int) $grid_spacing_tiles . 'px; }';
		if ( $grid_spacing_tiles > 5 ) {
			$output .= '.block-fs {padding:' . (int) $grid_spacing_tiles . 'px;}';
		}
		$output .= '.block-wrap-grid:not(.block-wrap-81) .block { width: calc( 100% + ' . (int) $grid_spacing_tiles . 'px ); }';
	}

	$slider_spacing_tiles = get_theme_mod( 'slider_spacing_tiles', 0 );
	if ( $slider_spacing_tiles > 0 ) {
		$output .= '.slider-spacing { margin-right: ' . (int) $slider_spacing_tiles . 'px;}';
	}
	$output .= '}';
	// 481 END

	$main_menu_pad_top = get_theme_mod( 'main_menu_padding_top', 15 );
	$main_menu_pad_bot = get_theme_mod( 'main_menu_padding_bottom', 15 );
	$header_pad_top = get_theme_mod( 'header_padding_top', 30 );
	$header_pad_bot = get_theme_mod( 'header_padding_bottom', 30 );

	// 768 START
	$output .= '@media only screen and (min-width: 768px) {';
	$customize_sticky = get_theme_mod( 'sticky_header_customize' );
	if ( ! empty( $customize_sticky ) ) {
		$output .= '.sticky-header--active .site-header.size-set .logo img, .site-header.size-set.slidedown .logo img, .site-header.size-set.sticky-menu-2.stuck .logo img { height: ' . (int) get_theme_mod( 'sticky_header_logo_height', 40 ) . 'px!important; }';
		$output .= '.sticky-header--active .site-header .bg-area, .site-header.sticky-menu-2.stuck .bg-area, .site-header.slidedown .bg-area, .main-navigation.stuck .menu-bg-area, .sticky-4-unfixed .header-skin-4.site-header .bg-area { background: ' . esc_attr( get_theme_mod( 'sticky_header_bg', 'rgba(255,255,255,0.9)' ) ) . '; }';
	} else {
		if ( abs( $main_menu_pad_top - $main_menu_pad_bot ) >= 5 && 72 != $header_style && 73 != $header_style && 74 != $header_style ) {
			$stuck_pad = $main_menu_pad_bot < $main_menu_pad_top ? $main_menu_pad_bot : $main_menu_pad_top;
			$output .= '.main-navigation.stuck .horizontal-menu > li > a {
				padding-top: ' . (int) $stuck_pad . 'px;
				padding-bottom: ' . (int) $stuck_pad . 'px;
			}';
		}
	}

	$mm = get_theme_mod( 'megamenu_skin', 2 );
	if ( 4 == $mm ) {
		$mm_color = get_theme_mod( 'megamenu_skin_color', '#fff' );
		$mm_bg = get_theme_mod( 'megamenu_skin_background', '#111' );
		$output .= '.mm-skin-4 .mm-art .menu-wrap, .mm-skin-4 .sub-menu, .trending-inline-drop .block-wrap, .trending-inline-drop, .trending-inline.dropper:hover { background: ' . esc_attr( $mm_bg ) . '; }';
		$output .= '.mm-skin-4 .mm-art .menu-wrap .block-wrap:not(.tile-design-4):not(.classic-title-overlay) a, .mm-skin-4 .sub-menu a, .mm-skin-4 .dropper .block-title-area .block-title, .mm-skin-4 .dropper .block-title-area .block-title a, .mm-skin-4 .mm-art .tipi-arrow, .mm-skin-4 .drop-it article .price, .trending-inline-drop .trending-inline-wrap .block article a, .trending-inline-drop, .trending-inline.dropper:hover a { color: ' . esc_attr( $mm_color ) . '; }';
		$output .= '.mm-skin-4 .mm-art .tipi-arrow, .trending-inline-drop .trending-selected { border-color: ' . esc_attr( $mm_color ) . '; }';
		$output .= '.mm-skin-4 .mm-art .tipi-arrow i:after { background: ' . esc_attr( $mm_color ) . '; }';
	}
	$contrast = 0;
	$post_inner_fs = get_theme_mod( 'font_size_post_inner', 44 );
	$post_inner_fs_sub = ( $post_inner_fs / 2 ) < 16 ? 16 : $post_inner_fs / 2;
	$output .= '.hero-meta.tipi-m-typo .title { font-size: ' . (int) $post_inner_fs . 'px; }';
	$output .= '.hero-meta.tipi-m-typo .subtitle { font-size: ' . (int) $post_inner_fs_sub . 'px; }';

	if ( get_theme_mod( 'logo_main' ) != '' ) {
		$contrast = $header_pad_bot + $header_pad_top + 50;
	}
	if ( has_nav_menu( 'main' ) && $header_style < 72 ) {
		$contrast = $main_menu_pad_top + $main_menu_pad_bot + 20 + $contrast;
	}
	$byline_size = get_theme_mod( 'font_size_byline', 12 );
	$thumbnail_title_size = get_theme_mod( 'font_size_thumbnail_blocks_title', 15 );
	$output .= '.title-contrast .hero-wrap { height: calc( 100vh - ' . (int) $contrast . 'px ); }';
	$output .= '.tipi-xs-typo .title  { font-size: ' . (int) $thumbnail_title_size . 'px; }';
	if ( $byline_size > $thumbnail_title_size ) {
		$output .= '.tipi-xs-typo .byline  { font-size: ' . (int) ( $thumbnail_title_size * 0.8 ) . 'px; }';
	}
	$base_block_title = get_theme_mod( 'font_size_classic_blocks_title', 24 );
	$output .= '.tipi-s-typo .title, .ppl-s-3 .tipi-s-typo .title, .zeen-col--wide .ppl-s-3 .tipi-s-typo .title, .preview-1 .title, .preview-21 .title  { font-size: ' . (int) $base_block_title . 'px;';
	if ( $base_block_title < 22 ) {
		$output .= 'line-height: 1.3333';
	}
	$output .= '}';
	if ( $base_block_title > 20 ) {
		$output .= '.block-col-self .block-71 .tipi-s-typo .title { font-size: 18px; }';
	}
	if ( $base_block_title < 20 && get_theme_mod( 'grid_font_size_override' ) != 1 ) {
		$output .= '.preview-grid.tipi-s-typo .title { font-size: ' . (int) round( $base_block_title * 1.2 ) . 'px; }';
	}

	$large_block_post_title = get_theme_mod( 'font_size_classic_blocks_title_l', 30 );
	$output .= '.block-wrap-classic .tipi-m-typo .title-wrap .title { font-size: ' . (int) $large_block_post_title . 'px; }';
	if ( $large_block_post_title > 18 ) {
		
		$output .= '.zeen-col--narrow .block-wrap-classic .tipi-m-typo .title-wrap .title { font-size: 18px; }';

	}
	$output .= '.sub-menu a:not(.tipi-button) { font-size: ' . (int) get_theme_mod( 'font_size_mm_sub_menu', 12 ) . 'px;}';
	if ( get_theme_mod( 'footer_widgets_border_onoff', 1 ) == 1 ) {
		$output .= '.footer-widget-wrap { border-right:' . get_theme_mod( 'footer_widgets_border_width', 1 ) . 'px ' . sanitize_hex_color( get_theme_mod( 'footer_widgets_border_color', '#333333' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'footer_widgets_border_style', 'solid' ) ) . ' ; }';
		$output .= '.footer-widget-wrap .widget_search form, .footer-widget-wrap select { border-color:' . sanitize_hex_color( get_theme_mod( 'footer_widgets_border_color', '#333333' ) ) . '; }';
		$output .= '.footer-widget-wrap .zeen-widget { border-bottom:' . get_theme_mod( 'footer_widgets_border_width', 1 ) . 'px ' . sanitize_hex_color( get_theme_mod( 'footer_widgets_border_color', '#333333' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'footer_widgets_border_style', 'solid' ) ) . ' ; }';
		$output .= '.footer-widget-wrap .zeen-widget .preview-thumbnail { border-bottom-color: ' . sanitize_hex_color( get_theme_mod( 'footer_widgets_border_color', '#333333' ) ) . ';}';
	}
	$output .= '.footer-widget-wrap {
		padding-top: ' . (int) get_theme_mod( 'footer_widgets_padding_top', 50 ) . 'px;
		padding-bottom: ' . (int) get_theme_mod( 'footer_widgets_padding_bottom', 50 ) . 'px;
	}';

	if ( $header_style > 80 ) {
		$header_side_width = get_theme_mod( 'header_side_width', 80 );
		$header_80_pad = 'padding-left';
		if ( 82 == $header_style ) {
			$header_80_pad = 'padding-right';
		}
		$header_side_width_768 = $header_side_width > 200 ? 200 : $header_side_width;
		$output .= '.next-prev__prev {left: ' . (int) $header_side_width_768 . 'px; }';
		$output .= '.secondary-wrap-v { width: ' . (int) $header_side_width_768 . 'px; }';
		$output .= '.body-with-v .site { ' . esc_attr( $header_80_pad ) . ': ' . (int) $header_side_width_768 . 'px; }';
		if ( 82 == $header_style ) {
			$output .= '.body-with-v .zeen-top-block .block-wrap { ' . esc_attr( $header_80_pad ) . ': ' . (int) $header_side_width_768 . 'px; }';
		}
	} elseif ( $header_style > 70 ) {
		$floating_side_menu_width = get_theme_mod( 'floating_side_menu', 80 );
		if ( $floating_side_menu_width > 0 ) {
			$output .= '.secondary-wrap-v { width: ' . (int) $floating_side_menu_width . 'px; }';
			if ( get_theme_mod( 'secondary_menu_side_enable', 1 ) == 1 ) {
				$output .= '.header-width-2 .header-side-padding, .tipi-builder-on .tipi-fs, .standard-archive, .header-width-2 .drop-it .block-wrap, .header-width-2 .trending-inline-drop .trending-inline-title { padding-left: ' . (int) $floating_side_menu_width . 'px; padding-right:' . (int) $floating_side_menu_width . 'px; }';
			}
		}
	} else {
		$output .= '.secondary-wrap .menu-padding, .secondary-wrap .ul-padding > li > a {
			padding-top: ' . (int) ( get_theme_mod( 'secondary_menu_padding_top', 10 ) ) . 'px;
			padding-bottom: ' . (int) ( get_theme_mod( 'secondary_menu_padding_bottom', 10 ) ) . 'px;
		}';
	}

	$output .= '}';
	// 768 END

	if ( ! empty( $builder ) ) {
		$output .= TipiBuilder\ZeenHelpers::zeen_style( $builder_data, 'm' );
	}
	if ( ! empty( $builder ) ) {
		$output .= '@media only screen and (min-width: 768px) {';
		$output .= TipiBuilder\ZeenHelpers::zeen_style( $builder_data, 't' );
		$output .= '}';
	}

	// 1020 START
	$output .= '@media only screen and (min-width: 1020px) {';
	$output .= 'h1 { font-size: ' . (int) get_theme_mod( 'font_size_h1', 50 ) . 'px; }';
	$output .= 'h2 { font-size: ' . (int) get_theme_mod( 'font_size_h2', 40 ) . 'px; }';
	$output .= 'h3 { font-size: ' . (int) get_theme_mod( 'font_size_h3', 30 ) . 'px; }';
	$output .= 'h4 { font-size: ' . (int) get_theme_mod( 'font_size_h4', 20 ) . 'px; }';
	$output .= 'h5 { font-size: ' . (int) get_theme_mod( 'font_size_h5', 16 ) . 'px; }';
	$output .= '.block-title, .page-title { font-size:' . (int) $block_main_title . 'px;}';
	if ( get_theme_mod( 'grid_font_size_override' ) == 1 ) {
		$output .= '.block-wrap-grid .tipi-xl-typo .title { font-size: ' . (int) $grid_fs_xl . 'px; }';
	}
	$output .= '}';
	// 1020 END

	// 1240 START
	$output .= '@media only screen and (min-width: 1240px) {';
	$global_border = get_theme_mod( 'global_border_width' );
	if ( ! empty( $global_border ) ) {
		$output .= 'body{ border:' . (int) $global_border . 'px ' . sanitize_hex_color( get_theme_mod( 'global_border_color', '#FBE610' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'global_border_style', 'solid' ) ) . ';}';
	}
	if ( ! empty( $builder ) ) {
		$output .= TipiBuilder\ZeenHelpers::zeen_style( $builder_data, 'dt' );
	}
	if ( get_theme_mod( 'grid_font_size_override' ) == 1 ) {
		$output .= '.block-wrap-grid .tipi-l-typo .title { font-size: ' . (int) $grid_fs_l . 'px; }';
	}
	$bg_ad = zeen_get_bg_ad();
	if ( ! empty( $bg_ad ) ) {
		if ( ! empty( $bg_ad['image'] ) ) {
			$output .= '.' . esc_attr( $bg_el ) . ' { background-image: url( ' . esc_url( $bg_ad['image'] ) . ' ); }';
		}
		if ( ! empty( $bg_ad['top_spacing'] ) ) {
			$output .= '.' . esc_attr( $bg_el ) . ' { padding-top: ' . (int) $bg_ad['top_spacing'] . 'px; }';
		}
	}

	if ( $header_style > 80 && $header_side_width > 200 ) {
		$output .= '.next-prev__prev {left: ' . (int) $header_side_width . 'px; }';
		$output .= '.secondary-wrap-v { width: ' . (int) $header_side_width . 'px; }';
		$output .= '.body-with-v .site { ' . esc_attr( $header_80_pad ) . ': ' . (int) $header_side_width . 'px; }';
		if ( 82 == $header_style ) {
			$output .= '.body-with-v .zeen-top-block .block-wrap { ' . esc_attr( $header_80_pad ) . ': ' . (int) $header_side_width . 'px; }';
		}
	}
	if ( $site_width_posts <= 1230 ) {
		$output .= '.align-fs .contents-wrap .video-wrap, .align-fs-center .aligncenter.size-full, .align-fs-center .wp-caption.aligncenter .size-full, .align-fs-center .tiled-gallery, .align-fs .alignwide { width: ' . (int) ( $site_width_posts - 60 ) . 'px; }';
		$output .= '.align-fs .contents-wrap .video-wrap { height: ' . (int) ( ( $site_width_posts - 60 ) * 0.5625 ) . 'px; }';

		$output .= '.has-bg .align-fs .contents-wrap .video-wrap, .has-bg .align-fs .alignwide, .has-bg .align-fs-center .aligncenter.size-full, .has-bg .align-fs-center .wp-caption.aligncenter .size-full, .has-bg .align-fs-center .tiled-gallery { width: ' . (int) $site_width_posts . 'px; }';
		$output .= '.has-bg .align-fs .contents-wrap .video-wrap { height: ' . (int) ( $site_width_posts * 0.5625 ) . 'px; }';
	}
	foreach ( $image_sizes as $key => $value ) {
		$width = $value['width'] > 300 ? 300 : $value['width'];
		$output .= '.align-pull .alignleft.size-' . esc_attr( $key ) . ', .align-pull .alignright.size-' . esc_attr( $key ) . ' { width: ' . (int) $width . 'px; }';
		$output .= '.align-pull .alignleft.wp-caption, .align-pull .alignright.wp-caption { width: ' . (int) $width . 'px!important; }';
		$output .= '.align-pull .alignleft.size-' . esc_attr( $key ) . ', .align-pull .alignleft.wp-caption { margin-left: -' . (int) ( $width / 2 ) . 'px; }';
		$output .= '.align-pull .alignright.size-' . esc_attr( $key ) . ', .align-pull .alignright.wp-caption { margin-right: -' . (int) ( $width / 2 ) . 'px; }';

	}
	$output .= '.align-pull .alignleft.size-full { margin-left: -' . (int) ( $width / 2 ) . 'px; }';
	$output .= '.align-pull .alignright.size-full { margin-right: -' . (int) ( $width / 2 ) . 'px; }';

	$output .= 'body { font-size: ' . (int) get_theme_mod( 'desktop_font_size', 15 ) . 'px; }';
	$output .= '}';
	// 1240 END

	$output .= '.main-menu-bar-color-1 .current-menu-item > a, .main-menu-bar-color-1 .menu-main-menu > .dropper.active:not(.current-menu-item) > a { background-color: ' . esc_attr( get_theme_mod( 'menu_accent', '#111' ) ) . ';}';
	$output .= '.byline { font-size: ' . (int) $byline_size . 'px; }';
	if (  $byline_size > 12 ) {
		$output .= '.cats .cat-with-bg { font-size: 12px; }';
	}
	$output .= '.post-tags a { font-size: ' . (int) get_theme_mod( 'font_size_tags', 8 ) . 'px; }';

	$output .= '.site-header a { color: ' . sanitize_hex_color( get_theme_mod( 'main_menu_color', '#111' ) ) . '; }';

	$output .= '.site-skin-3.content-subscribe, .site-skin-3.content-subscribe .subtitle, .site-skin-3.content-subscribe input, .site-skin-3.content-subscribe h2 { color: ' . sanitize_hex_color( get_theme_mod( 'subscribe_color', '#fff' ) ) . '; } .site-skin-3.content-subscribe input[type="email"] { border-color: ' . sanitize_hex_color( get_theme_mod( 'subscribe_color', '#fff' ) ) . '; }';

	if ( get_theme_mod( 'mobile_menu_skin', 1 ) > 2 ) {
		$output .= '.mob-menu-wrap a { color: ' . sanitize_hex_color( get_theme_mod( 'mobile_menu_color', '#fff' ) ) . '; }';
	}

	if ( get_theme_mod( 'footer_widgets_border_onoff', 1 ) == 1 ) {
		$output .= '.footer-widget-wrap .widget_search form { border-color:' . sanitize_hex_color( get_theme_mod( 'footer_widgets_border_color', '#333' ) ) . '; }';
	}

	if ( get_theme_mod( 'sidebar_border_onoff', 1 ) == 1 ) {
		$output .= '.sidebar-wrap .sidebar { border:' . (int) get_theme_mod( 'sidebar_border_width', 1 ) . 'px ' . sanitize_hex_color( get_theme_mod( 'sidebar_border_color', '#ddd' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'sidebar_border_style', 'solid' ) ) . ' ; }';
	}

	if ( get_theme_mod( 'sidebar_widgets_border_onoff', 1 ) == 1 ) {
		$border_width = get_theme_mod( 'sidebar_widgets_border_width', 1 ) . 'px';
		$border_width = 1 == get_theme_mod( 'sidebar_widgets_border_bottom', 1 ) ? '0 0 ' . $border_width . ' 0' : $border_width;
		$output .= '.content-area .zeen-widget { border: 0 ' . sanitize_hex_color( get_theme_mod( 'sidebar_widgets_border_color', '#ddd' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'sidebar_widgets_border_style', 'solid' ) ) . ' ; border-width: ' . esc_attr( $border_width ) . '; }';
	}

	$output .= '.content-area .zeen-widget { padding:' . (int) get_theme_mod( 'sidebar_widgets_padding_top', 30 ) . 'px ' . get_theme_mod( 'sidebar_widgets_padding_lr', 0 ) . 'px ' . (int) get_theme_mod( 'sidebar_widgets_padding_bottom', 30 ) . 'px; }';
	if ( get_theme_mod( 'sidebar_widgets_skin', 4 ) != 4 ) {
		$output .= '.content-area .zeen-widget{ margin-bottom:' . (int) get_theme_mod( 'sidebar_widgets_spacing' ) . 'px; }';
	}

	$output .= zeen_overlay();

	if ( get_theme_mod( 'logo_subtitle_main' ) != '' ) {
		$output .= '.logo-main .logo-subtitle { color: ' . sanitize_hex_color( get_theme_mod( 'logo_subtitle_main_color', '#111' ) ) . '; }';
	}
	if ( get_theme_mod( 'logo_subtitle_footer' ) != '' ) {
		$output .= '.logo-footer .logo-subtitle { color: ' . sanitize_hex_color( get_theme_mod( 'logo_subtitle_footer_color', '#111' ) ) . '; }';
	}
	foreach ( $skins as $key ) {
		$sanitize_options[] = $key['selector'];
	}

	foreach ( $skins as $key ) {
		$default = 1;
		$default_color = '#fff';
		$sanitize_options = array();
		if ( 'footer' == $key['customizer'] ) {
			$default = 2;
		} elseif ( 'footer_widgets' == $key['customizer'] ) {
			$default = 3;
			$default_color = '#dddede';
		} elseif ( 'post_end_subscribe' == $key['customizer'] ) {
			$default = 3;
			$default_color = '#dddede';
		}
		if ( zeen_skin_style( $key['customizer'], 'skin', $default ) == 3 ) {

			$skin_img = get_theme_mod( $key['customizer'] . '_skin_img' );
			$skin_color = get_theme_mod( $key['customizer'] . '_skin_color', '#272727' );

			if ( ! empty( $skin_color ) ) {
				$skin_color_b = get_theme_mod( $key['customizer'] . '_skin_color_b' );
				$key['selector'] = empty( $key['bg-area'] ) ? $key['selector'] . ' .bg-area' : $key['bg-area'];
				if ( 'header' == $key['customizer'] && $header_style > 80 ) {
					$key['selector'] = '.site-header-side';
				}

				if ( empty( $skin_color_b ) || $skin_color == $skin_color_b ) {
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ', ' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .woo-product-rating span { background-color: ' . esc_attr( $skin_color ) . '; }';
				} else {
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' { background-image: linear-gradient(130deg, ' . esc_attr( $skin_color ) . ' 0%, ' . esc_attr( $skin_color_b ) . ' 80%);  }';
				}
				if ( 'sidebar' == $key['customizer'] || 'footer_widgets' == $key['customizer'] ) {
					if ( zeen_is_light( $skin_color ) == true ) {
						$sidebar_17 = zeen_color_manipulation( $skin_color, -17 );
						$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .widget_search form, ' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .widget_product_search form, ' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .lwa-input-wrap input { border-color: ' . sanitize_hex_color( $sidebar_17 ) . '; }';
						$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .zeen-checkbox label .zeen-i { background: ' . sanitize_hex_color( $sidebar_17 ) . '; }';
						if ( 'sidebar' == $key['customizer'] ) {
							$output .= '.article-layout-skin-1 .user-page-box, .skin-light .user-page-box { background: ' . sanitize_hex_color( $skin_color ) . '; }';
						}
					}
				}
			}
			if ( ! empty( $skin_img ) ) {
				$skin_img_check = attachment_url_to_postid( $skin_img );
				if ( ! empty( $skin_img_check ) ) {
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .background { background-image: url( ' . esc_url( $skin_img ) . ' ); }';
				}

				$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .background { opacity: ' . floatval( get_theme_mod( $key['customizer'] . '_skin_img_transparency', 1 ) ) . '; }';
			} else {
				$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .background { background-image: none; opacity: 1; }';
			}

			if ( 'footer' == $key['customizer'] ) {
				$output .= '.footer-lower-area { color: ' . sanitize_hex_color( get_theme_mod( 'footer_color', '#fff' ) ) . '; }';
				$output .= '.to-top-2 a { border-color: ' . sanitize_hex_color( get_theme_mod( 'footer_color', '#fff' ) ) . '; }';
				$output .= '.to-top-2 i:after { background: ' . sanitize_hex_color( get_theme_mod( 'footer_color', '#fff' ) ) . '; }';
			} elseif ( 'sidebar' == $key['customizer'] ) {
				$output .= '.site-skin-3 .sidebar:not(.sidebar-own-bg) { color: ' . sanitize_hex_color( get_theme_mod( 'sidebar_color', '#fff' ) ) . '; }';
			}
		}

		if ( zeen_skin_style( $key['customizer'], 'skin', $default ) == 3 || zeen_skin_style( $key['customizer'] ) == 4 ) {
			$font_color = get_theme_mod( $key['customizer'] . '_color', $default_color );
			if ( 'slide' == $key['customizer'] ) {
				$output .= '.slide-in-menu,' . zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' a,' . zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' .widget-title, .slide-in-menu .cb-widget-design-1 .cb-score { color:' . esc_attr( $font_color ) . '; }';
				$output .= '.slide-in-menu form { border-color:' . esc_attr( $font_color ) . '; }';
				$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .mc4wp-form-fields input[type="email"], #subscribe-submit input[type="email"], .subscribe-wrap input[type="email"],' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .mc4wp-form-fields input[type="text"], #subscribe-submit input[type="text"], .subscribe-wrap input[type="text"] { border-bottom-color:' . esc_attr( $font_color ) . '; }';
			} elseif ( 'header' != $key['customizer'] ) {
				if ( 'sidebar' == $key['customizer'] ) {
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .load-more-wrap .tipi-arrow { border-color:' . esc_attr( $font_color ) . '; color:' . esc_attr( $font_color ) . '; }';
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .load-more-wrap .tipi-arrow i:after { background:' . esc_attr( $font_color ) . '; }';
				} elseif ( 'mobile_header' == $key['customizer'] ) {
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .tipi-i-menu-mob:after,' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .tipi-i-menu-mob:before,' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .tipi-i-menu-mob { background:' . esc_attr( $font_color ) . '; }';
				} elseif ( 'footer_widgets' == $key['customizer'] ) {
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' .block-skin-0 .tipi-arrow { color:' . esc_attr( $font_color ) . '; border-color:' . esc_attr( $font_color ) . '; }';
					$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' .block-skin-0 .tipi-arrow i:after{ background:' . esc_attr( $font_color ) . '; }';
				}
				$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ',' . zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .byline,' . zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' a,' . zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' .widget_search form *,' . zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' h3,' . zeen_sanitizer_options( $key['selector'], $sanitize_options )  . ' .widget-title { color:' . esc_attr( $font_color ) . '; }';
				$output .= zeen_sanitizer_options( $key['selector'], $sanitize_options ) . ' .tipi-spin.tipi-row-inner-style:before { border-color:' . esc_attr( $font_color ) . '; }';
			}
		}
	}
	// Footer Menu
	$output .= '.footer-navigation { font-size: ' . (int) get_theme_mod( 'footer_menu_font_size', 11 ) . 'px;  }';
	// Main Menu
	$output .= '.main-navigation { font-size: ' . (int) get_theme_mod( 'main_menu_font_size', 12 ) . 'px;  color: ' . get_theme_mod( 'main_menu_color', '#1e1e1e' ) . '; }';
	$output .= '.main-navigation .horizontal-menu>li>a { padding-left: ' . (int) ( get_theme_mod( 'main_menu_padding_sides', '12' ) ) . 'px; padding-right: ' . (int) ( get_theme_mod( 'main_menu_padding_sides', '12' ) ) . 'px; }';
	if ( get_theme_mod( 'main_menu_skin', 1 ) == 3 ) {
		$skin_color_b = get_theme_mod( 'main_menu_skin_color_b' );
		if ( empty( $skin_color_b ) ) {
			$output .= '.main-navigation .menu-bg-area { background-color: ' . sanitize_hex_color( get_theme_mod( 'main_menu_skin_color' ) ) . '; }';
		} else {
			$output .= '.main-navigation .menu-bg-area { background-image: linear-gradient(130deg, ' . esc_attr( get_theme_mod( 'main_menu_skin_color' ) ) . ' 0%, ' . esc_attr( $skin_color_b ) . ' 80%);  }';
		}
	}

	$main_menu_border_bot = get_theme_mod( 'main_menu_bottom_border_width', 3 );
	$main_menu_border_top = get_theme_mod( 'main_menu_top_border_width', 1 );
	if ( $main_menu_border_bot > 0 ) {
		$output .= '.main-navigation-border { border-bottom:' . (int) $main_menu_border_bot . 'px ' . sanitize_hex_color( get_theme_mod( 'main_menu_bottom_border_color', '#0a0a0a' ) ) . ' ' . zeen_sanitizer_border_type( zeen_sanitizer_border_type( get_theme_mod( 'main_menu_bottom_border_style', 'solid' ) ) ) . ' ; }';
		$output .= '.main-navigation-border .drop-search { border-top:' . (int) $main_menu_border_bot . 'px ' . sanitize_hex_color( get_theme_mod( 'main_menu_bottom_border_color', '#0a0a0a' ) ) . ' ' . zeen_sanitizer_border_type( zeen_sanitizer_border_type( get_theme_mod( 'main_menu_bottom_border_style', 'solid' ) ) ) . ' ; }';
		$output .= '#progress {bottom: 0;height: ' . (int) $main_menu_border_bot . 'px; }.sticky-menu-2:not(.active) #progress  { bottom: -' . (int) $main_menu_border_bot . 'px;  }';
	}
	if ( is_single() ) {
		$cat = zeen_get_cats( $post->ID, array( 'try_primary' => true ) );
		$cid = isset( $cat[0]->term_id ) ? $cat[0]->term_id : '';
		$category_color = zeen_term_color( $cid );
		$output .= '#progress { background-color: ' . sanitize_hex_color( $category_color ) . '; }';
	}

	if ( ! empty( $main_menu_border_top ) ) {
		$output .= '.main-navigation-border { border-top: ' . (int) $main_menu_border_top . 'px ' . sanitize_hex_color( get_theme_mod( 'main_menu_top_border_color', '#eee' ) ) . ' ' . zeen_sanitizer_border_type( get_theme_mod( 'main_menu_top_border_style', 'solid' ) ) . ' ; }';
	}
	if ( 72 != $header_style && 73 != $header_style && 74 != $header_style )  {
		$output .= '.main-navigation .horizontal-menu .drop, .main-navigation .horizontal-menu > li > a {
			padding-top: ' . (int) $main_menu_pad_top . 'px;
			padding-bottom: ' . (int) $main_menu_pad_bot . 'px;
		}';
	}

	// Secondary Menu
	if ( get_theme_mod( 'secondary_menu_skin', 1 ) == 3 ) {
		$skin_color_b = get_theme_mod( 'secondary_menu_skin_color_b' );
		if ( empty( $skin_color_b ) ) {
			$output .= '.secondary-wrap .menu-bg-area { background-color: ' . sanitize_hex_color( get_theme_mod( 'secondary_menu_skin_color' ) ) . '; }';
		} else {
			$output .= '.secondary-wrap .menu-bg-area { background-image: linear-gradient(130deg, ' . esc_attr( get_theme_mod( 'secondary_menu_skin_color' ) ) . ' 0%, ' . esc_attr( $skin_color_b ) . ' 80%);  }';
		}
	}
	$output .= '.secondary-wrap-v .standard-drop>a,.secondary-wrap, .secondary-wrap a { font-size: ' . (int) ( get_theme_mod( 'secondary_menu_font_size', '11' ) ) . 'px; color: ' . sanitize_hex_color( get_theme_mod( 'secondary_menu_color', '#fff' ) ) . '; }';
	$output .= '.secondary-wrap li a, .secondary-icons li a { padding-left: ' . (int) ( get_theme_mod( 'secondary_menu_padding_sides', '7' ) ) . 'px; padding-right: ' . (int) ( get_theme_mod( 'secondary_menu_padding_sides', '7' ) ) . 'px; }';

	$output .= '.mc4wp-form-fields input[type=submit], .mc4wp-form-fields button, #subscribe-submit input[type=submit], .subscribe-wrap input[type=submit] {';
	$subscribe_button_b = get_theme_mod( 'subscribe_button_color_b' );

		$output .= 'color: ' . esc_attr( get_theme_mod( 'subscribe_button_font_color', '#fff' ) ) . ';';
	if ( empty( $subscribe_button_b ) ) {
		$output .= 'background-color: ' . esc_attr( get_theme_mod( 'subscribe_button_color', '#121212' ) ) . ';';
	} else {
		$output .= 'background-image: linear-gradient(130deg, ' . esc_attr( get_theme_mod( 'subscribe_button_color' ) ) . ' 0%, ' . esc_attr( $subscribe_button_b ) . ' 80%);';
	}
	$output .= '}';

	$output .= '.site-mob-header .header-padding {
		padding-top: ' . (int) get_theme_mod( 'mobile_header_padding_top', 20 ) . 'px;
		padding-bottom: ' . (int) get_theme_mod( 'mobile_header_padding_bottom', 20 ) . 'px;
	}';

	$output .= '.site-header .header-padding {
		padding-top:' . (int) $header_pad_top . 'px;
		padding-bottom:' . (int) $header_pad_bot . 'px;
	}';

	if ( get_theme_mod( 'header_sticky_onoff', 1 ) == 1 && ! empty( $customize_sticky ) ) {
		$sticky_pad_top = get_theme_mod( 'sticky_header_padding_top', 30 );
		$sticky_pad_bot = get_theme_mod( 'sticky_header_padding_bottom', 30 );
		$output .= '.site-header.sticky-menu-2.stuck .header-padding, .site-header.slidedown .header-padding, .sticky-header--active .site-header .header-padding, .main-navigation.stuck .horizontal-menu > li > a { padding-top: ' . (int) $sticky_pad_top . 'px; padding-bottom: ' . (int) $sticky_pad_bot . 'px; }';
	}

	if ( 58 == $header_style ) {
		$header_style = get_theme_mod( 'header_style', 1 );
	}
	if ( 11 == $header_style ) {
		$output .= '.site-header-11 .menu { border-top-width: ' . (int) ( get_theme_mod( 'header_padding_bottom', 30 ) + 3 ) . 'px;}';
	}

	$output .= '.footer-upper-area {
		padding-top: ' . (int) ( get_theme_mod( 'footer_upper_padding_top', 50 ) ) . 'px;
		padding-bottom: ' . (int) ( get_theme_mod( 'footer_upper_padding_bottom', 50 ) ) . 'px;
	}';

	$output .= '.footer-lower-area {
		padding-top: ' . (int) ( get_theme_mod( 'footer_lower_padding_top', 90 ) ) . 'px;
		padding-bottom: ' . (int) ( get_theme_mod( 'footer_lower_padding_bottom', 90 ) ) . 'px;
	}';

	if ( get_theme_mod( 'top_bar_message' ) == 1 ) {
		$output .= '#top-bar-message { font-size: ' . (int) get_theme_mod( 'top_bar_message_content_font_size', 12 ) . 'px; padding: ' . (int) get_theme_mod( 'top_bar_message_content_spacing', 15 ) . 'px 30px;  }';
	}

	if ( get_theme_mod( 'sliding_global' ) == 1 ) {
		$bg = get_theme_mod( 'sliding_global_bg' );
		$output .= '.subscribe-wrap, .subscribe-wrap .content div { color: ' . sanitize_hex_color( get_theme_mod( 'sliding_global_font_color', '#fff' ) ) . '; }';
		if ( ! empty( $bg ) ) {
			$output .= '.slide-in-box:not(.slide-in-2) { background-image: url(' . esc_url( $bg ) . '); }';
		}
	}

	// Woo
	if ( zeen_woo_active() ) {
		$output .= '.cart .button, .woocommerce .button { background: ' . sanitize_hex_color( get_theme_mod( 'add_to_cart_background', '#111' ) ) . '}';
		$output .= '.out-of-stock, .onsale { background: ' . sanitize_hex_color( get_theme_mod( 'sale_background', '#111' ) ) . '}';
	}

	// bbPress

	if ( zeen_bbp_active() ) {
		if ( get_theme_mod( 'bbpress_show_tags' ) != 1 ) {
			$output .= '.bbp-topic-tags { display: none; }';
		}
	}

	return $output;
}

function zeen_overlay() {
	$output = '';

	$options = array( 'grid', 'slider' );

	foreach ( $options as $key ) {
		$title_onoff = get_theme_mod( $key . '_title_bg_onoff' );
		$image_onoff = get_theme_mod( $key . '_img_overlay_onoff', 1 );
		if ( 1 == $title_onoff ) {
			if ( get_theme_mod( $key . '_title_bg', 2 ) == 2 ) {
				$a = get_theme_mod( $key . '_title_gradient_a' ) != '' ? get_theme_mod( $key . '_title_gradient_a' ) : 'rgba(0,0,0,0)';
				$b = get_theme_mod( $key . '_title_gradient_b' ) != '' ? get_theme_mod( $key . '_title_gradient_b' ) : 'rgba(0,0,0,0)';
				$output .= '.' . zeen_sanitizer_options( $key, $options ) . '-meta-bg .mask:before { content: ""; background-image: linear-gradient(to top, ' . esc_attr( $a ) . ' 0%, ' . esc_attr( $b ) . ' 100%); }';
			} else {
				$output .= '.' . zeen_sanitizer_options( $key, $options ) . '-meta-bg .meta { background-color: ' . esc_attr( get_theme_mod( $key . '_title_solid' ) ) . ' ; }';
			}
		}

		if ( 1 == $image_onoff ) {
			if ( get_theme_mod( $key . '_img_overlay' ) == 2 ) {
				for ( $i = 1; $i < 7; $i++ ) {
					if ( 1 == $i ) {
						$a = get_theme_mod( $key . '_gradient_' . $i . '_a', 'rgba(238,9,121,0.6)' );
						$backup_a = $a;
						$b = get_theme_mod( $key . '_gradient_' . $i . '_b', 'rgba(255,106,0,0.3)' );
						$backup_b = $b;
					} else {
						$a = get_theme_mod( $key . '_gradient_' . $i . '_a' );
						$b = get_theme_mod( $key . '_gradient_' . $i . '_b' );
						$a = empty( $a ) ? $backup_a : $a;
						$b = empty( $b ) ? $backup_b : $b;
					}
					$output .= '.' . zeen_sanitizer_options( $key, $options ) . '-image-2.loop-' . ( $i - 1 ) . ' .mask-overlay { background-image: linear-gradient(130deg, ' . esc_attr( $a ) . ' 0%, ' . esc_attr( $b ) . ' 80%); }';
				}
			} else {
				$output .= '.' . zeen_sanitizer_options( $key, $options ) . '-image-1 .mask-overlay { background-color: ' . esc_attr( get_theme_mod( $key . '_img_overlay_solid', '#1a1d1e' ) ) . ' ; }';
			}
		}
		$title_color = get_theme_mod( $key . '_title_color', '#fff' );
		$title_color_hover = get_theme_mod( $key . '_title_color_hover', '#fff' );
		$img_overlay = get_theme_mod( $key . '_img_overlay_opacity', 0.2 );
		$img_overlay_hover = get_theme_mod( $key . '_img_overlay_opacity_hover', 0.6 );
		$output .= '.with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ',.with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ' .byline,.with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ' .subtitle, .with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ' a { color: ' . $title_color . '; }';
		$output .= '.preview-' . zeen_sanitizer_options( $key, $options ) . ' .mask-overlay { opacity: ' . floatval( $img_overlay ) . ' ; }';
		$output .= '@media (pointer: fine) {';
		if ( $title_color_hover != $title_color ) {
			$output .= '.with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ':hover, .with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ':hover .byline,.with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ':hover .subtitle, .with-fi.preview-' . zeen_sanitizer_options( $key, $options ) . ':hover a { color: ' . $title_color_hover . '; }';
		}
		if ( $img_overlay != $img_overlay_hover ) {
			$output .= '.preview-' . zeen_sanitizer_options( $key, $options ) . ':hover .mask-overlay { opacity: ' . floatval( $img_overlay_hover ) . ' ; }';
		}
		$output .= '}';
	}
	if ( get_theme_mod( 'top_bar_message' ) == 1 ) {
		$output .= '.top-bar-message { background: ' . sanitize_hex_color( get_theme_mod( 'top_bar_message_bg', '#F96854' ) ) . '; color: ' . sanitize_hex_color( get_theme_mod( 'top_bar_message_font_color', '#fff' ) ) . ';}';
	}

	return $output;
}

function zeen_font_family_output( $font = '' ) {
	if ( strpos( $font['font-family'], ',' ) !== false ) {
		$output = html_entity_decode( $font['font-family'], ENT_QUOTES );
	} else {
		$output = "'" . $font['font-family'] . "'";
	}
	if ( ! empty( $font['font-fallback'] ) ) {
		$output .= 1 == $font['font-fallback'] ? ',sans-serif' : ',serif';
	}
	return $output;
}

/**
 * Background
 *
 * @since 1.0.0
 */
function zeen_get_bg( $global = '' ) {
	$output = array();
	$output['color'] = get_theme_mod( 'global_background_color', '#fff' );
	$output['image'] = get_theme_mod( 'global_background_img' );
	if ( ! empty( $global ) ) {
		return $output;
	}

	if ( zeen_is_archive() ) {
		$term_id = zeen_get_term_id();
	} elseif ( is_single() ) {
		global $post;
		$hero = zeen_get_hero_design( $post->ID );
		if ( 31 == $hero['hero_design'] ) {
			$background = array(
				'color' => get_post_meta( $post->ID, 'zeen_background_color', true ),
			);
		} else {
			$cats = get_the_category( $post->ID );
			$term_id = empty( $cats[0]->term_id ) ? '' : $cats[0]->term_id;
		}
	} elseif ( is_page() ) {
		global $post;
		$builder = get_post_meta( $post->ID, 'tipi_builder_active', true );
		if ( ! empty( $builder ) ) {
			$background = get_post_meta( $post->ID, 'zeen_background', true );
		}
	}

	if ( ! empty( $term_id ) ) {
		$background = get_term_meta( $term_id, 'zeen_background', true );
	}

	if ( ! empty( $background ) ) {
		if ( ! empty( $background['color'] ) ) {
			$output['color'] = $background['color'];
			$output['image'] = '';
		}
		if ( ! empty( $background['src'] ) ) {
			$output['image'] = $background['src'];
		}
	}

	return $output;
}

function zeen_get_bg_ad() {
	$output = array();
	$bg_ad = get_theme_mod( 'bg_ad' );
	if ( ! empty( $bg_ad ) ) {
		if ( get_theme_mod( 'bg_ad_only_hp' ) != 1 || ( get_theme_mod( 'bg_ad_only_hp' ) == 1 && is_front_page() ) ) {
			$bg_ad_img = get_theme_mod( 'bg_ad_img' );
			$bg_ad_url = get_theme_mod( 'bg_ad_url' );
			$bg_ad_top_spacing = get_theme_mod( 'bg_ad_spacing' );
			if ( ! empty( $bg_ad_img ) ) {
				$output['image'] = $bg_ad_img;
				if ( ! empty( $bg_ad_url ) ) {
					$output['url'] = $bg_ad_url;
				}
				$output['top_spacing'] = $bg_ad_top_spacing;
			}
		}
	}
	return $output;
}
/**
 * Background repeat getter
 *
 * @since 1.0.0
 */
function zeen_get_bg_repeat() {

	$output = '';

	if ( get_theme_mod( 'global_background_img' ) != '' ) {
		$output = get_theme_mod( 'global_background_img_repeat', 1 );
	}

	if ( zeen_is_archive() ) {
		$term_id = zeen_get_term_id();
	} elseif ( is_single() ) {
		global $post;
		$cats = get_the_category( $post->ID );
		$term_id = empty( $cats[0]->term_id ) ? '' : $cats[0]->term_id;
	} elseif ( is_page() ) {
		global $post;
		$builder = get_post_meta( $post->ID, 'tipi_builder_active', true );
		if ( ! empty( $builder ) ) {
			$background = get_post_meta( $post->ID, 'zeen_background', true );
		}
	}
	if ( ! empty( $term_id ) ) {
		$background = get_term_meta( $term_id, 'zeen_background', true );
	}
	if ( ! empty( $background['src'] ) ) {
		$output = $background['repeat'];
	}

	return $output;
}

/**
 * Title
 *
 * @since 1.0.0
 */
function zeen_hero_title_tag( $pid = '', $args = array() ) {

	$args['heading'] = empty( $args['heading'] ) ? 2 : $args['heading'];
	$args['link'] = empty( $args['link'] ) ? 'on' : $args['link'];
	$args['subtitle'] = empty( $args['subtitle'] ) ? get_theme_mod( 'posts_subtitle', 1 ) : $args['subtitle'];

	echo '<div class="title-wrap';
	if ( zeen_get_subtitle_value( $pid ) != '' ) {
		echo ' title-with-sub';
	}
	echo '"><h' . (int) ( $args['heading'] ) . ' class="entry-title title flipboard-title">';
	if ( 'off' != $args['link'] ) {
		echo '<a href="' . esc_url( get_the_permalink() ) . '">';
	}
	do_action( 'zeen_hero_title_before', $pid );
	echo get_the_title( $pid );
	if ( 'off' != $args['link'] ) {
		echo '</a>';
	}
	echo '</h' . (int) ( $args['heading'] ) . '>';

	if ( ! empty( $args['subtitle'] ) ) {
		zeen_subtitle( $pid );
	}
	if ( 18 == $args['hero_design'] ) {
		zeen_share( array(
			'pid' => $pid,
			'hook' => 'before',
			'type' => 'top',
			'location' => 18,
		));
	}
	do_action( 'zeen_end_hero', $pid );

	echo '</div>';

}

/**
 * Share buttons
 *
 * @since 1.0.0
 */
function zeen_share( $args = array() ) {
	if ( class_exists( 'Zeen_Engine' ) ) {
		Zeen_Engine::zeen_engine_share( $args );
	}
}

/**
 * Icons
 *
 * @since 1.0.0
 */
function zeen_icons( $args = array() ) {

	$args['location'] = empty( $args['location'] ) ? 'main_menu' : $args['location'];

	if ( ! empty( $args['test'] ) ) {

		$options = zeen_selective_icons( '_icon_' );

		foreach ( $options as $key ) {
			if ( get_theme_mod( $args['location'] . $key ) == 1 ) {
				return true;
			}
		}
		return false;
	}

	$rtl = is_rtl();
	$args['type'] = empty( $args['type'] ) ? 'all' : $args['type'];
	$args['vertical'] = empty( $args['vertical'] ) ? false : $args['vertical'];
	$style = get_theme_mod( $args['location'] . '_icon_style', 1 );

	if ( empty( $args['vertical'] ) && get_theme_mod( $args['location'] . '_icon_subscribe' ) == 1 && ( 'all' == $args['type'] || 'util' == $args['type'] || 'subscribe' == $args['type'] ) ) {
		$sub_text = get_theme_mod( 'subscribe_button_text', esc_attr__( 'Subscribe', 'zeen' ) );
	?>
		<li class="menu-icon menu-icon-subscribe"><a href="#" class="modal-tr" data-type="subscribe"><i class="tipi-i-mail"></i><?php if ( ! empty( $sub_text ) ) { ?><span class="font-<?php echo (int) get_theme_mod( 'typo_main_menu', 3 ); ?>"><?php echo esc_attr( $sub_text ); ?></span><?php } ?></a></li>
	<?php
	}

	if ( 'all' == $args['type'] || 'social' == $args['type'] ) {
		$networks = array(
			'facebook' => array(
				'icon' => 'facebook',
				'class' => 'fb',
				'name' => 'Facebook',
				'url' => 'http://www.facebook.com/',
			),
			'twitter' => array(
				'icon' => 'twitter',
				'class' => 'tw',
				'name' => 'Twitter',
				'url' => 'http://www.twitter.com/',
			),
			'instagram' => array(
				'icon' => 'instagram',
				'class' => 'insta',
				'name' => 'Instagram',
				'url' => 'http://www.instagram.com/',
			),
			'patreon' => array(
				'icon' => 'patreon',
				'class' => 'pa',
				'name' => 'Patreon',
				'url' => 'http://www.patreon.com/',
			),
			'pinterest' => array(
				'icon' => 'pinterest',
				'class' => 'pin',
				'name' => 'Pinterest',
				'url' => 'http://www.pinterest.com/',
			),
			'soundcloud' => array(
				'icon' => 'soundcloud',
				'class' => 'sc',
				'name' => 'Soundcloud',
				'url' => 'https://soundcloud.com/',
			),
			'youtube' => array(
				'icon' => 'youtube-play',
				'class' => 'yt',
				'name' => 'YouTube',
				'url' => 'http://www.youtube.com/',
			),
			'twitch' => array(
				'icon' => 'twitch',
				'class' => 'twitch',
				'name' => 'Twitch',
				'url' => 'http://www.twitch.com/',
			),
			'linkedin' => array(
				'icon' => 'linkedin',
				'class' => 'linkedin',
				'name' => 'Linkedin',
				'url' => 'http://www.linkedin.com/',
			),
			'dribbble' => array(
				'icon' => 'dribbble',
				'class' => 'dribbble',
				'name' => 'Dribbble',
				'url' => 'http://www.dribbble.com/',
			),
			'medium' => array(
				'icon' => 'medium',
				'class' => 'medium',
				'name' => 'Medium',
				'url' => 'http://www.medium.com/',
			),
			'tumblr' => array(
				'icon' => 'tumblr',
				'class' => 'tumblr',
				'name' => 'Tumblr',
				'url' => 'http://www.tumblr.com/',
			),
			'vimeo' => array(
				'icon' => 'vimeo',
				'class' => 'vimeo',
				'name' => 'Vimeo',
				'url' => 'http://www.vimeo.com/',
			),
			'vk' => array(
				'icon' => 'vk',
				'class' => 'vk',
				'name' => 'VK',
				'url' => 'http://www.vk.com/',
			),
			'telegram' => array(
				'icon' => 'telegram',
				'class' => 'telegram',
				'name' => 'Telegram',
				'url' => 'https://t.me/',
			),
			'steam' => array(
				'icon' => 'steam',
				'class' => 'steam',
				'name' => 'Steam',
				'url' => 'https://steamcommunity.com/id/',
			),
			'spotify' => array(
				'icon' => 'spotify',
				'class' => 'spotify',
				'name' => 'Spotify',
				'url' => '',
			),
			'apple_music' => array(
				'icon' => 'apple_music',
				'class' => 'apple_music',
				'name' => 'Apple Music',
				'url' => '',
			),
			'discord' => array(
				'icon' => 'discord',
				'class' => 'discord',
				'name' => 'Discord',
				'url' => '',
			),
			'qq' => array(
				'icon' => 'qq',
				'class' => 'qq',
				'name' => 'QQ',
				'url' => '',
			),
			'weibo' => array(
				'icon' => 'weibo',
				'class' => 'weibo',
				'name' => 'Weibo',
				'url' => '',
			),
			'rss' => array(
				'icon' => 'rss',
				'class' => 'rss',
				'name' => 'RSS',
				'url' => get_bloginfo( 'rss2_url' ),
			),
		);

		foreach ( $networks as $key => $value ) {
			$override = 'rss' == $key ? true : get_theme_mod( 'icons_' . $key );
			if ( 1 == get_theme_mod( $args['location'] . '_icon_' . $key ) && ! empty( $override ) ) {
				echo '<li  class="menu-icon menu-icon-style-' . (int) ( $style ) . ' menu-icon-' . esc_attr( $value['class'] ) . '">';
				$complete_url = 'tumblr' == $key ? 'https://' . get_theme_mod( 'icons_' . $key ) . '.tumblr.com/' : $value['url'] . get_theme_mod( 'icons_' . $key );
				echo '<a href="' . esc_url( $complete_url ) . '" data-title="' . esc_attr( $value['name'] ) . '" class="';
				if ( 4 != $style ) {
					echo 'tipi-i-' . esc_attr( $value['icon'] );
				}
				if ( 1 == $style ) {
					echo ' tipi-tip ';
					if ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) == 82 ) {
						echo ( true == $rtl ) ? 'tipi-tip-r' : 'tipi-tip-l';
					} elseif ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) > 70 ) {
						echo ( true == $rtl ) ? 'tipi-tip-l' : 'tipi-tip-r';
					} else {
						echo 'tipi-tip-move';
					}
				}
				echo '" rel="noopener nofollow" aria-label="' . esc_attr( $value['name'] ) . '" target="_blank">';
				if ( $style > 2 ) {
					echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . esc_attr( $value['name'] ) . '</span>';
				};
				echo '</a></li>';
			}
		}

		if ( 1 == get_theme_mod( $args['location'] . '_icon_whatsapp' ) ) {
			echo '<li data-title="WhatsApp" class="';
			if ( 1 == $style ) {
				echo 'tipi-tip tipi-tip-move ';
			}
			echo 'tipi-xl-0 menu-icon menu-icon-style-' . (int) ( $style ) . ' menu-icon-whatsapp"><a href="whatsapp://send?text=';
			the_title_attribute();
			echo ' - ' . rawurlencode( the_permalink() ) . '" target="_blank">';
			if ( 4 != $style ) {
				echo '<i class="tipi-i-whatsapp" aria-hidden="true"></i>';
			}
			if ( $style > 2 ) {
				echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' .  'WhatsApp' . '</span>';
			}
			echo '</a></li>';
		}

		if ( ( ! empty( $args['p-menu'] ) && 'login' == $args['type'] ) || get_theme_mod( $args['location'] . '_icon_login' ) != '' && ( 'all' == $args['type'] || 'util' == $args['type'] || 'login' == $args['type'] ) ) { ?>
			<?php $user_logged_in = is_user_logged_in(); ?>
			<?php $user = wp_get_current_user(); ?>
			<li class="menu-icon menu-icon-style-<?php echo (int) ( $style ); ?> menu-icon-login<?php if ( $style == 1 ) {?> tipi-tip tipi-tip-move<?php } ?>" data-title="<?php if ( $user_logged_in ) { the_author_meta( 'display_name', $user->ID ); } else {
				if ( ! function_exists( 'login_with_ajax' ) ) {
					esc_html_e( 'Login With Ajax plugin not installed. Install it or remove this icon in the Theme Options.', 'zeen' );
				} else {
					esc_html_e( 'Login / Signup', 'zeen' );
				}
				} ?>">
				<?php if ( $user_logged_in ) { ?>
				<a href="#" class="modal-tr icon-logged-in" data-type="lwa"><?php if ( $style != 4 ) { echo get_avatar( $user->ID, 50 ); } ?><?php if ( $style > 2 ) { echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">'; the_author_meta( 'display_name', $user->ID ); echo '</span>'; } ?></a>
				<?php } else { ?>
					<a href="#" class="<?php if ( $style != 4 ) { ?>tipi-i-user <?php } ?>modal-tr icon-logged-out" data-type="lwa"><?php if ( $style > 2 ) {
						echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . esc_attr__( 'Login / Signup', 'zeen' ) . '</span>';
					} ?></a>
				<?php } ?>
			</li>
		<?php
		}
	}
	if ( ( ! empty( $args['p-menu'] ) && 'search' == $args['type'] ) || ! empty( $args['search_on'] ) || 1 == get_theme_mod( $args['location'] . '_icon_search' ) && ( 'all' == $args['type'] || 'util' == $args['type'] || 'search' == $args['type'] ) ) {

		if ( 1 == get_theme_mod( $args['location'] . '_icon_search_type', 1 ) || ( 1 != get_theme_mod( $args['location'] . '_icon_search_type', 1 ) && 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) > 70 ) ) {
			echo '<li class="menu-icon menu-icon-style-' . (int) ( $style ) . ' menu-icon-search">';

			echo '<a href="#" class="';
			if ( 4 != $style ) {
				echo 'tipi-i-search ';
			}
			echo 'modal-tr';
			if ( 1 == $style ) {
				echo ' tipi-tip ';
				if ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) == 82 ) {

						echo ( true == $rtl ) ? 'tipi-tip-r' : 'tipi-tip-l';
				} elseif ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) > 70 ) {
					echo ( true == $rtl ) ? 'tipi-tip-l' : 'tipi-tip-r';
				} else {
					echo 'tipi-tip-move';
				}
			}
			echo '"';
			echo ' data-title="' . esc_attr__( 'Search', 'zeen' ) . '" data-type="search">';
			if ( $style > 2 ) {
				echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . esc_attr__( 'Search', 'zeen' ) . '</span>';
			}
			echo '</a></li>';
		} else {
			echo '<li class="menu-icon drop-search-wrap menu-icon-search">';
			echo '<a href="#" class="';
			if ( 4 != $style ) {
				echo 'tipi-i-search ';
			}
			echo 'modal-tr" data-type="search-drop">';
			if ( $style > 2 ) {
				echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . esc_attr__( 'Search', 'zeen' ) . '</span>';
			}
			echo '</a>
				<div class="drop-search search-form-wrap widget_search clearfix">';
			zeen_search_dropdown();
			echo '</div></li>';
		}
	}

	if ( 1 == get_theme_mod( $args['location'] . '_icon_cart' ) && ( 'all' == $args['type'] || 'cart' == $args['type'] ) ) {
		$woo_active = zeen_woo_active();
		echo '<li class="menu-icon dropper drop-it menu-icon-style-' . (int) ( $style ) . ' menu-icon-basket';
		if ( $woo_active ) {
			echo ' tipi-tip-basket';
		}
		echo '">';

		$cart_icon = get_theme_mod( 'woo_cart', 1 );
		if ( $woo_active ) {
			echo '<a href="' . esc_url( wc_get_cart_url() ) . '" class="cart-icon-' . (int) ( $cart_icon );
			if ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) > 70 ) {
				echo ' tipi-tip ';
				if ( get_theme_mod( 'header_style' ) == 82 ) {
					echo ( true == $rtl ) ? 'tipi-tip-r' : 'tipi-tip-l';
				} else {
					echo ( true == $rtl ) ? 'tipi-tip-l' : 'tipi-tip-r';
				}
			}
			echo '" data-title="' . esc_attr__( 'Bag', 'zeen' ) . '">';
			if ( 4 != $style ) {
				echo '<i class="';
				if ( 1 == $cart_icon ) {
					echo 'tipi-i-cart-1';
				} else {
					echo 'tipi-i-cart-2';
				}
				echo '" aria-hidden="true">';
				echo '<span class="tipi-cart-count font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . (int) WC()->cart->get_cart_contents_count() . '</span></i>';
			}
			if ( $style > 2 ) {
				echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . esc_attr__( 'Bag', 'zeen' ) . '</span>';
			}
			echo '</a>';
			if ( ! ( ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) > 70 ) || 'mobile' == $args['location'] ) ) {
				zeen_woo_contents();
			}
		} else {
			echo '<a href="#" class="';
			echo ' tipi-tip ';
			if ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) == 82 ) {
						echo ( true == $rtl ) ? 'tipi-tip-r' : 'tipi-tip-l';
			} elseif ( 'secondary_menu' == $args['location'] && get_theme_mod( 'header_style', 1 ) > 70 ) {
				echo ( true == $rtl ) ? 'tipi-tip-l' : 'tipi-tip-r';
			} else {
				echo 'tipi-tip-move';
			}
			echo '" data-title="' . esc_attr__( 'Install WooCommerce To Use', 'zeen' ) . '">';
			if ( 4 != $style ) {
				echo '<i class="';
				if ( 1 == $cart_icon ) {
					echo 'tipi-i-cart-1';
				} else {
					echo 'tipi-i-cart-2';
				}
				echo '" aria-hidden="true">';
				echo '<span class="tipi-cart-count font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">0</span></i>';
			}
			if ( $style > 2 ) {
				echo '<span class="font-' . (int) get_theme_mod( 'typo_main_menu', 3 ) . '">' . esc_attr_e( 'Bag', 'zeen' ) . '</span>';
			}
			echo '</a>';
		}
		echo '</li>';
	}
	?>
	<?php $sub_text = get_theme_mod( 'subscribe_button_text', esc_attr__( 'Subscribe', 'zeen' ) ); ?>
	<?php if ( ! empty( $args['vertical'] ) && get_theme_mod( $args['location'] . '_icon_subscribe' ) == 1 && ( $args['type'] == 'all' || $args['type'] == 'util' || $args['type'] == 'subscribe' ) ) { ?>
		<li class="menu-icon menu-icon-subscribe"><a href="#" class="modal-tr" data-type="subscribe"><i class="tipi-i-mail"></i><?php if ( ! empty( $sub_text ) ) { ?> <span class="font-<?php echo (int) get_theme_mod( 'typo_main_menu', 3 ); ?>"><?php echo esc_attr( $sub_text ); ?></span><?php } ?></a></li>
	<?php } ?>
	<?php if ( ( ! empty( $args['p-menu'] ) && $args['type'] == 'slide' ) || get_theme_mod( $args['location'] . '_icon_slide' ) != '' && ( $args['type'] == 'all' || $args['type'] == 'util' || $args['type'] == 'slide' ) ) { ?>
		<li class="menu-icon menu-icon-slide"><a href="#" class="tipi-i-menu slide-menu-tr-open" data-target="slide"></a></li>
	<?php } ?>

	<?php if ( $args['type'] == 'mobile_slide' ) { ?>
		<li class="menu-icon menu-icon-mobile-slide"><a href="#" class="mob-tr-open" data-target="slide-menu"><i class="tipi-i-menu-mob" aria-hidden="true"></i></a></li>
	<?php } ?>

	<?php
}

/**
 * Tipi archive titles
 *
 * @since 1.0.0
 */
function zeen_archive_titles( $title ) {

	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( TipiBuilder\ZeenHelpers::zeen_builder_call() ) {
		$term_id = $_GET['id'];
		$term = get_term( $term_id );
		$title = $term->name;
	}

	return $title;

}
add_filter( 'get_the_archive_title', 'zeen_archive_titles' );

/**
 * Tipi archive titles
 *
 * @since 1.0.0
 */
function zeen_archive_description( $description ) {

	if ( TipiBuilder\ZeenHelpers::zeen_builder_call() ) {
		$term_id = $_GET['id'];
		$term = get_term( $term_id );
		$description = $term->description;
	}

	return $description;

}
add_filter( 'get_the_archive_description', 'zeen_archive_description' );

/**
 * Featured Image Style
 *
 * @since 1.0.0
 */
function zeen_hero_design( $args = array(), $echo = true, $in_content = '' ) {
	if ( 8 == $args['hero_design'] ) {
		return;
	}
	global $post;
	$img_or_css = 'img';
	$link = false;
	$classes = array( 'hero-' . $args['hero_design'] );
	$hero_classes = 'hero';
	$args['is_page'] = empty( $args['is_page'] ) ? '' : $args['is_page'];
	$pf = empty( $args['post_format'] ) ? '' : $args['post_format'];
	if ( 'gallery' == $pf ) {
		$gallery = get_post_meta( $post->ID, 'zeen_gallery', true );
	}
	if ( ! empty( $gallery ) ) {
		$hero_classes = 'hero-gallery';
	}
	$title_loc = empty( $args['title_location'] ) ? '' : $args['title_location'];
	$hero_size = 'l';
	$cover_height = empty( $args['cover_height'] ) ? '' : $args['cover_height'];
	$splitter_bottom = ! isset( $args['splitter_bottom'] ) ? 99 : $args['splitter_bottom'];
	$parallax = zeen_get_parallax_onoff( $post->ID, array(
		'hero_design' => $args['hero_design'],
		'post_format' => $pf,
		'media_design' => $args['media_design'],
		'is_page' => $args['is_page'],
	) );

	if ( 51 == $args['hero_design'] ) {
		zeen_hero_with_content( $args );
		return;
	} elseif ( $args['hero_design'] < 9 ) {
		$width = 770;
		$height = 'full';
		$hero_size = 's';
	} elseif ( $args['hero_design'] < 19 ) {
		$width = 1170;
		$height = 585;
			$height = 770;
		if ( ! empty( $parallax ) ) {
			$width = 1155;
		}
		if ( 18 == $args['hero_design'] ) {
			$width = 585;
			$height = 775;
		}
		$hero_size = 'm';
		$classes[] = 'tipi-row';
		$classes[] = 'content-bg';
	} elseif ( $args['hero_design'] < 29 ) {
		$width = 'full';
		$height = 'full';
		$classes[] = 'cover-' . $cover_height;
	} elseif ( $args['hero_design'] < 32 ) {
		$width = 'full';
		$height = 'full';
		$classes[] = 'cover-1';
		$img_or_css = 'css';
	} elseif ( $args['hero_design'] < 49 ) {
		$width = 770;
		$height = 1020;
		$hero_classes .= ' tipi-xs-12 tipi-m-6';
		if ( 42 == $args['hero_design'] ) {
			$classes[] = 'contrast';
		}
	}

	$args['hero_color'] = ( 'fixed' != $title_loc && 'middle' != $title_loc && 'middle-bl' != $title_loc && 'middle-cut' != $title_loc ) ? '' : zeen_post_color( $post->ID, $args['is_page'] );

	if ( 9 == $args['hero_design'] ) {
		return;
	}

	if ( 10 == $args['hero_design'] || ( 4 == $args['hero_design'] && empty( $in_content ) ) ) {
		if ( 4 != $args['hero_design'] ) {
			zeen_breadcrumbs( '', 'm' );
		}
		zeen_hero_title( $post, $args );
		return;
	}
	if ( $splitter_bottom < 99 ) {
		$hero_classes .= ' hero-has-splitter';
	}
	if ( 3 == $splitter_bottom && 11 != $args['media_design'] ) {
		$hero_classes .= ' splitter--fade--bottom splitter--fade';
	}
	if ( 'gallery' != $pf ) {
		$classes[] = ! empty( $parallax ) ? 'parallax' : 'no-par';
	}

	if ( 'above' == $title_loc && $args['hero_design'] < 11 ) {
		zeen_breadcrumbs( '', 'm' );
	}
	if ( 'above' == $title_loc || ( 'above-c' == $title_loc && 4 != $args['hero_design'] ) ) {
		zeen_hero_title( $post, $args );
	}
	$thumb_meta = get_post( get_post_meta( $post->ID, '_thumbnail_id', true ) );
	$caption_ss = get_post_meta( $post->ID, 'cb_image_credit', true );
	if ( empty( $caption_ss ) && ! empty( $thumb_meta->post_excerpt ) ) {
		$caption = $thumb_meta->post_excerpt;
	} else {
		$caption = $caption_ss;
	}
	$size = '';
	if ( empty( $gallery ) ) {
		$size = 'full' == $width ? 'full' : 'zeen-' . $width . '-' . $height;
		$size = 'full' == $height && 770 == $width ? 'medium_large' : $size;
		$size = 100 == $height && 100 == $width ? 'thumbnail' : $size;
		$dimensions = wp_get_attachment_image_src( $thumb_meta->ID, $size );
		if ( $dimensions[1] < $dimensions[2] ) {
			$classes[] = 'is-portrait';
		}
	}
	echo '<div class="hero-wrap clearfix ' . esc_attr( implode( ' ', $classes ) ) . '">';
	echo '<div class="' . esc_attr( $hero_classes ) . '">';

	if ( ( $args['media_design'] < 10 || 12 == $args['media_design'] ) && empty( $gallery ) ) {
		zeen_featured_img( $post->ID, array(
			'width' => $width,
			'height' => $height,
			'size' => $size,
			'link' => $link,
			'hero' => true,
			'caption' => true,
			'img_or_css' => $img_or_css,
			'secondary' => 'off',
			'lazy_off' => true,
		) );
	}

	if ( ! empty( $gallery ) ) {
		zeen_post_format_data( $post->ID, array(
			'post_format' => $pf,
			'media_design' => $args['media_design'],
			'splitter_bottom' => $splitter_bottom,
			'hero_size' => $hero_size,
			'cover_height' => $cover_height,
			'hero' => true,
		) );
	}

	if ( $args['media_design'] > 10 && 'gallery' != $pf ) {
		zeen_post_format_data( $post->ID, array(
			'post_format' => $pf,
			'media_design' => $args['media_design'],
			'hero' => true,
		) );
	}

	if ( 'fixed' != $title_loc && 'middle' != $title_loc && 'middle-bl' != $title_loc && 'middle-cut' != $title_loc && $args['media_design'] < 10 && 'gallery' != $pf ) {
		$pf_classes = 'icon-l';
		if ( get_theme_mod( 'icon_design', 1 ) == 1 ) {
			$pf_classes .= ' center-abs';
		} else {
			if ( 'cut-bc' == $title_loc || 'cut-bl' == $title_loc ) {
				$pf_classes .= ' center-abs';
			}
		}
		zeen_post_format_data( $post->ID, array(
			'post_format' => $pf,
			'media_design' => $args['media_design'],
			'classes' => $pf_classes,
			'hero' => true,
		) );
	}

	if ( ! empty( $caption ) && empty( $gallery ) && 18 == $args['hero_design'] ) {
		echo '<div class="caption">' . zeen_sanitize_titles( $caption ) . '</div>';// WPCS: XSS OK
	}
	echo '</div>';
	if ( ( 'fixed' == $title_loc || 'middle' == $title_loc || 'middle-bl' == $title_loc || 'middle-cut' == $title_loc ) && empty( $gallery ) && 3 != $splitter_bottom ) {

		echo '<span class="mask-overlay"';
		if ( ! empty( $args['hero_color']['overlay'] ) ) {
			echo ' style="background-color:' . esc_attr( $args['hero_color']['overlay'] ) . '"';
		}
		echo '></span>';
	}

	if ( ! empty( $caption ) && empty( $gallery ) && 18 != $args['hero_design'] ) {
		echo '<div class="caption">' . zeen_sanitize_titles( $caption ) . '</div>';// WPCS: XSS OK
	}

	if ( 31 == $args['hero_design'] ) {
		echo '<div class="spacer"></div>';
	}

	if ( 'beneath' != $title_loc && 'beneath-c' != $title_loc && 'above' != $title_loc && 'above-c' != $title_loc ) {
		zeen_hero_title( $post, $args );
	}
	if ( $splitter_bottom < 99 ) {
		zeen_shape( array( 'shape' => $splitter_bottom ) );
	}

	echo '</div>';

	if ( 'beneath-c' == $title_loc ) {
		zeen_hero_title( $post, $args );
	}
}

/**
 * Hero title
 *
 * @since 1.0.0
 */
function zeen_hero_title( $post = '', $args = array() ) {
	$pid = $post->ID;
	$classes = '';
	$meta_classes = '';
	$title_loc = empty( $args['title_location'] ) ? '' : $args['title_location'];
	$pf = empty( $args['post_format'] ) ? '' : $args['post_format'];
	$md = empty( $args['media_design'] ) ? '' : $args['media_design'];
	$hero_color = empty( $args['hero_color'] ) ? '' : $args['hero_color'];
	$hero_design = empty( $args['hero_design'] ) ? '' : $args['hero_design'];
	$size = empty( $args['size'] ) ? '' : $args['size'];
	$is_page = empty( $args['is_page'] ) ? '' : true;
	$typo = 'm';

	if ( 8 == $hero_design ) {
		return;
	}
	if ( 'hero-l' == $size ) {
		$typo = 'xl';
		if ( 'cut-bc' == $title_loc ) {
			$meta_classes .= ' tipi-xs-12 tipi-m-8';
			$classes .= ' tipi-row';
		} elseif ( 'cut-bl' == $title_loc ) {
			$meta_classes .= ' tipi-xs-12 tipi-m-8 tipi-l-6';
			$classes .= ' tipi-row';
		} elseif ( 'middle-bl' == $title_loc ) {
			$meta_classes .= ' tipi-xs-12 tipi-m-10';
			$classes .= ' tipi-row';
		}
	} else {
		if ( 'cut-bc' == $title_loc ) {
			$meta_classes .= ' tipi-xs-12 tipi-m-8';
			$classes .= ' tipi-row';
		} elseif ( 'cut-bl' == $title_loc ) {
			$classes .= ' tipi-xs-12 tipi-m-8 tipi-l-6 tipi-col';
		} 
		if ( 'hero-m' == $size && 'middle-bl' == $title_loc ) {
			$meta_classes .= ' tipi-xs-12 tipi-m-10';
		}
	}

	if ( 2 != $args['hero_design'] && ( 'above' == $title_loc || 'above-c' == $title_loc || 'beneath-c' == $title_loc ) ) {
		$classes .= ' tipi-row content-bg';
	}

	if ( 'contrast' == $title_loc ) {
		$classes .= ' tipi-xs-12 tipi-m-6 content-bg';
	}
	echo '<div class="meta-wrap hero-meta tipi-' . esc_attr( $typo ) . '-typo elements-design-' . (int) ( get_theme_mod( 'posts_meta_design', 1 ) ) . ' clearfix' . esc_attr( $classes ) . '">';
	echo '<div';
	if ( ! empty( $hero_color ) ) {
		$meta_classes .= ' meta-with-color';
		echo ' style="color:' . esc_attr( $hero_color['text'] ) . '" ';
	}
	echo ' class="meta ' . esc_attr( $meta_classes ) . '">';

	if ( 'cut-bl' == $title_loc || 'cut-bc' == $title_loc ) {
		zeen_breadcrumbs( '', 'm' );
	}

	$args = array(
		'type' => 'posts',
		'location' => 2,
		'base_design' => get_theme_mod( 'posts_base_design', 1 ),
		'elements_location' => get_theme_mod( 'posts_meta_location', 1 ),
		'cat_design' => get_theme_mod( 'posts_cat_design', 1 ),
		'elements_design' => get_theme_mod( 'posts_meta_design', 1 ),
	);

	$args = zeen_byline_args_check( $args );

	if ( empty( $is_page ) ) {
		zeen_byline( $pid, $args );
	}
	zeen_hero_title_tag( $pid, array(
		'heading' => 1,
		'hero_design' => $hero_design,
		'link' => 'off',
	) );
	$args['location'] = 3;
	if ( empty( $is_page ) ) {
		zeen_byline( $pid, $args );
	}

	echo '</div>';
	if ( ( 'fixed' == $title_loc || 'middle' == $title_loc || 'middle-bl' == $title_loc || 'middle-cut' == $title_loc ) && $md < 10 && 'gallery' != $pf ) {
		zeen_post_format_data( $pid, array(
			'post_format' => $pf,
			'media_design' => $md,
			'hero' => true,
		) );
	}
	do_action( 'zeen_meta_wrap_end', array(
		'pid' => $pid,
		'action_type' => 'single',
		'hook' => 'below_title',
		'title_loc' => $title_loc,
	) );
	echo '</div><!-- .meta-wrap -->';
}

function zeen_byline_args_check( $args ) {
	$keys = array( 'cats', 'comments', 'author_avatar', 'author', 'date', 'read_time', 'view_count', 'like_count' );
	$off = true;
	if ( empty( $args['override'] ) ) {
		foreach ( $keys as $key ) {
			$args[ $key ] = 'off';
			$default = 'cats' == $key ? 1 : '';
			if ( get_theme_mod( $args['type'] . '_' . $key, $default ) != 1 ) {
				$args[ $key ] = 'off';
			} else {
				$args[ $key ] = 'on';
				$off = '';
			}
		}

		if ( 1 == $args['location'] ) {
			$args['separator'] = 'off';
		}
	} else {

		foreach ( $keys as $key ) {
			$args[ $key ] = 'off';
		}
		$args['separator'] = 'off';
		$args[ $args['override'] ] = 'on';
	}

	if ( empty( $off ) ) {
		return $args;
	}
}

/**
 * Get hero title location
 *
 * @since 1.0.0
 */
function zeen_get_hero_title_location( $style = 1 ) {

	if ( 1 == $style || 11 == $style || 9 == $style || 31 == $style ) {
		return 'beneath';
	} elseif ( 2 == $style || 12 == $style ) {
		return 'above';
	} elseif ( 3 == $style || 16 == $style || 21 == $style ) {
		return 'middle';
	} elseif ( 5 == $style || 17 == $style || 27 == $style ) {
		return 'middle-bl';
	} elseif ( 13 == $style || 26 == $style || 4 == $style ) {
		return 'above-c';
	} elseif ( 14 == $style || 22 == $style ) {
		return 'cut-bl';
	} elseif ( 15 == $style || 23 == $style ) {
		return 'cut-bc';
	} elseif ( 24 == $style || 10 == $style ) {
		return 'beneath-c';
	} elseif ( 25 == $style ) {
		return 'middle-cut';
	} elseif ( 999 == $style ) {
		return 'fixed';
	} elseif ( 41 == $style || 42 == $style ) {
		return 'contrast';
	} elseif ( 45 == $style ) {
		return 'split';
	}

}

/**
 * Post End Ad
 *
 * @since 1.0.0
 */
function zeen_post_end_ad() {
	zeen_ad( 'post_end' );
}

/**
 * Post Above Featured Image Ad
 *
 * @since 1.0.0
 */
function zeen_post_above_featured_image_ad() {
	zeen_ad( 'post_above_fi' );
}

/**
 * Post End Ad
 *
 * @since 1.0.0
 */
function zeen_post_end_subscribe() {
	if ( get_theme_mod( 'single_subscribe_end' ) != 1 ) {
		return;
	}
	echo '<div class="post-end-subscribe content-subscribe-block content-subscribe-style site-skin-' . (int) zeen_skin_style( 'single_subscribe_end', 'skin', 3 ) . ' site-img-' . (int) zeen_skin_style( 'single_subscribe_end', 'repeat' ) . ' subscribe-button-' . (int) get_theme_mod( 'subscribe_signup_style', 1 ) . '"><div class="bg-area">';
	zeen_subscribe( true );
	zeen_elem_bg_area( 'single_subscribe_end' );
	echo '</div></div>';
}



/**
 * Post Before Content Ad
 *
 * @since 1.0.0
 */
function zeen_post_start_content_ad() {
	zeen_ad( 'post_before_content' );
}

/**
 * Post Middle Content Ad
 *
 * @since 1.0.0
 */
function zeen_post_middle_ad( $content ) {
	if ( ! is_single() ) {
		return $content;
	}
	global $post;
	$list = get_post_meta( $post->ID, 'zeen_list', true );
	if ( 'on' == $list ) {
		return $content;
	}
	$da = zeen_ad( 'post_middle_content', false, '' );
	$inline_post_single = get_post_meta( $post->ID, 'zeen_inline_post', true );
	if ( empty( $inline_post_single ) || 99 == $inline_post_single ) {
		$inline_post = get_theme_mod( 'post_mid_inline' );
	} elseif ( 1 == $inline_post_single ) {
		$inline_post = 1;
	} elseif ( 2 == $inline_post_single ) {
		$inline_post = '';
	}
	if ( ! is_single() || ( empty( $da ) && empty( $inline_post ) ) ) {
		return $content;
	}
	$data = explode( '</p>', $content );
	$count = count( $data );
	if ( $count < 5 ) {
		return $content;
	}
	$mid = floor( $count / 2 );
	if ( ! empty( $da ) && ! ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) ) {
		if ( substr( trim( $data[ $mid ] ), 0, 3 ) != '<p>' ) {
			for ( $i = 1; $i < 12; $i++ ) {
				if ( ! empty( $data[ $mid + $i ] ) && substr( trim( $data[ $mid + $i ] ), 0, 3 ) == '<p>' ) {
					$mid = $mid + $i;
					break;
				}
			}
		}
		array_splice( $data, $mid, 0, '<p>' . $da );
	}
	$thirds = floor( $count / 1.5 );
	if ( ! empty( $inline_post ) && $count > 1 ) {
		if ( substr( trim( $data[ $thirds ] ), 0, 3 ) != '<p>' ) {
			for ( $i = 1; $i < 6; $i++ ) {
				if ( ! empty( $data[ $thirds + $i ] ) && substr( trim( $data[ $thirds + $i ] ), 0, 3 ) == '<p>' ) {
					$thirds = $thirds + $i;
					break;
				}
			}
		}
		array_splice( $data, $thirds, 0, '<p>' . zeen_post_inline() );
	}
	$content = implode( '</p>', $data );
	return $content;
}

add_filter( 'the_content', 'zeen_post_middle_ad' );

/**
 * List
 *
 * @since 1.0.0
 */
function zeen_post_list( $content ) {
	if ( ( ! is_single() && empty( $_GET['ipl'] ) ) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() )  ) {
		return $content;
	}
	global $post;
	$output = '';
	$list = get_post_meta( $post->ID, 'zeen_list', true );
	if ( 'on' == $list ) {
		$countdown = get_post_meta( $post->ID, 'zeen_countdown', true );
		$separator = get_post_meta( $post->ID, 'zeen_list_separator', true );
		$separator = empty( $separator ) ? 'h3' : $separator;
		$pages = explode( '<' . $separator, $content );
		$pages = array_filter( $pages );
		$separator_is_h = strpos( $separator, 'h') !== false;
		if ( $separator_is_h && isset( $pages[0] ) && substr( trim( $pages[0] ), -4 ) != '/' . $separator . '>' ) {
			$output .= $pages[0];
			unset( $pages[0] );
		}
		$output .= '<div class="zeen__list--1 zeen__list slider clearfix tipi-spin" data-s="21">';
		$output .= '<div class="arrows sticky-el clearfix">';
		$output .= '<div class="arrow button-arrow-l button-arrow slider-arrow-prev disabled"><i class="tipi-i-arrow-left"></i><div class="button-text button-title">' . esc_html__( 'Previous', 'zeen' ) . '</div></div>';
		$output .= '<div class="arrow button-arrow-r button-arrow slider-arrow-next"><div class="button-text button-title">' . esc_html__( 'Next', 'zeen' ) . '</div><i class="tipi-i-arrow-right"></i></div>';
		$output .= '</div>';
		foreach ( $pages as $key ) {
			$output .= '<div class="zeen__list__entry slide">';
			$output .= '<' . $separator;
			if ( 'on' == $countdown ) {
				$output .= ' class="tipi-vertical-c list__counter"';
			}
			$output .= $key;
			$output .= '</div>';
		}
		$output .= '</div>';
		$content = $output;
	}
	return $content;
}

add_filter( 'the_content', 'zeen_post_list' );

/**
 * Post Sponsor
 *
 * @since 1.0.0
 */
function zeen_post_sponsor( $content = '', $ipl = '' ) {
	if ( ! is_single() && empty( $ipl ) ) {
		return $content;
	}

	$output = '';
	global $post;
	$sponsor = get_post_meta( $post->ID, 'zeen_spon', true );
	if ( 'on' == $sponsor ) {
		$output = '<div class="spon-block tipi-vertical-c">';
		$output .= '<span class="title">' . apply_filters( 'zeen_sponsored_title', esc_html__( 'Sponsored', 'zeen' ) ) . '</span>';
		$sponsor_link = get_post_meta( $post->ID, 'zeen_spon_link', true );
		$output .= '<span class="tipi-vertical-c spon-wrap">';
		if ( ! empty( $sponsor_link ) ) {
			$output .= '<a href="' . esc_url( $sponsor_link ) . '" class="tipi-vertical-c">';
		}
		$sponsor_img = get_post_meta( $post->ID, 'zeen_spon_img', true );
		if ( ! empty( $sponsor_img ) ) {
		$sponsor_img_2x = get_post_meta( $post->ID, 'zeen_spon_img_retina', true );
			$output .= '<span class="spon-img"><img src="' . esc_url( $sponsor_img ) . '"';
			if ( ! empty( $sponsor_img_2x ) ) {
				$output .= ' srcset="' . esc_url( $sponsor_img_2x ) . ' 2x"';
			}
			$output .= '></span>';
		}

		$sponsor_name = get_post_meta( $post->ID, 'zeen_spon_name', true );
		if ( ! empty( $sponsor_name ) ) {
			$output .= '<span class="spon-name">' . esc_html( $sponsor_name ) . '</span>';
		}
		if ( ! empty( $sponsor_link ) ) {
			$output .= '</a>';
		}
		$output .= '</span>';
		$output .= '</div>';
	}

	return $output . $content;
}
add_filter( 'the_content', 'zeen_post_sponsor' );

/**
 * Post Footer Blocks
 *
 * @since 1.0.0
 */
function zeen_post_footer_blocks( $post = '', $ipl = '' ) {
	if ( ! empty( $ipl ) ) {
		zeen_mob_height_limit();
	}
	if ( empty( $ipl ) && ( ! is_single() || 'attachment' == $post->post_type || 'page' == $post->post_type ) ) {
		return;
	}

	$pid = $post->ID;
	if ( function_exists( 'get_coauthors' ) ) {
		$authors = get_coauthors();
		$a_id = array();
		foreach ( $authors as $key ) {
			$a_id[] = $key->ID;
		}
	} else {
		$a_id = $post->post_author;
	}
	$args = array(
		'pid' => $pid,
		'aid' => $a_id,
		'action_type' => 'single',
		'hook' => 'after',
		'ipl' => $ipl,
	);
	if ( empty( $ipl ) ) {
		do_action( 'zeen_post_footer_blocks', $args );
	} else {
		do_action( 'zeen_post_footer_blocks_auto_next_post', $args );
	}

}

/**
 * Post Schema
 *
 * @since 1.0.0
 */
function zeen_schema( $post ) {
	if ( get_theme_mod( 'schema', 1 ) != 1 ) {
		return;
	}
	$facebook = get_theme_mod( 'icons_facebook' );
	$twitter = get_theme_mod( 'icons_twitter' );
	$network_site = network_site_url( '/' );
	$crumbs = zeen_breadcrumbs( true );
	echo '<script type="application/ld+json">{';
	echo '"@context": "http://schema.org",
	"@type": "WebPage",
	"name": "' . esc_attr( get_bloginfo( 'name' ) ) . '",
	"description": "' . esc_attr( get_bloginfo( 'description' ) ) . '",';
	if ( is_single() ) {
		global $post;
		if ( get_theme_mod( 'voice_search' ) == 1 && get_post_meta( $post->ID, 'zeen_voice_search', true ) == 1 ) {
			echo '"speakable": {
				"@type": "SpeakableSpecification",
				"xpath": [
				    "/html/head/title",
				    "/html/head/meta[@name=\'description\']/@content"
			    ]
			},';
		}
	}
	echo '"url": "' . esc_url( $network_site ) . '",';
	if ( is_single() ) {
		$date = get_the_date( 'c', $post->ID );
		$mod_date = get_the_modified_time( 'c', $post->ID );
		echo '"datePublished": "' . esc_attr( $date ) . '",';
		echo '"dateCreated": "' . esc_attr( $date ) . '",';
		echo '"dateModified": "' . esc_attr( $mod_date ) . '",';
	}
	if ( ( ! empty( $facebook ) && 'codetipi' != $facebook ) || ( ! empty( $twitter ) && 'codetipi' != $twitter ) ) {
		echo '"sameAs": [';
		$first = true;
		if ( ! empty( $facebook ) ) {
			$first = '';
			echo '"https://facebook.com/' . esc_attr( $facebook ) . '"';
		}
		if ( ! empty( $twitter ) ) {
			if ( empty( $first ) ) {
				echo ',';
			}
			echo '"https://twitter.com/' . esc_attr( $twitter ) . '"';
		}
		echo '],';
	}
	echo '"potentialAction": {
	"@type": "SearchAction",
	"target": "' . esc_url( $network_site ) . '?s=&#123;search_term&#125;",
	"query-input": "required name=search_term"}';

	if ( ! empty( $crumbs ) ) {
		echo ',"breadcrumb":{ "@type": "BreadcrumbList","itemListElement": [';
		$i = 1;
		$first = true;
		foreach ( $crumbs as $key => $value ) {
			if ( empty( $first ) ) {
				echo ',';
			}
			$first = '';
			echo '{"@type": "ListItem",	"position": ' . (int) $i . ', "item": {
				"@id": "' . esc_url( $value ) . '",
				"name": "' . esc_attr( $key ) . '"
				}
				}';
			$i++;
		}
		echo ']}';
	}
	echo '}</script>';
}

/**
 * Post Before Blocks
 *
 * @since 1.0.0
 */
function zeen_post_before_blocks( $post = '' ) {

	if ( ! is_single() || $post->post_type != 'post' ) {
		return;
	}

	$pid = $post->ID;
	$a_id = $post->post_author;
	$args = array( 'pid' => $pid, 'aid' => $a_id, 'action_type' => 'single', 'hook' => 'before' );
	do_action( 'zeen_post_before_blocks', $args );

}

/**
 * Post Before Blocks
 *
 * @since 1.0.0
 */
function zeen_post_before_content( $post = '' ) {

	if ( ! is_single() || $post->post_type != 'post' ) {
		return;
	}

	$pid = $post->ID;
	$a_id = $post->post_author;
	$args = array( 'pid' => $pid, 'aid' => $a_id, 'action_type' => 'single', 'hook' => 'before_content' );
	do_action( 'zeen_post_before_content', $args );

}




/**
 * Page Footer Blocks
 *
 * @since 1.0.0
 */
function zeen_page_footer_blocks( $post = '' ) {

	$pid = $post->ID;
	zeen_link_pages();
	if ( get_theme_mod( 'pages_share' ) == 1 ) {
		zeen_share( array( 'pid' => $pid ) );
	}
	if ( get_theme_mod( 'pages_comment', 1 ) == 1 ) {
		zeen_comment_template();
	}

}

/**
 * Post Comments Block
 *
 * @since 1.0.0
 */
function zeen_comment_template( $args = '', $standalone = '' ) {
	if ( empty( $args['ipl'] ) ) {
		if ( ! empty( $standalone ) ) {
			echo '<div class="tipi-col tipi-xs-12 standalone-comments clearfix">';
		}
		if ( get_theme_mod( 'fb_comments' ) == 1 ) {
			global $post;
			zeen_fb_coms( $post->ID );
		} else {
			comments_template();
		}
		if ( ! empty( $standalone ) ) {
			echo '</div>';
		}
	} else {
		zeen_ipl_coms( array( 'pid' => $args['pid'] ) );
	}

}


/**
 * FB SDK
 *
 * @since 1.0.0
 */
function zeen_fb() {
	$fb_app_id = get_theme_mod( 'facebook_app_id' );
	if ( empty( $fb_app_id ) || ! is_single() || get_theme_mod( 'fb_comments' ) != 1 ) {
		return;
	}
	?>
	<div id="fb-root"></div>
	<script>(function(d, s, id) {
	  var js, fjs = d.getElementsByTagName(s)[0];
	  if (d.getElementById(id)) return;
	  js = d.createElement(s); js.id = id;
	  js.src = 'https://connect.facebook.net/<?php echo esc_attr( get_locale() ); ?>/sdk.js#xfbml=1&version=v3.2&appId=<?php echo esc_attr( $fb_app_id ); ?>';
	  fjs.parentNode.insertBefore(js, fjs);
	}(document, 'script', 'facebook-jssdk'));</script>
	<?php
}
add_action( 'wp_footer', 'zeen_fb' );

function zeen_comment_form_defaults( $defaults ) {
	$defaults['title_reply_before'] = '<h3 id="reply-title" class="footer-block-title comment-reply-title">';
	$defaults['title_reply_after'] = '</h3>';
	$defaults['label_submit'] = esc_attr__( 'Submit', 'zeen' );
	$defaults['format'] = 'html5';
	$defaults['submit_button'] = '<input name="%1$s" type="submit" id="%2$s" class="%3$s tipi-button" value="%4$s" />';

	return $defaults;
}
add_filter( 'comment_form_defaults', 'zeen_comment_form_defaults' );

/**
 * Post Previous Next Block
 *
 * @since 1.0.0
 */
function zeen_previous_next_block( $args = array() ) {
	if ( empty( $args['pid'] ) ) {
		global $post;
		$pid = $post->ID;
	} else {
		$pid = $args['pid'];
	}

	if ( 'single' == $args['action_type'] && ( get_theme_mod( 'single_next_previous', 1 ) != 1 || get_post_meta( $pid, 'zeen_next_previous', true ) == '2' ) ) {
		return;
	}

	global $post;

	$zeen_next = get_next_post( apply_filters( 'zeen_previous_next_post_same_category', '' ) );
	$zeen_prev = get_previous_post( apply_filters( 'zeen_previous_next_post_same_category', '' ) );
	$classes = 'next-prev-posts clearfix next-prev__design-1';
	if ( empty( $zeen_next ) || empty( $zeen_prev ) ) { 
		$classes .= ' just-one';
	}
	if ( ( ! empty( $zeen_prev ) || ! empty( $zeen_next ) ) && 'attachment' != $post->post_type ) {
	?>
	<div class="<?php echo esc_attr( $classes ); ?>">
		<?php if ( ! empty( $zeen_prev ) ) {
			$pid = $zeen_prev->ID;
			$tid = get_post_meta( $pid, '_thumbnail_id', true );
			echo '<div class="prev-block prev-next-block clearfix">';
			if ( ! empty( $tid ) ) {
			?>
				<div class="mask">
					<a href="<?php echo esc_url( get_permalink( $pid ) ); ?>">
						<i class="tipi-i-long-left"></i>
						<?php zeen_featured_img( $pid, array( 'secondary' => 'off', 'width' => 100, 'height' => 100 ) ); ?>
					</a>
				</div>
			<?php } ?>
				<div class="meta">
					<a href="<?php echo esc_url( get_permalink( $pid ) ); ?>" class="previous-title title">
						<span><?php esc_html_e( 'Previous', 'zeen' ); ?></span>
						<?php echo get_the_title( $pid ); ?>
					</a>
				</div>
			</div>
		<?php } ?>
		<?php if ( ! empty( $zeen_next ) ) {
			$pid = $zeen_next->ID;
			$tid = get_post_meta( $pid, '_thumbnail_id', true );
			echo '<div class="next-block prev-next-block clearfix">';
			if ( ! empty( $tid ) ) {
			?>
				<div class="mask">
					<i class="tipi-i-long-right"></i>
					<a href="<?php echo esc_url( get_permalink( $pid ) ); ?>">
						<?php zeen_featured_img( $pid, array( 'secondary' => 'off', 'width' => 100, 'height' => 100 ) ); ?>
					</a>
				</div>
			<?php } ?>
				<div class="meta">
					<a href="<?php echo esc_url( get_permalink( $pid ) ); ?>" class="next-title title">
						<span><?php esc_html_e( 'Next', 'zeen' ); ?></span>
						<?php echo get_the_title( $pid ); ?>
					</a>
				</div>
			</div>
		<?php } ?>
	</div>
<?php }
}
/**
 * Post Previous Next Block Slide
 *
 * @since 2.5.0
 */
function zeen_previous_next_block_slide( $args = array() ) {
	if ( ! is_single() ) {
		return;
	}
	global $post;
	if ( get_theme_mod( 'single_next_previous', 1 ) != 1 || get_post_meta( $post->ID, 'zeen_next_previous', true ) == '2' ) {
		return;
	}

	$posts = array();
	if ( 'attachment' == $post->post_type ) {
		return;
	}
	$posts['prev'] = get_next_post( apply_filters( 'zeen_previous_next_post_same_category', '' ) );
	$posts['next'] = get_previous_post( apply_filters( 'zeen_previous_next_post_same_category', '' ) );
	foreach ( $posts as $key => $value ) {
		if ( empty( $value ) ) {
			continue;
		}
		$tid = get_post_meta( $value->ID, '_thumbnail_id', true );
		echo '<div id="' . esc_attr( $key ) . '-block__wrap" class="next-prev__design-2 tipi-vertical-c next-prev__' . esc_attr( $key ) . '">';
		echo '<div class="next-prev__trigger tipi-all-c">';
		if ( 'next' == $key ) {
			echo '<i class="tipi-i-arrow-right"></i>';
		} else {
			echo '<i class="tipi-i-arrow-left"></i>';
		}
		echo '</div>';
		echo '<div class="next-prev__contents">';
		echo '<div class="mask">';
		zeen_featured_img( $value->ID, array( 'link' => true, 'secondary' => 'off', 'width' => 100, 'height' => 100 ) );
		echo '</div>';
		echo '<div class="meta">';
		echo '<div class="pre-title">';
		if ( 'next' == $key ) {
			esc_html_e( 'Next', 'zeen' );
		} else {
			esc_html_e( 'Previous', 'zeen' );
		}
		echo '</div>';
		echo '<a href="' . esc_url( get_permalink( $value->ID ) ) . '" class="title">';
		echo get_the_title( $value->ID );
		echo '</a>';
		echo '</div>';
		echo '</div>';
		echo '</div>';
	}
}

function zeen_block_js( $args ) {
	$mnp = isset( $args['mnp'] ) ? $args['mnp'] : '';
	$echo = ! isset( $args['echo'] ) ? '' : $args['echo'];
	if ( empty( $echo ) ) {
		ob_start();
	} else {
		echo '<script>';
	}
	?>
	var zeen_<?php echo (int) ( $args['uid'] ); ?> = {
		id: <?php echo (int) ( $args['uid'] ); ?>,
		next: 2,
		prev: 0,
		target: 0,
		mnp: <?php echo (int) $mnp; ?>,
		preview: <?php echo (int) $args['preview']; ?>,
		is110: <?php echo (int) $args['is110']; ?>,
		counter: <?php echo (int) $args['counter']; ?>,
		counter_class: <?php echo wp_json_encode( esc_attr( $args['counter_class'] ) ); ?>,
		post_subtitle: <?php echo wp_json_encode( esc_attr( $args['post_subtitle'] ) ); ?>,
		excerpt_off: <?php echo (int) $args['excerpt_off']; ?>,
		excerpt_length: <?php echo (int) $args['excerpt_length']; ?>,
		excerpt_full: <?php echo (int) $args['excerpt_full']; ?>,
		img_shape: <?php echo (int) $args['img_shape']; ?>,
		byline_off: <?php echo (int) $args['byline_off']; ?>,
		ppp: <?php echo (int) $args['ppp']; ?>,
		args: <?php echo wp_json_encode( $args['qry_args'] ); ?>
	};
	<?php
	if ( ! empty( $args['quick'] ) ) {
		$args['qry_args']['offset'] = empty( $args['qry_args']['offset'] ) ? $args['qry_args']['posts_per_page'] : (int) $args['qry_args']['offset'] + (int) $args['qry_args']['posts_per_page'];
		$options = array(
			'qry'           => $args['qry_args'],
			'uid'           => $args['uid'],
			'preview'       => $args['preview'],
			'mobile'        => 'off',
			'is110'         => (int) $args['is110'],
			'counter'       => (int) $args['counter'],
			'counter_class' => wp_json_encode( esc_attr( $args['counter_class'] ) ),
			'post_subtitle' => wp_json_encode( esc_attr( $args['post_subtitle'] ) ),
			'excerpt_off'   => (int) $args['excerpt_off'],
			'excerpt_length' => (int) $args['excerpt_length'],
			'excerpt_full'  => (int) $args['excerpt_full'],
			'img_shape'     => (int) $args['img_shape'],
			'byline_off'    => (int) $args['byline_off'],
			'ppp'           => (int) $args['ppp'],
			'only_inner'    => true,
			'ndp_skip'      => true,
			'mnp'           => true,
			'specific'      => 'js',
		);
		$block = zeen_block_pick( $options );
		$response = $block->output( false );
		$mnp = $block->mnp();

		if ( ! empty( $response ) ) {
			?>
			var zeen_<?php echo (int) ( $args['uid'] ); ?>_2 = {
			0: <?php echo (int) ( $mnp ); ?>,
			1: <?php echo wp_json_encode( trim( $response ) ); ?>
			}; <?php
		}
	}

	if ( empty( $echo ) ) {
		return ob_get_clean();
	} else {
		echo '</script>';
	}
}

/**
 * Post Related Posts
 *
 * @since 1.0.0
 */
function zeen_related_posts( $args = array() ) {
	if ( empty( $args['pid'] ) ) {
		global $post;
		$pid = $post->ID;
	} else {
		$pid = $args['pid'];
	}
	if ( 'single' == $args['action_type'] && ( get_theme_mod( 'single_related_posts', 1 ) != 1 || get_post_meta( $pid, 'zeen_related_posts', true ) == '2' ) && empty( $args['override'] ) ) {
		return;
	}
	$post_type = get_post_type( $pid );

	$p = empty( $args['p'] ) ? get_theme_mod( 'single_related_posts_design', 29 ) : $args['p'];
	$ppp = empty( $args['ppp'] ) ? get_theme_mod( 'single_related_posts_ppp', 4 ) : $args['ppp'];
	if ( 52 == $p ) {
		$ppp = max( $ppp, 3 );
	} elseif ( 53 == $p ) {
		$ppp = max( $ppp, 4 );
	}
	$order = empty( $args['order'] ) ? get_theme_mod( 'single_related_posts_order', 1 ) : $args['order'];
	$classes = empty( $args['classes'] ) ? '' : $args['classes'];
	$separator_off = empty( $args['separator_off'] ) ? '' : true;
	$title_block_off = empty( $args['title_block_off'] ) ? '' : true;
	$fs = empty( $args['fs'] ) ? '' : $args['fs'];
	$byline_off = empty( $args['byline_off'] ) ? '' : $args['byline_off'];
	$contained = isset( $args['contained'] ) ? $args['contained'] : true;
	$qry = array(
		'post__not_in'      => array( $pid ),
		'posts_per_page'   => $ppp,
		'post_type' => $post_type,
	);
	if ( 3 == $order ) {
		$qry['orderby'] = 'rand';
	} elseif ( 2 == $order ) {
		$qry['order'] = 'ASC';
	}

	if ( 'post' == $post_type ) {
		$source = get_theme_mod( 'single_related_posts_source', 1 );

		if ( $source > 1 ) {
			$tags = wp_get_post_tags( $pid );
			if ( ! empty( $tags ) ) {
				$tag_qry = '';
				foreach ( $tags as $tag ) {
					$tag_qry .= $tag->slug . ',';
				}
				$qry['tag'] = rtrim( $tag_qry, ',' );
			}
		}
		if ( 3 == $source ) {
			if ( empty( $qry['tag'] ) ) {
				$fb = true;
			} else {
				foreach ( $tags as $tag ) {
					$total = get_term_by( 'id', $tag->term_id, 'post_tag' );
					if ( $total->count > 1 ) {
						$fb = '';
						break;
					} else {
						$fb = true;
					}
				}
			}
		}
		if ( 1 == $source || ! empty( $fb ) ) {
			$qry['tag'] = '';
			$cats = get_the_category();
			if ( ! empty( $cats ) ) {
				$all_cats = '';
				foreach ( $cats as $cat ) {
					$all_cats .= $cat->term_id . ',';
				}
				$qry['cat'] = $all_cats;
			}
		}
	} else {
		$taxonomies = get_object_taxonomies( $post_type );
		if ( ! empty( $taxonomies[0] ) ) {
			$tids = get_the_terms( $pid, $taxonomies[0] );
		}
		if ( ! empty( $tids ) ) {
			$all_tids = '';
			foreach ( $tids as $cat ) {
				$all_tids .= $cat->slug . ',';
			}
			$qry['tax_query'] = array(
				array(
					'taxonomy' => $taxonomies[0],
					'field' => 'slug',
					'terms' => $all_tids,
				),
			);
		}
	}

	if ( empty( $qry['cat'] ) && empty( $qry['tag'] ) && empty( $qry['tax_query'] ) ) {
		return;
	}
	$title = esc_html__( 'Related', 'zeen' );

	if ( get_post_meta( $pid, '_lets_review_onoff', true ) == 1 ) {
		$type = get_post_meta( $pid, '_lets_review_type', true );
		if ( 1 == $type ) {
			$qry['meta_key'] = '_lets_review_final_score_100';
		} else {
			$qry['meta_key'] = '_lets_review_user_rating';
		}
	}
	$post_subtitle = '';
	if ( get_theme_mod( 'single_related_posts_only_title' ) == 1 ) {
		$byline_off = true;
		$post_subtitle = 'off';
	}

	$img_shape = '';
	if ( 83 == $p || 52 == $p || 53 == $p ) {
		$img_shape = 2;
	}

	$options = array(
		'qry'        => $qry,
		'preview'    => $p,
		'max_col_2' => true,
		'nosubcats'  => true,
		'img_shape' => $img_shape,
		'title_block_off' => $title_block_off,
		'fs' => $fs,
		'uid' => zeen_uid(),
		'contained' => $contained,
		'specific' => 'related',
		'excerpt_off' => true,
		'byline_off' => $byline_off,
		'separator_off' => $separator_off,
		'load_more'  => 2,
		'post_subtitle'  => $post_subtitle,
		'title'      => apply_filters( 'zeen_related_title', $title ),
		'subtitle'   => apply_filters( 'zeen_related_subtitle', '' ),
		'mobile'     => 'true',
	);

	echo '<div class="related-posts-wrap clearfix' . esc_attr( $classes ) . '">';
	$block = zeen_block_pick( $options );
	$block->output();
	if ( empty( $block->found_posts ) && ! empty( $options['qry']['meta_key'] ) ) {
		unset( $options['qry']['meta_key'] );
		$block = zeen_block_pick( $options );
		$block->output();
	}
	echo '</div>';
}

/**
 * Tipi Block - Loader
 *
 * @since 1.0.0
 */
function zeen_block_loader( $args = '' ) {
	$loader = empty( $args['loader'] ) ? 1 : $args['loader'];
	$mnp = empty( $args['mnp'] ) ? '' : $args['mnp'];
	$size = empty( $args['size'] ) ? 1 : $args['size'];
	$echo = ! isset( $args['echo'] ) ? true : $args['echo'];
	$inner_only = empty( $args['inner_only'] ) ? '' : $args['inner_only'];
	if ( empty( $echo ) ) {
		ob_start();
	}
	if ( empty( $inner_only ) ) {
		echo '<div class="load-more-wrap load-more-size-' . (int) ( $size ) . ' load-more-wrap-' . (int) ( $loader ) . '">';
	}
	if ( 2 == $loader ) {
		?>
		<span data-id="<?php echo (int) ( $args['id'] ); ?>" class="tipi-arrow tipi-arrow-s tipi-arrow-l block-loader block-more block-more-1 no-more" data-dir="1"><i class="tipi-i-angle-left" aria-hidden="true"></i></span>
		<span data-id="<?php echo (int) ( $args['id'] ); ?>" class="tipi-arrow tipi-arrow-s tipi-arrow-r block-loader block-more block-more-2<?php if ( $mnp < 2 ) { ?> no-more<?php } ?>" data-dir="2"><i class="tipi-i-angle-right" aria-hidden="true"></i></span>
		<?php
	} else {
		echo '<span data-id="' . (int) ( $args['id'] ) . '" class="block-loader block-more block-more-1 tipi-button';
		echo ' load-more__fill-' . get_theme_mod( 'load_more_fill', 1 );
		echo ' load-more__size-' . get_theme_mod( 'load_more_size', 1 );
		echo ' load-more__rounded-' . get_theme_mod( 'load_more_rounded', 1 );
		echo '">' . esc_html__( 'Load more', 'zeen' ) . '</span>';
	}
	if ( empty( $inner_only ) ) {
		echo '</div>';
	}
	if ( empty( $echo ) ) {
		return ob_get_clean();
	}
}

/**
 * Ad
 *
 * @since 1.0.0
 */
function zeen_ad( $location = 'header', $wrap = false, $echo = true ) {
	$class = '';
	if ( 'archive_below' == $location ) {
		$location = 'archive';
		$below = true;
		$wrap = true;
	}
	if ( 'archive' == $location ) {
		$class = ' archive-da';
		if ( is_category() ) {
			$location = 'category';
		} elseif ( is_tag() ) {
			$location = 'tags';
		} elseif ( is_author() ) {
			$location = 'author';
		}
		if ( ! empty( $below ) ) {
			$location = $location . '_below';
		}
	}
	if ( get_theme_mod( $location . '_pub' ) == '' ) {
		return;
	}
	if ( empty( $echo ) ) {
		ob_start();
	}
	$class .= ( 'header' == $location ) ? ' tipi-flex-right' : '';
	if ( ! empty( $wrap ) ) {
		echo '<div class="';
		if ( ! empty( $below ) ) {
			echo 'tipi-row content-bg clearfix below-da';
		} else {
			echo 'tipi-xs-12';
		}
		echo '">';
	}
	echo '<div class="block-da-1 block-da block-da-' . esc_attr( $location . $class ) . ' clearfix">' . do_shortcode( get_theme_mod( $location . '_pub' ) ) . '</div>';
	if ( ! empty( $wrap ) ) {
		echo '</div>';
	}
	if ( empty( $echo ) ) {
		return ob_get_clean();
	}
}

/**
 * Mobile Menu Close
 *
 * @since 1.0.0
 */
function zeen_mobile_menu_close() {
	echo '<a href="#" class="mob-tr-close tipi-x-wrap"><i class="tipi-x tipi-x-l"></i></a>';
}

/**
 * Get pagi URL
 *
 * @since 1.0.0
 */
function zeen_get_pagi_url( $pagenum = 1, $escape = true, $root = '' ) {

	global $wp_rewrite;
	$pagenum = (int) $pagenum;
	$request = $root ? remove_query_arg( 'paged', $root ) : remove_query_arg( 'paged' );
	$home_root = wp_parse_url( home_url() );
	$home_root = ( isset( $home_root['path'] ) ) ? $home_root['path'] : '';
	$home_root = preg_quote( $home_root, '|' );
	$request = preg_replace( '|^' . $home_root . '|i', '', $request );
	$request = preg_replace( '|^/+|', '', $request );
	if ( ! $wp_rewrite->using_permalinks() || is_admin() ) {
		$base = trailingslashit( home_url() );
		if ( $pagenum > 1 ) {
			$result = add_query_arg( 'paged', $pagenum, $base . $request );
		} else {
			$result = $base . $request;
		}
	} else {
		$qs_regex = '|\?.*?$|';
		preg_match( $qs_regex, $request, $qs_match );
		if ( ! empty( $qs_match[0] ) ) {
			$query_string = $qs_match[0];
			$request = preg_replace( $qs_regex, '', $request );
		} else {
			$query_string = '';
		}
		$request = preg_replace( "|$wp_rewrite->pagination_base/\d+/?$|", '', $request );
		$request = preg_replace( '|^' . preg_quote( $wp_rewrite->index, '|' ) . '|i', '', $request );
		$request = ltrim( $request, '/' );
		$base = trailingslashit( home_url() );
		$using_index = $wp_rewrite->using_index_permalinks();
		if ( $using_index && ( $pagenum > 1 || '' != $request ) ) {
			$base .= $wp_rewrite->index . '/';
		}
		if ( $pagenum > 1 ) {
			$request = ( ( ! empty( $request ) ) ? trailingslashit( $request ) : $request ) . user_trailingslashit( $wp_rewrite->pagination_base . '/' . $pagenum, 'paged' );
		}
		$result = $base . $request . $query_string;
	}

	$result = apply_filters( 'get_pagenum_link', $result );
	if ( $escape ) {
		return esc_url( $result );
	} else {
		return esc_url_raw( $result );
	}
}

/**
 * Single bones
 *
 * @since 1.0.0
 */
function zeen_single_bones( $args = array() ) {
	$style = empty( $args['style'] ) ? array() : $args['style'];
	$layout = empty( $args['layout'] ) ? 1 : $args['layout'];
	$ipl = empty( $args['ipl'] ) ? '' : true;
	$style['hero_design'] = empty( $style['hero_design'] ) ? 1 : $style['hero_design'];
	$style['media_design'] = empty( $style['media_design'] ) ? '' : $style['media_design'];
	global $post;

	if ( ! empty( $args['builder'] ) ) {
		$content = get_post_meta( $post->ID, 'tipi_builder_data', true );
		zeen_builder_data( $content );
		return;
	}

	if ( ! empty( $args['style']['post_format'] ) && 21 == $args['style']['media_design'] ) {
		if ( empty( $args['style']['ipl'] ) ) {
			zeen_comment_template( array(), true );
		}
		return;
	}
	$footer_classes = $layout > 57 ? ' tipi-row tipi-l-8' : '';
	?>
	<main class="site-main tipi-xs-12 main-block-wrap block-wrap tipi-l-8 tipi-col clearfix">
		<article>
			<?php
			if ( $style['hero_design'] < 9 ) {
				do_action( 'zeen_above_featured_image' );
				zeen_hero_design( $style, true, true );
			}

			if ( ( $style['hero_design'] > 10 || 4 == $style['hero_design'] ) && 31 != $style['hero_design'] && 'cut-bc' != $style['title_location'] && 'cut-bl' != $style['title_location'] && 'beneath' != $style['title_location'] ) {
				zeen_breadcrumbs();
			}

			if ( 'beneath' == $style['title_location'] ) {
				zeen_breadcrumbs( '', 'm' );
				zeen_hero_title( $post, $style );
			}
			?>
			<div class="entry-content-wrap clearfix">
				<?php if ( ! is_page() ) { ?>
					<?php zeen_post_before_blocks( $post ); ?>
				<?php } ?>
				<?php zeen_article_side( $post->ID, $layout ); ?>
				<div class="entry-content body-color clearfix link-color-wrap<?php if ( $layout > 57 ) { echo ' sticky-el'; } ?>">
					<?php if ( ! is_page() ) { ?>
						<?php zeen_post_before_content( $post ); ?>
					<?php } ?>
					<?php if ( ! empty( $ipl ) ) { ?>
						<?php echo zeen_post_sponsor( '', true ); ?>
					<?php } ?>
					<?php
					echo zeen_date_updated( $post->ID );
					if ( ! empty( $ipl ) ) {
						if ( class_exists( 'WPBMap' ) ) {
							$vc_style = get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true );
							if ( ! empty( $vc_style ) ) {
								echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
								echo strip_tags( get_post_meta( $post->ID, '_wpb_shortcodes_custom_css', true ) );
								echo '</style>';
							}
							WPBMap::addAllMappedShortcodes();
						}
						$content = str_replace( '<!--more-->', '', $post->post_content );
						echo apply_filters( 'the_content', $content );
					} else {
						the_content();
					}
					?>
					<?php if ( ! empty( $args['page_template'] ) ) { ?>
						<?php zeen_team( $args['page_template'] ); ?>
					<?php } ?>
				</div><!-- .entry-content -->
				<?php zeen_article_side_gallery( $post->ID, $layout ); ?>
			</div><!-- .entry-content -->

			<footer class="entry-footer<?php echo esc_attr( $footer_classes ); ?>">
				<?php
				if ( is_page() ) {
					zeen_page_footer_blocks( $post );
				} else {
					zeen_post_footer_blocks( $post, $ipl );
				}
				?>
			</footer><!-- .entry-footer -->
		</article><!-- #post-x -->
	</main><!-- .site-main -->
	<?php
}

/**
 * Attachment bones
 *
 * @since 1.0.0
 */
function zeen_attachment_bones( $style = '' ) {
	global $post;
?>
	<main class="site-main tipi-xs-12 block-wrap tipi-m-8 tipi-col clearfix">
		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<?php zeen_hero_design( $style, true, true ); ?>
			<div class="entry-content-wrap clearfix">
				<div class="entry-content body-color link-color-wrap">
					<?php the_content(); ?>
				</div><!-- .entry-content -->
			</div><!-- .entry-content -->
		</article><!-- #post-x -->
	</main><!-- .site-main -->
<?php
}

/**
 * Article sides
 *
 * @since 1.0.0
 */
function zeen_article_side( $pid = '', $layout = 1 ) {

	if ( 2 != $layout && 12 != $layout && 32 != $layout ) {
		return;
	}

	$extras = get_post_meta( $pid, 'zeen_share_details', true );
?>
	<div class="sticky-el details">
		<?php if ( ! empty( $show_author ) ) { ?>
		<?php $aid = get_the_author_meta( 'ID' ); ?>
		<div class="detail">
			<div class="pre-title title-light"><?php esc_html_e( 'Author', 'zeen' ); ?></div>
			<div class="title"><?php the_author_meta( 'display_name', $aid ); ?></div>
		</div>
		<?php } ?>

		<?php if ( ! empty( $show_cats ) ) { ?>
		<div class="detail">
			<div class="pre-title title-light"><?php esc_html_e( 'Category', 'zeen' ); ?></div>
			<div class="title">
				<?php
				zeen_byline_category( $pid, array(
					'cat_design' => 9,
					'show_primary' => 'all',
				) );
				?>
			</div>
		</div>
		<?php } ?>
		<?php
		if ( ! empty( $extras ) && ( ! empty( $extras[0]['title'] ) || ! empty( $extras[1]['title'] ) ) ) {
			foreach ( $extras as $key ) {
			?>
			<div class="detail">
				<div class="pre-title title-light"><?php echo esc_html( $key['title'] ); ?></div>
				<div class="title"><?php echo esc_html( $key['content'] ); ?></div>
			</div>
			<?php
			}
		}
		if ( empty( $extras ) ) {
		?>
		<div class="detail sharer sharer-9">
			<div class="pre-title title-light"><?php esc_html_e( 'Share', 'zeen' ); ?></div>
			<div class="title">
				<?php zeen_share( array( 'pid' => $pid, 'design' => 9, 'ipl' => true ) ); ?>
			</div>
		</div>
		<?php } ?>
	</div>
	<?php
}

/**
 * Modals
 *
 * @since 1.0.0
 */
function zeen_article_side_gallery( $pid = '', $layout = 1 ) {
	if ( $layout < 58 ) {
		return;
	}
	$gallery = get_post_meta( $pid, 'zeen_article_layout_gallery', true );
	if ( empty( $gallery ) ) {
		return;
	}
?>
<div class="entry-side-gallery tipi-xs-12 tipi-m-6 sticky-el">
	<?php foreach ( $gallery as $key => $value ) { ?>
		<div class="img-wrap"><?php echo wp_get_attachment_image( $value, 'zeen-770-full' );  ?></div>
	<?php } ?>
</div>
<?php
}

/**
 * Trending Inline
 *
 * @since 1.0.0
 */
function zeen_trending_inline( $location = '', $args = array() ) {
	if ( ( 'secondary_menu' == $location && get_theme_mod( 'secondary_menu_trending_inline' ) != 1 ) || ( 'main_menu' == $location && get_theme_mod( 'main_menu_trending_inline' ) != 1 ) ) {
		return;
	}

	$uid = zeen_uid();
	$preview = 61;
	$ppp = get_theme_mod( 'trending_ppp', 3 );
	if ( 4 == $ppp ) {
		$preview = 71;
	} elseif ( 5 == $ppp ) {
		$preview = 79;
	}
	echo '<li class="trending-inline dropper drop-it mm-art mm-wrap';
	if ( 'main' == $location ) {
		echo ' menu-padding';
	}
	echo '">';
	echo '<a href="#" ';
	if ( 'main' == $location ) {
		echo 'id="trending-main"';
	} else {
		echo 'id="trending-secondary"';
	}
	echo ' class="main-title-wrap">';

	echo '<i class="tipi-i-';
	$icon = get_theme_mod( 'trending_icon', 1 );
	if ( 2 == $icon ) {
		echo 'bolt';
	} elseif ( 3 == $icon ) {
		echo 'hash';
	} elseif ( 4 == $icon ) {
		echo 'flame';
	} elseif ( 5 == $icon ) {
		echo 'trend';
	} elseif ( 6 == $icon ) {
		echo 'trend-2';
	} else {
		echo 'zap';
	}

	echo ' tipi-trending-icon"></i>';
	$trending_text = get_theme_mod( 'trending_text' );
	if ( empty( $args['title_off'] ) ) {
		echo '<span class="trending-text">' . esc_html( $trending_text ) . '</span>';
	}
	echo '</a>';
	echo '<div class="trending-inline-drop menu tipi-row">';
	echo '<div class="trending-inline-title clearfix">';
	$trending_text = get_theme_mod( 'trending_mm_title', 'Trending' );
	echo '<div class="trending-op-title">' . esc_html( $trending_text ) . '</div>';
	if ( function_exists( 'stats_get_from_restapi' ) ) {
		echo '<div class="trending-ops" data-uid="' . (int) ( $uid ) . '">';
		echo '<span data-r="1" class="trending-op trending-op-1 trending-selected">' . esc_html__( 'Now', 'zeen' ) . '</span>';
		echo '<span data-r="2" class="trending-op trending-op-2">' . esc_html__( 'Week', 'zeen' ) . '</span>';
		echo '<span data-r="3" class="trending-op trending-op-3">' . esc_html__( 'Month', 'zeen' ) . '</span>';
		echo '</div>';
	}
	echo '</div>';
	echo '<div class="trending-inline-wrap">';
	$options = array(
		'qry' => array(
			'posts_per_page' => $ppp,
			'trending' => array(
				'name' => 'zeen-trending-now',
				'num' => 2,
			),
		),
		'uid'             => $uid,
		'preview'         => $preview,
		'typo'            => 'tipi-m-typo',
		'ndp_skip'        => true,
		'specific'        => 'mm',
		'byline_off'      => true,
		'excerpt_off'     => true,
		'js_off'          => true,
		'wrap'            => 'off',
		'counter'         => true,
		'counter_class'   => 'border',
		'padding'         => '',
		'margin'          => '',
	);

	if ( function_exists( 'stats_get_from_restapi' ) ) {
		$options['qry']['post_type'] = zeen_get_post_types(
			array(
				'essentials' => true,
			)
		);
		if ( get_theme_mod( 'woocommerce_product_in_trending' ) == 1 ) {
			$options['qry']['post_type'][] = 'product';
		}
		$block = zeen_block_pick( $options );
		$output = $block->output();
	} else {
		echo '<div class="block-wrap tipi-doc-info clearfix">' . esc_html__( 'To display trending posts, please ensure the Jetpack plugin is installed and that the Stats module of Jetpack is active. Refer to the theme documentation for help.', 'zeen' ) . '</div>';
	}
	echo '</div>';
	echo '</div>';
	echo '</li>';

}

function zeen_current_date( $location = '' ) {
	if ( 'secondary_menu' == $location && get_theme_mod( 'secondary_date' ) != 1 ) {
		return;
	}
	echo '<li class="current-date menu-padding">' . date_i18n( get_option( 'date_format' ) ) . '</li>';
}

function zeen_search_suggestions() {
	if ( 1 != get_theme_mod( 'search_show_suggestions', 1 ) ) {
		return;
	}
	echo '<div class="suggestions-wrap font-2">';
	$search_suggestions = do_action( 'zeen_search_suggestions' );

	if ( ! has_action( 'zeen_search_suggestions' ) ) {
		wp_tag_cloud( array(
			'orderby' => 'count',
			'order' => 'DESC',
			'smallest' => 12,
			'largest' => 12,
			'number' => 5,
			'unit' => 'px',
		) );
	}
	echo '</div>';
}

function zeen_search_ajax() {
	if ( get_theme_mod( 'search_ajax', 1 ) != 1 ) {
		return;
	}
	echo '<div class="content-found-wrap">';
	echo '<div class="content-found"></div>';
	echo '<div class="button-wrap"><a class="search-all-results button-arrow-r button-arrow tipi-button" href="#"><span class="button-title">' . esc_attr__( 'See all results', 'zeen' ) . '</span><i class="tipi-i-arrow-right"></i></a>';
	echo '</div>';
	echo '</div>';
}

/**
 * Modals
 *
 * @since 1.0.0
 */
function zeen_modals() {
	$modal_class = 'modal-wrap inactive';
	$subscribe_code = get_theme_mod( 'subscribe_code' );
	$fid = ! empty( $_POST['_mc4wp_form_element_id'] ) && ! empty( $subscribe_code ) ? $_POST['_mc4wp_form_element_id'] : '';
	if ( get_theme_mod( 'modal_skin', 1 ) == 2 ) {
		$modal_class .= ' dark-overlay';
	}
?>
<div id="modal" class="<?php echo esc_attr( $modal_class ); ?>" data-fid="<?php echo esc_attr( $fid ); ?>">
	<span class="tipi-overlay tipi-overlay-modal"></span>
	<div class="content tipi-vertical-c tipi-row">
		<div class="content-search search-form-wrap content-block">
			<?php get_search_form(); ?>
			<div class="search-hints">
				<span class="search-hint">
					<?php
					if ( get_theme_mod( 'search_ajax', 1 ) == 1 ) {
						echo esc_attr__( 'Start typing to see results or hit ESC to close', 'zeen' );
					} else {
						echo esc_attr__( 'Press ESC to close', 'zeen' );
					}
					?>
				</span>
				<?php zeen_search_suggestions(); ?>
			</div>
			<?php zeen_search_ajax(); ?>
		</div>

		<?php zeen_subscribe(); ?>
		<div class="content-lwa content-block site-img-<?php echo (int) ( zeen_skin_style( 'lwa', 'repeat' ) ); ?> site-skin-<?php echo (int) ( zeen_skin_style( 'lwa', 'skin', 2 ) ); ?>">
		<?php if ( function_exists( 'login_with_ajax' ) ) { ?>
			<div class="tipi-modal-bg bg-area">
				<?php if ( get_theme_mod( 'footer_icon_login' ) == 1 || get_theme_mod( 'mobile_icon_login' ) == 1 || get_theme_mod( 'secondary_menu_icon_login' ) == 1 || get_theme_mod( 'main_menu_icon_login' ) == 1 ) { ?>
					<?php login_with_ajax(); ?>
					<?php zeen_elem_bg_area( 'lwa' ); ?>
				<?php } ?>
			</div>
		<?php } ?>
		</div>

		<div class="content-custom content-block">
		</div>
	</div>
	<a href="#" class="close tipi-x-wrap tipi-x-outer"><i class="tipi-i-close"></i></a>

</div>
<span id="tipi-overlay" class="tipi-overlay tipi-overlay-base tipi-overlay-dark"><a href="#" class="close tipi-x-wrap"><i class="tipi-i-close"></i></a></span>
<?php
}

/**
 * Search Dropdown
 *
 * @since 1.0.0
 */
function zeen_search_dropdown() {
	get_search_form();
	zeen_search_ajax();
}

/**
 * Top Bar Message
 *
 * @since 1.0.0
 */
function zeen_top_bar_message() {

	if ( get_theme_mod( 'top_bar_message' ) != 1 || ( get_theme_mod( 'top_bar_cookie', 1 ) == 1 && isset( $_COOKIE['wp_top_bar'] ) ) && ! is_customize_preview() ) {
		return;
	}

	echo '<div id="top-bar-message" class="top-bar-message font-2">';
	zeen_top_bar_message_content();
	echo '<div id="top-bar-message-close"><i class="tipi-i-close"></i></div>';
	echo '</div>';
}

/**
 * Top Bar Message Content - Needed separately for theme options
 *
 * @since 1.0.0
 */
function zeen_top_bar_message_content() {
	echo '<span class="top-bar-message-content">';
	$url = get_theme_mod( 'top_bar_message_link' );
	if ( ! empty( $url ) ) {
		echo '<a href="' . esc_url( $url ) . '" rel="nofollow"';
		if ( get_theme_mod( 'top_bar_newtab' ) == 1 ) {
			echo ' target="_blank';
		}
		echo ' title="' . esc_attr( apply_filters( 'zeen_top_bar_title_attr', get_theme_mod( 'top_bar_message_content' ) ) ) . '">';
	}
	echo esc_attr( get_theme_mod( 'top_bar_message_content' ) );
	if ( ! empty( $url ) ) {
		echo '</a>';
	}
	echo '</span>';
}

/**
 * Popup
 *
 * @since 1.0.0
 */
function zeen_popup() {

	if ( get_theme_mod( 'timed_popup' ) != 1 || ! is_active_sidebar( 'timed-popup' ) ) {
		return;
	}
	if ( ( get_theme_mod( 'timed_popup_cookie', 1 ) == 1 && isset( $_COOKIE['wp_timed_pp'] ) ) ) {
		if ( ! is_customize_preview() ) {
			return;
		}
	}
	echo '<div id="timed-pup" class="timed-pup tipi-flex" data-t="' . (int) get_theme_mod( 'timed_popup_timer', 15 ) . '" data-d="' . (int) get_theme_mod( 'timed_popup_cookie', 1 ) . '">';
	echo '<div class="timed-pup-inner">';
	dynamic_sidebar( 'timed-popup' );
	echo '</div>';
	echo '</div>';
}

/**
 * Subscribe
 *
 * @since 1.0.0
 */
function zeen_subscribe( $inner = '' ) {
	$title = get_theme_mod( 'subscribe_title', '' );
	$subtitle = get_theme_mod( 'subscribe_subtitle', '' );
	$code = get_theme_mod( 'subscribe_code' );
	if ( empty( $title ) && empty( $subtitle ) && empty( $code ) ) {
		return;
	}
	if ( empty( $inner ) ) {
	?>
	<div class="content-subscribe content-subscribe-style content-subscribe-<?php echo (int) ( get_theme_mod( 'subscribe_style', 1 ) ); ?> site-skin-<?php echo (int) ( zeen_skin_style( 'subscribe' ) ); ?> site-img-<?php echo (int) ( zeen_skin_style( 'subscribe', 'repeat' ) ); ?>  content-block subscribe-wrap subscribe-button-<?php echo (int) get_theme_mod( 'subscribe_signup_style', 1 ); ?>">
		<div class="tipi-modal-bg bg-area clearfix">
	<?php } ?>
		<div class="content-subscribe-inner">
			<?php if ( ! empty( $subtitle ) || ! empty( $title ) ) { ?>
			<div class="subscribe-titles">
			<?php } ?>
			<?php if ( ! empty( $title ) ) { ?>
				<h2 class="title"><?php echo esc_attr( $title ); ?></h2>
			<?php } ?>
			<?php if ( ! empty( $subtitle ) ) { ?>
				<div class="subtitle"><?php echo esc_attr( $subtitle ); ?></div>
			<?php } ?>
			<?php if ( ! empty( $subtitle ) || ! empty( $title ) ) { ?>
			</div>
			<?php } ?>
			<div class="subscribe-form">
				<?php if ( ! empty( $code ) ) { ?>
					<?php echo do_shortcode( get_theme_mod( 'subscribe_code' ) ); ?>
				<?php } else { ?>
					<?php esc_attr_e( 'Go to Appearance > Customize > Subscribe Pop-up to set this up.', 'zeen' ); ?>
				<?php } ?>

			</div>
		</div>
		<?php
		if ( empty( $inner ) ) {
			zeen_elem_bg_area();
			echo '</div></div>';
		}
}

/**
 * Pre get posts
 *
 * @since 1.0.0
 */
function zeen_search_pages( $args, $post_type ) {

	if ( ! is_admin() && get_theme_mod( 'search_show_pages' ) != 1 && 'page' == $post_type ) {
		$args['exclude_from_search'] = true;
	}

	return $args;
}
add_filter( 'register_post_type_args', 'zeen_search_pages', 10, 2 );

function zeen_builder_300_offset() {
	if ( is_category() || is_tag() || is_tax() ) {
		$tid = zeen_get_term_id();
		$builder = empty( $tid ) ? '' : zeen_get_term_meta( 'tipi_builder_active', $tid );
		if ( ! empty( $builder ) ) {
			$data = zeen_get_term_meta( 'tipi_builder_data' );
		}
	} elseif ( is_page() ) {
		global $post;
		if ( empty( $post->ID ) ) {
			$page = get_queried_object();
			if ( ! empty( $page ) ) {
				$pid = $page->ID;
			} else {
				$pid = get_option( 'page_on_front' );
			}
		} else {
			$pid = $post->ID;
		}
		$builder = empty( $pid ) ? '' : get_post_meta( $pid, 'tipi_builder_active', true );
		if ( ! empty( $builder ) ) {
			$data = get_post_meta( $pid, 'tipi_builder_data', true );
		}
	}
	$data = ! empty( $data ) ? json_decode( $data, true ) : '';
	if ( ! empty( $data ) ) {
		foreach ( $data as $data_key ) {
			if ( 300 == $data_key['preview'] && ! empty( $data_key['offset'] ) ) {
				return $data_key['offset'];
			}
		}
	}
}

/**
 * Pre get posts
 *
 * @since 1.0.0
 */
function zeen_pre_posts( $query ) {

	if ( isset( $query->query_vars['block_qry'] ) && ! empty( $query->query_vars['offset'] ) ) {
		$page_offset = $query->query_vars['offset'] + ( ( $query->query_vars['paged'] - 1 ) * $query->query_vars['posts_per_page'] );
		$query->set( 'offset', $page_offset );
	}

	if ( $query->is_main_query() && ! is_admin() ) {
		$default_offset = zeen_builder_300_offset();
		if ( ! empty( $default_offset ) ) {
			$ppp = get_option( 'posts_per_page' );
			if ( $query->is_paged ) {
				$offset = $default_offset + ( ( $query->query_vars['paged'] - 1 ) * $ppp );
			} else {
				$offset = $default_offset;
			}
			$query->set( 'offset' , $offset );
		}

		if ( get_theme_mod( 'blog_page_cat_exclude' ) == 1 ) {
			$cats_excluded = get_theme_mod( 'blog_page_cat_excluded' );
			if ( $query->is_home && ! empty( $cats_excluded ) ) {
				$query->set( 'category__not_in', $cats_excluded );
			}
		}
		if ( is_category() || is_tag() ) {
			$query->set( 'post_type', zeen_get_post_types( array(
				'essentials' => true,
			) ) );
		}

		$filter = get_query_var( 'filtered' );
		if ( ! empty( $filter ) ) {
			switch ( $filter ) {
				case 'rated':
					$query->set( 'meta_query', array(
						'related' => 'AND',
						array(
							'key' => '_lets_review_final_score_100',
							'compare' => 'EXISTS',
						),
						array(
							'key' => '_lets_review_onoff',
							'value' => 1,
							'compare' => '=',
						),
					) );
					$query->set( 'orderby', array(
						'_lets_review_final_score_100' => 'meta_value_num',
					) );
					break;
				case 'oldest':
					$query->set( 'order', 'ASC' );
					break;
				case 'atoz':
					$query->set( 'orderby', 'title' );
					$query->set( 'order', 'ASC' );
					break;
				case 'random':
					$query->set( 'orderby', 'RAND(' . rand( 10, 100 ) . ')' );
					break;
				case 'liked':
					$query->set( 'meta_key', 'zeen_like_count' );
					$query->set( 'orderby', 'meta_value_num' );
					break;
			}
		}
	}

	return $query;

}
add_filter( 'pre_get_posts', 'zeen_pre_posts' );

/**
 * Found Posts
 *
 * @since 1.0.0
 */
function zeen_found_posts( $found_posts, $query ) {

	if ( isset( $query->query_vars['block_qry'] ) && ! empty( $query->query_vars['offset'] ) ) {
		$found_posts = $found_posts - $query->query['offset'];
	}
	if ( $query->is_main_query() && ! is_admin() ) {
		$default_offset = zeen_builder_300_offset();
		if ( ! empty( $default_offset ) ) {
			$found_posts = $found_posts - $default_offset;
		}
	}
	return $found_posts;

}
add_filter( 'found_posts', 'zeen_found_posts', 1, 2 );

/**
 * Team
 *
 * @since 1.0.0
 */
function zeen_team( $page_template = 3 ) {

	$team_authors = get_theme_mod( 'team_authors' );
	if ( empty( $team_authors ) ) {
		echo '<h2>';
		esc_html_e( 'No Authors Are Currently Enabled To Appear', 'zeen' );
		echo '</h2><p>';
			esc_html_e( 'The site admin needs to go to Zeen > Theme Options > Pages and edit the authors that should appear here.', 'zeen' );
		echo '</p>';
		return;
	}

	echo '<div class="team-wrap team-wrap-' . (int) ( $page_template ) . ' clearfix">';
	global $post;
	$pid = empty( $post->ID ) ? '' : $post->ID;
	foreach ( $team_authors as $user_id ) {
		zeen_user_box( array(
			'action_type' => 'team',
			'pid' => $pid,
			'aid' => $user_id,
			'design' => $page_template,
		) );
	}
	echo '</div>';

}

/**
 * Author Archive Block
 *
 * @since 1.0.0
 */
function zeen_user_box( $args = array() ) {
	$authors = empty( $args['aid'] ) ? array() : $args['aid'];
	$type = empty( $args['action_type'] ) ? '' : $args['action_type'];
	$design = empty( $args['design'] ) ? 1 : $args['design'];
	$pid = empty( $args['pid'] ) ? get_the_ID() : $args['pid'];
	$type_val = 1;

	$avatar_size = 60;
	if ( 2 == $design ) {
		$avatar_size = 385;
	} elseif ( $design > 2 ) {
		$avatar_size = 280;
	}

	if ( 'archive' == $type ) {
		$type_val = 2;
		if ( 2 == $design ) {
			$avatar_size = 280;
		}
	}

	if ( 'single' == $type ) {
		$single_box = get_post_meta( $pid, 'zeen_user_box', true );

		if ( '2' == $single_box || ( ( empty( $single_box ) || '99' == $single_box ) && get_theme_mod( 'single_author_box', 1 ) != 1 ) ) {
			return;
		}
	}
	if ( ! is_array( $authors ) ) {
		$authors = array( $authors );
	}
	foreach ( $authors as $aid ) {
		$comment_count = get_comments( array(
			'user_id' => $aid,
			'count' => true,
		) );
		if ( function_exists( 'coauthors_links' ) ) {
			$user_check = get_userdata( $aid );
			if ( empty( $user_check ) ) {
				continue;
			}
		}
		$post_count = count_user_posts( $aid );
		echo '<div class="user-page-box-' . (int) ( $design ) . ' user-box-type-' . (int) ( $type_val ) . ' tipi-xs-12 user-page-box clearfix">';
		?>
		<div class="mask">
			<a href="<?php echo esc_url( get_author_posts_url( $aid ) ); ?>">
				<?php echo get_avatar( $aid, $avatar_size ); ?>
				<span class="overlay-arrow-r overlay-arrow"><i class="tipi-i-long-right"></i></span>
			</a>
		</div>
		<div class="meta">
			<div class="author-info-wrap">
				<div class="author-name font-1"><a href="<?php echo esc_url( get_author_posts_url( $aid ) ); ?>"><?php the_author_meta( 'display_name', $aid ); ?></a><?php if ( get_the_author_meta( 'url', $aid ) != '' ) { ?>
					<a href="<?php echo esc_url( get_the_author_meta( 'url', $aid ) ); ?>" target="_blank" rel="noopener nofollow" rel="noopener nofollow" class="author-icon author-ext-url tipi-tip tipi-tip-move" data-title="<?php esc_html_e( 'Website', 'zeen' ); ?>"><i class="tipi-i-external-link"></i></a>
				<?php } ?></div>
				<?php if ( 2 == $type_val ) { ?>
					<div class="team-member-details clearfix">
						<?php if ( get_the_author_meta( 'position', $aid ) != '' ) { ?>
						<div class="team-member-detail author-position"><span class="pre-title title-light"><?php echo esc_html__( 'Position', 'zeen' );?></span><span class="title"><?php echo the_author_meta( 'position', $aid ); ?></span></div>
						<?php } ?>
						<div class="team-member-detail author-joined"><span class="pre-title title-light"><?php echo esc_html__( 'Joined', 'zeen' );?></span><span class="title"><?php echo date_i18n( get_option( 'date_format' ), strtotime( get_the_author_meta( 'user_registered', $aid ) ) ); ?></span></div>
						<?php if ( $post_count > 0 ) { ?>
							<div class="team-member-detail author-article-count"><span class="pre-title title-light"><?php echo esc_html__( 'Articles', 'zeen' );?></span><span class="title"><?php echo (int) $post_count; ?></span></div>
						<?php } ?>
						<?php if ( $comment_count > 0 ) { ?>
							<div class="team-member-detail author-comments"><span class="pre-title title-light"><?php echo esc_html__( 'Comments', 'zeen' );?></span><span class="title"><?php echo (int) $comment_count; ?></span></div>
						<?php } ?>
					</div>
				<?php } elseif ( get_the_author_meta( 'position', $aid ) != '' ) { ?>
					<div class="author-position title-light"><?php the_author_meta( 'position', $aid ); ?></div>
				<?php } ?>
			</div>
			<div class="author-right-meta">
				<?php $description = get_the_author_meta( 'description', $aid ); ?>
				<?php if ( ! empty( $description ) ) { ?>
					<div class="author-bio body-color link-color-wrap"><?php the_author_meta( 'description', $aid ); ?></div>
				<?php } ?>
				<div class="icons">
					<?php if ( get_the_author_meta( 'publicemail', $aid ) != '' ) { ?>
						<a href="mailto:<?php echo sanitize_email( get_the_author_meta( 'publicemail', $aid ) ); ?>" class="author-icon tipi-tip tipi-tip-move" data-title="Email"><i class="tipi-i-mail"></i></a>
					<?php } ?>
					<?php
					$user_networks = array(
						'facebook' => array(
							'title' => 'Facebook',
							'icon' => 'facebook',
						),
						'patreon' => array(
							'title' => 'Patreon',
							'icon' => 'patreon',
						),
						'twitter' => array(
							'title' => 'Twitter',
							'icon' => 'twitter',
						),
						'twitch' => array(
							'title' => 'Twitch',
							'icon' => 'twitch',
						),
						'instagram' => array(
							'title' => 'Instagram',
							'icon' => 'instagram',
						),
						'pinterest' => array(
							'title' => 'Pinterest',
							'icon' => 'pinterest',
						),
						'soundcloud' => array(
							'title' => 'Soundcloud',
							'icon' => 'soundcloud',
						),
						'spotify' => array(
							'title' => 'Spotify',
							'icon' => 'spotify',
						),
						'linkedin' => array(
							'title' => 'LinkedIn',
							'icon' => 'linkedin',
						),
						'apple_music' => array(
							'icon' => 'apple_music',
							'title' => 'Apple Music',
						),
						'medium' => array(
							'title' => 'Medium',
							'icon' => 'medium',
						),
						'youtube' => array(
							'title' => 'YouTube',
							'icon' => 'youtube-play',
						),
						'dribbble' => array(
							'title' => 'Dribbble',
							'icon' => 'dribbble',
						),
						'vimeo' => array(
							'title' => 'Vimeo',
							'icon' => 'vimeo',
						),
						'vk' => array(
							'title' => 'VK',
							'icon' => 'vk',
						),
					);
					foreach ( $user_networks as $key => $value ) {
						$profile_meta = get_the_author_meta( $key, $aid );
						if ( empty( $profile_meta ) ) {
							continue;
						}
						if ( 'twitter' == $key ) {
							$profile_meta = ltrim( $profile_meta, '@' );
							if ( strpos( $profile_meta, 'twitter.co' ) === false ) {
								$profile_meta = 'https://twitter.com/' . $profile_meta;
							}
						}
						echo '<a href="' . esc_url( $profile_meta ) . '" target="_blank" rel="noopener nofollow" class="author-icon tipi-tip tipi-tip-move" data-title="' . esc_attr( $value['title'] ) . '"><i class="tipi-i-' . esc_attr( $value['icon'] ) . '"></i></a>';
					}
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
	}
}

function zeen_is_live_blog( $pid = '' ) {
	$live_blog = get_post_meta( $pid, 'lets_live_blog_enabled', true );
	if ( ( ! empty( $live_blog ) && 'on' != $live_blog ) || empty( $live_blog ) ) {
		return false;
	}
	return true;
}

/**
 * Post Inline
 *
 * @since 1.0.0
 */
function zeen_post_inline( $args = array() ) {
	global $post;
	$not_pid = empty( $args['not_pid'] ) ? $post->ID : $args['not_pid'];
	$pid = empty( $args['pid'] ) ? '' : $args['pid'];
	$title = ! isset( $args['title'] ) ? esc_html__( 'See also', 'zeen' ) : $args['title'];
	if ( ! empty( $pid ) ) {
		$qry = array(
			'posts_per_page'   => 1,
			'p' => $pid,
			'post_type' => 'any',
		);
	} else {
		$all_cats = '';
		$live_blog = zeen_is_live_blog( $not_pid );
		if ( ! empty( $live_blog ) ) {
			return;
		}
		$cats = get_the_category();
		foreach ( $cats as $cat ) {
			$all_cats .= $cat->term_id . ',';
		}
		$qry = apply_filters( 'zeen_post_inline_args', array(
			'cat'              => $all_cats,
			'post__not_in'     => array( $not_pid ),
			'posts_per_page'   => 1,
			'orderby'        => 'rand',
		) );
	}

	$args = array(
		'qry'        => $qry,
		'preview'    => 23,
		'title_block_off' => 'on',
		'contained' => true,
		'specific' => 'related',
		'uid' => zeen_uid(),
		'excerpt_off' => true,
		'shape_override' => 'l',
		'separator_off' => true,
		'mobile'     => 'true',
	);
	if ( empty( $pid ) ) {
		$date = get_theme_mod( 'post_mid_inline_date', 1 );
		if ( $date > 1 ) {
			$length_time = 7 != $date ? 'months' : 'days';
			$args['qry']['date_query'] = array(
				array(
					'inclusive' => true,
					'after'  => $date . ' ' . $length_time . ' ago',
				),
			);
		}
	}

	$block = zeen_block_pick( $args );
	$block_content = $block->output( false );
	if ( ! empty( $block_content ) ) {
		$output = '<div class="inline-post clearfix">';
		if ( ! empty( $title ) ) {
			$output .= '<div class="see-also byline">';
			$output .=  esc_html( $title );
			$output .= '</div>';
		}
		$output .= $block_content;
		$output .= '</div>';
		return $output;
	}
}

/**
 * Meta props
 *
 * @since 1.0.0
 */
function zeen_meta_props() {
	if ( get_theme_mod( 'og_meta', 1 ) != 1 || function_exists( 'wpseo_init' ) ) {
		return;
	}
	if ( is_singular() ) {
		global $post;
		$image = get_the_post_thumbnail_url( $post, 'large' );
		$desc = apply_filters( 'the_excerpt', get_post_field( 'post_excerpt', $post->ID ) );
		if ( ! is_page() ) {
			$title = the_title_attribute( array( 'echo' => false ) );
		}
	}
	$site_name = get_bloginfo( 'name' );
	if ( empty( $image ) ) {
		$image = get_theme_mod( 'og_meta_img' );
		if ( empty( $image ) ) {
			$image = get_site_icon_url();
		}
	}
	if ( empty( $desc ) ) {
		$desc = get_bloginfo( 'description' );
	}
	if ( empty( $title ) ) {
		$title = $site_name;
	}
	?>
	<meta property="og:title" content="<?php echo esc_attr( $title ); ?>">
	<meta property="og:description" content="<?php echo strip_tags( $desc ); ?>">
	<meta property="og:image" content="<?php echo esc_url( $image ); ?>">
	<meta property="og:url" content="<?php echo esc_url( get_permalink() ); ?>">
	<meta name="twitter:card" content="summary_large_image">
	<meta property="og:site_name" content="<?php echo esc_attr( $site_name ); ?>">
	<meta property="og:type" content="website">
	<?php
	$fb_app_id = get_theme_mod( 'facebook_app_id' );
	if ( ! empty( $fb_app_id ) ) {
		echo '<meta property="fb:app_id" content="' . esc_attr( $fb_app_id ) . '">';
	}
}

/**
 * Registered Sidebar
 *
 * @since 1.0.0
 */
function zeen_registered_sidebar( $sidebar = '' ) {
	global $wp_registered_sidebars;
	echo ' ';
	if ( isset( $wp_registered_sidebars[ $sidebar ] ) ) {
		echo esc_attr( $wp_registered_sidebars[ $sidebar ]['name'] );
	} else {
		esc_html_e( 'Default Sidebar', 'zeen' );
	}
}

/**
 * Archive Sorter
 *
 * @since 1.0.0
 */
function zeen_sorter( $args = array() ) {

	if ( is_date() || get_theme_mod( 'show_archive_filter', 1 ) != 1 ) {
		return;
	}
	if ( empty( $args['term_id'] ) ) {
		$term = get_queried_object();
	}
	if ( empty( $term ) && empty( $args['term_id'] ) ) {
		return;
	}

	$args['echo'] = isset( $args['echo'] ) ? $args['echo'] : true;

	if ( empty( $args['echo'] ) ) {
		ob_start();
	}

	$filter = get_query_var( 'filtered' );

	$term_id = empty( $args['term_id'] ) ? $term->term_id : $args['term_id'];

	if ( is_post_type_archive() ) {
		$term_a = get_post_type_archive_link( get_query_var( 'post_type' ) );
	} else {
		$term_a = get_term_link( $term_id );
	}

	if ( is_wp_error( $term_a ) ) {
		return;
	}

	echo '<div class="archive-sorter sorter" data-tid="' . (int) $term_id . '" tabindex="-1">';
	echo '<span class="current-sorter current">';
	echo '<span class="current-sorter-txt current-txt">';
	switch ( $filter ) {
		case 'rated':
			esc_html_e( 'Top Rated', 'zeen' );
			break;
		case 'oldest':
			esc_html_e( 'Oldest', 'zeen' );
			break;
		case 'random':
			esc_html_e( 'Random', 'zeen' );
			break;
		case 'liked':
			esc_html_e( 'Most Liked', 'zeen' );
			break;
		case 'atoz':
			esc_html_e( 'A to Z', 'zeen' );
			break;
		default:
			esc_html_e( 'Latest', 'zeen' );
		break;
	}

	echo '<i class="tipi-i-chevron-down"></i>';
	echo '</span>';
	echo '</span>';
	echo '<ul class="options">';
	if ( is_search() ) {
		echo '<li>';
		echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'revelance' ), $term_a ) ) . '" data-type="revelance">' . esc_html__( 'Relevance', 'zeen' ) . '</a>';
		echo '</li>';
	}
	echo '<li>';
	echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'latest' ), $term_a ) ) . '" data-type="latest">' . esc_html__( 'Latest', 'zeen' ) . '</a>';
	echo '</li>';
	echo '<li>';
	echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'oldest' ), $term_a ) ) . '" data-type="oldest">' . esc_html__( 'Oldest', 'zeen' ) . '</a>';
	echo '</li>';
	echo '<li>';
	echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'random' ), $term_a ) ) . '" data-type="random">' . esc_html__( 'Random', 'zeen' ) . '</a>';
	echo '</li>';
	echo '<li>';
	echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'atoz' ), $term_a ) ) . '" data-type="atoz">' . esc_html__( 'A to Z', 'zeen' ) . '</a>';
	echo '</li>';
	if ( get_theme_mod( 'classic_like_count' ) == 1 ) {
		echo '<li>';
		echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'liked' ), $term_a ) ) . '" data-type="liked">' . esc_html__( 'Most Liked', 'zeen' ) . '</a>';
		echo '</li>';
	}
	if ( class_exists( 'Lets_Review_API' ) ) {
		$active = get_term_meta( $term_id, '_lets_review_active', true );
		if ( ! empty( $active ) ) {
			echo '<li>';
			echo '<a href="' . esc_url( add_query_arg( array( 'filtered' => 'rated' ), $term_a ) ) . '" data-type="rated">' . esc_html__( 'Top Rated', 'zeen' ) . '</a>';
			echo '</li>';
		}
	}

	echo '</ul>';
	echo '</div>';

	if ( empty( $args['echo'] ) ) {
		return ob_get_clean();
	}
}

/**
 * Query vars
 *
 * @since 1.0.0
 */
function zeen_query_vars( $vars ) {

	$vars[] = 'block_qry';
	$vars[] = 'filtered';
	return $vars;

}
add_filter( 'query_vars', 'zeen_query_vars' );

/**
 * Header
 *
 * @since 1.0.0
 */
function zeen_header( $header_style ) {

	if ( 58 == $header_style ) {
		$related = true;
		$header_style = get_theme_mod( 'header_style', 1 );
	}

	if ( $header_style > 80 || zeen_is_mobile_site() == 'isMob' ) {
		return;
	}

	$sticky = get_theme_mod( 'header_sticky_onoff', 1 );
	$sticky_style = ! empty( $sticky ) ? get_theme_mod( 'header_sticky', 1 ) : '';
	$secondary = '';
	$row = '';
	$main = 2;
	$header_area = true;
	if ( $header_style < 70 ) {
		if ( 1 == $header_style || 2 == $header_style || 4 == $header_style ) {
			$secondary = 1;
		} elseif ( 11 != $header_style && 5 != $header_style ) {
			$secondary = 2;
		}
		if ( 4 == $header_style ) {
			$main = 1;
		}
	}
	if ( $header_style > 50 && $header_style < 60 ) {
		$secondary = '';
		$main = '';
		if ( 51 == $header_style ) {
			$main = 2;
			$header_style_bk = get_theme_mod( 'header_style', 1 );
			if ( 11 != $header_style_bk && 5 != $header_style_bk ) {
				$secondary = 1;
			}
			$row = true;
			$header_area = '';
		}
	}

	$header_exceptions = 52 == $header_style ? true : false;
	if ( ! has_nav_menu( 'main' ) && ( 5 == $header_style || 11 == $header_style ) ) {
		$header_exceptions = true;
	}
	if ( 1 == $secondary ) {
		zeen_secondary_menu( $row );
	}
	if ( 1 == $main ) {
		if ( 1 == $sticky_style ) {
			echo '<div id="header-line"></div>';
		}
		get_template_part( 'template-parts/menu/menu-main', 1 );
		if ( $sticky_style > 1 ) {
			echo '<div id="header-line"></div>';
		}
	}
	$mm_ani = get_theme_mod( 'megamenu_animation_onoff', 1 ) == 1 ? get_theme_mod( 'megamenu_animation', 1 ) : 0;
	$header_width = zeen_check_width( get_theme_mod( 'header_width', 1 ) );
	$ad = get_theme_mod( 'header_pub' );
	if ( ! empty( $header_area ) ) {
		echo '<header id="masthead" class="site-header-block site-header clearfix';
		echo ' site-header-' . (int) $header_style;
		echo ' header-width-' . (int) $header_width;
		echo ' header-skin-' . (int) zeen_skin_style( 'header' );
		echo ' site-img-' . (int) zeen_skin_style( 'header', 'repeat' );
		echo ' mm-ani-' . (int) $mm_ani;
		echo ' mm-skin-' . (int) get_theme_mod( 'megamenu_skin', 2 );
		echo ' main-menu-skin-' . (int) get_theme_mod( 'main_menu_skin', 1 );
		echo ' main-menu-width-' . (int) get_theme_mod( 'main_menu_width', 3 );
		if ( get_theme_mod( 'megamenu_color_usage_onoff', 1 ) == 1 ) {
			echo ' main-menu-bar-color-' . (int) get_theme_mod( 'megamenu_color_usage', 2 );
		}
		if ( ! empty( $sticky_style ) && ( $header_style > 70 || ! empty( $header_exceptions ) ) ) {
			echo ' sticky-menu-' . (int) $sticky_style;
			if ( 1 == $sticky_style || 4 == $sticky_style ) {
				echo ' sticky-top';
			} else {
				echo ' sticky-menu';
			}
		}
		if ( ! empty( $ad ) ) {
			echo ' dt-header-da';
		}
		if ( 1 == get_theme_mod( 'logo_main_menu_visible', 1 ) && ! ( is_singular() && ( 51 == $header_style || 58 == $header_style ) ) ) {
			echo ' logo-only-when-stuck';
		}
		if ( 3 == $header_width ) {
			echo ' tipi-row';
		}
		zeen_extra_header_classes( $header_style );
		echo '"';
		$pt_diff = 0;
		$pb_diff = 0;
		if ( ! empty( $sticky_style ) ) {
			if ( get_theme_mod( 'header_sticky_onoff', 1 ) == 1 && get_theme_mod( 'sticky_header_customize' ) == 1 ) {
				$pt_diff = get_theme_mod( 'header_padding_top', 30 ) - get_theme_mod( 'sticky_header_padding_top', 30 );
				$pb_diff = get_theme_mod( 'header_padding_bottom', 30 ) - get_theme_mod( 'sticky_header_padding_bottom', 30 );
			}
		}
		echo ' data-pt-diff="' . (int) $pt_diff . '" data-pb-diff="' . (int) $pb_diff . '"';
		echo '>';
		get_template_part( 'template-parts/header/header', $header_style );
		echo '</header><!-- .site-header -->';
	}
	if ( $header_style < 70 && empty( $header_exceptions ) && 2 == $main ) {
		if ( 1 == $sticky_style ) {
			echo '<div id="header-line"></div>';
		}
		get_template_part( 'template-parts/menu/menu-main', 1 );
		if ( $sticky_style > 1 ) {
			echo '<div id="header-line"></div>';
		}
	}

	if ( ! empty( $sticky_style ) && ( $header_style > 70 || ! empty( $header_exceptions ) ) ) {
		echo '<div id="header-line"></div>';
	}
	if ( 2 == $secondary ) {
		zeen_secondary_menu();
	}

	if ( ! empty( $related ) ) {
		global $post;
		$args = array(
			'pid' => $post->ID,
			'action_type' => 'single',
			'hook' => 'before',
			'p' => 79,
			'ppp' => 5,
			'uid' => zeen_uid(),
			'title_block_off' => 'off',
			'separator_off' => true,
			'byline_off' => true,
			'fs' => 'off',
			'override' => true,
			'contained' => '',
			'classes' => ' header-related-posts',
		);
		zeen_related_posts( $args );
	}

	do_action( 'zeen_header_after' );
}

/**
 * Header Classes
 *
 * @since 1.0.0
 */
function zeen_extra_header_classes( $header_style ) {
	if ( 58 == $header_style ) {
		$header_style = get_theme_mod( 'header_style', 1 );
	}
	if ( 2 == $header_style || 3 == $header_style || 5 == $header_style || 6 == $header_style || 11 == $header_style ) {
		echo ' main-menu-c';
	} elseif ( 1 == $header_style || 4 == $header_style || 7 == $header_style ) {
		echo ' main-menu-l';
	} elseif ( 72 == $header_style || 73 == $header_style || 74 == $header_style ) {
		echo ' main-menu-inline';
	}
}

/**
 * Mobile Header
 *
 * @since 1.0.0
 */
function zeen_mobile_header() {
	$mobile_header = zeen_get_style( 'mobile_header' );
	echo '<header id="mobhead" class="site-header-block site-mob-header tipi-m-0';
	echo ' site-mob-header-' . (int) $mobile_header;
	echo ' site-mob-menu-' . (int) zeen_get_style( 'mobile_menu' );
	if ( get_theme_mod( 'mobile_header_sticky_onoff', 1 ) == 1 ) {
		$mobile_st = get_theme_mod( 'mobile_header_sticky', 1 );

		if ( 11 != $mobile_st ) {
			echo ' sticky-menu-' . (int) $mobile_st;
			if ( 1 == $mobile_st ) {
				echo ' sticky-top';
			} else {
				echo ' sticky-menu';
			}
		}
	}
	echo ' site-skin-' . (int) zeen_skin_style( 'mobile_header', 'skin', 2 );
	echo ' site-img-' . (int) zeen_skin_style( 'mobile_header', 'repeat' );
	echo '">';
	get_template_part( 'template-parts/header/mob-header', $mobile_header );
	echo '</header><!-- .site-mob-header -->';
	echo '<div id="mob-line" class="tipi-m-0"></div>';
	if ( 3 == $mobile_header ) {
		echo '<div class="logo-main-wrap logo-mob-wrap site-mob-header-3-logo tipi-m-0">';
		zeen_logo( 'mobile' );
		echo '</div>';
	}
}

/**
 * Above Header block
 *
 * @since 1.0.0
 */
function zeen_above_header( $header_style = '' ) {

	if ( get_theme_mod( 'header_block_hp_onoff', 1 ) == 1 ) {
		zeen_header_block();
	} else {
		zeen_ad( 'header_top' );
		if ( get_theme_mod( 'header_block_instagram' ) == 1 ) {
			zeen_instagram_block( array(
				'location' => 'header',
				'user' => get_theme_mod( 'header_block_instagram_user' ),
				'per_row' => get_theme_mod( 'header_block_instagram_ppp', 6 ),
				'limit' => get_theme_mod( 'header_block_instagram_ppp', 6 ),
			) );
		}
	}
}

/**
 * Header block
 *
 * @since 1.0.0
 */
function zeen_header_block() {
	if ( get_theme_mod( 'header_block_hp_onoff', 1 ) != 1 ) {
		return;
	}
	if ( ( get_theme_mod( 'header_block_hp', 1 ) == 1 && ! is_front_page() ) || ( zeen_is_mobile_site() == 'isMob' && get_theme_mod( 'header_block_mobile' ) != 1 ) || TipiBuilder\ZeenHelpers::zeen_mob_active() ) {
		return;
	}

	$filter = get_theme_mod( 'header_block_source', 'categories' );
	$sortby = get_theme_mod( 'header_block_sortby', 0 );
	$cats = '';
	$pids = '';
	$tags = '';
	$post_type = '';
	$orderby = 'date';
	if ( 2 == $sortby ) {
		$orderby = 'rand';
	}
	switch ( $filter ) {
		case 'categories':
			$categories = get_theme_mod( 'header_block_categories' );
			if ( empty( $categories ) ) {
				break;
			}
			foreach ( $categories as $key => $value ) {
				$cats .= $value . ',';
			}
			$cats = rtrim( $cats, ',' );
			break;
		case 'tags':
			$tags = get_theme_mod( 'header_block_tags' );
			if ( empty( $tags ) ) {
				break;
			}
			$tags = explode( ',', $tags );
			break;
		case 'pids':
			$pids = get_theme_mod( 'header_block_pids' );
			$post_type = zeen_get_post_types(
				array(
					'output' => 'names',
					'public'   => true,
				)
			);
			$post_type['page'] = 'page';
			$orderby = 'post__in';
			break;
		default:
			$post_type = $filter;
			break;
	}

	$p = get_theme_mod( 'header_block_design', 83 );

	if ( 81 == $p ) {
		$ppp = 1;
	} elseif ( 82 == $p ) {
		$ppp = 2;
	} elseif ( 83 == $p || 86 == $p ) {
		$ppp = 3;
	} elseif ( 84 == $p || 94 == $p ) {
		$ppp = 4;
	} elseif ( 92 == $p ) {
		$ppp = 5;
	}

	if ( zeen_is_mobile_site() == 'isMob' ) {
		$ppp = 1;
		$p = 82;
	}

	if ( ! empty( $pids ) ) {
		$pids = explode( ',', str_replace( ' ', '', $pids ) );
		$pids = array_slice( $pids, 0, $ppp );
	}

	$qry = array(
		'post_type'             => $post_type,
		'cat'                   => $cats,
		'posts_per_page'        => $ppp,
		'orderby'               => $orderby,
		'post__in'              => $pids,
		'tag__in'               => $tags,
	);

	if ( 1 == $sortby ) {
		$qry['trending'] = array(
			'name' => 'header_block',
			'max' => 3,
			'num' => 2,
		);
	}
	$fs = 2 == get_theme_mod( 'header_block_width', 1 ) ? '' : 'on';
	$options = array(
		'qry'             => $qry,
		'preview'         => $p,
		'filter'          => $filter,
		'fs'              => $fs,
		'specific'        => 'top_block',
	);

	echo '<div id="zeen-top-block" class="zeen-top-block zeen-top-block-' . (int) ( $p );

	if ( get_theme_mod( 'header_block_parallax', 1 ) != 1 ) {
		echo ' standard-ani';
	}
	echo ' active clearfix';
	if ( get_theme_mod( 'header_block_mobile' ) != 1 ) {
		echo ' tipi-xs-0';
	}

	if ( get_theme_mod( 'grid_tile_design', 1 ) == 2 ) {
		echo ' byline-1-exists';
	}
	echo '">';
	if ( get_theme_mod( 'header_block_featured_title_onoff' ) == 1 ) {
		echo '<span class="special-title font-1">';
		echo esc_attr( get_theme_mod( 'header_block_featured_title', 'Featured' ) );
		echo '</span>';
	}
	$block = new ZeenBlockGrid( $options );
	$block->output();
	echo '</div>';
}

function zeen_fb_coms( $pid = '' ) {
	$color = zeen_get_article_layout_skin( $pid ) == 2 ? 'dark' : 'light';
	$color = zeen_is_light( get_theme_mod( 'skin', '#ffffff' ) ) == true ? $color : 'dark';
	echo '<div class="fb-comments" data-width="100%" data-colorscheme="' . esc_attr( $color ) . '" data-href="' . esc_url( get_the_permalink() ) . '" data-numposts="10"></div>';
}
/**
 * IPL Coms
 *
 * @since 1.0.0
 */
function zeen_ipl_coms( $args = array() ) {
	if ( post_password_required( $args['pid'] ) ) {
		return;
	}
	if ( get_theme_mod( 'fb_comments' ) == 1 ) {
		zeen_fb_coms( $args['pid'] );
		return;
	}
	if ( class_exists( 'Disqus' ) ) {
		echo '<div class="disqus-replace"></div>';
		return;
	}
	$comments = get_comments( array(
		'post_id' => $args['pid'],
		'status' => 'approve',
	) );

	$count = count( $comments );
?>
<div id="comments" class="comments-area">
	<h2 class="comments-title footer-block-title">
		<?php
			// Translators: Number of Comments
			echo esc_attr( sprintf( _n( '%d Comment', '%d Comments', $count, 'zeen' ), $count ) );
		?>
	</h2>
	<?php if ( ! empty( $comments ) ) { ?>
		<ol class="comment-list">
		<?php
			wp_list_comments( array(
				'avatar_size' => 130,
				'style'       => 'ol',
				'short_ping'  => true,
			), $comments );
		?>
		</ol>
	<?php } ?>
	<?php
	comment_form( '', $args['pid'] );
?>
</div><!-- #comments -->
<?php
}

/**
 * Slide In
 *
 * @since 1.0.0
 */
function zeen_slide_in() {
	$is_single = is_single();
	$sliding_post = get_theme_mod( 'sliding_post', 1 ) && apply_filters( 'zeen_slide_in_single_only', $is_single );
	$sliding_global = get_theme_mod( 'sliding_global' );
	$sliding_global_location = get_theme_mod( 'sliding_box_location', 1 );
	if ( empty( $sliding_post ) && ( empty( $sliding_global ) || ( 2 == $sliding_global_location && ! is_front_page() ) ) || zeen_is_bbp() || zeen_is_bp() ) {
		return;
	}
	$customizer = is_customize_preview();
	if ( ! empty( $sliding_post ) && ( 1 == get_theme_mod( 'sliding_post_cookie', 1 ) && isset( $_COOKIE['wp_sliding_box_p'] ) ) && empty( $customizer ) ) {
		if ( empty( $sliding_global ) ) {
			return;
		}
		$sliding_post = '';
	}

	$sliding_post_title = get_theme_mod( 'sliding_post_title', esc_html__( 'More Stories', 'zeen' ) );
	if ( ! empty( $sliding_post ) ) {
		global $post;
		if ( 'product' == $post->post_type ) {
			$sliding_post_title = esc_html__( 'More Products', 'zeen' );
		}
		$source = get_theme_mod( 'sliding_post_source', 1 );
		$date = get_theme_mod( 'sliding_post_date', 1 );
		$args = array( 'fields' => 'ids', 'posts_per_page' => 1, 'post_type' => $post->post_type, 'post__not_in' => array( $post->ID ), 'orderby' => 'rand' );
		if ( $date > 1 ) {
			$length_time = 7 != $date ? 'months' : 'days';
			$args['date_query'] = array(
				array(
					'inclusive' => true,
					'after'  => $date . ' ' . $length_time . ' ago',
				),
			);
		}

		if ( 2 == $source ) {
			$categories = get_the_category( $post->ID );
			$cat_arg = '';
			$i = 1;
			foreach ( $categories as $key ) {
				$cat_arg .= 1 == $i ? $key->term_id : ',' . $key->term_id;
				$i++;
			}
			$args['cat'] = $cat_arg;
		}
		$args = apply_filters( 'zeen_slide_in_args', $args );
		$qry = zeen_qry( $args );

		if ( ! $qry->have_posts() ) {
			wp_reset_postdata();
			return;
		}
	}

	if ( empty( $sliding_post ) && ! empty( $sliding_global ) && ( 1 == get_theme_mod( 'sliding_global_cookie', 1 ) && isset( $_COOKIE['wp_sliding_box'] ) || ( get_theme_mod( 'sliding_global_smallprint' ) == '' && get_theme_mod( 'sliding_global_title' ) == '' && get_theme_mod( 'sliding_global_bg' ) == '' && get_theme_mod( 'sliding_global_code' ) == '' && get_theme_mod( 'sliding_global_subtitle' ) == '' ) ) && empty( $customizer ) ) {
		return;
	}

	echo '<div id="slide-in-box" class="slide-in-box tipi-tile tipi-xs-0 slide-in-';
	if ( empty( $sliding_post ) ) {
		echo '1 subscribe-wrap subscribe-button-1';
	} else {
		echo '2';
	}
	echo '">';
	echo '<i class="tipi-i-close tipi-closer"></i>';
	echo '<div class="content">';
	do_action( 'zeen_promo_box_top' );
	if ( ! empty( $sliding_post ) ) {
		if ( ! empty( $sliding_post_title ) ) {
			echo '<div class="title">' . zeen_sanitize_titles( $sliding_post_title ) . '</div>';// WPCS: XSS OK
		}
		foreach ( $qry->posts as $pid ) {
			$tid = get_post_meta( $pid, '_thumbnail_id', true );
			?>
			<div class="mask"><?php zeen_featured_img( $pid, array( 'width' => 390, 'height' => 390, 'link' => true, 'secondary' => 'off', 'lazy_off' => true, ) ); ?><div class="go-next"><a href="<?php the_permalink( $pid ); ?>"><i class="tipi-i-long-right"></i></a></div></div>

			<div class="entry font-<?php echo (int) get_theme_mod( 'typo_headings', 1 ); ?><?php if ( empty( $tid ) ) { echo ' no-mask'; } ?>"><a href="<?php the_permalink( $pid ); ?>"><?php echo get_the_title( $pid ); ?></a></div>
			<?php
		}
		wp_reset_postdata();
	} else {
		zeen_slide_in_custom();
	}
	do_action( 'zeen_promo_box_bottom' );
	echo '</div>';
	echo '</div>';
}

function zeen_lazy_load_on_off( $content ) {
	if ( get_theme_mod( 'lazy', 1 ) != 1 || is_admin() || is_feed() || is_preview() || false !== strpos( $content, 'zeen-lazy-load' ) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) ) {
		return $content;
	}
	$placeholder = get_template_directory_uri() . '/assets/img/lazy.png';
	$content = str_replace( ' class="', ' class="zeen-lazy-load-base zeen-lazy-load ', $content );
	$content = str_replace( ' src="', ' src="' . esc_url( $placeholder ) . '" data-zeen-src="', $content );
	$content = str_replace( ' srcset="', ' data-zeen-srcset="', $content );
	$content = str_replace( ' sizes="', ' data-zeen-sizes="', $content );

	return $content;
}

function zeen_lazy_load_mm_on_off( $content ) {
	if ( get_theme_mod( 'lazy', 1 ) != 1 || is_admin() || is_feed() || is_preview() || false !== strpos( $content, 'zeen-lazy-load' ) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint() ) ) {
		return $content;
	}
	$placeholder = get_template_directory_uri() . '/assets/img/lazy-l.png';
	$content = str_replace( ' class="', ' class="zeen-lazy-load-base zeen-lazy-load-mm ', $content );
	$content = str_replace( ' src="', ' src="' . esc_url( $placeholder ) . '" data-zeen-src="', $content );
	$content = str_replace( ' srcset="', ' data-zeen-srcset="', $content );
	$content = str_replace( ' sizes="', ' data-zeen-sizes="', $content );

	return $content;
}

/**
 * Slide in data
 *
 * @since 1.0.0
 */
function zeen_slide_in_custom() {

	if ( get_theme_mod( 'sliding_global_title' ) != '' ) {
		?>
		<div class="title font-1"><?php echo zeen_sanitize_titles( get_theme_mod( 'sliding_global_title' ) ); ?></div>
		<?php
	}

	if ( get_theme_mod( 'sliding_global_subtitle' ) != '' ) {
		?>
		<div class="subtitle"><?php echo zeen_sanitize_titles( get_theme_mod( 'sliding_global_subtitle' ) ); ?></div>
		<?php
	}

	if ( get_theme_mod( 'sliding_global_code' ) != '' ) {
		?>
		<div class="content"><?php echo do_shortcode( get_theme_mod( 'sliding_global_code' ) ); ?></div>
		<?php
	}

	if ( get_theme_mod( 'sliding_global_smallprint' ) != '' ) {
		?>
		<div class="small-print"><?php echo zeen_sanitize_titles( get_theme_mod( 'sliding_global_smallprint' ) ); ?></div>
		<?php
	}

	if ( get_theme_mod( 'sliding_global_url' ) != '' ) {
		?>
		<a class="sliding-url" rel="nofollow" href="<?php echo esc_url( get_theme_mod( 'sliding_global_url' ) ); ?>"></a>
		<?php
	}

}

/**
 * Contents
 *
 * @since 1.0.0
 */
function zeen_woo_contents() {
	if ( ! zeen_woo_active() ) {
		return;
	}
	$cart = WC()->cart->get_cart();
	?>
	<div class="tipi-basket-wrap menu sub-menu">
		<div class="basket-contents">
		<?php
		foreach ( $cart as $cart_item_key => $cart_item ) {

			$_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
			$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

		   if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
				$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
				?>
				<div class="basket-item tipi-flex clearfix">
					<div class="img">
					<?php printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key ) ); ?>
					</div>
					<div class="meta">
						<div class="title"><?php echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ); ?></div>
						<div class="price"><?php echo (int) ( $cart_item['quantity'] ); ?> × <?php echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ); ?></div>
					</div>
					<a class="tipi-basket-remove" data-pid="<?php echo (int) ( $product_id ); ?>"><i class="tipi-i-close"></i></a>
				</div>
				<?php
			}
		}
		?>
		</div>
		<?php if ( empty( $cart ) ) { ?>
			<?php $cart_icon = get_theme_mod( 'woo_cart', 1 ); ?>
			<div class="basket-summary empty-basket">
				<i class="tipi-i-cart <?php if ( $cart_icon == 1 ) { ?>tipi-i-cart-1 <?php } else { ?>tipi-i-cart-2<?php } ?>" aria-hidden="true"><span class="tipi-cart-count font-3">0</span></i>
				<div class="empty-notice font-2"><?php esc_html_e( 'Your cart is empty', 'zeen' ); ?></div>
				<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_shop_page_id' ) ) ); ?>" class="shop-home tipi-button button-arrow-r button-arrow"><span class="button-title"><?php esc_attr_e( 'Browse Shop', 'zeen' ); ?></span><i class="tipi-i-arrow-right"></i></a>
			</div>
		<?php } else { ?>

		<div class="basket-summary">
			<div class="subtotal"><span class="subtotal-title"><?php esc_attr_e( 'Subtotal', 'zeen' ); ?></span><?php echo WC()->cart->get_cart_total(); ?></div>
			<div class="tipi-buttons">
				<a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="view-cart tipi-button"><?php esc_attr_e( 'View Cart', 'zeen' ); ?></a>
				<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="checkout tipi-button"><?php esc_attr_e( 'Checkout', 'zeen' ); ?></a>
			</div>
		</div>
		<?php } ?>
	</div>
	<?php
}

/**
 * Before Main Menu Output
 *
 * @since  1.0.0
 */
function zeen_before_main_menu_output( $header_style = '' ) {

	$logo = 'main_menu';
	$args = array();
	if ( $header_style > 50 && $header_style < 58 ) {
		$args['header_style'] = $header_style;
		$logo_p = get_theme_mod( 'logo_p_menu' );
		if ( 53 == $header_style || 54 == $header_style || 55 == $header_style ) {
			if ( ! empty( $logo_p ) ) {
				$logo = 'p_menu';
			}
		} else {
			$logo_menu = get_theme_mod( 'logo_main_menu' );
			if ( ! empty( $logo_p ) && empty( $logo_menu ) ) {
				$logo = 'p_menu';
			}
		}
	}
	zeen_logo( $logo, $args );
}

function zeen_skin_mode( $pid = '' ) {
	if ( get_theme_mod( 'reading_mode' ) != 1 ) {
		return;
	}
	$skin = get_post_meta( $pid, 'zeen_article_layout_skin', true );
	?>
	<a href="#" id="mode__wrap" class="mode__wrap<?php if ( ! empty( $skin ) && 'on' == $skin ) { echo ' mode--dark'; } ?>">
		<span class="mode__inner__wrap tipi-vertical-c tipi-tip tipi-tip-move" data-title="<?php echo esc_attr__( 'Reading Mode', 'zeen' ); ?>">
			<i class="tipi-i-sun"></i>
			<i class="tipi-i-moon"></i>
		</span>
	</a>
	<?php
}

/**
 * Sticky P2
 *
 * @since  1.0.0
 */
function zeen_sticky_p2() {
	if ( ! is_single() || get_theme_mod( 'header_sticky_onoff', 1 ) != 1 ) {
		return;
	}
	global $post;
	echo '<div id="sticky-p2" class="sticky-part sticky-p2">';
	echo '<div class="sticky-p2-inner tipi-vertical-c">';
	echo '<div class="title-wrap">';
	echo '<span class="pre-title reading">';
	esc_html_e( 'Reading', 'zeen' );
	echo '</span>';
	echo '<div class="title" id="sticky-title">';
	the_title();
	echo '</div>';
	echo '</div>';
	echo '<div id="sticky-p2-share" class="share-it tipi-vertical-c';
	if ( apply_filters( 'zeen_menu_share_bold', '' ) == true ) {
		echo ' share-it-2 share-it-bold share-it-count-0 share-it-after tipi-flex';
	}
	echo '">';
	if ( class_exists( 'Lets_Review_API' ) && get_post_meta( $post->ID, '_lets_review_onoff', true ) == 1 ) {
		$options = get_post_meta( $post->ID, '_lets_review_aff_buttons', true );
		if ( ! empty( $options ) ) {
			$font_share = get_theme_mod( 'typo_share_buttons', 1 );
			foreach ( $options as $key ) {
				echo '<a href="' . esc_url( $key['url'] ) . '" class="share-button get-now" rel="nofollow" target="_blank"><span class="share-button-content tipi-vertical-c"><i class="tipi-i-cart-1"></i><span class="social-tip font-' . (int) $font_share . '">' . zeen_sanitize_titles( $key['title'] ) . '</span></span></a>';// WPCS: XSS OK
				break;
			}
		}
	}
	if ( get_theme_mod( 'sticky_menu_share', 1 ) == 1 ) {
		zeen_share( array(
			'pid' => $post->ID,
			'design' => 12,
			'type' => 'facebook',
			'ipl' => true,
		));
		zeen_share( array(
			'pid' => $post->ID,
			'design' => 12,
			'type' => 'twitter',
			'ipl' => true,
		));
	}
	zeen_skin_mode( $post->ID );
	echo '</div>';
	echo '</div>';
	echo '</div>';
}

/**
 * AMP Extra CSS
 *
 * @since  1.0.0
 */
function zeen_amp_extra_css( $amp_template ) {
	?>
	.inline-post {margin: 30px 0; clear: both; border-top: 1px solid #eee; border-bottom: 1px solid #eee; position: relative; padding: 15px 0; width: 100%; }
	.inline-post .block .split-1 {padding: 0; }
	.inline-post .block article {width: 100%; border-bottom: 0; margin-bottom: 0; padding-bottom: 0; }
	.inline-post .block article .title {margin: 0; font-size: 1rem; }
	.inline-post .block article .mask {-webkit-box-flex: 0; -webkit-flex: 0 0 25%; -ms-flex: 0 0 25%; flex: 0 0 25%; max-width: 150px; margin-right: 15px; }
	.inline-post .block article .meta:first-child {padding-left: 0; padding-top: 30px; }
	.inline-post .see-also {font-size: 10px; z-index: 2; position: absolute; background: black; display: inline-block; padding: 0px 10px; color: white; height: 20px; line-height: 20px; top: 15px; }
	.inline-post a {text-decoration: none; }
	.inline-post .preview-mini-wrap {display: -webkit-box; display: -webkit-flex; display: -ms-flexbox; display: flex; -webkit-box-align: center; -webkit-align-items: center; -ms-flex-align: center; align-items: center; }
	.secondary-img, .inline-post .byline  {display: none; }
	.cb-clearfix, .clearfix {zoom: 1; }
	.cb-clearfix, .clearfix:before, .cb-clearfix, .clearfix:after {content: ""; display: table; } .cb-clearfix, .clearfix:after {clear: both; }
	amp-iframe { width: 100%; }
	.amp-wp-comments-link {padding: 0 20px; }
	.cb-aff-button .cb-icon-wrap { display: none; }
	.amp-wp-comments-link a { background: #111; border: 0; color: #fff; text-transform: uppercase; font-size: 12px; letter-spacing: 1px;  width: 100%;
	max-width: none; -webkit-box-sizing: border-box;
	box-sizing: border-box;}
	.amp-wp-comments-link a:hover, .amp-wp-comments-link a:visited, .amp-wp-comments-link a:focus { color: #fff; }
	.amp-wp-article-content amp-img.alignleft { width: 50%; }
	.amp-wp-tax-category a, .amp-wp-tax-tag a { text-decoration: none; background: #eee; padding: 5px 10px; text-transform: uppercase; font-weight: 700; letter-spacing: 1px; font-size: 9px; margin-left: 5px;}
	body {
		background: <?php echo sanitize_hex_color( get_theme_mod( 'amp_body_background', '#fff' ) );// WPCS: XSS OK ?>;
		color: <?php echo sanitize_hex_color( get_theme_mod( 'amp_body_color', '#000' ) );// WPCS: XSS OK ?>;
	}
	.amp-wp-article, .amp-wp-title {
		color: <?php echo sanitize_hex_color( get_theme_mod( 'amp_body_color', '#000' ) );// WPCS: XSS OK ?>;
	}
	a, a:visited{
		color: <?php echo sanitize_hex_color( get_theme_mod( 'amp_body_a_color', '#000' ) );// WPCS: XSS OK ?>;
	}
	.amp-wp-footer {
		text-align: center;
		background: <?php echo sanitize_hex_color( get_theme_mod( 'amp_footer_background', '#111' ) );// WPCS: XSS OK ?>;
	}
	.spon-block {margin-bottom: 15px; }
	.spon-block .title {background: #fee700; text-transform: uppercase; padding: 3px 7px; font-size: 8px; letter-spacing: 2px; color: #333; border-radius: 2px; display: inline-block; margin-right: 15px; }
	.spon-block .spon-img { margin-right: 10px; line-height: 0; }
	.tipi-vertical-c, .tipi-all-c {align-items: center; }
	.tipi-all-c {justify-content: center; }
	.tipi-flex-lcr {flex-direction: row; flex-wrap: wrap; justify-content: flex-start; align-items: center; }
	.tipi-flex-eq-height {align-items: stretch; }
	.tipi-flex-lcr, .tipi-vertical-c, .tipi-all-c, .tipi-flex, .tipi-flex-eq-height {display: -webkit-box;
	display: -webkit-flex;
	display: -ms-flexbox;
	display: flex; }
	.amp-wp-article-content .alignnone, .amp-wp-article-content .aligncenter {  margin-right: -16px;   margin-left: -16px;   max-width: none; }
	.amp-wp-footer, .amp-wp-footer a {
		color: <?php echo sanitize_hex_color( get_theme_mod( 'amp_footer_color', '#fff' ) );// WPCS: XSS OK ?>;
	}
	header.amp-wp-header, header.amp-wp-header a, amp-sidebar#amp-sb a {
		color: <?php echo sanitize_hex_color( get_theme_mod( 'amp_header_color', '#fff' ) );// WPCS: XSS OK ?>;
	}
	.back-top {margin: 20px 0; right: 0; bottom: 0; position: relative; }
	.copyright {font-size: .8em; }
	.related-posts {margin: 40px 0; padding: 0 20px; }
	.related-post a {text-decoration: none; }
	.related-post .mask {float: left; margin-right: 30px; line-height: 0; width: 75px; height: 75px; }
	.related-post {margin-bottom: 30px; }
	header.amp-wp-header {padding: 20px 0; position: sticky; top: 0; z-index: 2;}
	header.amp-wp-header, amp-sidebar {
		background: <?php echo sanitize_hex_color( get_theme_mod( 'amp_header_background', '#111' ) );// WPCS: XSS OK ?>;
	}
	.lets-info-up-skin-1 {     border: 1px solid #ededed; background: #fff;    color: #111; }
	.lets-info-up-skin-2 {background: #111; color: #fff; }
	.lets-info-up-skin-2 a{ color: #fff; }
	.lets-info-up-wrap { width: 55%; margin-bottom: 20px; text-align: center; float: left; margin-right: 20px; }
	.lets-info-up-block-wrap {padding: 30px 15px; }
	.lets-info-up-pretitle {color: #ead125; text-transform: uppercase; font-size: 10px; }
	.lets-info-up-title {font-size: 15px; }
	header.amp-wp-header div {padding: 0; }
	header.amp-wp-header .logo {display: block; margin: 0 auto; padding: 0 20px; line-height: 0; }
	amp-sidebar {width: 80vw; padding: 30px 45px; -webkit-box-sizing: border-box; box-sizing: border-box; }
	amp-sidebar a {text-decoration: none; }
	amp-sidebar li {margin-bottom: 7px; list-style: none; }
	.amp-wp-header .header-right, .amp-wp-header .header-left {margin: 0; width: 25px; padding: 0 15px; }
	.amp-sb-open {width: 12px; height: 2px; position: relative; margin: 0 auto; border-radius: 1px; display: block; }
	.amp-sb-open {
		background: <?php echo sanitize_hex_color( get_theme_mod( 'amp_header_color', '#fff' ) );// WPCS: XSS OK ?>;
	}
	.amp-sb-open:before, .amp-sb-open:after {width: inherit; display: block; height: inherit; border-radius: inherit; background: inherit; content: ''; position: absolute; width: 125%; }
	.amp-sb-logo .logo {margin-bottom: 30px; }
	.amp-sb-open:before {top: -5px; }
	.amp-sb-open:after {top: 5px; }
	.amp-sb-close {width: 20px; height: 20px; position: absolute; top: 30px; right: 15px; }
	.amp-header-logo {
		width: 100%;
	}
	.amp-sb-close:before, .amp-sb-close:after {position: absolute; left: 10px; content: ''; height: 20px; width: 2px; background: #fff; }
	.amp-sb-close:before {transform: rotate(45deg); }
	.amp-sb-close:after {transform: rotate(-45deg); }
	 .share-button-fb {background: #3b5998; margin-right: 20px; }
	amp-social-share.button__share {height: 44px; text-align: center; color: #fff; -webkit-transition: .2s ease-out; transition: .2s ease-out; min-width: calc( 50% - 10px ); margin-bottom: 20px; border-radius: 3px;	}
	.share-button-pin {
		margin-right: 20px;
		background: #bd081c;
	}
	.share-button-tw {
		background: #1da1f2;
	}
	.share-button-wa {
		background: #00ec67;
	}
	.zeen-share-buttons {
		flex-wrap: wrap;
		padding: 20px;
	}
	.header-right {
		margin-left: auto;
	}
	.amp-ad-wrap { text-align: center; margin: 30px 0; }
	<?php
}

/**
 * AMP Meta
 *
 * @since  1.0.0
 */
function zeen_amp_meta( $meta_parts ) {

	if ( get_theme_mod( 'amp_author', 1 ) != 1 ) {
		foreach ( array_keys( $meta_parts, 'meta-author', true ) as $key ) {
			unset( $meta_parts[ $key ] );
		}
	}

	if ( get_theme_mod( 'amp_date', 1 ) != 1 ) {
		foreach ( array_keys( $meta_parts, 'meta-time', true ) as $key ) {
			unset( $meta_parts[ $key ] );
		}
	}

	return $meta_parts;
}

/**
 * AMP AD
 *
 * @since  1.0.0
 */
function zeen_amp_ad( $location = 1 ) {
	$amp_ad = get_theme_mod( 'amp_ad' );
	$amp_ad_onoff = 2 == $location ? get_theme_mod( 'amp_ad_footer' ) : get_theme_mod( 'amp_ad_header' );
	if ( ! empty( $amp_ad ) && ! empty( $amp_ad_onoff ) ) {
		$ad_type = get_theme_mod( 'amp_type' );
		$ad_client = get_theme_mod( 'amp_ad_client' );
		$ad_slot = get_theme_mod( 'amp_ad_slot' );
		?>
		<div class="amp-ad-wrap">
			<amp-ad width=300
			<?php if ( 1 == $ad_type ) { ?>
				type="doubleclick" height=50 data-slot="<?php echo esc_attr( $ad_slot ); ?>">
			<?php } else { ?>
				type="adsense" height=250 data-ad-client="<?php echo esc_attr( $ad_client ); ?>" data-ad-slot="<?php echo esc_attr( $ad_slot ); ?>">
			<?php } ?>
			</amp-ad>
		</div>
		<?php
	}
}
/**
 * AMP Template Parts
 *
 * @since  1.0.0
 */
function zeen_amp_template_parts( $file, $type, $post ) {
	if ( 'footer' === $type ) {
		$file = get_theme_file_path( 'template-parts/AMP/footer.php' );
	} elseif ( 'article-footer' === $type ) {
		$file = get_theme_file_path( 'template-parts/AMP/article-footer.php' );
	} elseif ( 'header-bar' === $type ) {
		$file = get_theme_file_path( 'template-parts/AMP/header-bar.php' );
	}
	return $file;
}

/**
 * AMP Footer Logo
 *
 * @since  1.0.0
 */
function zeen_amp_footer_logo() {
	zeen_logo( 'amp_footer', array( 'amp' => true ) );
}

/**
 * AMP After Content
 *
 * @since  1.0.0
 */
function zeen_amp_after_content() {
	$fb_app_id = get_theme_mod( 'facebook_app_id' );
	?>
<div class="zeen-share-buttons tipi-vertical-c">
	<amp-social-share type="facebook" class="button__share tipi-all-c share-button-fb"
					  data-url="<?php echo esc_url( get_permalink() ); ?>"
					  data-param-app_id="<?php echo esc_attr( $fb_app_id ); ?>"
					  data-media="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>"
					  data-description="<?php the_title_attribute(); ?>">
		<i class="fa fa-facebook"></i>
	</amp-social-share>
	<amp-social-share type="twitter" class="button__share tipi-all-c share-button-tw"
					  data-url="<?php echo esc_url( get_permalink() ); ?>"
					  data-media="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>"
					  data-description="<?php the_title_attribute(); ?>">
		<i class="fa fa-twitter"></i>
	</amp-social-share>
	<amp-social-share type="pinterest" class="button__share tipi-all-c share-button-pin"
					  data-url="<?php echo esc_url( get_permalink() ); ?>"
					  data-media="<?php echo esc_url( wp_get_attachment_url( get_post_thumbnail_id() ) ); ?>"
					  data-description="<?php the_title_attribute(); ?>">
		<i class="fa fa-pinterest"></i>
	</amp-social-share>
	<amp-social-share type="whatsapp" class="button__share tipi-all-c share-button-wa">
		<i class="fa fa-whatsapp"></i>
	</amp-social-share>
</div>
	<?php

	if ( get_theme_mod( 'amp_related_posts', 1 ) != 1 ) {
		return;
	}
	global $post;

	$terms = get_the_terms( $post->ID, 'category' );
	$term_ids = array();
	if ( empty( $terms ) || is_wp_error( $terms ) ) {
		return;
	}

	foreach ( $terms as $key ) {
		$term_ids[] = $key->term_id;
	}

	$args = array( 'category__in' => $term_ids, 'post__not_in' => array( $post->ID), 'posts_per_page' => 4, 'ignore_sticky_posts' => 1 );
	$qry = new wp_query( $args );
	if ( $qry->have_posts() ) {
		?>
		<div class="related-posts">
			<h3><?php esc_attr_e( 'You might also like', 'zeen' ); ?></h3>
			<?php while( $qry->have_posts() ) { ?>
				<?php $qry->the_post(); ?>
				<?php global $post; ?>
				<div class="related-post clearfix">
					<?php $tid = get_post_meta( $post->ID, '_thumbnail_id', true ); ?>
					<?php if ( ! empty( $tid ) ) { ?>
						<div class="mask">
							<a href="<?php the_permalink(); ?>amp/" rel="bookmark" title="<?php the_title_attribute(); ?>">
								<amp-img src="<?php echo esc_url( wp_get_attachment_thumb_url( $tid ) ); ?>" width="75" height="75" alt="<?php the_title_attribute(); ?>" ></amp-img>
							</a>
						</div>
					<?php } ?>
					<div class="title">
						<a href="<?php the_permalink()?>amp/" rel="bookmark" title="<?php the_title_attribute(); ?>"><h4><?php the_title(); ?></h4></a>
					</div>
				</div>
			<?php } ?>
		</div>
		<?php
		wp_reset_postdata();
	}
}

/**
 * AMP Args
 *
 * @since  1.0.0
 */
function zeen_amp_args( $args ) {
	$args[] = 'article-footer';
	return $args;
}

/**
 * Adds prev/next paginated post
 *
 * @since 2.1.0
 */
function zeen_wp_link_pages_args( $args = '' ) {
	global $page, $numpages, $more;

	if ( ! $more ) {
		return $args;
	}
	if ( $page - 1 ) {
		$args['before'] .= _wp_link_page( $page - 1 ) . $args['link_before'] . $args['previouspagelink'] . $args['link_after'] . '</a>';
	}

	if ( $page < $numpages ) {
		$args['after'] = _wp_link_page( $page + 1 ) . $args['link_before'] . ' ' . $args['nextpagelink'] . $args['link_after'] . '</a>' . $args['after']
		;
	}

	return $args;
}
add_filter( 'wp_link_pages_args', 'zeen_wp_link_pages_args' );
