<?php
/**
 * Zeen Helpers
 *
 * @copyright   Copyright Codetipi
 * @since       1.0.0
*/
namespace Zeen;

class ZeenHelpers {

	/**
	 * Args
	 *
	 * @since 1.0.0
	 */
	public static function zeen_args() {

		$output = array();
		$output['sDelay'] = get_theme_mod( 'slider_args_autoplay', 1 ) == 1 ? get_theme_mod( 'slider_args_delay', 5 ) * 1000 : false;
		$output['subL'] = get_theme_mod( 'subscribe_on_leave' ) == 1 ? true : false;
		$output['lazy'] = get_theme_mod( 'lazy', 1 ) == 1 ? true : false;
		$output['iconSorter'] = '<i class="tipi-i-chevron-down"></i>';
		$output['iplComs'] = get_theme_mod( 'ipl_coms' ) == 1 ? true : false;
		$output['heroFade'] = apply_filters( 'zeen_hero_fade_opacity', 0.075 );
		$output['iplMob'] = get_theme_mod( 'ipl_mobile', 1 ) == 1 ? true : false;
		$output['fbComs'] = get_theme_mod( 'fb_comments' ) == 1 ? true : false;
		$output['lightbox'] = get_theme_mod( 'lightbox', 1 ) == 1 ? true : false;
		$output['stickyHeaderCustomize'] = get_theme_mod( 'sticky_header_customize' ) == 1 ? true : false;
		$output['cookieDuration'] = apply_filters( 'zeen_cookie_duration_in_days', 90 );
		$output['searchPpp'] = apply_filters( 'zeen_search_number_of_posts', 3 );
		$disqus = false;
		if ( class_exists( 'Disqus' ) ) {
			$disqus = get_option( 'disqus_forum_url' );
			if ( ! empty( $disqus ) ) {
				$disqus = strtolower( $disqus );
			}
		}
		$output['disqus'] = $disqus;
		$output['subCookie'] = get_theme_mod( 'subscribe_leave_cookie', 1 ) == 1 ? true : false;
		$output['pluginsUrl'] = plugins_url();
		$output['frontpage'] = is_front_page();
		$ipl = apply_filters( 'zeen_infinite_post_ajax', array() );
		if ( class_exists( 'Jetpack_Tiled_Gallery' ) ) {
			$ipl[] = 'jetpack/modules/tiled-gallery/tiled-gallery/tiled-gallery.js';
		}
		if ( class_exists( 'aesopStoryTheme' ) ) {
			$ipl[] = 'aesop-story-engine/public/assets/js/ai-core.min.js';
		}
		if ( class_exists( 'Lets_Review_Blocks' ) ) {
			$ipl[] = 'lets-review/assets/js/functions.min.js';
		}
		$output['ipl'] = $ipl;
		return $output;

	}

	/**
	 * Admin Args
	 *
	 * @since 1.0.0
	 */
	public static function zeen_admin_args() {

		$output = array();
		global $post;

		if ( ! empty( $post->post_type ) ) {
			$output['postType'] = $post->post_type;
			if ( ! empty( $post->ID ) ) {
				$output['builderActive'] = get_post_meta( $post->ID, 'tipi_builder_active', true );
				$button_text = empty( $output['builderActive'] ) ? esc_attr__( 'Create With Tipi Builder', 'zeen' ) : esc_attr__( 'Edit With Tipi Builder', 'zeen' );
				$output['tipiBuilderLogo'] = array( esc_url( get_parent_theme_file_uri( 'inc/builder/assets/img/tipi-builder-mark-s.png' ) ), esc_url( get_parent_theme_file_uri( 'inc/builder/assets/img/tipi-builder-mark-s@2x.png' ) ) );
				$output['buttonLink'] = \TipiBuilder\ZeenAdminActions::zeen_get_url(
					array(
						'item_id' => $post->ID,
					),
					$button_text
				);
			}
		}

		return $output;
	}

}
