<?php
/**
 * Control Alpha Color picker
 *
 * @package Zeen
 * @since 1.0.0
 */
/** 
 * Credit to BraadMartin (thanks dude!): https://github.com/BraadMartin/components/tree/master/customizer/alpha-color-picker
 * License: GPL
 */
class Zeen_Control_Color_A extends WP_Customize_Control {

	/**
	 * Control type
	 *
	 * @since  1.0.0
	 */
	public $type = 'alpha-color';

	/**
	 * Palette support
	 *
	 * @since  1.0.0
	 */
	public $palette;

	/**
	 * Opacity support
	 *
	 * @since  1.0.0
	 */
	public $show_opacity;

	/**
	 * Enqueue control related scripts
	 *
	 * @since 1.0.0
	 */
	public function enqueue() {
		wp_enqueue_script( 'zeen-control-color-a', get_parent_theme_file_uri( '/assets/admin/js/zeen-control-color-a.js' ), array( 'jquery', 'wp-color-picker' ), false, true );
	}

	/**
	 * Render the content of the control
	 *
	 * @since 1.0.0
	 */
	public function render_content() {

		// Process the palette
		if ( is_array( $this->palette ) ) {
			$palette = implode( '|', $this->palette );
		} else {
			// Default to true.
			$palette = ( false === $this->palette || 'false' === $this->palette ) ? 'false' : 'true';
		}

		// Support passing show_opacity as string or boolean. Default to true.
		$show_opacity = ( false === $this->show_opacity || 'off' === $this->show_opacity || 'false' === $this->show_opacity ) ? 'off' : 'on';
		?>
		<label>
			<span class="customize-control-title customize-control-title-top"><?php echo sanitize_text_field( $this->label ); ?><?php
			if ( isset( $this->description ) && '' !== $this->description ) {
				echo '<span class="tipi-tip description customize-control-description dashicons dashicons-editor-help" data-title="' . sanitize_text_field( $this->description ) . '"></span>';
			}
			?></span>
			<div class="customize-control-content">
				<input class="alpha-color-control" type="text" data-show-opacity="<?php echo esc_attr( $show_opacity ); ?>" data-palette="<?php echo esc_attr( $palette ); ?>" data-default-color="<?php echo esc_attr( $this->settings['default']->default ); ?>" data-customize-setting-link="<?php echo esc_attr( $this->setting->id ); ?>">
			</div>
		</label>
		<?php
	}
}
