<?php
/**
 * Zeen block Image
 *
 * @since 1.0.0
 */

class ZeenBlockImage extends ZeenBlocks {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	*/
	public function __construct( $args ) {
		$this->type = 'image';
		parent::__construct( $args );
	}

	/**
	 * Block output
	 *
	 * @since 1.0.0
	 *
	*/
	public function output( $echo = true ) {

		if ( $this->enabled() != true ) {
			return;
		}

		if ( empty( $echo ) ) {
			ob_start();
		}

		$parallax = ! empty( $this->args['parallax'] ) && 'on' == $this->args['parallax'] ? true : false;
		$img_bg = empty( $this->args['img_bg_id'] ) ? '' : $this->args['img_bg_id'];
		$img_link = empty( $this->args['img_link'] ) ? '' : $this->args['img_link'];
		$lightbox = ! empty( $this->args['lightbox'] ) && 'on' == $this->args['lightbox'] ? true : false;
		$new_tab = empty( $this->args['new_tab'] ) ? '' : $this->args['new_tab'];
		$divider_bottom = 'on' == $this->args['divider_bottom_onoff'] && isset( $this->args['divider_bottom'] ) ? $this->args['divider_bottom'] : '';
		$divider_top = 'on' == $this->args['divider_top_onoff'] && isset( $this->args['divider_top'] ) ? $this->args['divider_top'] : '';
		$title = ! empty( $this->args['title_check'] ) && 'on' == $this->args['title_check'] && ! empty( $this->args['title'] ) ? $this->args['title'] : '';
		$png = zeen_is_png( wp_get_attachment_image_src( $this->args['img_bg_id'] ) );
		if ( 'on' == $lightbox ) {
			$img_link = wp_get_attachment_url( $this->args['img_bg_id'] );
		}
		if ( empty( $this->args['only_inner'] ) ) {
			$this->opening_wrap();
			echo '<div class="clearfix mask';
			if ( ! empty( $parallax ) ) {
				echo ' parallax parallax--resized';
			}
			if ( ! empty( $png ) ) {
				echo ' mask-transparent';
			}
			if ( 3 == $divider_bottom || 3 == $divider_top ) {
				echo ' splitter--fade';
				if ( 3 == $divider_bottom ) {
					echo ' splitter--fade--bottom';
				}
				if ( 3 == $divider_top ) {
					echo ' splitter--fade--top';
				}
			}
			echo '">';
		}

		if ( ! empty( $img_bg ) ) {
			echo wp_get_attachment_image( $this->args['img_bg_id'], 'full' );
		}
		if ( 'on' == $this->args['divider_bottom_onoff'] ) {
			zeen_shape( array( 'shape' => $divider_bottom ) );
		}
		if ( 'on' == $this->args['divider_top_onoff'] ) {
			zeen_shape( array( 'shape' => $divider_top, 'location' => 'top' ) );
		}
		if ( empty( $this->args['only_inner'] ) ) {
			echo '</div>';
			if ( ! empty( $img_link ) ) {
				echo '<a href="' . esc_url( $img_link ) . '"  class="overlay';
				if ( 'on' == $lightbox ) {
					echo ' tipi-lightbox';
				}
				echo '"';
				if ( 'on' == $new_tab ) {
					echo ' target="_blank"';
				}
				echo '>';
				echo '</a>';
			}
			if ( ! empty( $title ) ) {
				echo '<div class="meta__wrap meta__wrap_f tipi-all-c title-area mask-overlay">';
				echo '<div class="cta-title cta-title-bg">';
				echo zeen_sanitize_titles( $title );
				echo '</div>';
				echo '</div>';
			}
			$this->closing_wrap();
		}

		if ( empty( $echo ) ) {
			return ob_get_clean();
		}

	}

}
