<?php
/**
 * Zeen block gallery
 *
 * @since 2.5.0
 */

class ZeenBlockGallery extends ZeenBlocks {

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 *
	*/
	public function __construct( $args ) {
		$this->type = 'gallery';
		parent::__construct( $args );
	}

	/**
	 * Block output
	 *
	 * @since 1.0.0
	 *
	*/
	public function output( $echo = true ) {

		if ( $this->enabled() != true ) {
			return;
		}

		if ( empty( $echo ) ) {
			ob_start();
		}

		$lightbox = ! empty( $this->args['lightbox'] ) && 'on' == $this->args['lightbox'] ? true : false;

		if ( empty( $this->args['only_inner'] ) ) {
			$this->opening_wrap();
			echo '<div class="gallery-block__wrap tipi-flex">';
		}

		if ( ! empty( $this->args['gallery'] ) ) {
			$imgs = explode( ',', $this->args['gallery'] );
			$count = count( $imgs );
			$height = 293;
			$width = 293;
			if ( $count == 1 ) {
				$height = 900;
				$width = 900;
			} elseif ( $count == 2 ) {
				$height = 585;
				$width = 585;
			} elseif ( $count == 3 ) {
				$height = 390;
				$width = 390;
			}
			if ( 1 == $this->args['img_shape'] ) {
				$height = 247;
				$width = 370;
				if ( $count == 1 ) {
					$height = 1155;
					$width = 770;
				} elseif ( $count == 2 ) {
					$height = 770;
					$width = 513;
				}
			} elseif ( 3 == $this->args['img_shape'] ) {
				$height = 490;
				$width = 370;
				if ( $count == 1 ) {
					$height = 1020;
					$width = 770;
				} elseif ( $count == 2 ) {
					$height = 775;
					$width = 585;
				}
			}
			$i = 1;
			foreach ( $imgs as $key ) {
				echo '<div class="gallery-block__image';
				$this->animation_class();
				echo '" style="--animation-order:' . (int) $i . '">';
				if ( 'on' == $lightbox ) {
					$img_link = wp_get_attachment_image_src( $key, 'full' );
					echo '<a href="' . esc_url( $img_link[0] ) . '"  class="tipi-i-maximize tipi-lightbox">';
				}
				echo wp_get_attachment_image( $key, 'zeen-' . $width . '-' . $height );
				$caption = wp_get_attachment_caption( $key );
				if ( ! empty( $caption ) ) {
					echo '<span class="caption">' . zeen_sanitize_titles( $caption ) . '</span>';
				}
				if ( 'on' == $lightbox ) {
					echo '</a>';
				}
				echo '</div>';
				$i++;
			}
		}
		
		if ( empty( $this->args['only_inner'] ) ) {
			echo '</div>';
			$this->closing_wrap();
		}

		if ( empty( $echo ) ) {
			return ob_get_clean();
		}

	}

}
