/**
 * Copyright: Codetipi
 * Theme: Zeen
 * Version: 3.2.0
 */
 /* global jQuery, ScrollMagic, zeenJS, IntersectionObserver, imagesLoaded, TweenLite, Power2, Cookies, Linear, Power0, ga, _gaq, zenscroll, FB, DISQUS */
var zeen = ( function($) { "use strict";
	var zeenPrv = {
		init: function() {
			this.dom();
			this.data();
			this.bind();
			this.anis();
			this.sticky();
			this.cta();
			this.sliderInit();
			this.lightboxInit();
			this.sidebars();
			this.infScr();
			this.fillRunner();
			this.mobileMenuClass();
			this.header();
			this.topBlock();
			this.anchorTouch();
			this.parallax3s();
			this.parallaxIt();
			this.noPar();
			this.hero31();
			this.ipl();
			this.imgControl();
			this.postTracks();
			this.qtyArrows();
			this.foldMid();
			this.modalCheck();
			this.topBarMsg();
			this.videoWrap();
			this.videoBg();
			this.woo();
			this.stickyCheck();
			this.stickyEl();
			this.hovererBlock();
			this.twitchLoad();
		},
		woo: function() {
			if ( this.wooArchive === true ) {
				this.$products.imagesLoaded().progress( function( instance, image ) {
  					image.img.parentNode.parentNode.parentNode.classList.add('article-window');
				});
			}
		},
		dom: function() {
			this.$win 				= $( window );
			this.$doc 				= $( document );
			this.$body				= $( 'body' );
			this.$page 				= $( '#page' );
			this.$rtl				= this.$body.hasClass( 'rtl' );
			this.$content			= $( '#content' );
			this.$hovererBlock		= $( '#contents-wrap').find('> .block-wrap-hoverer').add( $( '#contents-wrap').find('> .block-wrap-110 .block-wrap-hoverer') );
			this.$timedPup			= $( '#timed-pup' );
			this.$modal				= $( '#modal' );
			this.$baseOverlay		= $( '#tipi-overlay' );
			this.$skinMode 			= $( '#mode__wrap' );
			this.$modalCustom		= this.$modal.find( '.content-custom' );
			this.$modalSearch		= this.$modal.find( '.content-search' );
			this.$modalSearchField	= this.$modalSearch.find( '.search-field' );
			this.$modalSearchFound	= this.$modalSearch.find( '.content-found' );
			this.$dropSearch		= $( '.drop-search' );
			this.$dropSearchFound	= this.$dropSearch.find( '.content-found' );
			this.$dropSearchField	= this.$dropSearch.find( '.search-field' );
			this.$searchResults = $( '.search-all-results' );
			this.resizing 			= false;
			this.$stickyOff 		= true;
			this.$header 			= $( '#masthead' );
			this.$trendingSecondary = $( '#trending-secondary' );
			this.$siteNav           = $( '#site-navigation' );
			this.$secondaryWrap     = $( '#secondary-wrap' );
			this.$stickyP2    		= $( '#sticky-p2-share' );
			this.$dropper			= this.$siteNav.find( '.horizontal-menu > .dropper' ).add( this.$secondaryWrap.find( '.horizontal-menu > .dropper' ) ).add( this.$header.find( '.horizontal-menu > .dropper' ) );
			this.$dropperChild		= this.$dropper.find( '.block-mm-changer' );
			this.$toolTip			= $( '.tipi-tip' );
			this.$toolTipOutput		= '';
			this.$toolTipCurrent	= '';
			this.headerOne          = this.$header.hasClass( 'main-menu-inline' );
			this.$wpAdminBar 		= $( '#wpadminbar' );
			this.$primary	 		= $( '#primary' );
			this.$verticalMenu 		= $( '#site-header-side-70s' );
			this.$entryContentWrap  = this.$primary.find( '.entry-content-wrap' );
			this.$entryContent	 	= this.$primary.find( '.entry-content' );
			this.$parentAnimation   = this.$primary.find( '.parent-animation:not(.loaded)' );
			this.$toTopWrap			= $( '#to-top-wrap' );
			this.$toTopA 			= $( '#to-top-a' );
			this.$progress			= $( '#progress' );
			this.$mobBotShare		= $( '#mob-bot-share' );
			this.$iplTitle			= $( '#sticky-title' );
			this.$slideIn			= $( '#slide-in-box' );
			this.$slideInX			= this.$slideIn.find( '> .tipi-closer' );
			this.$slideForm			= this.$slideIn.find( 'form' );
			this.slideInScene		= '';
			this.foldMidScene	 	= '';
			this.mobMenuClearTO		= '';
			this.resizeTo			= '';
			this.pubTimer			= '';
			this.qvWrapCache		= '';
			this.ticking			= false;
			this.$sorter			= $( '.sorter' );
			this.$topBarMsg			= $( '#top-bar-message' );
			this.$topBlock			= $( '#zeen-top-block' );
			this.imgAni				=  document.getElementsByClassName( 'article-ani' );
			this.$footer			= $( '#colophon' );
			this.$footerBgArea		= this.$footer.find( '.bg-area' );
			this.stickyVertical 	= false;
			this.$stickyMenu		= $( '.sticky-menu' );
			this.stickyMenu 		= false;
			this.stickyMobMenu		= false;
			this.$hero31			= $( '.hero-31 > .hero' );
			this.$controller 		= new ScrollMagic.Controller();
			this.$parallaxItCont	= new ScrollMagic.Controller();
			this.$parallax3sController = new ScrollMagic.Controller();
			this.progressScene      = '';
			this.$main 				= $( '#main' );
			this.ignoreCodes		= [9, 13, 16, 17, 18, 20, 32, 45, 116, 224, 93, 91];
			this.timer				= 0;
			this.headerIsSticky		= false;
			this.$slideInMenu		= $( '#slide-in-menu' );
			this.$slideMenuOpen 	= $( '.slide-menu-tr-open' );
			this.$mobMenuOpen 		= $( '.mob-tr-open' );
			this.$mobMenuClose 		= $( '.mob-tr-close' );
			this.$mobHead			= $( '#mobhead' );
			this.$mobMenu 			= this.$mobHead.find( '.mobile-navigation' ).add( $( '#mob-menu-wrap' ).find( '.mobile-navigation' ) );
			this.$mobMenuChildren	= this.$mobMenu.find( '.menu-item-has-children' );
			this.thePaged			= zeenJS.qry.paged || 1;
			this.audio 				= new Audio();
			this.video 				= document.createElement( 'video' );
			this.ajaxCall			= '';
			this.ajaxData			= {};
			this.wooArchive         = '';
			this.$products 			= '';
			this.headAreaHeight 	= 0;
		},
		verticalMenus: function() {
			if ( this.$verticalMenu.length === 0 ) {
				return;
			}
			this.$verticalMenu.addClass( 'v-70-vis' );

		},
		data: function() {
			this.$docHeight			= this.$doc.height();
			this.$winWidth			= this.$win.width();
			this.$winHeight			= this.$win.height() + 1;
			this.$headerHeight      = this.$header.outerHeight( true );
			this.$wpAdminBarHeight = 0;
			this.$wpAdminBarHeightNeg = 0;
			if ( this.$body.hasClass( 'admin-bar' ) && ! this.$body.hasClass( 'tipi-builder-frame-inner' ) ) {
				this.$wpAdminBarHeight = this.$winWidth > 783 ? 32 : 46;
				this.$wpAdminBarHeightNeg = '-' + this.$wpAdminBarHeight;
			}

			this.mmAni = 0;
			if ( this.$body.hasClass( 'mm-ani-3' ) ) {
				this.mmAni = 3;
			}

			if ( this.$body.hasClass( 'term-woocategory' ) || this.$body.hasClass( 'post-type-archive-product' ) || this.$body.hasClass( 'woocommerce-page' ) ) {
				this.wooArchive = true;
				this.$products = this.$entryContentWrap.find( '.products' );
			}

        	if ( zeenPrv.$winWidth < 767 ) {
        		this.headAreaHeight = this.$mobHead.outerHeight();
        	} else {
	        	if ( this.$header.hasClass( 'sticky-menu-1' ) || this.$header.hasClass( 'sticky-menu-3' )  ) {
	        		this.headerIsSticky = true;
	        		this.headAreaHeight = this.$headerHeight;
	        	}

	        	if ( this.$siteNav.hasClass( 'sticky-menu-1' ) || this.$siteNav.hasClass( 'sticky-menu-3' ) ) {
	        		this.headerIsSticky = false;
	        		this.headAreaHeight = this.$siteNav.outerHeight();
	        	}
        	}

			var passiveSupported = false;
			try {
			  var options = Object.defineProperty({}, "passive", {
			    get: function() {
			      passiveSupported = true;
			    }
			  });
			  window.addEventListener("zeen", options, options);
			  window.removeEventListener("zeen", options, options);
			} catch(err) {
			  passiveSupported = false;
			}
			this.$listener = passiveSupported ? { passive: true } : false;
		},
		bind: function() {
			this.$win.on( 'resize', this.resize.bind( this ) );
			this.$win.on( 'orientationchange', this.orientationchange.bind( this ) );

			this.$toTopA.on( 'click', this.toTopInit );
			this.$doc.on( 'keyup', this.keyUp.bind( this ) );
			this.$body.on( 'click touchstart', '.block-more', this.blockMore );
			this.$body.on( 'click', '.inf-load-more', this.loadMoreButton );
			this.$body.on( 'click', '.media-tr, .modal-tr', this.modalOn );
			this.$body.on( 'click', '.close, .tipi-overlay', this.modalOff );
			if ( this.$body.hasClass( 'body--mobile--limit' ) ) {
				this.$body.on( 'click', '.mobile--limiter', this.mobLimiter );
			}

			if ( this.$modalSearchFound.length > 0 ) {
				this.$modalSearchField.on( 'keyup', this.liveSearch );
			}
			if ( this.$skinMode.length > 0 ) {
				this.$skinMode.on( 'click', this.skinMode );
			}
			if ( this.$dropSearchFound.length > 0 ) {
				this.$dropSearchField.on( 'keyup', function( event ) {
					var wrapper = $( this ).parent().parent();
            		var args = {
	                	'field': $( this ),
	                	'wrapper': wrapper,
	                	'ppp': 2,
	                	'results': wrapper.find( '.content-found' ),
	                };
					zeenPrv.liveSearch( event, args );
				});
			}
			if ( this.$dropSearchFound.length > 0 || this.$modalSearchFound.length ) {
				this.$searchResults.on( 'click', this.liveSearchTr );
			}

	        this.$siteNav.find( '.horizontal-menu' ).add( this.$secondaryWrap.find( '.horizontal-menu' ) ).add( this.$header.find( '.horizontal-menu' ) ).menuAim({
	            activateCallback: zeenPrv.menuAc,
	            deactivateCallback: zeenPrv.menuDeac,
	            submenuDirection: 'below',
	            openClassName: 'active',
	            tolerance: 0,
	            exitMenuCallback: zeenPrv.menuEx,
	        });

			this.$body.on( 'click', '.trending-op', this.trending );

			this.$mobMenuClose.on( 'click', this.closeMobMenu.bind( this ) );
			this.$mobMenuOpen.on( 'click', this.openMobMenu.bind( this ) );
			this.$mobMenu.on( 'click', '.open-child', this.verticalMenuShow );

			this.$slideMenuOpen.on( 'click', this.openSlideMenu.bind( this ) );

			this.$toolTip.on( 'mouseenter', this.toolTipInit );

			this.$body.on( 'click', '.tipi-like-count', this.likes );
			this.$slideInX.on( 'click', this.slideInPX.bind( this ) );
			this.$slideForm.on( 'submit', this.slideInSubmit.bind( this ) );
			this.$sorter.on( 'click', this.sorter );

			this.$body.on( 'click', '.tipi-basket-remove', this.removeBasket );
			this.$body.on( 'click', '#qty-plus', this.qtyArrowChange );
			this.$body.on( 'click', '#qty-minus', this.qtyArrowChange );
			this.$doc.on( 'updated_wc_div', function() {
				zeenPrv.qtyArrows();
			} );
			this.$win.load( function() {
				zeenPrv.loaded();
			});

			this.$dropperChild.hoverIntent( this.blockMore );
		},
		trending: function( e ) {
			var $selected = $( this );
			var $uid = $selected.parent().data( 'uid' );
			var $blockData = $( '#block-wrap-' + $uid );
			var $blockLoading = $blockData.find( ' > div' );
			if ( $blockLoading.hasClass( 'loading' ) ) {
				return;
			}
			var paged = $selected.data( 'r' ),
				trendingName = 'now';
			if ( paged === 1 ) {
				paged = 2;
			} else if ( paged === 2 ) {
				paged = 7;
				trendingName = 'week';
			} else {
				paged = 30;
				trendingName = 'month';
			}
			$selected.siblings().removeClass( 'trending-selected' );
			$selected.addClass( 'trending-selected' );
			var setter = 'zeen_' + $uid;
			var blockData = window[ setter ];
			var args = { blockData: blockData, $blockData: $blockData, changer: false, append: 2, manual: true, response: '', mm: true };
			$.ajax({
			    method: "GET",
			    data: {
			    	uid: $uid,
					mm: true,
					excerpt_off: true,
					counter: true,
					counter_class: 'border',
					byline_off: true,
					review_off: true,
					data: blockData,
					trending: [ 'zeen-trending-' + trendingName, paged ],
				},
				dataType: 'html',
			    url: zeenJS.root + 'block',
			    beforeSend: function( xhr ) {
			    	$blockLoading.addClass( 'loading' );
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
			        if ( zeenPrv.ajaxChecker( setter + '_' + paged) ) {
			        	args.response = zeenPrv.ajaxGetter( setter + '_' + paged );
						zeenPrv.ajaxLoadMore( args );
						$blockData.addClass( 'loaded' );
						return false;
			    	}
			    },
			    success : function( response ) {
			    	response = JSON.parse( response );
					args.response = response;
					zeenPrv.ajaxLoadMore( args );
			    	zeenPrv.ajaxSetter( setter + '_' + paged, response );
					$blockData.addClass( 'loaded' );
			    },
			    fail : function( response ) {
			        console.log( 'ERROR', response );
			    }
			});
		},
		hovererBlock: function() {
			if ( this.$hovererBlock.length === 0 ) {
				return;
			}
			this.$hovererBlock.each( function() {
				var _this = $( this ),
				maskWrap = _this.find('.mask__wrap'),
				article = _this.find('article');
				article.on( 'mouseenter mouseleave', function( e ) {
					var _thisArticle = $( this ),
						selection = _thisArticle.data('i'),
						excerpt = _thisArticle.find('.excerpt');
						_thisArticle.siblings().removeClass('selected');
					if ( e.type === 'mouseenter' ) {
						maskWrap.children().removeClass('selected');
						_thisArticle.addClass('selected');
						maskWrap.find( "> [data-i='" + selection + "']" ).addClass('selected');
						if ( excerpt.length > 0 ) {
							TweenLite.set(excerpt, {height:"auto", opacity: 1})
						    TweenLite.from(excerpt, 0.3, {height:0, opacity: 0, ease: "power4.inOut"})
						} else {
							_thisArticle.addClass('no-excerpt__ani');
						}
					} else {
						if ( excerpt.length > 0 ) {
						    TweenLite.to(excerpt, 0.3, {height:0, opacity: 0, ease: "power4.inOut"})
						} else {
							_thisArticle.removeClass('no-excerpt__ani');
						}
					}
				});

			});
		},
		anchorTouch: function() {
			var touch = 'ontouchstart' in document.documentElement ? true : false;

			this.$dropper.each( function( index, elem ) {
				var dropper = $( this ), dropperA = dropper.find( '> a' ), href = dropperA.attr( 'href' );
				if ( typeof href !== 'undefined' && href.indexOf( '#' ) > -1  ) {
			        dropperA.on( 'click.anchor', function( e ) {
			        	var targetY = 0,
							targetElem = document.getElementById( href.split( '#' )[1] );
						if ( href !== "#" ) {
							if ( ! targetElem ) {
								return;
							}
							targetY = zenscroll.getTopOf( targetElem );
						}
						e.preventDefault();
						zenscroll.toY( ( targetY - zeenPrv.headAreaHeight - zeenPrv.$wpAdminBarHeight ), null);
			        });
				}
				if ( touch === false ) {
					return true;
				}
				if ( dropper.find( '> .menu' ).length > 0 ) {
					dropperA.on( 'click', function( e ) {
		                var current = $( this );
		                dropper.siblings( '.tapped' ).removeClass( 'tapped' );
		                if ( ( ( dropper.find( '.menu' ).length === 0 && dropper.find( '.sub-menu' ).length === 0 ) || dropper.hasClass( 'tapped' ) ) && current.attr( 'href' ) !== '#' ) {
		                    return true;
		                } else {
		                    e.preventDefault();
		                    dropper.addClass( 'tapped' );
		                }
		            });
				}
			});

		},
		topBlock: function() {
			if ( this.$topBlock.length === 0 || this.$topBlock.hasClass( 'standard-ani' ) || this.$topBlock.hasClass( 'loaded' ) ) {
				return;
			}
			var _this = this;
			this.$topBlock.imagesLoaded().always( function( instance ) {
				var duration = _this.$topBlock.outerHeight( true );
				var args = { y: 100, opacity: 0.3 };
				if ( _this.$winWidth > 767 ) {
					if ( _this.$topBlock.hasClass( 'zeen-top-block-92' ) || _this.$topBlock.hasClass( 'zeen-top-block-94' ) ) {
						args  = { opacity: 0.3 };
					}
				}
				new ScrollMagic
                .Scene( {triggerElement: 'body', offset: 0, duration: duration, triggerHook: 0 })
                .setTween( _this.$topBlock.find( 'img' ), args )
                .addTo( zeenPrv.$controller );
                _this.$topBlock.addClass('loaded');
			});
		},
		anis: function( e ) {
			this.tempAni();
			this.loopAni();
			this.blockAni();
		},
		lrTempAni: function() {
			var box = document.querySelectorAll( '.lets-review-unseen' ),
				observer = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry) {
					if ( entry.intersectionRatio > 0 ) {
						entry.target.classList.add('lets-review-seen' );
			            observer.unobserve(entry.target);
					}
				});
			}, { threshold: [0] });
			for ( var i = box.length - 1; i >= 0; i-- ) {
				observer.observe( box[i] );
			}
		},
		tempAni: function() {
			var ani = document.getElementsByClassName( 'ani-base' ),
				observer = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry) {
					if ( entry.isIntersecting ) {
						imagesLoaded( entry.target, function( instance ) {
							entry.target.classList.add('article-window');
						});
						entry.target.classList.remove('article-ani');
						var revs = entry.target.getElementsByClassName('lets-review-api-wrap');

						if ( revs.length > 0 && ( entry.target.parentElement.classList.contains('preview-review-bot' ) || entry.target.parentElement.parentElement.classList.contains( 'preview-review-bot' ) ) ) {
							setTimeout(function() {
							entry.target.classList.add( 'review-ani-done' );
								TweenLite.fromTo( revs[0], 1, { width: '0' }, { width: revs[0].getAttribute('data-api-100') + '%', ease: Power2.easeOut } );
							}, 300);
						}
						observer.unobserve(entry.target);
					}
				});
			}, { threshold: [0] });
			for ( var i = ani.length - 1; i >= 0; i-- ) {
				if ( ! ani[i].classList.contains('article-window') ) {
					observer.observe( ani[i] );
				}
			}

			var blockToSee = document.getElementsByClassName( 'block-to-see' ),
				blockToSeeObs = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry ) {
					if ( entry.isIntersecting ) {
						entry.target.classList.add('tipi-seen');
						blockToSeeObs.unobserve(entry.target);
					}
				});
			}, { threshold: [0], rootMargin: '-100px 0px', });
			for ( i = blockToSee.length - 1; i >= 0; i-- ) {
				if ( ! blockToSee[i].classList.contains('tipi-seen') ) {
					blockToSeeObs.observe( blockToSee[i] );
				}
			}
			var iLazy = document.getElementsByClassName( 'zeen-iframe-lazy-load' ),
				ilazyObs = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry ) {
					if ( entry.isIntersecting ) {
						ilazyObs.unobserve(entry.target);
						zeenPrv.iframeAttrLoad(entry.target);
					}
				});
			}, { threshold: [0], rootMargin: '150px 0px', });
			for ( var i = iLazy.length - 1; i >= 0; i-- ) {
				if ( ! iLazy[i].classList.contains( 'zeen-lazy-loaded' ) ) {
					ilazyObs.observe( iLazy[i] );
				}
			}
			if ( zeenJS.args.lazy !== true ) {
				return;
			}
			var lazy = document.getElementsByClassName( 'zeen-lazy-load' ),
				lazyObs = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry ) {
					if ( entry.isIntersecting ) {
						lazyObs.unobserve(entry.target);
						zeenPrv.imgAttrLoad(entry.target);
					}
				});
			}, { threshold: [0], rootMargin: '600px 0px', });
			for ( i = lazy.length - 1; i >= 0; i-- ) {
				if ( ! lazy[i].classList.contains( 'zeen-lazy-loaded' ) ) {
					lazyObs.observe( lazy[i] );
				}
			}
		},
		imgAttrLoad: function( img, imgLdd ) {
			var src = img.getAttribute('data-zeen-src');
			var srcset = img.getAttribute('data-zeen-srcset');
			var sizes = img.getAttribute('data-zeen-sizes');
			if ( src ) {
  				img.src = src;
  				img.removeAttribute('data-zeen-src');
			}
			if ( srcset ) {
  				img.srcset = srcset;
  				img.removeAttribute('data-zeen-srcset');
			}
			if ( sizes ) {
  				img.sizes = sizes;
  				img.removeAttribute('data-zeen-sizes');
			}
			if ( imgLdd === true ) {
				imagesLoaded( img, function( instance ) {
					instance.images[0].img.classList.remove( 'zeen-lazy-load' );
					instance.images[0].img.classList.add( 'zeen-lazy-loaded' );
				});
			} else {
				img.classList.remove( 'zeen-lazy-load' );
				img.classList.add( 'zeen-lazy-loaded' );
			}
		},
		iframeAttrLoad: function( iframe ) {
			var iframeChild = iframe.firstElementChild,
				src = iframeChild.getAttribute('data-zeen-src');
			var ifrm = document.createElement('iframe');
        		ifrm.setAttribute('src', src );
        		ifrm.setAttribute('seamless', 'seamless' );
        		ifrm.setAttribute('frameborder', 0 );
        		ifrm.setAttribute('scrolling', 'no' );
        		ifrm.classList.add('frame');
				iframeChild.insertAdjacentElement( 'afterend', ifrm );
			$(ifrm).load(function() {
				ifrm.classList.add( 'loaded' );
			});
			iframe.classList.add('zeen-lazy-loaded');
			iframe.removeChild( iframeChild );
		},
		mobLimiter: function( e ) {
			e.preventDefault();
			$( this ).closest( '.post-wrap' ).addClass( 'mobile--limiter--more' );
			zeenPrv.progressScene.destroy();
			zeenPrv.postTracks();
		},
		loopAni: function( e ) {
			if ( this.$winWidth < 1200 ) {
				return;
			}
			this.$primary.find( '> .post-wrap' ).each( function() {
				var current = $(this);
				if ( current.hasClass( 'loop-ani-checked' ) ) {
					return true;
				}
				if ( current.hasClass( 'align-fade-up' ) || current.hasClass( 'align-fade-up-done' ) ) {
					var effect = current.hasClass( 'align-fade-up' ) ? 'fade-up' : 'fade-up-done';
					var ani = current.find( '.alignleft, .alignright' ),
						observer = new IntersectionObserver(function (entries) {
						entries.forEach(function (entry) {
							if ( entry.boundingClientRect.top > 0 ) {
								entry.target.classList.add('tipi-seen');
								if ( effect === 'fade-up-done' ) {
									observer.unobserve(entry.target);
								}
								if ( entry.isIntersecting === false  ) {
									entry.target.classList.remove('tipi-seen');
								}
							}
						});
					}, { threshold: [0], rootMargin: '500px 0px 0px 0px' });
					for ( var i = ani.length - 1; i >= 0; i-- ) {
						observer.observe( ani[i] );
					}
				}
				current.addClass('loop-ani-checked');
			});
		},
		blockAni: function() {
			var ani = document.getElementsByClassName( 'block-ani' );
			if ( ani.length === 0 ) {
				return;
			}
			var observer = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry) {
					if ( entry.isIntersecting ) {
						entry.target.classList.add('loaded');
						observer.unobserve(entry.target);
					}
				});
			}, { threshold: [0] });
			for ( var i = ani.length - 1; i >= 0; i-- ) {
				if ( ! ani[i].classList.contains('loaded') ) {
					observer.observe( ani[i] );
				}
			}
		},
		twitchLoad: function() {
			var ani = document.getElementsByClassName( 'twitch' );
			if ( ani.length === 0 ) {
				return;
			}

			var observer = new IntersectionObserver(function (entries) {
				entries.forEach(function (entry) {
					if ( entry.isIntersecting ) {
						var tw = $( entry.target );
				      	tw.append( '<iframe width="1280" height="720" scrolling="no" class="twitch-frame" src="' + tw.data( 'src' ) + '" frameborder="0" seamless="seamless" allowfullscreen="true"></iframe>' );
						tw.find('iframe').load(function() {
							tw.addClass( 'ani-in loaded' );
						});
						observer.unobserve(entry.target);
					}
				});
			}, { threshold: [0] });
			for ( var i = ani.length - 1; i >= 0; i-- ) {
				if ( ! ani[i].classList.contains('loaded') ) {
					observer.observe( ani[i] );
				}
			}
		},
		sorter: function() {
			var $sorter = $( this );

			if ( $sorter.hasClass( 'load-more-wrap' ) ) {
				return;
			}
			zeenPrv.activeFocus( $sorter );
		},
		activeFocus: function( el ) {
			if ( el.hasClass( 'active' ) ) {
				el.blur();
			    el.removeClass( 'active' );
				return;
			}
			el.addClass( 'active' );
			if ( 'ontouchstart' in document.documentElement ) {
				zeenPrv.$doc.on( 'touchstart', function( e ) {
					el.removeClass( 'active' );
					zeenPrv.$doc.off( 'touchstart' );
					el.off( 'touchstart' );
				});
				el.on( 'touchstart', function( e ) {
				    e.stopPropagation();
				});
			} else {
				el.focus();
				el.on({
				  focusout: function() {
					el.data( 'timer', setTimeout( function() {
				    	el.removeClass( 'active' );
				  		el.off( 'focusin focusout' );
				    }, 0 ) );
				  },
				  focusin: function() {
				  	clearTimeout( el.data( 'timer' ) );
				  }
				});
			}
		},
		loading: function( el, status ) {
			if ( status === 'on' ) {
				el.addClass( 'loading' );
			} else {
				el.removeClass( 'loading' );
			}
		},
		slideInP: function() {
			if ( this.$slideIn.length === 0 || this.$winWidth < 767 ) {
				return;
			}

			var trigger = this.$content, offset = this.$winHeight * 2;
			if ( this.$slideIn.hasClass( 'slide-in-2' ) ) {
				// Wrap used for vertical galleries and sticky gets shifted
				if ( this.$entryContentWrap.length > 0 ) {
					trigger = this.$entryContentWrap;
					offset = trigger.outerHeight( true );
				}
			}
			if ( ( offset + trigger.offset().top ) > ( this.$docHeight ) ) {
				offset =  trigger.offset().top;
			}
			if ( this.$body.hasClass('single-product') ) {
				offset = offset * 0.4;
			}
			this.slideInScene = new ScrollMagic.Scene({triggerElement: trigger, offset: offset, triggerHook: 0.75 } )
				.addTo( zeenPrv.$controller )
				.setClassToggle( this.$body, 'slide-in-active' )
				.setClassToggle( this.$slideIn, 'active' );
		},
		slideInPX: function() {
			this.$body.removeClass( 'slide-in-active' );
			if ( this.$slideIn.hasClass( 'slide-in-1' ) ) {
				this.turnItOff( 1 );
			}
			if ( this.$slideIn.hasClass( 'slide-in-2' ) ) {
				this.turnItOff( 2 );
			}
			this.slideInScene.destroy( true );
		},
		slideInSubmit: function() {
			this.turnItOff( 1 );
		},
		turnItOff: function( arg ) {
			if ( arg === 1 ) {
				Cookies.set( 'wp_sliding_box', 'off', { expires: zeenJS.args.cookieDuration } );
			} else if ( arg === 2 ) {
				Cookies.set( 'wp_sliding_box_p', 'off', { expires: zeenJS.args.cookieDuration } );
			} else if ( arg === 3 ) {
				Cookies.set( 'wp_timed_pp', 'off', { expires: zeenJS.args.cookieDuration } );
			} else if ( arg === 4 ) {
				Cookies.set( 'wp_top_bar', 'off', { expires: zeenJS.args.cookieDuration } );
			}  else if ( arg === 5 ) {
				Cookies.set( 'subL', 'off', { expires: zeenJS.args.cookieDuration } );
			}
		},
		topBarMsg: function() {
			if ( this.$topBarMsg.length === 0 ) {
				return;
			}
			$( '#top-bar-message-close' ).on( 'click', function() {
				var closer = $( this );
				zeenPrv.$topBarMsg.slideUp();
				closer.off( 'click' );
				zeenPrv.turnItOff( 4 );
			});
		},
		timedPup: function() {
			if ( this.$timedPup.length === 0 ) {
				return;
			}
			var timer = this.$timedPup.data( 't' ), disable = this.$timedPup.data( 'd' ), _this = this;
			if ( typeof timer === 'undefined' ) {
				timer = 15000;
			} else {
				timer = timer * 1000;
			}
			setTimeout( function() {
				_this.modalOff();
				_this.$body.addClass( 'modal-active' );
				_this.$baseOverlay.addClass( 'active' );
				_this.$timedPup.addClass( 'active' );
				if ( disable === 1 ) {
					_this.$baseOverlay.on( 'click', function() {
						_this.turnItOff( 3 );
						_this.$baseOverlay.off( 'click' );
					});
				}
			}, timer);
		},
		postTracks: function() {
			if ( this.$progress.length === 0 && this.$mobBotShare.length === 0 ) {
				return;
			}
			this.$entryContent.each( function( index, elem ) {
				var $elem = $( elem );
				if ( $elem.hasClass( 'sticky-el' ) ) {
					return true;
				}
				$elem.addClass( 'progresson' );
				$elem.find( 'img' ).imagesLoaded( function() {
					var $elemOuter = $elem.outerHeight( true );
					zeenPrv.progressScene = new ScrollMagic.Scene({triggerElement: $elem, duration: $elemOuter, triggerHook: 0.5 } )
						.addTo( zeenPrv.$controller )
						.on( "enter leave", function( e ) {
							if ( e.type === 'leave' ) {
								zeenPrv.$progress.add( zeenPrv.$mobBotShare ).addClass( 'inactive' ).removeClass( 'active' );
							} else {
								zeenPrv.$progress.add( zeenPrv.$mobBotShare ).removeClass( 'inactive' ).addClass( 'active' );
							}
						});
					if ( zeenPrv.$progress.length !== 0 ) {
						if ( zeenPrv.$winHeight < ( $elemOuter + 50 ) || zeenPrv.$body.hasClass('ipl-done') ) {
							zeenPrv.progressScene.setTween( TweenLite.fromTo( zeenPrv.$progress, 3, { width: '0' }, { width: '100%', ease: Power0.easeNone } ) );
						}
					}
				});
			});

		},
		keyUp: function( e ) {
			if ( this.$modal.hasClass( 'inactive' ) && ! this.$body.hasClass( 'slide-menu-open' ) ) {
				return;
			}
			var keyCheck = false;

			if ( 'key' in e ) {
		        keyCheck = ( e.key === 'Escape' || e.key === 'Esc' );
		    } else {
		        keyCheck = ( e.keyCode === 27 );
		    }

			if ( keyCheck !== false ) {
				this.closeSlideMenu( e );
            	this.modalOff();
	        }
		},
		header: function( resize ) {

			if ( this.$winWidth > 767 ) {
				var isStickyTop = false;

				if ( this.$header.hasClass( 'sticky-top' ) && ! this.$header.hasClass( 'evented' ) ) {
					var offset = this.getDetails( this.$header );
					window.addEventListener( 'scroll', function(e) {
						  var currentScroll = window.pageYOffset || document.documentElement.scrollTop;
						  if ( ! zeenPrv.ticking ) {
						    window.requestAnimationFrame(function() {
								if ( currentScroll > Math.min( 45, zeenPrv.$headerHeight ) && currentScroll >= offset.top - zeenPrv.$wpAdminBarHeight ) {
									if ( ! zeenPrv.$body[0].classList.contains('sticky-header--active') ) {
										zeenPrv.$body[0].classList.add('sticky-header--active');
									}
								} else {
									zeenPrv.$body[0].classList.remove('sticky-header--active');
								}
								zeenPrv.ticking = false;
						    });
						    zeenPrv.ticking = true;
						  }
					}, zeenPrv.$listener );
					isStickyTop = true;
					this.$header.addClass( 'evented' );
				}
				if ( zeenJS.args.stickyHeaderCustomize === true && ( isStickyTop || this.$header.hasClass( 'sticky-menu' ) ) ) {
					var logo = this.$header.find( '.logo-main img' );
					logo.imagesLoaded( function() {
						logo.css( 'height', '' ).css( 'height', logo.height() );
						zeenPrv.$header.css( 'height', '' ).css( 'height', zeenPrv.$headerHeight ).addClass( 'size-set' );
					});
				}
			}
		},
		mobileMenuClass: function() {
			this.$mobMenuChildren.find( '> a' ).after( '<a href="#" class="open-child"><i class="tipi-i-chevron-down"></i></a>' );
		},
		verticalMenuShow: function( e ) {
	        e.preventDefault();
	        var currentVerticalMenu = $( this );
	        var currentParent = currentVerticalMenu.parent();
	        var currentSiblings = currentParent.siblings( '.menu-item-has-children' );
	        currentSiblings.find('> .opened-child').removeClass('opened-child');
	        currentSiblings.find('> .child-is-open').removeClass('child-is-open');
	        var currentVerticalSubMenu = currentParent.find( '> .sub-menu' );
	        if ( currentVerticalMenu.hasClass( 'child-is-open' ) ) {
	            currentVerticalMenu.removeClass( 'child-is-open' );
	            currentVerticalSubMenu.removeClass( 'opened-child' );
	        } else {
	            currentVerticalMenu.addClass( 'child-is-open' );
	            currentVerticalSubMenu.addClass( 'opened-child' );
	        }

		},
		 secondaryImgs: function( event ) {
		 	var hovered = $( this );
            if ( event.type === 'mouseenter' ) {
                hovered.addClass( 'hovering' );
            } else {
                hovered.removeClass( 'hovering' );
            }
        },
        stickyCheck: function() {
        	 var el = document.createElement('a'),
				check = el.style;
			check.cssText = "position:sticky;position:-webkit-sticky;";
			this.$stickyOff = check.position.indexOf('sticky')!==-1;
			if ( this.$stickyOff === false ) {
				this.$body.addClass('sticky-disabled');
			}
        },
        stickyEl: function() {
        	var spacing;
        	if ( this.headAreaHeight === 0 || this.$stickyOff === false ) {
        		return;
        	}
        	$( '.sticky-el' ).each( function( index, elem ) {
        		var $elem = $( this );
	        	if ( $elem.hasClass( 'block-wrap' ) && parseInt( $elem.find('> .tipi-row-inner-style').css( 'padding-top' ) ) > 0 ) {
	        		spacing = 0;
	        	} else {
	        		spacing = 30;
	        	}
	        	if ( zeenPrv.$winWidth < 767  ) {
	        		spacing = 15;
	        	}
        		$elem.css( 'top', zeenPrv.headAreaHeight + zeenPrv.$wpAdminBarHeight + spacing );
        	});
        },
		sticky: function() {
			if ( this.$stickyMenu.length === 0 ) {
				return;
			}

			this.$stickyMenu.each( function( index, elem ) {
				var stickyElem = $( elem );
				if ( ( stickyElem.hasClass( 'site-header' ) || stickyElem.hasClass( 'stickied' ) ) && zeenPrv.$winWidth < 768 ) {
					return;
				}

				if ( ( stickyElem.hasClass( 'site-mob-header' ) || stickyElem.hasClass( 'stickied' ) ) && zeenPrv.$winWidth > 767 ) {
					return;
				}

				stickyElem.addClass( 'stickied' );
				var lineSpacer = $( '#header-line' );

				var offset = 120, extras, stickyMenuType;
				if ( stickyElem.hasClass( 'site-mob-header' ) ) {
		    		offset = zeenPrv.$winHeight;
					lineSpacer = $( '#mob-line');
		    	}

				var stickyElemHeight = stickyElem.outerHeight( true );
		    	var scene;
				if ( stickyElem.hasClass( 'sticky-menu-2' ) ) {
					stickyMenuType = 2;
					stickyElem.addClass( 'still' );
					scene = new ScrollMagic
					.Scene({triggerElement: lineSpacer, triggerHook: 0 })
					.addTo( zeenPrv.$controller )
					.on( 'update', function( event ) {
						if ( event.scrollPos > event.startPos + 1 ) {
							if ( zeenPrv.$controller.info( 'scrollDirection' ) === 'FORWARD' ) {
							   stickyElem.removeClass( 'active' );
							} else if ( zeenPrv.$controller.info( 'scrollDirection' ) === 'REVERSE'  ) {
								stickyElem.addClass( 'active' ).removeClass( 'still' );
							}
						}
						var cutoff = parseInt( event.startPos - stickyElemHeight - zeenPrv.$wpAdminBarHeight + 1 );
						if ( cutoff < 1 ) {
							cutoff = 1;
						}
						if ( event.scrollPos < cutoff ) {
							stickyElem.removeClass( 'stuck active' ).addClass( 'still' );
						}
					}).on( 'enter', function( event ) {
						stickyElem.addClass( 'stuck' );
					});

			    } else if ( stickyElem.hasClass( 'sticky-menu-3' ) ) {
			    	stickyMenuType = 3;
			    	scene = new ScrollMagic
					.Scene({triggerElement: lineSpacer, triggerHook: 0, offset: offset })
					.addTo( zeenPrv.$controller )
					.on( 'update', function( event ) {
						if ( event.scrollPos > event.startPos ) {
							stickyElem.addClass( 'slidedown stuck' );
						} else if ( event.scrollPos < event.startPos - stickyElemHeight - zeenPrv.$wpAdminBarHeight - offset + 1 || event.scrollPos === 0 ) {
							stickyElem.removeClass( 'slidedown stuck' );
						}
					});
					if ( zeenPrv.$body.hasClass('single-post') && stickyElem.hasClass('main-navigation') ) {
						extras = true;
					}
			    } else if ( ( stickyElem.hasClass( 'sticky-menu-1' ) || stickyElem.hasClass( 'sticky-menu-4' ) ) && ! stickyElem.hasClass( 'site-mob-header' ) ) {
			    	stickyMenuType = 1;
			    	scene = new ScrollMagic
						.Scene({triggerElement: lineSpacer, triggerHook: 0, offset: zeenPrv.$wpAdminBarHeight * -1 })
						.addTo( zeenPrv.$controller );
						if ( zeenPrv.$body.hasClass('single-post') && stickyElem.hasClass('main-navigation') ) {
							extras = true;
						}
			    }

			    if ( extras === true ) {
			    	scene.on( 'update', function( event ) {
						if ( event.scrollPos > event.startPos ) {
							stickyElem.addClass( 'stuck' );
						}
						if ( event.scrollPos > event.startPos + ( zeenPrv.$winHeight / 2 ) ) {
							stickyElem.addClass( 'stuck-full' );
							if ( zeenPrv.$controller.info( 'scrollDirection' ) === 'FORWARD' ) {
							   stickyElem.removeClass( 'stuck-up' );
							} else if ( zeenPrv.$controller.info( 'scrollDirection' ) === 'REVERSE'  ) {
								stickyElem.addClass( 'stuck-up' );
							}
						}
					});
					scene.on( 'leave', function( event ) {
					   stickyElem.removeClass( 'stuck-up stuck-full stuck' );
					});
			    } else if ( stickyMenuType !== 2 ) {
			     	scene.on( 'update', function( event ) {
					 	if ( event.scrollPos > event.startPos ) {
					 		stickyElem.addClass( 'stuck' );
					 	} else {
					 		stickyElem.removeClass( 'stuck' );
					 	}
					});
			    }
			    if ( stickyElem.hasClass( 'site-mob-header' ) ) {
			    	zeenPrv.stickyMobMenu = scene;
			    } else {
			    	zeenPrv.stickyMenu = scene;
			    }
			});
		},
		liveSearchTr: function( e ) {
			e.preventDefault();
			$( this ).closest( '.search-form-wrap' ).find( '> form' ).trigger( 'submit' );
		},
		liveSearch: function( e, args ) {
			if ( typeof( args ) === 'undefined' ) {
				args = {
					'field': zeenPrv.$modalSearchField,
		        	'wrapper': zeenPrv.$modalSearch,
		        	'results': zeenPrv.$modalSearchFound
		        };
			}
			if ( zeenPrv.timer ) {
                clearTimeout( zeenPrv.timer );
            }
            if ( $.inArray( e.keyCode, zeenPrv.ignoreCodes ) === -1  ) {
                zeenPrv.timer = setTimeout( zeenPrv.searchAjax( args ), 700 );
            }

		},
		searchAjax: function( args ) {
			var typing = args.field.val();
			args.wrapper.removeClass( 'with-results' );
            if ( typing.length < 2 ) {
				args.wrapper.addClass( 'zero-typo' );
            	return;
            }
            var ppp = zeenJS.args.searchPpp;
            var child = 0;
            if ( typeof( args.ppp ) !== 'undefined' ) {
            	ppp = args.ppp;
            	child = 1;
            }

			$.ajax({
			    method: "GET",
			    url: zeenJS.root + 's?kw=' + typing + '&ppp=' + ppp,
			    dataType: 'html',
			    beforeSend: function( xhr ) {
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
			        args.wrapper.css( 'height', args.wrapper.height() );
			    },
			    success : function( response ) {
			    	args.results.empty();
			    	args.results.append( response );
			    	args.wrapper.removeClass( 'zero-typo' );
			    	var articles = args.results.find( 'article' );
			    	if ( articles.length === 0 ) {
			    		args.wrapper.addClass( 'no-results-found' );
			    	} else {
			    		args.wrapper.removeClass( 'no-results-found' );
			    		if ( ( articles.length + 1 ) % 3 === 0 ) {
				    		args.results.find( '.block' ).append( '<article></article>' );
				    	}
			    	}

			    	articles.imagesLoaded( function() {
						zeenPrv.blockAni();
						args.wrapper.css( 'height', 'auto' );
					});
					args.wrapper.addClass( 'with-results with-results-cache' );
			    },
			    fail : function( response ) {
			        console.log( 'ERROR', response );
			    }
			});
		},
		mediaPlay: function() {
			zeenPrv.video.play();
			zeenPrv.audio.play();
		},
		mediaStop: function() {
			zeenPrv.audio.pause();
			zeenPrv.video.pause();
		},
		subL: function() {
			if ( zeenJS.args.subL === false || Cookies.get( 'subL' ) === 'off' ) {
				return;
			}
			document.documentElement.addEventListener( 'mouseleave', zeenPrv.subE, zeenPrv.$listener );
		},
		modalSubscribe: function() {
			zeenPrv.$modal.addClass( 'active active-4' ).removeClass( 'inactive' );
			zeenPrv.$body.addClass( 'modal-active' );
			setTimeout( function() {
				zeenPrv.$modal.find( '.content-subscribe input[type=email]' ).focus();
			}, 400 );
		},
		modalOn: function( e ) {
			e.preventDefault();
			var trigger = $( this ),
				modalData = trigger.data(),
				modalOutput;
			if ( ! zeenPrv.$body.hasClass( 'modal-skin-2' ) ) {
				if ( modalData.type == 'frame' || modalData.type == 'qv' || modalData.type == 'embed' || modalData.type == '46' ) {
					zeenPrv.$modal.addClass('dark-overlay').removeClass('light-overlay');
				} else {
					zeenPrv.$modal.addClass('light-overlay').removeClass('dark-overlay');
				}
			}

			if ( modalData.type == 'frame' || modalData.type == 'embed' || modalData.type == '46' ) {
				if ( modalData.source == 'ext' ) {
					if ( modalData.src === '' ) {
						modalOutput = '<span class="embed-error">' + zeenJS.i18n.embedError + '</span>';
					} else {
						modalOutput = '<iframe width="560" height="315"  class="frame" src="' + modalData.src + '" frameborder="0" seamless="seamless" allow="autoplay" allowfullscreen></iframe>';
					}
				} else {
					if ( modalData.format === 'audio' ) {
						if ( zeenPrv.audio.canPlayType( 'audio/mpeg;' ) ) {
						    zeenPrv.audio.type= 'audio/mpeg';
						    if ( modalData.srcA !== '' ) {
		                        zeenPrv.audio.src = modalData.srcA;
		                    }
						} else {
						    zeenPrv.audio.type= 'audio/ogg';
						     if ( modalData.srcB !== '' ) {
		                        zeenPrv.audio.src = modalData.srcB;
		                    }
						}
						zeenPrv.audio.controls = true;
						modalOutput = zeenPrv.audio;
						zeenPrv.mediaPlay();
					}
					if ( modalData.format === 'video' ) {
						if ( zeenPrv.video.canPlayType( 'video/mp4;' ) ) {
						    zeenPrv.video.type= 'video/mp4';
						    if ( modalData.srcA !== '' ) {
		                        zeenPrv.video.src = modalData.srcA;
		                    }
						} else {
						    zeenPrv.video.type= 'video/ogg';
						     if ( modalData.srcB !== '' ) {
		                        zeenPrv.video.src = modalData.srcB;
		                    }
						}
						zeenPrv.video.setAttribute( 'controls', 'controls' );
						zeenPrv.video.setAttribute( 'controlsList', 'nodownload' );
						zeenPrv.mediaPlay();
						modalOutput = zeenPrv.video;
					}
					setTimeout(function() {
						zeenPrv.$modalCustom.addClass( 'ani-in' );
					}, 350);
				}
			}
			if ( modalData.type == 'frame' ) {
				zeenPrv.audio = new Audio();
				zeenPrv.video = document.createElement( 'video' );
				zeenPrv.$modalCustom.addClass( 'is-' + modalData.format ).append( modalOutput );
				zeenPrv.$modal.addClass( 'active active-1' ).removeClass( 'inactive' );
				zeenPrv.$body.addClass( 'modal-active' );
					zeenPrv.$modalCustom.addClass( 'tipi-spin ani-in' );
				if ( modalData.source == 'ext' ) {
					zeenPrv.$modalCustom.find('iframe').load( function() {
						zeenPrv.$modalCustom.addClass( 'frame-ldd' ).removeClass('tipi-spin');
					});
				} else {
					var obj = zeenPrv.$modalCustom.find( 'audio, video' );
					obj.on('loadstart', function() {
						zeenPrv.$modalCustom.addClass( 'frame-ldd' ).removeClass('tipi-spin');
					});
				}
			}

			if ( modalData.type == 'embed' ) {
				var  embedTarget = trigger.closest( '.hero-wrap' );
				if ( embedTarget.hasClass( 'active-embed' ) ) {
					return;
				}
				var targetVal = parseInt( Math.random() * ( 9999 - 1000) + 1000 );
				embedTarget.append( '<div id="frame-wrap-' + targetVal + '" class="frame-wrap"></div>' ).addClass( 'active-embed is-' + modalData.format ).removeClass( 'inactive-embed' );
				$( '#frame-wrap-' + targetVal ).append(modalOutput );
			}

			if ( modalData.type == '46' ) {
				var triggerArticle = trigger.closest( 'article' );
				if ( triggerArticle.hasClass( 'playing' ) ) {
					return;
				}
				var targetBlockWrap = $( '#block-wrap-' + modalData.target );
				var targetBlockPiece1 = targetBlockWrap.find( '.block-piece-1' );
				var target = targetBlockPiece1.find( '.mask' );
				targetBlockPiece1.addClass( 'loading-embed' ).removeClass( 'active-embed' );
				target.html( '<div class="frame-wrap-46-pad"><div id="frame-wrap-' + modalData.target + '" class="frame-wrap tipi-spin frame-wrap-46"></div></div>' );
				$( '#frame-wrap-' + modalData.target ).append(modalOutput );

				setTimeout( function() {
					targetBlockPiece1.addClass( 'active-embed embed-ldd-once' );
				}, 150 );

				if ( trigger.hasClass( 'icon-size-s' ) ) {
					triggerArticle.addClass( 'playing' ).siblings().removeClass( 'playing' );
				}
			}

			if ( modalData.type == 'search' ) {
				zeenPrv.$modal.addClass( 'active active-3' ).removeClass( 'inactive' );
				zeenPrv.$body.addClass( 'modal-active' );
				if ( zeenPrv.$winWidth > 1024 ) {
					setTimeout( function() {
						zeenPrv.$modalSearchField.focus();
					}, 500 );
				}
			}

			if ( modalData.type == 'subscribe' ) {
				zeenPrv.modalSubscribe();
			}

			if ( modalData.type == 'lwa' ) {
				zeenPrv.$modal.addClass( 'active active-2' ).removeClass( 'inactive' );
				zeenPrv.$body.addClass( 'modal-active' );
				setTimeout( function() {
					zeenPrv.$modal.find( '.lwa-username > input' ).focus();
				}, 700 );
			}

			if ( modalData.type == 'search-drop' ) {
				zeenPrv.activeFocus( trigger.closest( '.drop-search-wrap' ) );
				setTimeout( function() {
					trigger.parent().find( '.search-field' ).focus();
				}, 250 );
			}

			if ( modalData.type == 'qv' ) {
                zeenPrv.$modal.addClass( 'active active-qv' ).removeClass( 'inactive' );
                zeenPrv.$body.addClass( 'modal-active' );
                zeenPrv.ajaxCall = $.ajax({
                    method: "GET",
                    dataType: 'html',
                    url: zeenJS.root + 'qv?id=' + modalData.pid,
                    beforeSend: function( xhr ) {
                        zeenPrv.$modal.addClass( 'tipi-spin' );

                        zeenPrv.$modalCustom.empty().removeClass( 'is-video is-audio' );
                    },
                    success : function( response ) {
                        zeenPrv.$modalCustom.html(response );
                        zeenPrv.qtyArrows();
                        zeenPrv.$modalCustom.find( 'img' ).imagesLoaded().always( function( instance ) {
							zeenPrv.$modal.removeClass( 'tipi-spin' );
							setTimeout( function() {
								zeenPrv.$modalCustom.addClass( 'ani-in' );
							}, 50 );
  						});
                    },
                    fail : function( response ) {
                       console.log( 'ERROR', response );
                    }
                });
            }
            return false;
		},
		modalOff: function( e ) {
			if ( typeof( e ) !== 'undefined' ) {
				e.preventDefault();
			}
			zeenPrv.closeSlideMenu( e );
			zeenPrv.mediaStop();
			var to = 0;
			if ( zeenPrv.$modalCustom.hasClass( 'ani-in' ) ) {
				zeenPrv.$modalCustom.removeClass( 'ani-in' );
				to = 220;
			}
			zeenPrv.$modal.removeClass( 'active active-qv active-4 active-3 active-2 active-1' ).addClass( 'inactive' );
			zeenPrv.$body.removeClass( 'modal-active' );
			zeenPrv.$timedPup.removeClass( 'active' );
			setTimeout( function() {
				zeenPrv.$modalCustom.empty().removeClass( 'is-video is-audio' );
			}, to);
			setTimeout( function() {
				zeenPrv.$modalSearch.removeClass( 'with-results-cache with-results' );
				zeenPrv.$modalSearchField.val( '' );
			}, 600 );

			if ( zeenPrv.$body.hasClass( 'sub-l' ) ) {
				zeenPrv.turnItOff( 5 );
			}
		},
		parallax3s: function( override ) {
			if ( this.$body.hasClass( 'tipi-builder-frame-inner' ) && override !== true ) {
				return;
			}
			var $parallax3s = $( '.block-65' );
			if ( $parallax3s.length === 0 || this.$winWidth < 480 ) {
				return;
			}

			$parallax3s.find( '> article' ).each( function( index, elem ) {
				var $elem = $( elem );
				if ( $elem.hasClass( 'parallaxed3s' ) ) {
					return true;
				}
				$elem.addClass( 'parallaxed3s' );
			 	$elem.imagesLoaded( function() {
					var elemOH = $elem.outerHeight( true );
					var $yData = $elem.hasClass( 'odd' ) ? elemOH * 0.35 : elemOH * 0.15;
					new ScrollMagic.Scene({triggerElement: $elem, triggerHook: 1,  offset: 0, duration: zeenPrv.$winHeight + elemOH })
						.setTween(TweenLite.fromTo(  $elem.find( '> .preview-mini-wrap' ), 1, {y: $yData, ease: Linear.easeNone, force3D: true },  {y: "-" + $yData, ease: Linear.easeNone, force3D: true } ) )
					.addTo( zeenPrv.$parallax3sController);
				});
			});

		},
		cta: function() {
			var bgPar = this.$content.find( '.block-wrap-cta' ).add( this.$content.find( '.has-bg-img' ) );
			if ( bgPar.length === 0 ) {
				return;
			}
			bgPar.each( function( index, element ){
				var $elem = $( this );
				var $imgTag, tween;
				if ( $elem.hasClass( 'block-wrap-cta' ) ) {
					$imgTag = $elem.find( '.img-bg-wrapper' );
				} else {
					$imgTag = $elem.find( '> .img-bg-wrapper' );
					if ( $imgTag.length === 0 ) {
						$imgTag = $elem.find( '> div > .img-bg-wrapper' );
					}
				}
				if ( $imgTag.length === 0 ) {
					$imgTag = $elem.find( '.video-wrap' );
					tween = $imgTag.find('iframe');
				} else {
					tween = $imgTag.find('.bg');
				}
				$imgTag.imagesLoaded( { background: true }, function() {
		        	if ( $imgTag.hasClass( 'bg-parallax' ) && ! $elem.hasClass( 'parallaxed' ) ) {
		        		var duration = $imgTag.outerHeight() + zeenPrv.$winHeight;
		        		new ScrollMagic.Scene({triggerElement: $imgTag, triggerHook: 1, duration: duration })
						.setTween(TweenLite.fromTo( tween, 1, {y: '-20%', ease: Linear.easeNone},  {y: '20%', ease: Linear.easeNone} ) )
						.addTo( zeenPrv.$parallaxItCont );
						$elem.addClass( 'parallaxed' );
		        	}
		        	setTimeout(function() {
		        		$elem.addClass( 'bg-img-ldd' );
		        	}, 200);
		        });
			});
		},
		modalCheck: function() {
			var modalData = zeenPrv.$modal.data( 'fid' );
			if ( modalData !== '' && modalData === zeenPrv.$modal.find( '.mc4wp-form' ).attr('id') ) {
				zeenPrv.modalSubscribe();
			}
		},
		noPar: function( override ) {
			var $noPar = $( '.no-par' );
			if ( $noPar.length === 0 ) {
				return;
			}
			$noPar.imagesLoaded( function() {
				$noPar.addClass( 'mask-loaded' );
		    });
		},
		parallaxIt: function( override ) {
			var $parallaxIt = $( '.parallax' );
			if ( $parallaxIt.length === 0 || ( this.$body.hasClass( 'tipi-builder-frame-inner' ) && override !== true ) ) {
				return;
			}

			$parallaxIt.each( function( index, element ){
				var $elem = $( this );
				if ( $elem.hasClass( 'parallaxed' ) ) {
					return;
				}
				$elem.addClass('parallaxed');
				var parallaxS = false,
					$parallaxImg = $elem.find( 'img:not(.avatar)' );
				if ( $elem.hasClass( 'parallax-tight' ) ) {
					parallaxS = true;
				}
				$parallaxImg.imagesLoaded( function() {
					var $parallaximgheight = $parallaxImg.outerHeight();

					if ( $parallaximgheight === 0 ) {
						$parallaximgheight = $parallaxImg.parent().outerHeight();
					}
					if ( $elem.hasClass( 'parallax--resized' ) ) {
						$parallaxImg.css( 'height', parseInt( $parallaximgheight * 1.2 ) + 'px' );
					}
					var parallaxQty = $parallaximgheight * 0.2 + 'px',
						duration = $parallaximgheight + zeenPrv.$winHeight;

					if ( zeenPrv.$winHeight > zeenPrv.$winWidth ) {
						parallaxQty = $parallaximgheight * 0.125 + 'px';
					}
					if ( parallaxS === true ) {
						parallaxQty = $parallaximgheight * 0.16 + 'px';
					}
					new ScrollMagic.Scene({triggerElement: $elem, triggerHook: 1, duration: duration })
						.setTween(TweenLite.fromTo( $parallaxImg, 1, {y: '-' + parallaxQty, ease: Linear.easeNone},  {y: parallaxQty, ease: Linear.easeNone} ) )
						.addTo( zeenPrv.$parallaxItCont );

					setTimeout(function() {
			        	$elem.addClass( 'mask-loaded' );
					}, 450);
		        });

			});
		},
		hero31: function() {
			if ( this.$hero31.length === 0 ) {
				return;
			}
			var $figure = '';
			if ( this.$hero31.closest( '.post-wrap' ).hasClass( 'format-gallery' ) ) {
			 	$figure = this.$hero31.find( '> .slider' );
				this.doHero31( $figure );
			} else{
			 	$figure = this.$hero31.find( '.fi-bg' );
				$figure.imagesLoaded( { background: true }, function() {
					$figure.addClass('fi-bg-ldd');
					TweenLite.to( $figure, 0.3, { opacity: 1 } );
					setTimeout(function() {
						zeenPrv.doHero31( $figure );
					}, 300);
				});
			}
		},
		doHero31: function( $figure ) {
			var hero31Controller = new ScrollMagic.Controller(),
			height = this.$winHeight - this.$wpAdminBarHeight;
			if ( zeenPrv.$winWidth > 767 ) {
				height -= this.$headerHeight - this.$siteNav.outerHeight() - this.$secondaryWrap.outerHeight();
			} else {
				height -= this.$mobHead.outerHeight();
			}
			height -= this.$winHeight * 0.1;
			this.$hero31.parent().height( height );
			new ScrollMagic.Scene({triggerElement: this.$body, triggerHook: 0, offset: 0, duration: this.$winHeight * 0.1 })
					.setTween( $figure, {opacity: zeenJS.args.heroFade })
					.addTo(hero31Controller);
			new ScrollMagic.Scene({triggerElement: this.$body, triggerHook: 0, offset: 0, duration: this.$winHeight * 0.1 })
					.setTween( this.$hero31.find( '.mask-overlay' ), {opacity: 1 })
					.addTo(hero31Controller);
		},
		loadMoreButton: function( e ) {
			e.preventDefault();
			var $elem = $( this ),
				$elemData = $elem.data();
			if ( $elem.hasClass( 'loaded' ) ) {
				return;
			}
			zeenPrv.loadMore( $elem, $elemData );
		},
		infScr: function() {
			var infScr = $( '.inf-scr' );
			if ( infScr.length === 0 ) {
				return;
			}
			var $elem, $elemData;
			var mnp = infScr.first().data( 'mnp' );
			infScr.each( function( index, elem ) {
				$elem = $( elem );
				var $block = $elem.closest( '.block-wrap' );
				if ( $elem.hasClass( 'loaded' ) || $elem.hasClass( 'inf-load-more' ) || $elem.hasClass( 'inf-scr-masonry' ) || ( $block.hasClass( 'dt-off' ) && zeenPrv.$winWidth > 767 ) || ( $block.hasClass( 'mob-off' ) && zeenPrv.$winWidth < 768 ) ) {
					return;
				}

				$elemData = $elem.data();
				$elemData.mnp = mnp;

				var scene = new ScrollMagic
				.Scene({ triggerElement: $elem, triggerHook: 1, offset: -500 })
				.addTo( zeenPrv.$controller)
				.on( 'enter', function( e ) {
					if ( $elem.hasClass( 'loaded' ) ) {
						scene.destroy();
						return;
					}
					zeenPrv.loadMore( $elem, $elemData );
					$elem.addClass( 'loaded' );
		        });
			});
		},
		loaded: function() {
			this.slideInP();
			this.subL();
			this.timedPup();
			this.verticalMenus();
		},
		likes: function( e ){
			e.preventDefault();
			var elem = $( this );
			if ( elem.hasClass( 'liking' ) || elem.hasClass( 'liked' ) ) {
				return;
			}
			var data = elem.data();
			$.ajax({
			    method: "POST",
			    data: { 'pid': data.pid },
			    url: zeenJS.root + 'lk',
			    beforeSend: function( xhr ) {
			    	elem.addClass( 'liking' );
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
			    },
			    success : function( response ) {
			    	elem.removeClass( 'liking' ).addClass( 'liked' );
			    	elem.find( '.tipi-value' ).html( response[0] );
			    	Cookies.set( 'wp_liked_articles', response[1], { expires: zeenJS.args.cookieDuration });
			    },
			    fail : function( response ) {
			        console.log( 'ERROR', response );
			    }
			});
		},
		ipl: function(){
			var $ipl = $( '.ipl' );
			if ( $ipl.length === 0 || ( zeenJS.args.iplMob !== true && zeenPrv.$winWidth < 768 ) ) {
				return;
			}
			$ipl.each( function( index, elem ) {
				elem = $( this );
				var data = elem.data();
				if ( elem.hasClass( 'loaded' ) ) {
					return;
				}
				var scene = new ScrollMagic.Scene({triggerElement: $( elem ), triggerHook: 1, offset: zeenPrv.$winHeight * -2  })
					.addTo( zeenPrv.$controller )
					.on( 'enter', function( e ) {
						if ( ! elem.hasClass( 'loaded' ) ) {
							zeenPrv.runIpl( elem, data );
							elem.addClass( 'loaded' );
							setTimeout(function() {
								scene.destroy(true);
							}, 1000);
						}
					});
			});
		},
		updateHref: function( title, url ) {
			window.history.pushState( '', title, url );
			if ( title !== '' ) {
				document.title = title;
			}
		},
		GA: function( url ) {
			if ( typeof _gaq !== 'undefined' && _gaq !== null ) {
                _gaq.push(['_trackPageview', url]);
            }
            if ( typeof ga !== 'undefined' && ga !== null ) {
                ga( 'send', 'pageview', url );
            }
		},
		subE: function( e ) {
			if ( Cookies.get( 'subL' ) === 'off' && zeenJS.args.subCookie === true ) {
				document.documentElement.removeEventListener( 'mouseleave', zeenPrv.subE, zeenPrv.$listener );
				return;
			}
			if ( zeenPrv.$body.hasClass( 'modal-active' ) || e.clientY > 0 ) {
				return;
			}
			zeenPrv.$body.addClass( 'sub-l' );
			zeenPrv.modalSubscribe();
		},
		runIpl: function( elem, data ) {
			if ( typeof( data ) === 'undefined' ) {
				elem = $( this );
				data = elem.data();
			}
			$.ajax({
			    method: "GET",
			    data: { 'pid': data.pid, ipl: true },
			    dataType: 'html',
			    url: zeenJS.root + 'ipl',
			    beforeSend: function( xhr ) {
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
			    },
			    success : function( response ) {
				    zeenPrv.$primary.append( response );
				    var $currentPost = zeenPrv.$primary.find( '> .post-' + data.pid );

				    var rect = $currentPost[0].getBoundingClientRect(),
						scrollTop = window.pageYOffset || document.documentElement.scrollTop,
					    height = rect.top + scrollTop;
				    if ( zeenPrv.$winWidth > 767 ) {
			        	height -= 180;

					    if ( zeenPrv.$header.hasClass( 'sticky-menu-1' ) || zeenPrv.$header.hasClass( 'sticky-menu-3' )  ) {
			        		height -= zeenPrv.$headerHeight;
			        	}

			        	if ( zeenPrv.$siteNav.hasClass( 'sticky-menu-1' ) || zeenPrv.$siteNav.hasClass( 'sticky-menu-3' ) ) {
			        		height -= zeenPrv.$siteNav.outerHeight();
			        	}

					}
		        	if ( scrollTop > height ) {
						window.scrollTo( 0, height );
					}

					zeenPrv.blockAni();
					zeenPrv.tempAni();
					zeenPrv.lrTempAni();
					zeenPrv.sliderInit();

					for ( var i = zeenJS.args.ipl.length - 1; i >= 0; i-- ) {
		                $.get(zeenJS.args.pluginsUrl + '/' + zeenJS.args.ipl[i]);
		            }
		            if ( typeof window.instgrm !== 'undefined' ) {
					    window.instgrm.Embeds.process();
					}

		            if ( zeenJS.args.fbComs === true && zeenJS.args.iplComs === true ) {
		            	FB.XFBML.parse( $currentPost[0] );
		            }
		            var asr;
					new ScrollMagic
					.Scene({ triggerElement: elem, triggerHook: 0.5, offset: 0 })
					.addTo( zeenPrv.$controller)
					.on( 'enter leave', function( e ) {
						if ( e.progress === 1 ) {
							if ( zeenPrv.$progress.length > 0 ) {
								zeenPrv.$progress.css( 'background-color', data.nextHex );
							}
							zeenPrv.updateHref( data.titleNext, data.next );
							zeenPrv.GA( data.next );
							zeenPrv.$iplTitle.html( data.titleNext);
							if ( zeenPrv.$stickyP2.length > 0 ) {
								zeenPrv.$stickyP2.find( '.share-button-tw' ).attr( 'href', 'https://twitter.com/share?url=' + encodeURIComponent( data.next ) );
								zeenPrv.$stickyP2.find( '.share-button-fb' ).attr( 'href', 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent( data.next ) );
							}
							if ( zeenPrv.$mobBotShare.length > 0 ) {
								zeenPrv.$mobBotShare.find( '.share-button-tw' ).attr( 'href', 'https://twitter.com/share?url=' + encodeURIComponent( data.next ) );
								zeenPrv.$mobBotShare.find( '.share-button-fb' ).attr( 'href', 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent( data.next ) );
								zeenPrv.$mobBotShare.find( '.share-button-msg' ).attr( 'href', 'fb-messenger://share/?link=' + encodeURIComponent( data.next ) );
								zeenPrv.$mobBotShare.find( '.share-button-wa' ).attr( 'href', 'whatsapp://send?text=' + data.titleNext + ' – ' + encodeURIComponent( data.next ) );
							}

				            if ( zeenJS.args.disqus !== false ) {
				            	asr = $currentPost.find( '.disqus-replace');
								if ( asr.length > 0 ) {
				            		$('#disqus_thread').attr('id', '' ).addClass( 'disqus-replace' );
									asr.attr( 'id', 'disqus_thread' );
				            		setTimeout(function() {
						            	DISQUS.reset({
										  reload: true,
										  config: function () {
										    this.page.identifier = data.pid;
										    this.page.url = data.next;
										     this.page.title = data.titleNext;
										  }
										});
						            }, 50 );
					            }

				            }

						} else {
							if ( zeenJS.args.disqus !== false ) {
								asr = zeenPrv.$primary.find( '> .post-' + data.pidori +  ' .disqus-replace');
								if ( asr.length > 0 ) {
									$('#disqus_thread').attr('id', '' ).addClass( 'disqus-replace' );
									asr.attr( 'id', 'disqus_thread' );
									setTimeout(function() {
						            	DISQUS.reset({
										  reload: true,
										  config: function () {
										    this.page.identifier = data.pidori;
										    this.page.url = data.prev;
										    this.page.title = data.titlePrev;
										  }
										});
						            }, 50);
					            }
				            }

							if ( zeenPrv.$progress.length > 0 ) {
								zeenPrv.$progress.css( 'background-color', data.prevHex );
							}
							zeenPrv.updateHref( data.titlePrev, data.prev );
							zeenPrv.GA( data.prev );
							zeenPrv.$iplTitle.html( data.titlePrev );
							if ( zeenPrv.$stickyP2.length > 0 ) {
								zeenPrv.$stickyP2.find( '.share-button-tw' ).attr( 'href', 'https://twitter.com/share?url=' + encodeURIComponent( data.prev ) );
								zeenPrv.$stickyP2.find( '.share-button-fb' ).attr( 'href', 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent( data.prev ) );
							}

							if ( zeenPrv.$mobBotShare.length > 0 ) {
								zeenPrv.$mobBotShare.find( '.share-button-tw' ).attr( 'href', 'https://twitter.com/share?url=' + encodeURIComponent( data.prev ) );
								zeenPrv.$mobBotShare.find( '.share-button-fb' ).attr( 'href', 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent( data.prev ) );
								zeenPrv.$mobBotShare.find( '.share-button-msg' ).attr( 'href', 'fb-messenger://share/?link=' + encodeURIComponent( data.prev ) );
								zeenPrv.$mobBotShare.find( '.share-button-wa' ).attr( 'href', 'whatsapp://send?text=' + data.titlePrev + ' – ' + encodeURIComponent( data.prev ) );
							}

						}
			        });

			        var iplScene = new ScrollMagic
					.Scene({ triggerElement: elem, triggerHook: 1, offset: 0 })
					.addTo( zeenPrv.$controller)
					.on( 'enter', function( e ) {
						zeenPrv.$body.addClass('ipl-done');
						$currentPost.removeClass( 'ipl-loading' );
						$currentPost.prev().addClass('ipl-bg');
						zeenPrv.parallaxIt();
						zeenPrv.noPar();
						setTimeout(function() {
							zeenPrv.sidebars();
							zeenPrv.reSidebars();
							zeenPrv.stickyEl();
							zeenPrv.imgControl();
							zeenPrv.lightboxInit();
							iplScene.destroy(true);
						}, 750);

						setTimeout(function() {
			       			zeenPrv.postTracks();
						}, 900);
			        });
			        zeenPrv.$entryContent = $( '.entry-content:not(.progresson)' );
			       	zeenPrv.videoWrap();
			       	zeenPrv.stickyEl();
			       	zeenPrv.loopAni();
					zeenPrv.ipl();

					if ( zeenPrv.$primary.find( '.no-more-articles-wrap').length > 0 ) {
						$( '#ipl-loader' ).addClass( 'ipl-end' );
					}
					if ( zeenPrv.$skinMode.length > 0 && zeenPrv.$skinMode.hasClass( 'triggered' ) ) {
						if ( zeenPrv.$skinMode.hasClass( 'mode--dark' ) ) {
							$currentPost.removeClass( 'article-layout-skin-1' ).addClass( 'article-layout-skin-2' );
						} else {
							$currentPost.removeClass( 'article-layout-skin-2' ).addClass( 'article-layout-skin-1' );
						}
					}
 			    },
			    fail : function( response ) {
			    	console.log( 'ERROR', response );
			    }
			});
			$( '.inf-scr' ).removeClass("active");
		},
		blockMore: function( e ) {
			var $elem = $( this );
			if ( ! ( $elem.hasClass( 'block-mm-changer' ) && e.type === 'click' ) ) {
				e.preventDefault();
			}
			if ( $elem.hasClass( 'no-more' ) || $elem.hasClass( 'active' ) ) {
				return;
			}
			var $elemPa, $elemMenu, mm, mmChanger;
			if ( $elem.hasClass( 'block-mm-changer' ) ) {
				$elemMenu = $elem.closest( '.menu' );
				if ( parseInt( $elemMenu.data( 'mm' ) ) < 10 || parseInt( $elemMenu.data( 'mm' ) ) > 50 ) {
					return;
				}
				$elemPa = $elemMenu.find( '.block-wrap' );
				mm = true;
				mmChanger = true;
			}  else {
				$elemPa = $elem.closest( '.block-wrap' );
				if ( $elemPa.parent().hasClass( 'menu-wrap' ) ) {
					mm = true;
				}
			}

			var data = $elem.data(),
				parentData = $elemPa.data();
			var $blockData = $( '#block-wrap-' + parentData.id );
			var $blockLoading = $blockData.find( '> div' );
			if ( $blockLoading.hasClass( 'loading' ) ) {
				return;
			}

			var changer = $elem.hasClass( 'block-changer' ) ? true : false,
				dataDir = typeof( data.dir ) !== 'undefined' && data.dir === 1 ? 1 : 2,
				trigger_type = typeof( data.dir ) === 'undefined' ? 1 : 2,
				append = trigger_type,
				paged, loaders,
				term = { term: data.term, id: data.tid },
				setter = 'zeen_' + parentData.id;

			if ( window[setter].target !== 0 && ( typeof( data.tid ) === 'undefined' || data.tid === 0 ) ) {
				setter = setter + '_' + window[setter].target;
			}

			if ( data.tid > 0 ) {
				setter = setter + '_' + data.tid;
				if ( typeof( window[setter] ) === 'undefined' ) {
					window[setter] = $.extend( true, {}, window['zeen_' + parentData.id ] );
		        	window[setter].args.cat = '';
			    	window[setter].args.tag__in = '';
			    	window[setter].args.post__in = '';
			    	window[setter].term = '';
			    	if ( data.term === 'category' ) {
			    		window[setter].args.cat = data.tid;
			    	} else if ( data.term === 'post_tag' ) {
			    		window[setter].args.tag__in = data.tid;
			    	} else {
			    		window[setter].args.tax_query = {taxonomy: term.term, field: 'term_id', 'terms': term.id };
			    		window[setter].term = term;
			    	}
				}
				window['zeen_' + parentData.id ].target = data.tid;
			}
			if ( data.reset === 1 ) {
				setter = 'zeen_' + parentData.id;
				window[setter].target = 0;
			}
			var title = data.title,
				reset = data.reset,
				subtitle = data.subtitle,
				newUrl = data.ur,
				$elemN = $elemPa.find( '.block-more-2' ),
				$elemP = $elemPa.find( '.block-more-1' ),
				mnp;
			if ( $elemN.length === 0 ) {
				$elemN = $elemPa.find( '.block-more-3' );
			} else {
				if ( typeof data.term !== 'undefined' ) {
					$elemN.data({ term: data.term, tid: data.tid } );
					$elemP.data({ term: data.term, tid: data.tid } );
				} else {
					$elemN.removeData( 'term' ).removeData( 'tid' );
					$elemP.removeData( 'term' ).removeData( 'tid' );
				}
			}
			if ( changer === true ) {
				paged = 1;
				append = 2;
				if ( $elem.hasClass( 'block-mm-changer' ) ) {
					$elemMenu.find( '.active' ).removeClass( 'active' );
				} else {
					var $sorter = $elem.closest( '.sorter' );
					$sorter.find( '.block-changer' ).removeClass( 'active' );
					$sorter.find( '.current-txt' ).html( data.sorttitle + zeenJS.args.iconSorter );
				}
				if ( $elem.hasClass( 'block-mm-init' ) ) {
					$elemMenu.find( '.block-mm-init' ).removeClass( 'block-mm-init' );
				}
				$elem.addClass( 'active' );
				window[setter].next = 2;
				window[setter].prev = 0;
				mnp = data.mnp;
				if ( mnp === 1 ) {
					loaders = 'off';
				}
			} else {
				mnp = window[setter].mnp;
		    	if ( dataDir === 1 ){
		    		paged = window[setter].prev;
		    		window[setter].prev = parseInt( window[setter].prev ) - 1;
		    		window[setter].next = parseInt( window[setter].next ) - 1;
		    	} else {
		    		paged = window[setter].next;
		    		window[setter].prev = parseInt( window[setter].prev ) + 1;
		    		window[setter].next = parseInt( window[setter].next ) + 1;
		    	}
		    }

			var blockData = window[setter],
				args = { blockData: blockData, $blockData: $blockData, $elemN: $elemN, $elemP: $elemP, dir: data.dir, changer: changer, trigger_type: trigger_type, append: append, loaders: loaders, title: title, newUrl: newUrl, reset: reset, subtitle: subtitle, response: '', mm: mm };
			$.ajax({
			    method: "GET",
			    data: {
					paged: paged,
					type: trigger_type,
					mm: mm,
					term: term,
					data: blockData,
				},
				dataType: 'html',
			    url: zeenJS.root + 'block',
			    beforeSend: function( xhr ) {
			    	if ( mmChanger === true ) {
			    		if ( $elemMenu.parent().find( '> a' ).data( 'ppp' ) >= data.count ) {
			    			args.loaders = 'off';
			    		}
			    	}

			    	$blockLoading.addClass( 'loading tipi-spin' );
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
			        if ( zeenPrv.ajaxChecker( setter + '_' + paged ) ) {
			        	args.response = zeenPrv.ajaxGetter( setter + '_' + paged );
						zeenPrv.ajaxLoadMore( args );

				    	if ( mmChanger === true ) {
				    		$elemPa.closest( '.mm-wrap' ).addClass( 'active-1' );
				    	} else if ( mm === true ) {
				    		$elemPa.closest( '.mm-wrap' ).removeClass( 'active-1' );
				    	}
				    	if ( append === 2 ) {
					    	if ( dataDir === 1 ) {
					    		$elemPa.removeClass( 'loaded block-ani-r' ).addClass( 'block-ani-l' );
					    	} else {
					    		$elemPa.removeClass( 'loaded block-ani-l' ).addClass( 'block-ani-r' );
					    	}
					    }
					    zeenPrv.reSidebars();
						$elemPa.addClass( 'loaded' );
			        	return false;
			    	}
			    },
			    success : function( response ) {
			    	response = JSON.parse( response );
					args.response = response;
					zeenPrv.ajaxLoadMore( args );
					if ( mmChanger === true ) {
			    		$elemPa.closest( '.mm-wrap' ).addClass( 'active-1' );
			    	} else if ( mm === true ) {
			    		$elemPa.closest( '.mm-wrap' ).removeClass( 'active-1' );
			    	}
			    	zeenPrv.ajaxSetter( setter + '_' + paged, response );
					$elemPa.addClass( 'loaded' );
					zeenPrv.parallax3s();
					zeenPrv.videoWrap();
					if ( append === 2 ) {
				    	if ( dataDir === 1 ) {
				    		$elemPa.removeClass( 'block-ani-r' ).addClass( 'block-ani-l' );
				    	} else {
				    		$elemPa.removeClass( 'block-ani-l' ).addClass( 'block-ani-r' );
				    	}
				    }
			    },
			    fail : function( response ) {
			        console.log( 'ERROR', response );
			    }
			});
			return false;
		},
		masonryAppend: function( $items, target ) {
			$items.each( function() {
				var item = $( this );
				if ( item.hasClass('masonry__col-1' ) ) {
					target.find( '.masonry__col-1' ).append( item.children('article') );
				} else if ( item.hasClass('masonry__col-2' ) ) {
					target.find( '.masonry__col-2' ).append( item.children('article') );
				} else if ( item.hasClass('masonry__col-3' ) ) {
					target.find( '.masonry__col-3' ).append( item.children('article') );
				} else if ( item.hasClass('pagination' ) ) {
					target.append( item );
				}
			});
		},
		ajaxLoadMore: function( args ) {
			var $items = $( args.response[1] );
			if ( typeof args.title !== 'undefined' || typeof args.subtitle !== 'undefined' ) {
				var titleTarget = args.$blockData.find( '.block-title-wrap' );
				if ( typeof args.title !== 'undefined' ) {
					if ( typeof args.newUrl !== 'undefined' ) {
						titleTarget.find( '.block-title-url' ).attr( 'href', args.newUrl ).html( args.title );
					} else {
						titleTarget.find( '.block-title' ).html( args.title );
					}
				}
				if ( typeof args.subtitle !== 'undefined' ) {
					titleTarget.find( '.block-subtitle' ).html( args.subtitle );
				}
			}
			var target = args.$blockData.find( '.block' );
			var masonryTarget = target.find( '> .block-masonry' );
			if ( args.append === 1 ) {
				if ( args.$blockData.hasClass( 'block-wrap-grid' ) ) {
					target.last().after( $items );
				} else if ( masonryTarget.length > 0 ) {
					zeenPrv.masonryAppend( $items, target );
				} else {
					target.append( $items );
				}
				zeenPrv.reSidebars();
			} else {
				if ( args.$blockData.hasClass( 'block-wrap-grid' ) ) {
					args.$blockData.css( 'height', args.$blockData.height() );
					if ( target.length === 1 ) {
						target.replaceWith( $items );
					} else {
						$items = $items.filter( function() { return this.nodeType === 1; });
						for ( var i = 0; i < target.length; i++ ) {
							target[i].replaceWith( $items[i] );
						}
					}
		            target.imagesLoaded( function() {
		            	args.$blockData.css( 'height', 'auto' );
		            });
				} else {
					target.css( 'height', target.height() );
					target.html( $items );
		            target.imagesLoaded( function() {
		            	target.css( 'height', 'auto' );
		            });
				}
			}
			if ( args.manual !== true ) {
				if ( args.changer === true ) {
					if ( args.loaders === 'off' ) {
						args.$elemN.addClass( 'no-more' );
						args.$elemP.addClass( 'no-more' );
						if ( args.$elemN.hasClass( 'block-more-3' ) ) {
							args.$elemN.html( zeenJS.i18n.noMore );
						}
					} else {
						args.$elemN.removeClass( 'no-more' );
						args.$elemP.addClass( 'no-more' );
						if ( args.$elemN.hasClass( 'block-more-3' ) ) {
							args.$elemN.html( zeenJS.i18n.loadMore );
						}
					}

				} else {
					if ( args.trigger_type === 1 ) {
						if ( args.blockData !== '' && args.blockData.next > args.response[0] ) {
							args.$elemP.html( zeenJS.i18n.noMore ).addClass( 'no-more' );
						}
					} else {
						args.$elemN.removeClass( 'no-more' );
						args.$elemP.removeClass( 'no-more' );
						if ( args.blockData !== '' && args.blockData.prev === 0 ) {
							args.$elemP.addClass( 'no-more' );
							args.$elemN.removeClass( 'no-more' );
						}

						if ( args.blockData !== '' && args.response[0] < args.blockData.next ) {
							if ( args.blockData.prev !== 0 ) {
								args.$elemP.removeClass( 'no-more' );
							}
							args.$elemN.addClass( 'no-more' );
						}
					}
				}
			}

			args.$blockData.find( '> div' ).removeClass( 'loading tipi-spin' );
			zeenPrv.fillRunner();
			zeenPrv.tempAni();
			if ( typeof args.mm !== 'undefined' && args.mm === true ) {
				args.$blockData.find( '.zeen-lazy-load-mm' ).each( function() {
					zeenPrv.imgAttrLoad( $(this)[0], true );
				});
			}
		},
		ajaxGetter: function( ajaxCall ) {
			return zeenPrv.ajaxData[ajaxCall];
		},
		ajaxSetter: function( ajaxCall, ajaxData ) {
			zeenPrv.ajaxDeleter(ajaxCall);
			zeenPrv.ajaxData[ ajaxCall ] = ajaxData;
		},
		videoWrap: function() {
			$( 'iframe[src*="youtube"], iframe[src*="vimeo.com"], iframe[src*="dailymotion"]' ).each( function() {
				var _this = $( this ), thisParent = _this.parent();
				if ( ! thisParent.hasClass( 'video-wrap' ) && ! thisParent.hasClass( 'wp-block-embed__wrapper' ) && ! thisParent.parent().hasClass( 'wp-block-embed__wrapper' ) && ! thisParent.hasClass( 'frame-wrap' ) && ! thisParent.hasClass( 'content-custom' ) && ! _this.hasClass( 'elementor-video-iframe' ) && ! _this.hasClass( 'skip-video' ) && ! thisParent.hasClass( 'fluid-width-video-wrapper' ) ) {
					_this.wrap( '<div class="video-wrap"></div>' );
				}
			});
		},
		videoBg: function() {
			if ( this.$winWidth > 767 ) {
				var $media_bg = [], $header_bg = this.$header.find( '.bg-area > .background .media-bg' ), $footer_bg = this.$footerBgArea.find( '.background .media-bg' );
				if ( $header_bg.length > 0 ) {
					$media_bg.push( $header_bg );
				}
				if ( $footer_bg.length > 0 ) {
					$media_bg.push( $footer_bg );
				}
				for ( var i = $media_bg.length - 1; i >= 0; i-- ) {
					if ( $media_bg[i].find( '> source' ).length > 0 ) {
						var $media_bg_src = $media_bg[i].find( '> source' );
						$media_bg_src.attr( 'src', $media_bg_src.data( 'src' ) ).removeAttr( 'data-src' );
						$media_bg[i][0].load();
					} else {
						$media_bg[i].attr( 'src', $media_bg[i].data( 'src' ) );
					}
					$media_bg[i].addClass( 'active' );
				}
			}
		},
		skinMode: function( e ) {
			e.preventDefault();
			zeenPrv.$skinMode.addClass( 'triggered' );
			if ( zeenPrv.$skinMode.hasClass( 'mode--dark' ) ) {
				zeenPrv.$skinMode.removeClass( 'mode--dark' );
				zeenPrv.$body.removeClass( 'mode--dark--b' );
				zeenPrv.$primary.find( '> .article-layout-skin-2' ).removeClass('article-layout-skin-2').addClass('article-layout-skin-1');
			} else {
				zeenPrv.$skinMode.addClass( 'mode--dark' );
				zeenPrv.$body.addClass( 'mode--dark--b' );
				zeenPrv.$primary.find( '> .article-layout-skin-1' ).removeClass('article-layout-skin-1').addClass('article-layout-skin-2');
			}
		},
		removeBasket: function( e ) {
			e.preventDefault();
			var trigger = $( this );
			var pid = trigger.data( 'pid' );
			zeenPrv.ajaxCall = $.ajax({
			    method: "POST",
			    url: zeenJS.root + 'remove?pid=' + pid,
			    beforeSend: function( xhr ) {
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
			        trigger.parent().addClass( 'loading' );
			    },
			    success : function( response ) {
		    		zeenPrv.$body.trigger( 'wc_fragment_refresh' );
			    },
			    error : function( response ) {
			    	console.log( 'ERROR', response );
			    }
			});
		},
		imgControl: function( resize ) {
			this.$primary.find( '> .post-wrap' ).each( function() {
				var current = $( this );
		        var img = current.find( '.entry-content .alignnone' ).add( current.find( '.entry-content .aligncenter' ) );
		        if ( img.length > 0 ) {
					var imgObs = new IntersectionObserver(function (entries) {
						entries.forEach(function (entry ) {
							if ( entry.isIntersecting ) {
								entry.target.classList.add('embed-vis');
								imgObs.unobserve(entry.target);
							}
						});
					}, { threshold: [0], rootMargin: '-100px 0px', });
					var currentImg;
					img.each( function( index, elem ) {
						currentImg = $( this );
						if ( ! currentImg.hasClass('embed-vis') ) {
							imgObs.observe( currentImg[0] );
						}
					});
				}
			});
	    },
		ajaxDeleter: function( ajaxCall, target ) {
			if ( target === true ) {

				for ( var el in zeenPrv.ajaxData ) {
				  if ( el.indexOf(ajaxCall) === 0 ) {
					  delete zeenPrv.ajaxData[el];
					}
				}
				if ( typeof( window[ ajaxCall + '_2' ] ) !== 'undefined' ) {
					window[ ajaxCall + '_2' ] = '';
				}
			} else {
				delete zeenPrv.ajaxData[ajaxCall];
			}
		},
		ajaxChecker: function( ajaxCall ) {
			if ( typeof( window[ ajaxCall ] ) !== 'undefined' && window[ ajaxCall ] !== '' ) {
				zeenPrv.ajaxData[ ajaxCall ] = window[ ajaxCall ];
				return true;
			}

			if ( typeof( zeenPrv.ajaxData[ ajaxCall ] ) !== 'undefined' ) {
				return true;
			}
		},
		loadMore: function( elem, data ) {
			elem.addClass( 'loaded' );
			if ( typeof( zeenPrv.thePaged ) === 'undefined' || zeenPrv.thePaged === 0 ) {
				zeenPrv.thePaged = 1;
			}
			if ( typeof( data ) === 'undefined' ) {
				elem = $( this );
				data = elem.data();
			}
			var elemBlockWrap = elem.closest( '.block-wrap' );
			var type = data.type;
			if ( type === 4 ) {
				type = 3;
			}
			var target = elemBlockWrap, masonry;

			if ( elemBlockWrap.hasClass( 'block-masonry-wrap' ) ) {
				target = target.find( '.block' );
				masonry = true;
			} else if ( elemBlockWrap.hasClass( 'block-wrap-65' ) ) {
				target = target.find( '.block' );
				masonry = 65;
			} else {
				target = target.find( '> .tipi-row-inner-style > .tipi-row-inner-box' );
			}
			var currentLoader, qry = zeenJS.qry, bid = elemBlockWrap.data('id');
			if ( typeof bid !== 'undefined' && typeof window[ 'zeen_' + bid ] !== 'undefined' && ! zeenPrv.$body.hasClass( 'blog' ) ) {
				qry = window[ 'zeen_' + bid ].args;
			}
			$.ajax({
			    method: "POST",
			    data: {
					preview: data.preview,
					mnp: data.mnp,
					qry: qry,
					paged: zeenPrv.thePaged,
					frontpage: zeenJS.args.frontpage,
					basePagi: window.location.pathname,
					type: type,
				},
			    url: zeenJS.root + 'pagi',
			    dataType: 'html',
			    beforeSend: function( xhr ) {
			    	zeenPrv.thePaged = parseInt( zeenPrv.thePaged ) + 1;
			        xhr.setRequestHeader( 'X-WP-Nonce', zeenJS.nonce );
   					currentLoader = elemBlockWrap.find( '.inf-load-more-wrap:not(.inf-loaded)' ).addClass( 'tipi-spin inf-loading' );
			    },
			    success : function( response ) {
					var $items = $( response ), item;
					var offset;
					if ( masonry === 65 ) {
						offset = zeenPrv.getDetails( target );
						elemBlockWrap.find( '.inf-scr:not(.inf-scr-masonry)' ).css( 'top', offset.height - 200 ).addClass( 'inf-scr-masonry' );
						currentLoader.addClass( 'inf-scr-masonry' ).css( 'top', offset.height - 200 );
						$items.each( function() {
							item = $( this );
							if ( item.hasClass( 'pagination' ) || item.hasClass( 'inf-scr' ) ) {
								elemBlockWrap.append( item );
							} else {
								target.append( item );
							}
						});
					} else if ( masonry === true ) {
						zeenPrv.masonryAppend( $items, target );
					} else {
						target.append( $items );
					}
					currentLoader.removeClass( 'tipi-spin inf-loading' ).addClass( 'inf-loaded' );
					zeenPrv.tempAni();
					zeenPrv.parallax3s();
					zeenPrv.infScr();
					zeenPrv.fillRunner();
					if ( masonry === true ) {
						zeenPrv.GA( data.next );
					} else {
						zeenPrv.infPagi( elem, data );
					}
			    },
			    fail : function( response ) {
			        console.log( 'ERROR', response );
			    }

			});

			$( '.inf-scr' ).removeClass("active");
		},
		infPagi: function( elem, data ) {
			new ScrollMagic
				.Scene({ triggerElement: elem, triggerHook: 1, offset: '100px' })
				.addTo( zeenPrv.$controller)
				.on( "enter leave", function( e ) {
					if ( e.progress === 1 ) {
						zeenPrv.updateHref( data.titleNext, data.next );
						zeenPrv.GA( data.next );
					} else {
						zeenPrv.updateHref( data.titlePrev, data.prev );
						zeenPrv.GA( data.prev );
					}
		    	});
		    this.reSidebars();
		},
		menuAc: function( row ) {
			var drop = $( row ),
			_parent = drop.closest( '.horizontal-menu' );
			if ( ! drop.hasClass( 'dropper' ) ) {
				return;
			}
			if ( ! drop.hasClass( 'zeen-lazy-loaded') ) {
				drop.find( '.zeen-lazy-load-mm' ).each( function() {
					zeenPrv.imgAttrLoad( $(this)[0], true );
				});
			}
			drop.addClass( 'active active-1 zeen-lazy-loaded' );
			if ( zeenPrv.mmAni === 3 ) {
				var trigger = drop.find( '> .menu' );
				if ( trigger.hasClass( 'mm-1' ) ) {
					trigger = trigger.find( '> .menu-wrap > .sub-menu' );
				}
				_parent.find( '.menu--slid' ).hide().removeClass('menu--slid');
				trigger.css( { 'visibility': 'visible', 'opacity': '1'  } ).addClass('menu--slid')
				if ( _parent.hasClass( 'menu--active') ) {
		   			trigger.show();
		   		} else {
		   			trigger.hide().stop().slideDown( 200 );
		   		}
			}
			setTimeout(function() {
        		_parent.addClass('menu--active');
			}, 220 );
        },
        menuDeac: function( row ) {
        	$( row ).removeClass( 'active' );
        },
        menuEx: function( item ) {
        	if ( zeenPrv.mmAni === 3 ) {
		   		var trigger = $(item).find( '.menu--slid' );
		   		trigger.stop().slideUp( 200 );
			}
        	$( item ).removeClass( 'menu--active' );
        },
		reSidebars: function() {
			$('.sticky-on').each( function() {
				$( this ).data('hcSticky').refresh();
			});
		},
		sidebars: function() {
			var builder = '';
			if ( this.$body.hasClass( 'tipi-builder-frame-inner' ) ) {
        		builder = true;
        	}
			var _this = this, stickies;
			if ( zeenPrv.$winWidth < 1020 ) {
				stickies = $( '.sticky-sb-on:not(.sidebar-wrap)' );
			} else {
				stickies = $( '.sticky-sb-on' );
			}
			stickies.each( function() {
				var sb = $(this),
				heightCheck,
				isSb = false,
				tweaks = 0;
				sb.imagesLoaded( function() {
					if ( sb.hasClass( 'sidebar-wrap') ) {
						isSb = true;
						heightCheck = sb.find('> .sidebar').outerHeight( true );
					}  else {
						heightCheck = sb.outerHeight( true );
					}
					var navH = 0;
					if ( _this.$siteNav.hasClass( 'sticky-menu' ) ) {
						if ( ! _this.$siteNav.hasClass( 'sticky-menu-2' ) ) {
							navH = _this.$siteNav.outerHeight();
						}
					} else {
						var navP = _this.$siteNav.closest( '.site-header' );
						if ( navP.length > 0 && ! navP.hasClass( 'sticky-menu-2' ) ) {
							navH = navP.outerHeight();
						}
					}

					if ( _this.headerIsSticky === true ) {
						navH = _this.$headerHeight - _this.$header.data( 'ptDiff' ) - _this.$header.data( 'pbDiff' );
						tweaks = 15;
					}
					var top = 30 + zeenPrv.$wpAdminBarHeight + navH - tweaks;
					if ( ( _this.$winWidth < 1020 && isSb === true ) || _this.$winWidth < 767 ) {
						top = 0;
					}
					if ( _this.$winHeight < heightCheck + top ) {
						if ( sb.hasClass( 'sticky-on' ) || builder === true ) {
							sb.removeClass( 'sticky-sb sticky-el' );
							return;
						}
						sb.addClass('sticky-on').hcSticky({
							top: top, resizeDebounce: 300
						});
					} else {
						sb.addClass('sticky-sb sticky-el');
						sb.css( 'top', top );
					}
				});
			});
		},
		sliderInit: function() {
			var sliders = $( '.slider' );
			if ( sliders.length === 0 ) {
				return;
			}
			sliders.each( function() {
				var $slider = $( this ), $sliderData = $slider.data(), arrows = true, artArrows = false, run = true, hideMeta, $sliderToArrow = $slider, sliderEffect = parseInt( $sliderData.effect );
				var args = {
					wrapAround: true,
					imagesLoaded: true,
					draggable: false,
					pageDots: false,
					setGallerySize: false,
					prevNextButtons: false,
					cellSelector: '.slide',
					contain: true,
					rightToLeft: zeenPrv.$rtl,
				};
				if ( zeenPrv.$winWidth < 768 === true ) {
					args.draggable = true;
				}
				if ( $slider.hasClass( 'flickity-enabled' ) ) {
					run = false;
				}

				if ( $sliderData.s === 10 ) {
					hideMeta = true;
					args.draggable = true;
					args.lazyLoad = 1;
					if ( $sliderData.fs === 's' || $sliderData.fs === 'm' ) {
						args.fullscreen = true;
					}
				}

				if ( $sliderData.s > 50 && $sliderData.s < 60 ) {
					args.setGallerySize = true;
					args.adaptiveHeight = true;
					args.selectedAttraction = 0.0925;
					args.friction = 0.725;
					if ( sliderEffect === 2 || ( $sliderData.s !== 51 && $sliderData.s !== 55 ) ) {
						args.autoPlay =  zeenJS.args.sDelay;
					}
				}


				if ( $sliderData.s === 51 || $sliderData.s === 55 ) {
					artArrows = true;
					arrows = false;
					if ( sliderEffect === 0 ) {
						args.selectedAttraction = 0.2;
						args.friction = 0.8;
					}
				}
				if ( zeenPrv.$winWidth > 768 ) {
					if ( $sliderData.s === 52  ) {
						args.groupCells = 2;
					} else if ( $sliderData.s === 53  ) {
						args.groupCells = 3;
					} else if ( $sliderData.s === 54  ) {
						args.groupCells = 4;
					}
				}

				if ( $sliderData.s === 15 ) {
					arrows = false;
					args.wrapAround = false;
					args.lazyLoad = 2;
					args.draggable = true;
				}
				if ( $sliderData.s === 16 ) {
					args.wrapAround = false;
					args.cellAlign = 'left';
					$sliderToArrow = $slider.prev();
					args.asNavFor = $sliderToArrow[0];
				}
				if ( $sliderData.s === 21 ) {
					args.setGallerySize = true;
					args.wrapAround = false;
					args.adaptiveHeight = true;
				}

				if ( sliderEffect === 2 ) {
					args.contain = false;
					args.fade = true;
					args.pageDots = true;
					arrows = false;
					artArrows = false;
				}

				if ( run === true ) {
					$slider.on( 'ready.flickity', function() {
						$slider.addClass( 'slider-ldd' );
						if ( $sliderData.s === 21 ) {
							$slider.removeClass('tipi-spin');
						}
						var slides;
						if ( $sliderData.s > 50 ) {
							slides = $slider.find( 'article');
						} else {
							slides = $slider.find( 'img');
						}
						if ( $sliderData.s === 51 || $sliderData.s === 55 ) {
							slides.first().imagesLoaded( function() {
								$slider.addClass('slider-rdy');
							});
						} else if ( $sliderData.s === 52 ) {
							slides.slice(0, 1).imagesLoaded( function() {
								$slider.addClass('slider-rdy');
							});
						} else if ( $sliderData.s === 53 ) {
							slides.slice(0, 2).imagesLoaded( function() {
								$slider.addClass('slider-rdy');
							});
						} else if ( $sliderData.s === 54 ) {
							slides.slice(0, 3).imagesLoaded( function() {
								$slider.addClass('slider-rdy');
							});
						} else if ( $sliderData.s === 10 || $sliderData.s === 15 ) {
							slides.imagesLoaded( function(e) {
								$slider.addClass('slider-rdy');
								$slider.closest('.hero-wrap').addClass( 'mask-loaded' );
							});
						} else if ( $sliderData.s === 16 ) {
							slides.imagesLoaded( function(e) {
								$slider.addClass('nav-slider-rdy');
							});
						}
					});
					$slider.flickity( args );
					var flkty = '';
					if ( args.wrapAround === false ) {
						flkty = $slider.data( 'flickity' );
					}
					if ( $sliderData.s === 21 ) {
						$slider.css( 'counter-reset', 'list ' + ( flkty.slides.length + 1 ) );
					}
					if ( arrows === true ) {
						var prev = $slider.find( '.slider-arrow-prev' );
						var next = $slider.find( '.slider-arrow-next' );
						prev.on( 'click', function() {
							$sliderToArrow.flickity( 'previous' );
							if ( args.wrapAround === false ) {
								if ( flkty.selectedIndex === 0 ) {
									prev.addClass('disabled');
								} else {
									prev.removeClass('disabled');
								}
								if ( flkty.selectedIndex === flkty.slides.length - 1 ) {
									next.addClass('disabled');
								} else {
									next.removeClass('disabled');
								}
							}
						});
						next.on( 'click', function() {
							$sliderToArrow.flickity( 'next' );
							if ( args.wrapAround === false ) {
								if ( flkty.selectedIndex === 0 ) {
									prev.addClass('disabled');
								} else {
									prev.removeClass('disabled');
								}
								if ( flkty.selectedIndex === flkty.slides.length - 1 ) {
									next.addClass('disabled');
								} else {
									next.removeClass('disabled');
								}
							}
						});
					}
					if ( hideMeta === true ) {
						$slider.on( 'change.flickity', function( event, index ) {
							var sliderHeroWrap = $slider.closest('.hero-wrap');
				            if ( ! sliderHeroWrap.hasClass( 'gallery-viewing' ) ) {
					            $slider.on( 'mouseleave', function() {
									sliderHeroWrap.removeClass( 'gallery-viewing' );
									$slider.off( 'mouseleave' );
								});
					        }
				            sliderHeroWrap.addClass( 'gallery-viewing' );
				        });
					}
					if ( artArrows === true ) {
						flkty = $slider.data( 'flickity' );
						var $sliderArrows = $slider.find( '.slider-arrow' );
						$sliderArrows.on( 'click', function() {
							var arrow = $( this );
							if ( arrow.data( 'doing' ) ) return;
							arrow.data( 'doing', true );
							var start = flkty.selectedIndex;
							if ( arrow.hasClass( 'slider-arrow-next' ) ) {
								$sliderToArrow.flickity( 'next' );
							} else {
								$sliderToArrow.flickity( 'previous' );
							}
							var finish = flkty.selectedIndex;
							if ( flkty.cells.length > 1 ) {
								zeenPrv.sliderAlt( flkty, start, finish, $sliderData.effect );
							}
						});

						if ( zeenJS.args.sDelay > 0 ) {
							$slider.data( 'autoplay', true );
							setInterval( function() {
								if ( $slider.data('autoplay') === true ) {
									var start = flkty.selectedIndex;
									$sliderToArrow.flickity( 'next' );
									var finish = flkty.selectedIndex;
									if ( flkty.cells.length > 1 ) {
										zeenPrv.sliderAlt( flkty, start, finish, $sliderData.effect );
									}
								}
							}, zeenJS.args.sDelay );
							$slider.on( 'mouseenter', function() {
								$slider.data( 'autoplay', false );
							});
							$slider.on( 'mouseleave', function() {
								$slider.data( 'autoplay', true );
							});
						}

						$slider.on( 'settle.flickity', function( event, index ) {
							$sliderArrows.removeData( 'doing' );
						});

						$slider.on( 'settle.flickity', function( event, index ) {
							$sliderArrows.removeData( 'doing' );
						});

					}
				}
			});
		},
		sliderAlt: function( flkty, start, finish, effect ) {
			if ( parseInt( effect ) !== 0 ) {
				return;
			}
			var length = flkty.cells.length;
			if ( finish === length ) {
				finish = 0;
			}
			var dir = ! ( start === 0 && finish === length - 1 ) && ( ( finish === 0 && start === length - 1 ) || start < finish ) ? 'R' : 'L',
			$start = $( flkty.slides[start].cells[0].element ),
			$finish = $( flkty.slides[finish].cells[0].element ),
			outerWidth = flkty.slides[start].outerWidth,
			ease = Power2.easeInOut,
			outerWidthCalc = outerWidth - outerWidth * 0.2,
			finishR = dir === 'R' ? -Math.abs( outerWidthCalc ) : outerWidthCalc,
			startMaskL = dir === 'L' ? -Math.abs( outerWidthCalc ) : outerWidthCalc,
			startL = dir === 'L' ? -Math.abs( outerWidth ) : outerWidth,
			startR = dir === 'R' ? -Math.abs( outerWidth ) : outerWidth;
			for ( var i = flkty.slides.length - 1; i >= 0; i-- ) {
				flkty.slides[i].cells[0].element.classList.remove( 'old-slide', 'new-slide' );
			}
			$start.addClass( 'old-slide' );
			$finish.addClass( 'new-slide' );
			TweenLite.fromTo( $finish, 0.6, { x: startL }, { x: 0, ease: ease } );
			TweenLite.fromTo( $start, 0.6, { x: 0 }, { x: startR, ease: ease } );
			TweenLite.fromTo( $finish.find( '> .mask' ), 0.6, { x: finishR }, { x: 0, ease: ease } );
			TweenLite.fromTo( $start.find( '> .mask' ), 0.6, { x: 0 }, { x: startMaskL, ease: ease } );
			TweenLite.fromTo( $finish.find( '> .meta' ), 0.6, { x: startR }, { x: 0, ease: ease } );
			TweenLite.fromTo( $start.find( '> .meta' ), 0.6, { x: 0 }, { x: startL, ease: ease } );
		},
		lightboxClasses: function() {
			this.$entryContent.find( 'a' ).has( 'img' ).each( function() {

	            var attrTitle = $( 'img', this ).attr( 'title' ), $instance = $( this ),
	                attrHref = $instance.attr( 'href' );

				if ( typeof attrTitle !== 'undefined' ) {
					$instance.attr( 'title', attrTitle );
				}
	            if ( typeof attrHref !== 'undefined' && $instance.data( 'rel' ) !== 'prettyPhoto[product-gallery]' ) {
	                var splitHref = attrHref.split( '.' ),
	                	ext = $(splitHref)[$(splitHref).length - 1];
	                if ( ext === 'jpg' || ext === 'jpeg' || ext === 'png' || ext === 'gif' ) {
	                    $instance.addClass( 'tipi-lightbox' );
	                }
	            }
	        });
		},
		lightboxInit: function() {
			zeenPrv.lightboxClasses();
			if ( zeenJS.args.lightbox === true ) {
				$( '.tipi-lightbox' ).swipebox();
			}
		},
		toolTipInit: function( e ) {

			if ( zeenPrv.$winWidth < 1200 ) return;
			zeenPrv.$toolTipCurrent = $( this );
			zeenPrv.$toolTipCurrent.addClass( 'tipi-tipped' );
			var direction = 'tipi-tip-wrap-b';

			if ( zeenPrv.$toolTipCurrent.hasClass( 'tipi-tip-r' ) ) {
				direction = 'tipi-tip-wrap-r';
			}
			if ( zeenPrv.$toolTipCurrent.hasClass( 'tipi-tip-l' ) ) {
				direction = 'tipi-tip-wrap-l';
			}

			var output = '<div class="tipi-tip-wrap font-s ' + direction  + '">' +
				'<div class="inner">' +
					zeenPrv.$toolTipCurrent.data( 'title' ) +
				'</div>' +
				'<div class="detail"></div>' +
				'</div>';

			zeenPrv.$body.append( output );

			zeenPrv.$toolTipOutput = zeenPrv.$body.find( ' > .tipi-tip-wrap:not(.removing)' );

			if ( zeenPrv.$toolTipCurrent.hasClass( 'tipi-tip-move' ) ) {
				zeenPrv.$toolTipCurrent.on( 'mousemove', zeenPrv.tooltipLive );
				zeenPrv.$toolTipOutput.addClass( 'tipi-tip-mover' );
			} else {
				zeenPrv.tooltipSetup();
			}

			zeenPrv.$toolTipCurrent.on( 'mouseleave', zeenPrv.tooltipDestroy );
		},
		tooltipDestroy: function() {
			zeenPrv.$toolTipOutput.addClass( 'removing' );
			setTimeout( function() {
				$( '.removing' ).remove();
			}, 500 );
			zeenPrv.$toolTipCurrent.off( 'mouseleave mousemove' );
		},
		tooltipLive: function( e ) {
			zeenPrv.tooltipSetup( { 'left': e.clientX, 'top': e.clientY } );
		},
		tooltipSetup: function( args ) {
			if ( typeof( args ) === 'undefined' ) {
				args = {};
			}
			if ( typeof( args.output ) === 'undefined' ) {
				args.output = zeenPrv.$toolTipOutput;
			}

			if ( typeof( args.current ) === 'undefined' ) {
				args.current = zeenPrv.$toolTipCurrent;
			}

			var	instanceDetails = zeenPrv.getDetails( args.output );
			var offset = zeenPrv.getDetails( args.current );

			if ( typeof( args.left ) === 'undefined' ) {
				args.left = offset.left + ( offset.width / 2 ) - instanceDetails.width / 2;
			} else {
				args.left = args.left - instanceDetails.width / 2;
			}

			if ( typeof( args.top ) === 'undefined' ) {
				args.top = offset.top;
				args.top = args.top + offset.height;
			} else {
				args.top = args.top + 10;
			}

			if ( args.current.hasClass( 'tipi-tip-r' ) ) {
				args.top = offset.top + ( offset.height / 2 ) - ( instanceDetails.height / 2 );
				args.left = offset.width + offset.left + 10;
			} else if ( args.current.hasClass( 'tipi-tip-l' ) ) {
				args.top = offset.top + ( offset.height / 2 ) - ( instanceDetails.height / 2 );
				args.left =  offset.left - instanceDetails.width - 10;
			}
			args.output.css({
				left: args.left,
				top: args.top
			}).addClass( 'tipi-tip-wrap-visible' );
		},
		getDetails: function( elem ) {
	   		var output = elem[0].getBoundingClientRect();
	   		return { left: output.left, top: output.top, width: output.width, height: output.height };
		},
		orientationchange: function() {
			this.cleanUp();
			this.$parallax3sController.destroy( true );
			this.$parallax3sController = new ScrollMagic.Controller();
			$( '.parallaxed3s' ).removeClass('parallaxed3s');
			this.parallax3s();
		},
		resize: function() {
			this.resizing = true;
			var width = this.$winWidth;
			this.data();
			var _this = this;
			clearTimeout( this.resizeTo );
			this.resizeTo = setTimeout( function() {
				if ( width !== _this.$winWidth ) {
					_this.cleanUp();
					_this.header();
					_this.sticky();
					_this.sliderInit();
					_this.sidebars();
					_this.reSidebars();
					_this.cta();
				}
				_this.imgControl( true );
				_this.resizing = false;
			}, 275 );

		},
		cleanUp: function() {
			this.$parallaxItCont.destroy( true );
			this.$parallaxItCont = new ScrollMagic.Controller();
			$( '.parallaxed' ).removeClass( 'parallaxed' );
			this.parallaxIt();
		},
		qtyArrows: function() {
			$( '.cart .quantity:not(.has-arrows )' ).addClass( 'has-arrows' ).append( '<span class="qty-arrows"><span id="qty-plus" class="qty-arrow qty-plus"><i class="tipi-i-chevron-up"></i></span><span id="qty-minus" class="qty-arrow qty-minus"><i class="tipi-i-chevron-down"></i></span></span>' );
		},
		qtyArrowChange: function() {
			var $quantity = $( this ).closest( '.quantity' ),
				$qty = $quantity.find( '.qty' ),
				type = $( this ).hasClass( 'qty-plus' ),
				current	= parseInt( $qty.val() ),
				max = parseInt( $qty.attr( 'max' ) ),
				min = parseInt( $qty.attr( 'min' ) ),
				step = $qty.attr( 'step' );

			if ( ! current || current === '' || current === 'NaN' ) {
				current = 0;
			}
			if ( max === '' || max === 'NaN' ) {
				max = '';
			}
			if ( min === '' || min === 'NaN' ) {
				min = 0;
			}
			if ( step === 'any' || step === '' || typeof step === 'undefined' || parseInt( step ) === 'NaN' ) {
				step = 1;
			}

			if ( type === true ) {
				if ( max && ( current >= max ) ) {
					$qty.val( max );
				} else {
					$qty.val( current + parseInt( step ) );
				}
			} else {
				if ( min && ( current <= min ) ) {
					$qty.val( min );
				} else if ( current > 0 ) {
					$qty.val( current - parseInt( step ) );
				}
			}

			$qty.trigger( 'change' );
		},
		fillRunner: function( override ) {
			if ( this.$body.hasClass( 'tipi-builder-frame-inner' ) && override !== true ) {
				return;
			}
			if ( override === true ) {
				$( '.tipi-fill' ).remove();
			}
			if ( this.wooArchive === true ) {
				var woo = this.$entryContentWrap.data('ppl');
				if ( woo > 2 && this.$products.length > 0 ) {
					this.$products.each( function() {
						zeenPrv.fillIt( $( this ), woo, 'product' );
					});
				}
			}
			var block = this.$primary.add(this.$dropper).find( '.ppl-l-4, .ppl-m-4' );
			if ( block.length > 0 ) {
				block = block.find( '.block:not(.block-65)' );
				block.each( function() {
					zeenPrv.fillIt( $( this ), 4 );
				});
			}
			block = this.$primary.add(this.$dropper).find( '.ppl-l-5, .ppl-m-5' );
			if ( block.length > 0 ) {
				block = block.find( '.block:not(.block-65)' );
				block.each( function() {
					zeenPrv.fillIt( $( this ), 5 );
				});
			}
			block = this.$primary.add(this.$dropper).find( '.ppl-l-3, .ppl-m-3' );
			if ( block.length > 0 ) {
				block = block.find( '.block:not(.block-65)' );
				block.each( function() {
					if ( ! block.hasClass( 'block-wrap-65' ) ) {
						zeenPrv.fillIt( $( this ), 3 );
					}
				});
			}
		},
		fillIt: function( block, count, classes ) {
			if ( this.$winWidth > 767 ) {
				var counter = block.children().length;
				if ( counter === count ) {
					return;
				}
				var remainder;
				if ( counter < count ) {
					remainder = count - counter;
				} else{
					remainder = counter - ( Math.floor( counter / count ) * count );
					remainder = count - remainder;
				}
				if ( remainder < count ) {
					for ( var i = 0; i < remainder; i++ ) {
						var article = document.createElement( 'article' );
						article.classList.add( 'tipi-fill' );
						if ( typeof classes !== 'undefined' ) {
							article.classList.add( classes );
						}
						block.append(article );
					}
				}
			} else {
				$( '.tipi-fill' ).remove();
			}

		},
		toTopInit: function( e ) {
			e.preventDefault();
			zenscroll.toY( 0, 800 );
		},
		foldMid: function() {
			var togglers = this.$toTopWrap.add(this.$verticalMenu).add( $('#next-block__wrap' ) ).add( $('#prev-block__wrap' ) );
			if ( togglers.length > 0 ) {
				this.foldMidScene = new ScrollMagic.Scene({triggerElement: this.$body, offset: Math.min( 400, this.$winHeight), triggerHook: 0 } )
					.addTo( zeenPrv.$controller )
					.setClassToggle( togglers, 'past__mid' );
			}

		},
		openSlideMenu: function( e ) {
			e.preventDefault();
			this.$body.addClass( 'slide-menu-open' );
			this.$baseOverlay.addClass( 'active' );
			this.$slideInMenu.addClass( 'active' );
		},
		closeSlideMenu: function( e ) {
			if ( typeof( e ) !== 'undefined' ) {
				e.preventDefault();
			}
			this.$body.removeClass( 'slide-menu-open' );
			this.$slideInMenu.removeClass( 'active' );
			this.$baseOverlay.removeClass( 'active' );
		},
		openMobMenu: function( e ) {
			e.preventDefault();
			if ( this.$body.hasClass( 'site-mob-menu-a-3' ) ) {
				var currentTop = $(window).scrollTop();
				zeenPrv.$body.addClass( 'mob-open mob-open-3' );
				this.$content.add( this.$topBlock ).add( this.$mobHead ).css( 'top', '-' + currentTop + 'px' );
				this.$page.css( 'height', this.$winHeight );
			} else {
				if ( this.$body.hasClass( 'mob-open' ) ) {
					this.$body.removeClass( 'mob-open' );
				} else {
					this.$body.addClass( 'mob-open' );
				}
			}
		},
		mobMenuClear: function( e ) {
			this.$body.removeClass( 'mob-open' );
			if ( ! this.$body.hasClass( 'site-mob-menu-a-3' ) ) {
				return;
			}
			clearTimeout( zeenPrv.mobMenuClearTO );
			zeenPrv.mobMenuClearTO = setTimeout( function() {

				var scrollTo = ( zeenPrv.$content.css( 'top' ) );
				zeenPrv.$content.add( zeenPrv.$topBlock ).add( zeenPrv.$mobHead ).css( 'top', '' );
				zeenPrv.$page.css( 'height', '' );
				zeenPrv.$body.removeClass( 'mob-open mob-open-3' );
				window.scrollTo(0, scrollTo);
			}, 500 );
		},
		closeMobMenu: function( e ) {
			e.preventDefault();
			zeenPrv.mobMenuClear();
		},
		pub: function() {
			var _this = this;
			clearTimeout( this.pubTimer );
			this.pubTimer = setTimeout( function() {
				_this.$parallaxItCont.destroy( true );
				_this.$parallax3sController.destroy( true );
				$( '.parallaxed').removeClass('parallaxed');
				$( '.parallaxed3s').removeClass('parallaxed3s');
				$( '.tipi-parallax-ani .bg, .tipi-parallax-ani iframe' ).css( 'transform', '' );
				_this.dom();
				_this.data();
				_this.anis();
				_this.sliderInit();
				_this.sidebars();
				_this.reSidebars();
				_this.cta( true );
				_this.noPar();
				_this.fillRunner( true );
				_this.stickyEl();
				_this.parallaxIt( true );
				_this.parallax3s( true );
			}, 50 );
		},
		cus: function( setting ) {
			if ( setting === 'sticky' && typeof zeenPrv.stickyMenu.destroy === 'function' ) {
				zeenPrv.stickyMenu.destroy( true );
			}
			if ( setting === 'sticky' && typeof zeenPrv.stickyMobMenu.destroy === 'function' ) {
				zeenPrv.stickyMobMenu.destroy( true );
			}
			this.dom();
			this.data();
			this.bind();
			if ( setting === 'sticky' ) {
				this.$stickyMenu.removeClass( 'slidedown stickied stuck active still' );
				this.sticky();
			}

		}
	};
	zeenPrv.init();
	return {
		pub: function() {
			zeenPrv.pub();
		},
		cus: function( setting ) {
			zeenPrv.cus( setting );
		},
	};
})(jQuery);
/**
 * Zenscroll 4.0.2
 * https://github.com/zengabor/zenscroll/
 *
 * Copyright 2015–2018 Gabor Lenard
 *
 * This is free and unencumbered software released into the public domain.
 * 
 * Anyone is free to copy, modify, publish, use, compile, sell, or
 * distribute this software, either in source code form or as a compiled
 * binary, for any purpose, commercial or non-commercial, and by any
 * means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors
 * of this software dedicate any and all copyright interest in the
 * software to the public domain. We make this dedication for the benefit
 * of the public at large and to the detriment of our heirs and
 * successors. We intend this dedication to be an overt act of
 * relinquishment in perpetuity of all present and future rights to this
 * software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to <http://unlicense.org>
 * 
 */


 /* CODETIPI CHANGES:

 Removed auto smoothscroll entire section

/*jshint devel:true, asi:true */

/*global define, module */


(function (root, factory) {
	if (typeof define === "function" && define.amd) {
		define([], factory())
	} else if (typeof module === "object" && module.exports) {
		module.exports = factory()
	} else {
		(function install() {
			// To make sure Zenscroll can be referenced from the header, before `body` is available
			if (document && document.body) {
				root.zenscroll = factory()
			} else {
				// retry 9ms later
				setTimeout(install, 9)
			}
		})()
	}
}(this, function () {
	"use strict"


	// Detect if the browser already supports native smooth scrolling (e.g., Firefox 36+ and Chrome 49+) and it is enabled:
	var isNativeSmoothScrollEnabledOn = function (elem) {
		return elem && "getComputedStyle" in window &&
			window.getComputedStyle(elem)["scroll-behavior"] === "smooth"
	}


	// Exit if it’s not a browser environment:
	if (typeof window === "undefined" || !("document" in window)) {
		return {}
	}


	var makeScroller = function (container, defaultDuration, edgeOffset) {

		// Use defaults if not provided
		defaultDuration = defaultDuration || 999 //ms
		if (!edgeOffset && edgeOffset !== 0) {
			// When scrolling, this amount of distance is kept from the edges of the container:
			edgeOffset = 9 //px
		}

		// Handling the life-cycle of the scroller
		var scrollTimeoutId
		var setScrollTimeoutId = function (newValue) {
			scrollTimeoutId = newValue
		}

		/**
		 * Stop the current smooth scroll operation immediately
		 */
		var stopScroll = function () {
			clearTimeout(scrollTimeoutId)
			setScrollTimeoutId(0)
		}

		var getTopWithEdgeOffset = function (elem) {
			return Math.max(0, container.getTopOf(elem) - edgeOffset)
		}

		/**
		 * Scrolls to a specific vertical position in the document.
		 *
		 * @param {targetY} The vertical position within the document.
		 * @param {duration} Optionally the duration of the scroll operation.
		 *        If not provided the default duration is used.
		 * @param {onDone} An optional callback function to be invoked once the scroll finished.
		 */
		var scrollToY = function (targetY, duration, onDone) {
			stopScroll()
			if (duration === 0 || (duration && duration < 0) || isNativeSmoothScrollEnabledOn(container.body)) {
				container.toY(targetY)
				if (onDone) {
					onDone()
				}
			} else {
				var startY = container.getY()
				var distance = Math.max(0, targetY) - startY
				var startTime = new Date().getTime()
				duration = duration || Math.min(Math.abs(distance), defaultDuration);
				(function loopScroll() {
					setScrollTimeoutId(setTimeout(function () {
						// Calculate percentage:
						var p = Math.min(1, (new Date().getTime() - startTime) / duration)
						// Calculate the absolute vertical position:
						var y = Math.max(0, Math.floor(startY + distance*(p < 0.5 ? 2*p*p : p*(4 - p*2)-1)))
						container.toY(y)
						if (p < 1 && (container.getHeight() + y) < container.body.scrollHeight) {
							loopScroll()
						} else {
							setTimeout(stopScroll, 99) // with cooldown time
							if (onDone) {
								onDone()
							}
						}
					}, 9))
				})()
			}
		}

		/**
		 * Scrolls to the top of a specific element.
		 *
		 * @param {elem} The element to scroll to.
		 * @param {duration} Optionally the duration of the scroll operation.
		 * @param {onDone} An optional callback function to be invoked once the scroll finished.
		 */
		var scrollToElem = function (elem, duration, onDone) {
			scrollToY(getTopWithEdgeOffset(elem), duration, onDone)
		}

		/**
		 * Scrolls an element into view if necessary.
		 *
		 * @param {elem} The element.
		 * @param {duration} Optionally the duration of the scroll operation.
		 * @param {onDone} An optional callback function to be invoked once the scroll finished.
		 */
		var scrollIntoView = function (elem, duration, onDone) {
			var elemHeight = elem.getBoundingClientRect().height
			var elemBottom = container.getTopOf(elem) + elemHeight
			var containerHeight = container.getHeight()
			var y = container.getY()
			var containerBottom = y + containerHeight
			if (getTopWithEdgeOffset(elem) < y || (elemHeight + edgeOffset) > containerHeight) {
				// Element is clipped at top or is higher than screen.
				scrollToElem(elem, duration, onDone)
			} else if ((elemBottom + edgeOffset) > containerBottom) {
				// Element is clipped at the bottom.
				scrollToY(elemBottom - containerHeight + edgeOffset, duration, onDone)
			} else if (onDone) {
				onDone()
			}
		}

		/**
		 * Scrolls to the center of an element.
		 *
		 * @param {elem} The element.
		 * @param {duration} Optionally the duration of the scroll operation.
		 * @param {offset} Optionally the offset of the top of the element from the center of the screen.
		 *        A value of 0 is ignored.
		 * @param {onDone} An optional callback function to be invoked once the scroll finished.
		 */
		var scrollToCenterOf = function (elem, duration, offset, onDone) {
			scrollToY(Math.max(0, container.getTopOf(elem) - container.getHeight()/2 + (offset || elem.getBoundingClientRect().height/2)), duration, onDone)
		}

		/**
		 * Changes default settings for this scroller.
		 *
		 * @param {newDefaultDuration} Optionally a new value for default duration, used for each scroll method by default.
		 *        Ignored if null or undefined.
		 * @param {newEdgeOffset} Optionally a new value for the edge offset, used by each scroll method by default. Ignored if null or undefined.
		 * @returns An object with the current values.
		 */
		var setup = function (newDefaultDuration, newEdgeOffset) {
			if (newDefaultDuration === 0 || newDefaultDuration) {
				defaultDuration = newDefaultDuration
			}
			if (newEdgeOffset === 0 || newEdgeOffset) {
				edgeOffset = newEdgeOffset
			}
			return {
				defaultDuration: defaultDuration,
				edgeOffset: edgeOffset
			}
		}

		return {
			setup: setup,
			to: scrollToElem,
			toY: scrollToY,
			intoView: scrollIntoView,
			center: scrollToCenterOf,
			stop: stopScroll,
			moving: function () { return !!scrollTimeoutId },
			getY: container.getY,
			getTopOf: container.getTopOf
		}

	}


	var docElem = document.documentElement
	var getDocY = function () { return window.scrollY || docElem.scrollTop }

	// Create a scroller for the document:
	var zenscroll = makeScroller({
		body: document.scrollingElement || document.body,
		toY: function (y) { window.scrollTo(0, y) },
		getY: getDocY,
		getHeight: function () { return document.documentElement.clientHeight || docElem.clientHeight },
		getTopOf: function (elem) { return elem.getBoundingClientRect().top + getDocY() - docElem.offsetTop }
	})


	/**
	 * Creates a scroller from the provided container element (e.g., a DIV)
	 *
	 * @param {scrollContainer} The vertical position within the document.
	 * @param {defaultDuration} Optionally a value for default duration, used for each scroll method by default.
	 *        Ignored if 0 or null or undefined.
	 * @param {edgeOffset} Optionally a value for the edge offset, used by each scroll method by default. 
	 *        Ignored if null or undefined.
	 * @returns A scroller object, similar to `zenscroll` but controlling the provided element.
	 */
	zenscroll.createScroller = function (scrollContainer, defaultDuration, edgeOffset) {
		return makeScroller({
			body: scrollContainer,
			toY: function (y) { scrollContainer.scrollTop = y },
			getY: function () { return scrollContainer.scrollTop },
			getHeight: function () { return Math.min(scrollContainer.clientHeight, document.documentElement.clientHeight || docElem.clientHeight) },
			getTopOf: function (elem) { return elem.offsetTop }
		}, defaultDuration, edgeOffset)
	}

	return zenscroll


}));