<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

// Header sidebar
$wisemove_header_name = wisemove_get_theme_option('header_widgets');
$wisemove_header_present = !wisemove_is_off($wisemove_header_name) && is_active_sidebar($wisemove_header_name);
if ($wisemove_header_present) { 
	wisemove_storage_set('current_sidebar', 'header');
	$wisemove_header_wide = wisemove_get_theme_option('header_wide');
	ob_start();
    if ( is_active_sidebar( $wisemove_header_name ) ) {
        dynamic_sidebar( $wisemove_header_name );
    }
	$wisemove_widgets_output = ob_get_contents();
	ob_end_clean();
	if (trim(strip_tags($wisemove_widgets_output)) != '') {
		$wisemove_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $wisemove_widgets_output);
		$wisemove_need_columns = strpos($wisemove_widgets_output, 'columns_wrap')===false;
		if ($wisemove_need_columns) {
			$wisemove_columns = max(0, (int) wisemove_get_theme_option('header_columns'));
			if ($wisemove_columns == 0) $wisemove_columns = min(6, max(1, substr_count($wisemove_widgets_output, '<aside ')));
			if ($wisemove_columns > 1)
				$wisemove_widgets_output = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($wisemove_columns).' widget ', $wisemove_widgets_output);
			else
				$wisemove_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($wisemove_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$wisemove_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($wisemove_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'wisemove_action_before_sidebar' );
				wisemove_show_layout($wisemove_widgets_output);
				do_action( 'wisemove_action_after_sidebar' );
				if ($wisemove_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$wisemove_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>