<?php
/**
 * The template to display the main menu
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */
$wisemove_header_text_custom = wisemove_get_theme_option('header_title_text');
?>
<div class="top_panel_navi sc_layouts_row sc_layouts_row_type_normal sc_layouts_row_fixed
			scheme_<?php echo esc_attr(wisemove_is_inherit(wisemove_get_theme_option('menu_scheme')) 
												? (wisemove_is_inherit(wisemove_get_theme_option('header_scheme')) 
													? wisemove_get_theme_option('color_scheme') 
													: wisemove_get_theme_option('header_scheme')) 
												: wisemove_get_theme_option('menu_scheme')); ?>">

			<div class="sc_layouts_column logo_section sc_layouts_column_align_left sc_layouts_column_icons_position_left">
				<?php
				// Logo
				?><div class="sc_layouts_item"><?php
					get_template_part( 'templates/header-logo' );
				?></div>
			</div>

    <?php
    if (!empty($wisemove_header_text_custom)) { ?>
        <div class="panel_right clearfix">
        <?php
            wisemove_show_layout($wisemove_header_text_custom, '<div class="top_panel_custom_text">', '</div>');
        ?>
        </div><?php
    }
			
			// Attention! Don't place any spaces between columns!
			?><div class="sc_layouts_column sc_layouts_column_align_right sc_layouts_column_icons_position_left">
				<div class="sc_layouts_item">
					<?php
					// Main menu
					$wisemove_menu_main = wisemove_get_nav_menu(array('location' => 'menu_main', 'class' => 'sc_layouts_hide_on_mobile'));
					if (empty($wisemove_menu_main)) $wisemove_menu_main = wisemove_get_nav_menu(array('class' => 'sc_layouts_hide_on_mobile'));
					wisemove_show_layout($wisemove_menu_main);
					// Mobile menu button
					?>
					<div class="sc_layouts_iconed_text sc_layouts_menu_mobile_button">
						<a class="sc_layouts_item_link sc_layouts_iconed_text_link" href="#">
							<span class="sc_layouts_item_icon sc_layouts_iconed_text_icon trx_addons_icon-menu"></span>
						</a>
					</div>
				</div><?php
			
				// Attention! Don't place any spaces between layouts items!
				?>

			</div>

</div><!-- /.top_panel_navi -->