<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_args = get_query_var('wisemove_logo_args');

// Site logo
$wisemove_logo_image  = wisemove_get_logo_image(isset($wisemove_args['type']) ? $wisemove_args['type'] : '');
$wisemove_logo_text   = wisemove_is_on(wisemove_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$wisemove_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($wisemove_logo_image) || !empty($wisemove_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($wisemove_logo_image)) {
			$wisemove_attr = wisemove_getimagesize($wisemove_logo_image);
			echo '<img src="'.esc_url($wisemove_logo_image).'" alt="'.esc_attr__('logo', 'wisemove').'"'.(!empty($wisemove_attr[3]) ? sprintf(' %s', $wisemove_attr[3]) : '').'>' ;
		} else {
			wisemove_show_layout(wisemove_prepare_macros($wisemove_logo_text), '<span class="logo_text">', '</span>');
			wisemove_show_layout(wisemove_prepare_macros($wisemove_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>