<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0
 */

$wisemove_header_css = $wisemove_header_image = '';
$wisemove_header_video = wp_is_mobile() ? '' : wisemove_get_theme_option('header_video');
if (true || empty($wisemove_header_video)) {
	$wisemove_header_image = get_header_image();
	if (wisemove_is_on(wisemove_get_theme_option('header_image_override')) && apply_filters('wisemove_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($wisemove_cat_img = wisemove_get_category_image()) != '')
				$wisemove_header_image = $wisemove_cat_img;
		} else if (is_singular() || wisemove_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$wisemove_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($wisemove_header_image)) $wisemove_header_image = $wisemove_header_image[0];
			} else
				$wisemove_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
                    if (wisemove_is_on(wisemove_get_theme_option('header_full_width'))) echo ' header_in_content';
					echo !empty($wisemove_header_image) || !empty($wisemove_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($wisemove_header_video!='') echo ' with_bg_video';
					if ($wisemove_header_image!='') echo ' '.esc_attr(wisemove_add_inline_style('background-image: url('.esc_url($wisemove_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (wisemove_is_on(wisemove_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(wisemove_is_inherit(wisemove_get_theme_option('header_scheme')) 
													? wisemove_get_theme_option('color_scheme') 
													: wisemove_get_theme_option('header_scheme'));
					?>"><?php
	
	// Main menu
	if (wisemove_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );

	// Header for single posts
	get_template_part( 'templates/header-single' );

?></header>