<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0.06
 */

$wisemove_header_css = $wisemove_header_image = '';
$wisemove_header_video = wp_is_mobile() ? '' : wisemove_get_theme_option('header_video');
if (true || empty($wisemove_header_video)) {
	$wisemove_header_image = get_header_image();
	if (wisemove_is_on(wisemove_get_theme_option('header_image_override')) && apply_filters('wisemove_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($wisemove_cat_img = wisemove_get_category_image()) != '')
				$wisemove_header_image = $wisemove_cat_img;
		} else if (is_singular() || wisemove_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$wisemove_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($wisemove_header_image)) $wisemove_header_image = $wisemove_header_image[0];
			} else
				$wisemove_header_image = '';
		}
	}
}

$wisemove_header_id = str_replace('header-custom-', '', wisemove_get_theme_option("header_style"));

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr($wisemove_header_id);
						echo !empty($wisemove_header_image) || !empty($wisemove_header_video) ? ' with_bg_image' : ' without_bg_image';
						if ($wisemove_header_video!='') echo ' with_bg_video';
						if ($wisemove_header_image!='') echo ' '.esc_attr(wisemove_add_inline_style('background-image: url('.esc_url($wisemove_header_image).');'));
						if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
						if (wisemove_is_on(wisemove_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
						?> scheme_<?php echo esc_attr(wisemove_is_inherit(wisemove_get_theme_option('header_scheme')) 
														? wisemove_get_theme_option('color_scheme') 
														: wisemove_get_theme_option('header_scheme'));
						?>"><?php
		
	// Custom header's layout
	do_action('wisemove_action_show_layout', $wisemove_header_id);

	// Header widgets area
	get_template_part( 'templates/header-widgets' );
		
?></header>