<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage WISEMOVE
 * @since WISEMOVE 1.0.10
 */

// Footer sidebar
$wisemove_footer_name = wisemove_get_theme_option('footer_widgets');
$wisemove_footer_present = !wisemove_is_off($wisemove_footer_name) && is_active_sidebar($wisemove_footer_name);
if ($wisemove_footer_present) { 
	wisemove_storage_set('current_sidebar', 'footer');
	$wisemove_footer_wide = wisemove_get_theme_option('footer_wide');
	ob_start();
    if ( is_active_sidebar( $wisemove_footer_name ) ) {
        dynamic_sidebar( $wisemove_footer_name );
    }
	$wisemove_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($wisemove_out)) != '') {
		$wisemove_out = preg_replace("/<\\/aside>[\r\n\s]*<aside/", "</aside><aside", $wisemove_out);
		$wisemove_need_columns = true;
		if ($wisemove_need_columns) {
			$wisemove_columns = max(0, (int) wisemove_get_theme_option('footer_columns'));
			if ($wisemove_columns == 0) $wisemove_columns = min(6, max(1, substr_count($wisemove_out, '<aside ')));
			if ($wisemove_columns > 1)
				$wisemove_out = preg_replace("/class=\"widget /", "class=\"column-1_".esc_attr($wisemove_columns).' widget ', $wisemove_out);
			else
				$wisemove_need_columns = false;
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo !empty($wisemove_footer_wide) ? ' footer_fullwidth' : ''; ?>">
			<div class="footer_widgets_inner widget_area_inner">
				<?php 
				if (!$wisemove_footer_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($wisemove_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'wisemove_action_before_sidebar' );
				wisemove_show_layout($wisemove_out);
				do_action( 'wisemove_action_after_sidebar' );
				if ($wisemove_need_columns) {
					?></div><!-- /.columns_wrap --><?php
				}
				if (!$wisemove_footer_wide) {
					?></div><!-- /.content_wrap --><?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>